/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.CountingTransformation;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.InPlaceTransformation;
import java.util.LinkedList;

public class Iteratively
extends InPlaceTransformation {
    private CountingTransformation[] transforms;

    public Iteratively(Context context, CountingTransformation ... transformations) {
        super(context);
        this.transforms = transformations;
    }

    public static Iteratively parseAndCreate(ExecuteTransformation et) {
        LinkedList<CountingTransformation> ts = new LinkedList<CountingTransformation>();
        while (et.tryMatchTransformationCall()) {
            CountingTransformation t = (CountingTransformation)et.matchTransformationCall();
            ts.add(t);
        }
        return new Iteratively(et.context, ts.toArray(new CountingTransformation[ts.size()]));
    }

    @Override
    protected Integer transform() {
        int iterations = 0;
        boolean iterate = true;
        while (iterate) {
            int cnt = 0;
            for (CountingTransformation t : this.transforms) {
                cnt += ((Integer)t.execute()).intValue();
            }
            if (cnt == 0) {
                iterate = false;
                continue;
            }
            ++iterations;
        }
        return iterations;
    }
}

