/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.Record;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.gretl.AddMappings;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.CreateSubgraph;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.InPlaceTransformation;
import de.uni_koblenz.jgralab.gretl.parser.TokenTypes;
import de.uni_koblenz.jgralab.gretl.template.CreateEdge;
import de.uni_koblenz.jgralab.gretl.template.CreateVertex;
import de.uni_koblenz.jgralab.gretl.template.TemplateGraph;
import de.uni_koblenz.jgralab.gretl.templategraphparser.TemplateGraphParser;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.pcollections.Empty;
import org.pcollections.POrderedMap;
import org.pcollections.PSet;

public class MatchReplace
extends InPlaceTransformation {
    private TemplateGraph replaceGraph;
    private String semanticExpression;
    private PSet<Object> matches;
    private Map<CreateVertex, Vertex> createVertices2Vertices = new HashMap<CreateVertex, Vertex>();
    private LinkedHashSet<Vertex> matchedVertices = new LinkedHashSet();
    private LinkedHashSet<Edge> matchedEdges = new LinkedHashSet();
    private Set<GraphElement<?, ?>> preservables = new HashSet();
    private boolean addGlobalMappings = false;
    private HashSet<GraphElement<?, ?>> allModifiedElements = new HashSet();

    public MatchReplace(Context context, TemplateGraph replaceGraph, String semanticExpression) {
        super(context);
        this.replaceGraph = replaceGraph;
        this.semanticExpression = semanticExpression;
    }

    public MatchReplace(Context context, TemplateGraph replaceGraph, boolean addGlobalMappings, String semanticExpression) {
        super(context);
        this.replaceGraph = replaceGraph;
        this.semanticExpression = semanticExpression;
        this.addGlobalMappings = addGlobalMappings;
    }

    public MatchReplace(Context context, String replaceGraphText, String semanticExpression) {
        this(context, TemplateGraphParser.parse(replaceGraphText), semanticExpression);
    }

    public MatchReplace(Context context, TemplateGraph replaceGraph, PSet<Object> matches) {
        super(context);
        this.replaceGraph = replaceGraph;
        this.matches = matches;
    }

    public static MatchReplace parseAndCreate(ExecuteTransformation et) {
        TemplateGraph replaceGraph = TemplateGraphParser.parse(et.match((TokenTypes)TokenTypes.DOMAIN_SPECIFIC).value);
        et.matchTransformationArrow();
        String semExp = et.matchSemanticExpression();
        return new MatchReplace(et.context, replaceGraph, semExp);
    }

    @Override
    protected Integer transform() {
        if (this.context.getPhase() == Context.TransformationPhase.SCHEMA) {
            throw new GReTLException("SCHEMA phase in InPlaceTransformatio?!?");
        }
        if (this.matches == null) {
            this.matches = (PSet)this.context.evaluateGReQLQuery(this.semanticExpression);
        }
        this.allModifiedElements.clear();
        int applicationCount = 0;
        for (Object e : this.matches) {
            this.context.setGReQLVariable("$", e);
            this.matchedVertices.clear();
            this.matchedEdges.clear();
            this.preservables.clear();
            this.createVertices2Vertices.clear();
            this.calculateMatchedElements(e);
            if (!this.isValidMatch()) continue;
            ++applicationCount;
            this.apply();
        }
        this.matches = null;
        return applicationCount;
    }

    private void apply() {
        this.createAndUpdateVertices();
        this.createAndUpdateEdges();
        this.deleteNonPreservables();
    }

    private void calculateMatchedElements(Object matchedElem) {
        if (matchedElem instanceof Vertex) {
            this.matchedVertices.add((Vertex)matchedElem);
        } else if (matchedElem instanceof Edge) {
            this.matchedEdges.add(((Edge)matchedElem).getNormalEdge());
        } else if (matchedElem instanceof Collection) {
            for (Object j : (Collection)matchedElem) {
                this.calculateMatchedElements(j);
            }
        } else if (matchedElem instanceof Record) {
            for (Object o : ((Record)matchedElem).toPMap().values()) {
                this.calculateMatchedElements(o);
            }
        } else if (matchedElem instanceof Map) {
            Map m = (Map)matchedElem;
            this.calculateMatchedElements(m.keySet());
            this.calculateMatchedElements(m.values());
        }
    }

    private void deleteNonPreservables() {
        for (Vertex v : this.matchedVertices) {
            if (!v.isValid() || this.preservables.contains(v)) continue;
            this.verifyNoIncidentalDeletion(v);
            v.delete();
        }
        for (Edge e : this.matchedEdges) {
            if (!e.isValid() || this.preservables.contains(e)) continue;
            e.delete();
        }
    }

    private void verifyNoIncidentalDeletion(Vertex v) {
        for (Edge e : v.incidences()) {
            if (!this.preservables.contains(e.getNormalEdge()) && this.matchedEdges.contains(e.getNormalEdge())) continue;
            throw new GReTLException(this.context, "Prevervable or non-matched edge " + e + " from " + e.getAlpha() + " to " + e.getOmega() + " would be deleted by deleting " + v + "\ndeleted vertex = " + v + ",\nmatchedVertices = " + this.matchedVertices + ",\nmatchedEdges = " + this.matchedEdges + ",\npreservables = " + this.preservables + ",\nquery = " + this.semanticExpression);
        }
    }

    private void createAndUpdateEdges() {
        for (CreateEdge ce : this.replaceGraph.getCreateEdgeEdges()) {
            Vertex startVertex = this.createVertices2Vertices.get(ce.getAlpha());
            Vertex endVertex = this.createVertices2Vertices.get(ce.getOmega());
            Object arch = null;
            if (ce.get_archetype() != null) {
                arch = this.context.evaluateGReQLQuery(ce.get_archetype());
            }
            if (ce.get_typeName() == null && arch != null && arch instanceof Edge) {
                Edge e = ((Edge)arch).getNormalEdge();
                this.preservables.add(e);
                this.allModifiedElements.add(e);
                e.setAlpha(startVertex);
                e.setOmega(endVertex);
                this.setAttributeValues(e, arch, ce.get_attributes(), ce.is_copyAttributeValues());
                continue;
            }
            Edge newEdge = this.createEdge(ce, startVertex, endVertex);
            if (this.addGlobalMappings && arch != null) {
                POrderedMap<Object, AttributedElement<?, ?>> m = Empty.orderedMap();
                m = m.plus(arch, newEdge);
                new AddMappings(this.context, m).execute();
                if (arch instanceof Edge) {
                    this.allModifiedElements.add((Edge)arch);
                }
            }
            this.setAttributeValues(newEdge, arch, ce.get_attributes(), ce.is_copyAttributeValues());
        }
    }

    private void createAndUpdateVertices() {
        for (CreateVertex cv : this.replaceGraph.getCreateVertexVertices()) {
            Object arch = null;
            if (cv.get_archetype() != null) {
                arch = this.context.evaluateGReQLQuery(cv.get_archetype());
            }
            if (cv.get_typeName() == null && arch != null && arch instanceof Vertex) {
                Vertex v = (Vertex)arch;
                this.createVertices2Vertices.put(cv, v);
                this.preservables.add(v);
                this.allModifiedElements.add(v);
                this.setAttributeValues(v, arch, cv.get_attributes(), cv.is_copyAttributeValues());
                continue;
            }
            Vertex newVertex = this.createVertex(cv);
            this.createVertices2Vertices.put(cv, newVertex);
            if (arch != null) {
                if (this.addGlobalMappings) {
                    POrderedMap<Object, AttributedElement<?, ?>> m = Empty.orderedMap();
                    m = m.plus(arch, newVertex);
                    new AddMappings(this.context, m).execute();
                }
                if (arch instanceof Vertex) {
                    Vertex replacedVertex = (Vertex)arch;
                    this.allModifiedElements.add(replacedVertex);
                    this.relinkIncidences(replacedVertex, newVertex);
                }
            }
            this.setAttributeValues(newVertex, arch, cv.get_attributes(), cv.is_copyAttributeValues());
        }
    }

    private Vertex createVertex(CreateVertex cv) {
        VertexClass vc = this.vc(CreateSubgraph.getVertexClassName(cv, this.context));
        Object nv = this.context.getTargetGraph().createVertex(vc);
        return nv;
    }

    private Edge createEdge(CreateEdge e, Vertex startVertex, Vertex endVertex) {
        EdgeClass ec = null;
        if (e.get_typeName() != null) {
            String type = e.get_typeName();
            ec = e.is_typeNameIsQuery() ? this.ec(this.context.evaluateGReQLQuery(type).toString()) : this.ec(e.get_typeName());
        } else {
            ec = this.getSingleEdgeClassBetween(startVertex.getAttributedElementClass(), endVertex.getAttributedElementClass());
        }
        return this.context.getTargetGraph().createEdge(ec, startVertex, endVertex);
    }

    private EdgeClass getSingleEdgeClassBetween(VertexClass from, VertexClass to) {
        LinkedList<EdgeClass> possibles = new LinkedList<EdgeClass>();
        for (EdgeClass ec : from.getConnectedEdgeClasses()) {
            if (ec.isAbstract()) continue;
            VertexClass f = ec.getFrom().getVertexClass();
            VertexClass t = ec.getTo().getVertexClass();
            if (!f.equals(from) && !f.isSuperClassOf(from) || !t.equals(to) && !t.isSuperClassOf(to)) continue;
            possibles.add(ec);
        }
        if (possibles.size() != 1) {
            throw new GReTLException(this.context, "Cannot find exactly one EdgeClass between " + from.getQualifiedName() + " and " + to.getQualifiedName() + ", but there were these possibilities: " + possibles + ".");
        }
        return (EdgeClass)possibles.get(0);
    }

    private void setAttributeValues(GraphElement<?, ?> ge, Object arch, Map<String, String> attrMap, boolean copy) {
        if (attrMap == null) {
            return;
        }
        if (copy && (arch == null || !(arch instanceof AttributedElement))) {
            throw new GReTLException(this.context, "Should copy attribute values, but the archetype '" + arch + "' is no AttributedElement.");
        }
        if (copy) {
            AttributedElement ae = (AttributedElement)arch;
            Object aeClass = ae.getAttributedElementClass();
            GraphElementClass geClass = (GraphElementClass)ge.getAttributedElementClass();
            for (Attribute attr : geClass.getAttributeList()) {
                String attrName = attr.getName();
                if (attrMap.containsKey(attrName) || !aeClass.containsAttribute(attrName) || aeClass.getAttribute(attrName).getDomain() != attr.getDomain()) continue;
                ge.setAttribute(attrName, ae.getAttribute(attrName));
            }
        }
        for (Map.Entry<String, String> e : attrMap.entrySet()) {
            ge.setAttribute(e.getKey(), this.context.evaluateGReQLQuery(e.getValue()));
        }
    }

    private boolean isValidMatch() {
        for (Vertex v : this.matchedVertices) {
            if (!this.allModifiedElements.contains(v)) continue;
            return false;
        }
        for (Edge e : this.matchedEdges) {
            if (!this.allModifiedElements.contains(e)) continue;
            return false;
        }
        return true;
    }
}

