/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.InPlaceTransformation;
import java.util.Map;
import org.pcollections.PMap;
import org.pcollections.PSet;

public class MergeVertices
extends InPlaceTransformation {
    private final String semanticExpression;
    private PMap<Vertex, PSet<Vertex>> matches;

    public MergeVertices(Context context, String semExp) {
        super(context);
        this.semanticExpression = semExp;
    }

    public MergeVertices(Context context, PMap<Vertex, PSet<Vertex>> matches) {
        this(context, (String)null);
        this.matches = matches;
    }

    public static MergeVertices parseAndCreate(ExecuteTransformation et) {
        et.matchTransformationArrow();
        String semExp = et.matchSemanticExpression();
        return new MergeVertices(et.context, semExp);
    }

    @Override
    protected Integer transform() {
        if (this.context.getPhase() == Context.TransformationPhase.SCHEMA) {
            throw new GReTLException("SCHEMA phase in InPlaceTransformatio?!?");
        }
        if (this.matches == null) {
            this.matches = (PMap)this.context.evaluateGReQLQuery(this.semanticExpression);
        }
        int count = 0;
        for (Map.Entry e : this.matches.entrySet()) {
            Vertex keep = (Vertex)e.getKey();
            if (!keep.isValid()) continue;
            PSet deletes = (PSet)e.getValue();
            if (deletes.size() > 0) {
                ++count;
            }
            for (Vertex del : deletes) {
                if (del == keep) {
                    throw new GReTLException(this.context, keep + " should be both kept and deleted!");
                }
                this.relinkIncidences(del, keep);
                del.delete();
            }
        }
        this.matches = null;
        return count;
    }
}

