/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.CountingTransformation;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.parser.TokenTypes;
import de.uni_koblenz.jgralab.utilities.tg2dot.Tg2Dot;
import de.uni_koblenz.jgralab.utilities.tg2dot.dot.GraphVizOutputFormat;
import java.io.File;
import java.io.IOException;

public class PrintGraph
extends CountingTransformation {
    private File file;
    private Graph graph;

    protected PrintGraph(Context context, Graph g, File f) {
        super(context);
        this.file = f;
        this.graph = g;
    }

    public static PrintGraph parseAndCreate(ExecuteTransformation et) {
        String alias = "default";
        if (et.tryMatchGraphAlias()) {
            alias = et.matchGraphAlias();
        }
        Graph g = null;
        g = alias.equals("target") ? et.context.getTargetGraph() : et.context.getSourceGraph(alias);
        File f = new File(et.match((TokenTypes)TokenTypes.STRING).value);
        return new PrintGraph(et.context, g, f);
    }

    @Override
    protected Integer transform() {
        try {
            Tg2Dot.convertGraph(this.graph, this.file.getAbsolutePath(), GraphVizOutputFormat.PDF);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }
}

