/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl.eca;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.eca.Action;
import de.uni_koblenz.jgralab.eca.events.Event;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class GretlTransformAction<AEC extends AttributedElementClass<AEC, ?>>
implements Action<AEC> {
    Class<? extends Transformation<Graph>> transformationClass;

    public GretlTransformAction(Class<? extends Transformation<Graph>> transformationClass) {
        this.transformationClass = transformationClass;
    }

    @Override
    public void doAction(Event<AEC> event) {
        try {
            Graph graph = event.getGraph();
            Context context = new Context(graph.getSchema());
            context.setSourceGraph(graph);
            context.setTargetGraph(graph);
            Constructor<? extends Transformation<Graph>> constr = this.transformationClass.getConstructor(Context.class);
            Transformation<Graph> transform = constr.newInstance(context);
            transform.execute();
        }
        catch (SecurityException e) {
            System.err.println("Gretl transformation " + this.transformationClass.getName() + " failed!");
        }
        catch (NoSuchMethodException e) {
            System.err.println("Gretl transformation " + this.transformationClass.getName() + " failed!");
        }
        catch (IllegalArgumentException e) {
            System.err.println("Gretl transformation " + this.transformationClass.getName() + " failed!");
        }
        catch (InstantiationException e) {
            System.err.println("Gretl transformation " + this.transformationClass.getName() + " failed!");
        }
        catch (IllegalAccessException e) {
            System.err.println("Gretl transformation " + this.transformationClass.getName() + " failed!");
        }
        catch (InvocationTargetException e) {
            System.err.println("Gretl transformation " + this.transformationClass.getName() + " failed!");
        }
    }

    public Class<? extends Transformation<Graph>> getTransformationClass() {
        return this.transformationClass;
    }
}

