/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl.parser;

import de.uni_koblenz.jgralab.gretl.CreateSubgraph;
import de.uni_koblenz.jgralab.gretl.MatchReplace;
import de.uni_koblenz.jgralab.gretl.parser.Token;
import de.uni_koblenz.jgralab.gretl.parser.TokenTypes;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GReTLLexer {
    private String transformText = null;
    private int position = 0;
    private List<Token> tokens = null;
    private static Set<String> transformsWithCustomDSL = new HashSet<String>();
    protected static Map<TokenTypes, String> fixedTokens;
    private static final String[] semanticExpSeparators;

    private GReTLLexer(String source) {
        this.transformText = source;
        this.position = 0;
        this.tokens = new ArrayList<Token>();
        if (this.transformText == null) {
            throw new NullPointerException("Cannot parse nullpointer as GReTL transformation.");
        }
    }

    private static final boolean isSeparator(int c) {
        return c == 59 || c == 40 || c == 41 || c == 123 || c == 125 || c == 58 || c == 44 || Character.isWhitespace(c) || c == 45;
    }

    private static final boolean isStringQuote(int c) {
        return c == 34 || c == 39;
    }

    private Token nextIdentifier() {
        StringBuilder nextPossibleToken = new StringBuilder();
        int start = this.position;
        while (!GReTLLexer.isSeparator(this.transformText.charAt(this.position))) {
            nextPossibleToken.append(this.transformText.charAt(this.position++));
            this.checkPosition("reading identifier");
        }
        String tokenText = nextPossibleToken.toString();
        return new Token(TokenTypes.IDENT, tokenText, start, this.position);
    }

    private int skipString() {
        char quoteChar = this.transformText.charAt(this.position);
        if (!GReTLLexer.isStringQuote(quoteChar)) {
            throw new RuntimeException();
        }
        int start = this.position;
        do {
            ++this.position;
            if (this.transformText.charAt(this.position - 2) != '\\' && this.transformText.charAt(this.position - 1) == '\\') {
                ++this.position;
            }
            this.checkPosition("skipping string");
        } while (this.transformText.charAt(this.position) != quoteChar);
        if (this.transformText.charAt(this.position) != quoteChar) {
            throw new RuntimeException();
        }
        ++this.position;
        this.checkPosition("skipping string");
        return start;
    }

    private void checkPosition(String txt) {
        if (this.position >= this.transformText.length()) {
            throw new RuntimeException("EOF while " + txt + " (position " + this.position + ")");
        }
    }

    private final boolean skipWhitespacesAndComments() {
        boolean skipped = false;
        boolean everSkipped = false;
        do {
            skipped = false;
            while (this.position < this.transformText.length() && Character.isWhitespace(this.transformText.charAt(this.position))) {
                ++this.position;
                skipped = true;
                everSkipped = true;
            }
            if (this.position == this.transformText.length()) {
                return everSkipped;
            }
            if (!this.transformText.substring(this.position, this.position + 2).equals("//")) continue;
            skipped = true;
            this.position += 2;
            while (this.transformText.charAt(this.position) != '\n') {
                ++this.position;
            }
            ++this.position;
            everSkipped = true;
        } while (skipped);
        return everSkipped;
    }

    public static List<Token> scan(String query) {
        GReTLLexer lexer = new GReTLLexer(query);
        List<Token> tokens = lexer.scan();
        return tokens;
    }

    public List<Token> scan() {
        boolean lexingGReQL = false;
        boolean lexingDSL = false;
        block0: do {
            Token t;
            int start;
            this.skipWhitespacesAndComments();
            if (this.position == this.transformText.length()) {
                this.tokens.add(new Token(TokenTypes.EOF, "", this.position, this.position));
                continue;
            }
            if (lexingGReQL) {
                start = this.skipToSemicolonOrArrow();
                lexingGReQL = false;
                t = new Token(TokenTypes.GREQL, this.transformText.substring(start, this.position).trim(), start, this.position);
                this.tokens.add(t);
                continue;
            }
            if (lexingDSL) {
                start = this.skipToArrow();
                lexingDSL = false;
                t = new Token(TokenTypes.DOMAIN_SPECIFIC, this.transformText.substring(start, this.position).trim(), start, this.position);
                this.tokens.add(t);
                continue;
            }
            if (GReTLLexer.isStringQuote(this.transformText.charAt(this.position))) {
                start = this.skipString();
                t = new Token(TokenTypes.STRING, this.transformText.substring(start + 1, this.position - 1), start, this.position);
                this.tokens.add(t);
                continue;
            }
            start = this.position;
            for (Map.Entry<TokenTypes, String> e : fixedTokens.entrySet()) {
                if (!this.transformText.regionMatches(start, e.getValue(), 0, e.getValue().length())) continue;
                char c = this.transformText.charAt(this.position + e.getValue().length());
                if (e.getValue().matches("\\p{Alnum}+") && !GReTLLexer.isSeparator(c)) continue;
                this.position = start + e.getValue().length();
                Token t2 = new Token(e.getKey(), e.getValue(), start, this.position);
                this.tokens.add(t2);
                if (e.getKey() != TokenTypes.TRANSFORM_ARROW && e.getKey() != TokenTypes.DEFINES) continue block0;
                lexingGReQL = true;
                continue block0;
            }
            t = this.nextIdentifier();
            this.tokens.add(t);
            if (!transformsWithCustomDSL.contains(t.value)) continue;
            lexingDSL = true;
        } while (this.position < this.transformText.length());
        return this.tokens;
    }

    private int skipToArrow() {
        int start = this.position;
        while (!this.transformText.regionMatches(this.position, fixedTokens.get((Object)TokenTypes.TRANSFORM_ARROW), 0, 3)) {
            ++this.position;
        }
        return start;
    }

    private int skipToSemicolonOrArrow() {
        this.skipWhitespacesAndComments();
        int start = this.position;
        char c = this.transformText.charAt(this.position);
        while (c != ';' && !this.transformText.substring(this.position, this.position + 3).equals(fixedTokens.get((Object)TokenTypes.TRANSFORM_ARROW))) {
            if (!this.skipWhitespacesAndComments()) {
                ++this.position;
            }
            c = this.transformText.charAt(this.position);
        }
        return start;
    }

    public static void main(String[] args) throws IOException {
        BufferedReader r = new BufferedReader(new FileReader(new File("/home/horn/Repos/uni/jgralab/testit/de/uni_koblenz/jgralabtest/gretl/transforms/AddressBookRefactoring.gretl")));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = r.readLine()) != null) {
            sb.append(line);
            sb.append('\n');
        }
        r.close();
        List<Token> tokens = GReTLLexer.scan("makeAddressBook ::= CreateVertexClass AddressBook <== set(1);\nCall makeAddressBook;\n");
        for (Token t : tokens) {
            System.out.println(t);
        }
    }

    static {
        transformsWithCustomDSL.add(CreateSubgraph.class.getSimpleName());
        transformsWithCustomDSL.add(MatchReplace.class.getSimpleName());
        fixedTokens = new LinkedHashMap<TokenTypes, String>();
        fixedTokens.put(TokenTypes.TRANSFORMATION, "transformation");
        fixedTokens.put(TokenTypes.AGGREGATION, "aggregation");
        fixedTokens.put(TokenTypes.FROM, "from");
        fixedTokens.put(TokenTypes.ROLE, "role");
        fixedTokens.put(TokenTypes.TO, "to");
        fixedTokens.put(TokenTypes.TRANSFORM_ARROW, "<==");
        fixedTokens.put(TokenTypes.DEFINES, ":=");
        fixedTokens.put(TokenTypes.DEFINES_TRANSFORMATION, "::=");
        fixedTokens.put(TokenTypes.PAREN_OPEN, "(");
        fixedTokens.put(TokenTypes.PAREN_CLOSE, ")");
        fixedTokens.put(TokenTypes.COLON, ":");
        fixedTokens.put(TokenTypes.ASSIGN, "=");
        fixedTokens.put(TokenTypes.SEMICOLON, ";");
        fixedTokens.put(TokenTypes.COMMA, ",");
        fixedTokens.put(TokenTypes.GREQL_IMPORT, "import");
        semanticExpSeparators = new String[]{fixedTokens.get((Object)TokenTypes.DEFINES), fixedTokens.get((Object)TokenTypes.TRANSFORM_ARROW)};
        Arrays.sort(semanticExpSeparators, new StringLengthComparator());
    }

    private static final class StringLengthComparator
    implements Comparator<String> {
        private StringLengthComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            int o2l;
            int o1l = o1.length();
            int diff = o1l - (o2l = o1.length());
            if (diff != 0) {
                return diff;
            }
            return o1.compareTo(o2);
        }
    }
}

