/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.grumlschema;

import de.uni_koblenz.jgralab.GraphFactory;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.ProgressFunction;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.grumlschema.SchemaGraph;
import de.uni_koblenz.jgralab.grumlschema.impl.std.SchemaGraphFactoryImpl;
import de.uni_koblenz.jgralab.impl.generic.GenericGraphFactoryImpl;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.EnumDomain;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.impl.ConstraintImpl;
import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;
import java.lang.ref.WeakReference;

public class GrumlSchema
extends SchemaImpl {
    static WeakReference<GrumlSchema> theInstance = new WeakReference<Object>(null);

    public static synchronized GrumlSchema instance() {
        GrumlSchema s = (GrumlSchema)theInstance.get();
        if (s != null) {
            return s;
        }
        s = new GrumlSchema();
        theInstance = new WeakReference<GrumlSchema>(s);
        return s;
    }

    private GrumlSchema() {
        super("GrumlSchema", "de.uni_koblenz.jgralab.grumlschema");
        EnumDomain dom = this.createEnumDomain("structure.AggregationKind");
        dom.addConst("NONE");
        dom.addConst("SHARED");
        dom.addConst("COMPOSITE");
        this.createListDomain(this.getDomain("String"));
        GraphClass gc = this.createGraphClass("SchemaGraph");
        VertexClass vc_NamedElement = gc.createVertexClass("structure.NamedElement");
        vc_NamedElement.setAbstract(true);
        vc_NamedElement.createAttribute("qualifiedName", this.getDomain("String"), null);
        VertexClass vc_Comment = gc.createVertexClass("structure.Comment");
        vc_Comment.setAbstract(false);
        vc_Comment.createAttribute("text", this.getDomain("String"), null);
        VertexClass vc_IncidenceClass = gc.createVertexClass("structure.IncidenceClass");
        vc_IncidenceClass.setAbstract(false);
        vc_IncidenceClass.createAttribute("aggregation", this.getDomain("structure.AggregationKind"), null);
        vc_IncidenceClass.createAttribute("max", this.getDomain("Integer"), null);
        vc_IncidenceClass.createAttribute("min", this.getDomain("Integer"), null);
        vc_IncidenceClass.createAttribute("roleName", this.getDomain("String"), null);
        vc_IncidenceClass.addConstraint(new ConstraintImpl("Each IncidenceClass must either have a ComesFrom or a GoesTo Edge.", "import structure.*; forall ic : V{IncidenceClass} @ count(ic --<>{ComesFrom, GoesTo}) = 1", "import structure.*; from ic : V{IncidenceClass} with count(ic --<>{ComesFrom, GoesTo}) <> 1 reportSet ic end"));
        vc_IncidenceClass.addComment("The implementation in jgralab.schema.impl gets an \"edgeclass\" attribute to ensure two-way navigability of ComesFrom/GoesTo associations.");
        VertexClass vc_Schema = gc.createVertexClass("structure.Schema");
        vc_Schema.setAbstract(false);
        vc_Schema.createAttribute("name", this.getDomain("String"), null);
        vc_Schema.createAttribute("packagePrefix", this.getDomain("String"), null);
        VertexClass vc_Constraint = gc.createVertexClass("structure.Constraint");
        vc_Constraint.setAbstract(false);
        vc_Constraint.createAttribute("message", this.getDomain("String"), null);
        vc_Constraint.createAttribute("offendingElementsQuery", this.getDomain("String"), null);
        vc_Constraint.createAttribute("predicateQuery", this.getDomain("String"), null);
        VertexClass vc_Attribute = gc.createVertexClass("structure.Attribute");
        vc_Attribute.setAbstract(false);
        vc_Attribute.createAttribute("defaultValue", this.getDomain("String"), null);
        vc_Attribute.createAttribute("name", this.getDomain("String"), null);
        vc_Attribute.addComment("The defaultValue is a string constant in TG syntax, compatible to the Domain of the Attribute.\ndefaultValue may be null (which means no default value is specified).");
        VertexClass vc_Package = gc.createVertexClass("structure.Package");
        vc_Package.setAbstract(false);
        vc_Package.addSuperClass(vc_NamedElement);
        vc_Package.addConstraint(new ConstraintImpl("A Package must either be default or subpackage, but not both", "import structure.*; forall p: V{Package} @ (inDegree{ContainsDefaultPackage}(p) + inDegree{ContainsSubPackage}(p)) = 1", "import structure.*; from p: V{Package} with (inDegree{ContainsDefaultPackage}(p) + inDegree{ContainsSubPackage}(p)) <> 1 reportSet p end"));
        VertexClass vc_AttributedElementClass = gc.createVertexClass("structure.AttributedElementClass");
        vc_AttributedElementClass.setAbstract(true);
        vc_AttributedElementClass.addSuperClass(vc_NamedElement);
        VertexClass vc_Domain = gc.createVertexClass("domains.Domain");
        vc_Domain.setAbstract(true);
        vc_Domain.addSuperClass(vc_NamedElement);
        VertexClass vc_GraphClass = gc.createVertexClass("structure.GraphClass");
        vc_GraphClass.setAbstract(false);
        vc_GraphClass.addSuperClass(vc_AttributedElementClass);
        vc_GraphClass.addConstraint(new ConstraintImpl("There must be exactly one GraphClass.", "count(V{structure.GraphClass}) = 1", "V{structure.GraphClass}"));
        VertexClass vc_GraphElementClass = gc.createVertexClass("structure.GraphElementClass");
        vc_GraphElementClass.setAbstract(true);
        vc_GraphElementClass.addSuperClass(vc_AttributedElementClass);
        vc_GraphElementClass.createAttribute("abstract", this.getDomain("Boolean"), null);
        VertexClass vc_CollectionDomain = gc.createVertexClass("domains.CollectionDomain");
        vc_CollectionDomain.setAbstract(true);
        vc_CollectionDomain.addSuperClass(vc_Domain);
        VertexClass vc_BasicDomain = gc.createVertexClass("domains.BasicDomain");
        vc_BasicDomain.setAbstract(true);
        vc_BasicDomain.addSuperClass(vc_Domain);
        VertexClass vc_RecordDomain = gc.createVertexClass("domains.RecordDomain");
        vc_RecordDomain.setAbstract(false);
        vc_RecordDomain.addSuperClass(vc_Domain);
        VertexClass vc_MapDomain = gc.createVertexClass("domains.MapDomain");
        vc_MapDomain.setAbstract(false);
        vc_MapDomain.addSuperClass(vc_Domain);
        VertexClass vc_EnumDomain = gc.createVertexClass("domains.EnumDomain");
        vc_EnumDomain.setAbstract(false);
        vc_EnumDomain.addSuperClass(vc_Domain);
        vc_EnumDomain.createAttribute("enumConstants", this.getDomain("List<String>"), null);
        VertexClass vc_VertexClass = gc.createVertexClass("structure.VertexClass");
        vc_VertexClass.setAbstract(false);
        vc_VertexClass.addSuperClass(vc_GraphElementClass);
        VertexClass vc_EdgeClass = gc.createVertexClass("structure.EdgeClass");
        vc_EdgeClass.setAbstract(false);
        vc_EdgeClass.addSuperClass(vc_GraphElementClass);
        vc_EdgeClass.addConstraint(new ConstraintImpl("An EdgeClass may have at most one shared/composite end.", "import structure.*; forall ec : V{EdgeClass}, degree{ComesFrom}(ec) = 1 and degree{GoesTo}(ec) = 1 @ theElement(ec <>--{ComesFrom}).aggregation = \"NONE\" or theElement(ec <>--{GoesTo}).aggregation = \"NONE\"", "import structure.*; from ec : V{EdgeClass} with degree{ComesFrom}(ec) = 1 and degree{GoesTo}(ec) = 1 ? theElement(ec <>--{ComesFrom}).aggregation <> \"NONE\" and theElement(ec <>--{GoesTo}).aggregation <> \"NONE\" : false reportSet ec end"));
        VertexClass vc_SetDomain = gc.createVertexClass("domains.SetDomain");
        vc_SetDomain.setAbstract(false);
        vc_SetDomain.addSuperClass(vc_CollectionDomain);
        VertexClass vc_ListDomain = gc.createVertexClass("domains.ListDomain");
        vc_ListDomain.setAbstract(false);
        vc_ListDomain.addSuperClass(vc_CollectionDomain);
        VertexClass vc_StringDomain = gc.createVertexClass("domains.StringDomain");
        vc_StringDomain.setAbstract(false);
        vc_StringDomain.addSuperClass(vc_BasicDomain);
        VertexClass vc_IntegerDomain = gc.createVertexClass("domains.IntegerDomain");
        vc_IntegerDomain.setAbstract(false);
        vc_IntegerDomain.addSuperClass(vc_BasicDomain);
        VertexClass vc_LongDomain = gc.createVertexClass("domains.LongDomain");
        vc_LongDomain.setAbstract(false);
        vc_LongDomain.addSuperClass(vc_BasicDomain);
        VertexClass vc_DoubleDomain = gc.createVertexClass("domains.DoubleDomain");
        vc_DoubleDomain.setAbstract(false);
        vc_DoubleDomain.addSuperClass(vc_BasicDomain);
        VertexClass vc_BooleanDomain = gc.createVertexClass("domains.BooleanDomain");
        vc_BooleanDomain.setAbstract(false);
        vc_BooleanDomain.addSuperClass(vc_BasicDomain);
        EdgeClass ec_Annotates = gc.createEdgeClass("structure.Annotates", vc_Comment, 0, Integer.MAX_VALUE, "comments", AggregationKind.NONE, vc_NamedElement, 1, 1, "annotatedelement", AggregationKind.NONE);
        ec_Annotates.setAbstract(false);
        EdgeClass ec_EndsAt = gc.createEdgeClass("structure.EndsAt", vc_IncidenceClass, 0, Integer.MAX_VALUE, "incidences", AggregationKind.NONE, vc_VertexClass, 1, 1, "targetclass", AggregationKind.NONE);
        ec_EndsAt.setAbstract(false);
        EdgeClass ec_HasDomain = gc.createEdgeClass("structure.HasDomain", vc_Attribute, 0, Integer.MAX_VALUE, "", AggregationKind.NONE, vc_Domain, 1, 1, "domain", AggregationKind.NONE);
        ec_HasDomain.setAbstract(false);
        EdgeClass ec_HasConstraint = gc.createEdgeClass("structure.HasConstraint", vc_AttributedElementClass, 1, 1, "constrainedelement", AggregationKind.NONE, vc_Constraint, 0, Integer.MAX_VALUE, "constraints", AggregationKind.COMPOSITE);
        ec_HasConstraint.setAbstract(false);
        EdgeClass ec_HasAttribute = gc.createEdgeClass("structure.HasAttribute", vc_AttributedElementClass, 1, 1, "element", AggregationKind.NONE, vc_Attribute, 0, Integer.MAX_VALUE, "attributes", AggregationKind.COMPOSITE);
        ec_HasAttribute.setAbstract(false);
        EdgeClass ec_SpecializesEdgeClass = gc.createEdgeClass("structure.SpecializesEdgeClass", vc_EdgeClass, 0, Integer.MAX_VALUE, "subclasses", AggregationKind.NONE, vc_EdgeClass, 0, Integer.MAX_VALUE, "superclasses", AggregationKind.NONE);
        ec_SpecializesEdgeClass.setAbstract(false);
        EdgeClass ec_ContainsSubPackage = gc.createEdgeClass("structure.ContainsSubPackage", vc_Package, 0, 1, "", AggregationKind.NONE, vc_Package, 0, Integer.MAX_VALUE, "subpackages", AggregationKind.COMPOSITE);
        ec_ContainsSubPackage.setAbstract(false);
        EdgeClass ec_ContainsDomain = gc.createEdgeClass("structure.ContainsDomain", vc_Package, 1, 1, "package", AggregationKind.NONE, vc_Domain, 0, Integer.MAX_VALUE, "domains", AggregationKind.COMPOSITE);
        ec_ContainsDomain.setAbstract(false);
        EdgeClass ec_ContainsGraphElementClass = gc.createEdgeClass("structure.ContainsGraphElementClass", vc_Package, 1, 1, "package", AggregationKind.NONE, vc_GraphElementClass, 0, Integer.MAX_VALUE, "graphelementclasses", AggregationKind.COMPOSITE);
        ec_ContainsGraphElementClass.setAbstract(false);
        EdgeClass ec_ContainsDefaultPackage = gc.createEdgeClass("structure.ContainsDefaultPackage", vc_Schema, 0, 1, "", AggregationKind.NONE, vc_Package, 1, 1, "defaultpackage", AggregationKind.COMPOSITE);
        ec_ContainsDefaultPackage.setAbstract(false);
        EdgeClass ec_DefinesGraphClass = gc.createEdgeClass("structure.DefinesGraphClass", vc_Schema, 1, 1, "", AggregationKind.NONE, vc_GraphClass, 1, 1, "graphclass", AggregationKind.COMPOSITE);
        ec_DefinesGraphClass.setAbstract(false);
        EdgeClass ec_SpecializesVertexClass = gc.createEdgeClass("structure.SpecializesVertexClass", vc_VertexClass, 0, Integer.MAX_VALUE, "subclasses", AggregationKind.NONE, vc_VertexClass, 0, Integer.MAX_VALUE, "superclasses", AggregationKind.NONE);
        ec_SpecializesVertexClass.setAbstract(false);
        EdgeClass ec_ComesFrom = gc.createEdgeClass("structure.ComesFrom", vc_EdgeClass, 0, 1, "", AggregationKind.NONE, vc_IncidenceClass, 1, 1, "from", AggregationKind.COMPOSITE);
        ec_ComesFrom.setAbstract(false);
        EdgeClass ec_GoesTo = gc.createEdgeClass("structure.GoesTo", vc_EdgeClass, 0, 1, "", AggregationKind.NONE, vc_IncidenceClass, 1, 1, "to", AggregationKind.COMPOSITE);
        ec_GoesTo.setAbstract(false);
        EdgeClass ec_HasBaseDomain = gc.createEdgeClass("domains.HasBaseDomain", vc_CollectionDomain, 0, Integer.MAX_VALUE, "", AggregationKind.NONE, vc_Domain, 1, 1, "basedomain", AggregationKind.NONE);
        ec_HasBaseDomain.setAbstract(false);
        EdgeClass ec_HasValueDomain = gc.createEdgeClass("domains.HasValueDomain", vc_MapDomain, 0, Integer.MAX_VALUE, "", AggregationKind.NONE, vc_Domain, 1, 1, "valuedomain", AggregationKind.NONE);
        ec_HasValueDomain.setAbstract(false);
        EdgeClass ec_HasKeyDomain = gc.createEdgeClass("domains.HasKeyDomain", vc_MapDomain, 0, Integer.MAX_VALUE, "", AggregationKind.NONE, vc_Domain, 1, 1, "keydomain", AggregationKind.NONE);
        ec_HasKeyDomain.setAbstract(false);
        EdgeClass ec_HasRecordDomainComponent = gc.createEdgeClass("domains.HasRecordDomainComponent", vc_RecordDomain, 0, Integer.MAX_VALUE, "", AggregationKind.NONE, vc_Domain, 1, Integer.MAX_VALUE, "componentdomains", AggregationKind.SHARED);
        ec_HasRecordDomainComponent.setAbstract(false);
        ec_HasRecordDomainComponent.createAttribute("name", this.getDomain("String"), null);
        this.finish();
    }

    @Override
    public GraphFactory createDefaultGraphFactory(ImplementationType implementationType) {
        switch (implementationType) {
            case GENERIC: {
                return new GenericGraphFactoryImpl(this);
            }
            case STANDARD: {
                return new SchemaGraphFactoryImpl();
            }
        }
        throw new UnsupportedOperationException("No " + (Object)((Object)implementationType) + " support compiled.");
    }

    public SchemaGraph createSchemaGraph(ImplementationType implType) {
        return this.createSchemaGraph(implType, null, 100, 100);
    }

    public SchemaGraph createSchemaGraph(ImplementationType implType, String id, int vMax, int eMax) {
        GraphFactory factory = this.createDefaultGraphFactory(implType);
        return (SchemaGraph)factory.createGraph(this.getGraphClass(), id, vMax, eMax);
    }

    public SchemaGraph createSchemaGraph(GraphFactory factory) {
        return (SchemaGraph)factory.createGraph(this.getGraphClass(), null, 100, 100);
    }

    public SchemaGraph createSchemaGraph(GraphFactory factory, String id, int vMax, int eMax) {
        return (SchemaGraph)factory.createGraph(this.getGraphClass(), id, vMax, eMax);
    }

    public SchemaGraph loadSchemaGraph(String filename) throws GraphIOException {
        GraphFactory factory = this.createDefaultGraphFactory(ImplementationType.STANDARD);
        return this.loadSchemaGraph(filename, factory, null);
    }

    public SchemaGraph loadSchemaGraph(String filename, ProgressFunction pf) throws GraphIOException {
        GraphFactory factory = this.createDefaultGraphFactory(ImplementationType.STANDARD);
        return this.loadSchemaGraph(filename, factory, pf);
    }

    public SchemaGraph loadSchemaGraph(String filename, ImplementationType implType) throws GraphIOException {
        GraphFactory factory = this.createDefaultGraphFactory(implType);
        return this.loadSchemaGraph(filename, factory, null);
    }

    public SchemaGraph loadSchemaGraph(String filename, ImplementationType implType, ProgressFunction pf) throws GraphIOException {
        GraphFactory factory = this.createDefaultGraphFactory(implType);
        return this.loadSchemaGraph(filename, factory, pf);
    }

    public SchemaGraph loadSchemaGraph(String filename, GraphFactory factory) throws GraphIOException {
        return (SchemaGraph)GraphIO.loadGraphFromFile(filename, factory, null);
    }

    public SchemaGraph loadSchemaGraph(String filename, GraphFactory factory, ProgressFunction pf) throws GraphIOException {
        return (SchemaGraph)GraphIO.loadGraphFromFile(filename, factory, pf);
    }

    @Override
    public boolean reopen() {
        throw new UnsupportedOperationException("Cannot reopen a compiled Schema.");
    }
}

