/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.grumlschema.impl.std.structure;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.exception.NoSuchAttributeException;
import de.uni_koblenz.jgralab.grumlschema.SchemaGraph;
import de.uni_koblenz.jgralab.grumlschema.domains.Domain;
import de.uni_koblenz.jgralab.grumlschema.structure.Attribute;
import de.uni_koblenz.jgralab.grumlschema.structure.AttributedElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.HasAttribute;
import de.uni_koblenz.jgralab.grumlschema.structure.HasDomain;
import de.uni_koblenz.jgralab.impl.IncidenceIterable;
import de.uni_koblenz.jgralab.impl.std.VertexImpl;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AttributeImpl
extends VertexImpl
implements Vertex,
Attribute {
    protected String _defaultValue;
    protected String _name;

    public AttributeImpl(int id, Graph g) {
        super(id, g);
    }

    @Override
    public final VertexClass getAttributedElementClass() {
        return Attribute.VC;
    }

    @Override
    public final Class<? extends Vertex> getSchemaClass() {
        return Attribute.class;
    }

    @Override
    public <T> T getAttribute(String attributeName) {
        if (attributeName.equals("defaultValue")) {
            return (T)this.get_defaultValue();
        }
        if (attributeName.equals("name")) {
            return (T)this.get_name();
        }
        throw new NoSuchAttributeException("structure.Attribute doesn't contain an attribute " + attributeName);
    }

    @Override
    public <T> void setAttribute(String attributeName, T data) {
        if (attributeName.equals("defaultValue")) {
            this.set_defaultValue((String)data);
            return;
        }
        if (attributeName.equals("name")) {
            this.set_name((String)data);
            return;
        }
        throw new NoSuchAttributeException("structure.Attribute doesn't contain an attribute " + attributeName);
    }

    @Override
    public String get_defaultValue() {
        return this._defaultValue;
    }

    @Override
    public void set_defaultValue(String _defaultValue) {
        this.ecaAttributeChanging("defaultValue", this._defaultValue, _defaultValue);
        String oldValue = this._defaultValue;
        this._defaultValue = _defaultValue;
        this.graphModified();
        this.ecaAttributeChanged("defaultValue", oldValue, _defaultValue);
    }

    @Override
    public String get_name() {
        return this._name;
    }

    @Override
    public void set_name(String _name) {
        this.ecaAttributeChanging("name", this._name, _name);
        String oldValue = this._name;
        this._name = _name;
        this.graphModified();
        this.ecaAttributeChanged("name", oldValue, _name);
    }

    @Override
    public void readAttributeValues(GraphIO io) throws GraphIOException {
        this._defaultValue = io.matchUtfString();
        this.set_defaultValue(this._defaultValue);
        this._name = io.matchUtfString();
        this.set_name(this._name);
    }

    @Override
    public void readAttributeValueFromString(String attributeName, String value) throws GraphIOException {
        if (attributeName.equals("defaultValue")) {
            GraphIO io = GraphIO.createStringReader(value, this.getSchema());
            this._defaultValue = io.matchUtfString();
            this.set_defaultValue(this._defaultValue);
            return;
        }
        if (attributeName.equals("name")) {
            GraphIO io = GraphIO.createStringReader(value, this.getSchema());
            this._name = io.matchUtfString();
            this.set_name(this._name);
            return;
        }
        throw new NoSuchAttributeException("structure.Attribute doesn't contain an attribute " + attributeName);
    }

    @Override
    public void writeAttributeValues(GraphIO io) throws GraphIOException, IOException {
        io.space();
        io.writeUtfString(this._defaultValue);
        io.writeUtfString(this._name);
    }

    @Override
    public String writeAttributeValueToString(String attributeName) throws IOException, GraphIOException {
        if (attributeName.equals("defaultValue")) {
            GraphIO io = GraphIO.createStringWriter(this.getSchema());
            io.writeUtfString(this._defaultValue);
            return io.getStringWriterResult();
        }
        if (attributeName.equals("name")) {
            GraphIO io = GraphIO.createStringWriter(this.getSchema());
            io.writeUtfString(this._name);
            return io.getStringWriterResult();
        }
        throw new NoSuchAttributeException("structure.Attribute doesn't contain an attribute " + attributeName);
    }

    @Override
    public Attribute getNextAttribute() {
        return (Attribute)this.getNextVertex(Attribute.VC);
    }

    @Override
    public HasDomain getFirstHasDomainIncidence() {
        return (HasDomain)this.getFirstIncidence(HasDomain.EC);
    }

    @Override
    public HasDomain getFirstHasDomainIncidence(EdgeDirection orientation) {
        return (HasDomain)this.getFirstIncidence(HasDomain.EC, orientation);
    }

    @Override
    public HasAttribute getFirstHasAttributeIncidence() {
        return (HasAttribute)this.getFirstIncidence(HasAttribute.EC);
    }

    @Override
    public HasAttribute getFirstHasAttributeIncidence(EdgeDirection orientation) {
        return (HasAttribute)this.getFirstIncidence(HasAttribute.EC, orientation);
    }

    @Override
    public HasAttribute add_element(AttributedElementClass vertex) {
        return (HasAttribute)((SchemaGraph)this.getGraph()).createEdge(HasAttribute.EC, vertex, this);
    }

    @Override
    public List<? extends AttributedElementClass> remove_element() {
        ArrayList<AttributedElementClass> adjacences = new ArrayList<AttributedElementClass>();
        HasAttribute edge = (HasAttribute)this.getFirstIncidence(HasAttribute.EC, EdgeDirection.IN);
        while (edge != null) {
            HasAttribute next = (HasAttribute)edge.getNextIncidence(HasAttribute.EC, EdgeDirection.IN);
            adjacences.add((AttributedElementClass)edge.getThat());
            edge.delete();
            edge = next;
        }
        return adjacences;
    }

    @Override
    public boolean remove_element(AttributedElementClass vertex) {
        boolean elementRemoved = false;
        HasAttribute edge = (HasAttribute)this.getFirstIncidence(HasAttribute.EC, EdgeDirection.IN);
        while (edge != null) {
            HasAttribute next = (HasAttribute)edge.getNextIncidence(HasAttribute.EC, EdgeDirection.IN);
            if (edge.getThat().equals(vertex)) {
                edge.delete();
                elementRemoved = true;
            }
            edge = next;
        }
        return elementRemoved;
    }

    @Override
    public AttributedElementClass get_element() {
        HasAttribute edge = (HasAttribute)this.getFirstIncidence(HasAttribute.EC, EdgeDirection.IN);
        if (edge != null) {
            return (AttributedElementClass)edge.getThat();
        }
        return null;
    }

    @Override
    public HasDomain add_domain(Domain vertex) {
        return (HasDomain)((SchemaGraph)this.getGraph()).createEdge(HasDomain.EC, this, vertex);
    }

    @Override
    public List<? extends Domain> remove_domain() {
        ArrayList<Domain> adjacences = new ArrayList<Domain>();
        HasDomain edge = (HasDomain)this.getFirstIncidence(HasDomain.EC, EdgeDirection.OUT);
        while (edge != null) {
            HasDomain next = (HasDomain)edge.getNextIncidence(HasDomain.EC, EdgeDirection.OUT);
            adjacences.add((Domain)edge.getThat());
            edge.delete();
            edge = next;
        }
        return adjacences;
    }

    @Override
    public boolean remove_domain(Domain vertex) {
        boolean elementRemoved = false;
        HasDomain edge = (HasDomain)this.getFirstIncidence(HasDomain.EC, EdgeDirection.OUT);
        while (edge != null) {
            HasDomain next = (HasDomain)edge.getNextIncidence(HasDomain.EC, EdgeDirection.OUT);
            if (edge.getThat().equals(vertex)) {
                edge.delete();
                elementRemoved = true;
            }
            edge = next;
        }
        return elementRemoved;
    }

    @Override
    public Domain get_domain() {
        HasDomain edge = (HasDomain)this.getFirstIncidence(HasDomain.EC, EdgeDirection.OUT);
        if (edge != null) {
            return (Domain)edge.getThat();
        }
        return null;
    }

    @Override
    public Iterable<HasDomain> getHasDomainIncidences() {
        return new IncidenceIterable<HasDomain>((Vertex)this, HasDomain.EC);
    }

    @Override
    public Iterable<HasDomain> getHasDomainIncidences(EdgeDirection direction) {
        return new IncidenceIterable<HasDomain>(this, HasDomain.EC, direction);
    }

    @Override
    public Iterable<HasAttribute> getHasAttributeIncidences() {
        return new IncidenceIterable<HasAttribute>((Vertex)this, HasAttribute.EC);
    }

    @Override
    public Iterable<HasAttribute> getHasAttributeIncidences(EdgeDirection direction) {
        return new IncidenceIterable<HasAttribute>(this, HasAttribute.EC, direction);
    }
}

