/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl;

import de.uni_koblenz.jgralab.ProgressFunction;
import java.io.PrintStream;

public class ConsoleProgressFunction
implements ProgressFunction {
    private static final int DEFAULTLENGTH = 60;
    private static final String DEFAULTMESSAGE = "Processing";
    private long totalElements;
    private long length;
    private long startTime;
    private int currentChar;
    private PrintStream printStream;
    private String message;

    public ConsoleProgressFunction() {
        this(System.out, 60);
    }

    public ConsoleProgressFunction(int length) {
        this(System.out);
    }

    public ConsoleProgressFunction(String message) {
        this(System.out, message);
    }

    public ConsoleProgressFunction(PrintStream printStream) {
        this(printStream, 60);
    }

    public ConsoleProgressFunction(PrintStream printStream, int length) {
        this(printStream, DEFAULTMESSAGE, length);
    }

    public ConsoleProgressFunction(PrintStream printStream, String message) {
        this(printStream, message, 60);
    }

    public ConsoleProgressFunction(PrintStream printStream, String message, int length) {
        this.printStream = printStream;
        this.length = length;
        this.message = message;
    }

    @Override
    public long getUpdateInterval() {
        return this.length > this.totalElements ? 1L : this.totalElements / this.length;
    }

    @Override
    public void init(long elements) {
        this.printStream.println(this.message + " " + elements + " elements");
        this.currentChar = 0;
        this.totalElements = elements;
        this.printStream.print("[");
        this.printStream.flush();
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void progress(long processedElements) {
        if ((long)this.currentChar < this.length) {
            this.printStream.print("#");
            this.printStream.flush();
            ++this.currentChar;
        }
    }

    @Override
    public void finished() {
        long stopTime = System.currentTimeMillis();
        for (long i = (long)this.currentChar; i < this.length; ++i) {
            this.printStream.print("#");
        }
        this.printStream.println("] time: " + (double)(stopTime - this.startTime) / 1000.0 + "s");
    }
}

