/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl;

import java.io.PrintStream;

public class FreeIndexList {
    private int[] runs;
    private int free;
    private int used;
    private int runCount;

    public FreeIndexList(int initialFreeElements) {
        assert (initialFreeElements > 0);
        this.runs = new int[16];
        this.free = initialFreeElements;
        this.used = 0;
        this.runs[0] = initialFreeElements;
        this.runCount = 1;
        assert (this.isHealthy());
    }

    public int allocateIndex() {
        if (this.free == 0) {
            return 0;
        }
        assert (this.runCount > 0);
        int result = 0;
        if (this.runs[0] > 0) {
            result = 1;
            this.runs[0] = this.runs[0] - 1;
            if (this.runs[0] == 0) {
                if (this.runCount > 1) {
                    System.arraycopy(this.runs, 1, this.runs, 0, this.runCount - 1);
                    this.runs[--this.runCount] = 0;
                    this.runs[0] = this.runs[0] - 1;
                } else {
                    this.runs[0] = -1;
                }
            } else {
                if (this.runCount >= this.runs.length) {
                    int[] newRuns = new int[this.runs.length * 2];
                    System.arraycopy(this.runs, 0, newRuns, 1, this.runs.length);
                    this.runs = newRuns;
                } else {
                    System.arraycopy(this.runs, 0, this.runs, 1, this.runCount);
                }
                ++this.runCount;
                this.runs[0] = -1;
            }
        } else {
            assert (this.runCount >= 2);
            result = -this.runs[0] + 1;
            this.runs[0] = this.runs[0] - 1;
            this.runs[1] = this.runs[1] - 1;
            if (this.runs[1] == 0) {
                if (this.runCount > 2) {
                    assert (this.runs[2] < 0);
                    this.runs[0] = this.runs[0] + this.runs[2];
                    System.arraycopy(this.runs, 3, this.runs, 1, this.runCount - 3);
                    this.runs[--this.runCount] = 0;
                    this.runs[--this.runCount] = 0;
                } else {
                    assert (this.runs[this.runCount - 1] == 0);
                    --this.runCount;
                }
            }
        }
        --this.free;
        ++this.used;
        assert (this.isHealthy());
        return result;
    }

    public void freeIndex(int index) {
        this.freeRange(index, 1);
    }

    public void freeRange(int index, int length) {
        int begin;
        assert (this.runCount > 0);
        assert (index > 0);
        assert (length > 0);
        assert (index + length - 1 <= this.used + this.free);
        int end = 0;
        int runIndex = 0;
        do {
            begin = end + 1;
        } while (index > (end += Math.abs(this.runs[runIndex])) && ++runIndex < this.runCount);
        assert (runIndex < this.runCount) : "freeRange: index " + index + " out of range 1.." + (this.used + this.free);
        assert (this.runs[runIndex] < 0);
        if (index == begin) {
            assert (length <= -this.runs[runIndex]);
            if (runIndex == 0) {
                if (length == -this.runs[0]) {
                    if (this.runCount == 1) {
                        this.runs[0] = length;
                    } else {
                        System.arraycopy(this.runs, 1, this.runs, 0, this.runCount - 1);
                        assert (this.runs[0] > 0);
                        this.runs[--this.runCount] = 0;
                        this.runs[0] = this.runs[0] + length;
                    }
                } else {
                    if (this.runCount == this.runs.length) {
                        int[] newRuns = new int[this.runs.length * 2];
                        System.arraycopy(this.runs, 0, newRuns, 1, this.runCount);
                        this.runs = newRuns;
                    } else {
                        System.arraycopy(this.runs, 0, this.runs, 1, this.runCount);
                    }
                    ++this.runCount;
                    this.runs[0] = length;
                    this.runs[1] = this.runs[1] + length;
                }
            } else {
                assert (this.runs[runIndex - 1] > 0);
                if (length == -this.runs[runIndex]) {
                    int n = runIndex - 1;
                    this.runs[n] = this.runs[n] + length;
                    if (runIndex == this.runCount - 1) {
                        this.runs[--this.runCount] = 0;
                    } else {
                        int n2 = runIndex - 1;
                        this.runs[n2] = this.runs[n2] + this.runs[runIndex + 1];
                        System.arraycopy(this.runs, runIndex + 2, this.runs, runIndex, this.runCount - runIndex - 2);
                        this.runs[--this.runCount] = 0;
                        this.runs[--this.runCount] = 0;
                    }
                } else {
                    int n = runIndex - 1;
                    this.runs[n] = this.runs[n] + length;
                    int n3 = runIndex;
                    this.runs[n3] = this.runs[n3] + length;
                }
            }
        } else if (index == end) {
            assert (length == 1);
            if (runIndex == this.runCount - 1) {
                if (this.runCount == this.runs.length) {
                    int[] newRuns = new int[this.runs.length * 2];
                    System.arraycopy(this.runs, 0, newRuns, 0, this.runCount);
                    this.runs = newRuns;
                }
                int n = runIndex;
                this.runs[n] = this.runs[n] + length;
                this.runs[this.runCount++] = length;
            } else {
                assert (this.runs[runIndex + 1] > 0);
                int n = runIndex;
                this.runs[n] = this.runs[n] + length;
                assert (this.runs[runIndex] < 0);
                int n4 = runIndex + 1;
                this.runs[n4] = this.runs[n4] + length;
            }
        } else {
            assert (index - begin + length <= -this.runs[runIndex]);
            if (index + length == end + 1) {
                if (runIndex == this.runCount - 1) {
                    if (this.runCount == this.runs.length) {
                        int[] newRuns = new int[this.runs.length * 2];
                        System.arraycopy(this.runs, 0, newRuns, 0, this.runCount);
                        this.runs = newRuns;
                    }
                    int n = runIndex;
                    this.runs[n] = this.runs[n] + length;
                    this.runs[this.runCount++] = length;
                } else {
                    assert (this.runs[runIndex + 1] > 0);
                    int n = runIndex;
                    this.runs[n] = this.runs[n] + length;
                    int n5 = runIndex + 1;
                    this.runs[n5] = this.runs[n5] + length;
                }
                assert (this.runs[runIndex] < 0);
            } else {
                int n = this.runs[runIndex];
                if (this.runCount + 2 > this.runs.length) {
                    int[] newRuns = new int[this.runs.length * 2];
                    System.arraycopy(this.runs, 0, newRuns, 0, runIndex);
                    System.arraycopy(this.runs, runIndex + 1, newRuns, runIndex + 3, this.runCount - runIndex - 1);
                    this.runs = newRuns;
                } else {
                    System.arraycopy(this.runs, runIndex + 1, this.runs, runIndex + 3, this.runCount - runIndex - 1);
                }
                this.runCount += 2;
                this.runs[runIndex] = -(index - begin);
                this.runs[runIndex + 1] = length;
                this.runs[runIndex + 2] = n + (index - begin) + length;
            }
        }
        this.used -= length;
        this.free += length;
        assert (this.isHealthy());
    }

    private void printArray(PrintStream ps) {
        ps.println("---------------------------------------------------");
        ps.println(this);
        ps.println("free=" + this.free + ", used=" + this.used + ", length=" + this.runs.length + ", runCount=" + this.runCount);
        ps.print(" [");
        for (int run : this.runs) {
            ps.print(" " + run);
        }
        ps.println(" ]");
        ps.println("---------------------------------------------------");
        ps.flush();
    }

    public void reinitialize(Object[] a) {
        int i = 1;
        this.free = 0;
        this.used = 0;
        this.runCount = 0;
        while (i < a.length) {
            int[] newRuns;
            int cnt = 0;
            while (i < a.length && a[i] != null) {
                ++i;
                ++cnt;
            }
            if (cnt > 0) {
                if (this.runCount == this.runs.length) {
                    newRuns = new int[this.runs.length * 2];
                    System.arraycopy(this.runs, 0, newRuns, 0, this.runCount);
                    this.runs = newRuns;
                }
                this.runs[this.runCount++] = -cnt;
                this.used += cnt;
            }
            cnt = 0;
            while (i < a.length && a[i] == null) {
                ++i;
                ++cnt;
            }
            if (cnt <= 0) continue;
            if (this.runCount == this.runs.length) {
                newRuns = new int[this.runs.length * 2];
                System.arraycopy(this.runs, 0, newRuns, 0, this.runCount);
                this.runs = newRuns;
            }
            this.runs[this.runCount++] = cnt;
            this.free += cnt;
        }
        assert (this.used + this.free + 1 == a.length);
        assert (this.isHealthy());
    }

    private boolean isHealthy() {
        int i;
        assert (this.runCount > 0);
        assert (this.free >= 0);
        assert (this.used >= 0);
        int sum = 0;
        for (i = 0; i < this.runCount; ++i) {
            assert (this.runs[i] != 0) : "runs[" + i + "] must be != 0";
            if (i > 0) assert (this.runs[i - 1] > 0 && this.runs[i] < 0 || this.runs[i - 1] < 0 && this.runs[i] > 0) : "used and free runs must alternate";
            sum += Math.abs(this.runs[i]);
        }
        for (i = this.runCount; i < this.runs.length; ++i) {
            assert (this.runs[i] == 0) : "runs[" + i + "] must be == 0";
        }
        assert (sum == this.used + this.free);
        return true;
    }

    public int getFree() {
        return this.free;
    }

    public int getSize() {
        return this.used + this.free;
    }

    public int getUsed() {
        return this.used;
    }

    public void expandBy(int n) {
        assert (n > 0);
        if (this.runs[this.runCount - 1] > 0) {
            int n2 = this.runCount - 1;
            this.runs[n2] = this.runs[n2] + n;
        } else {
            if (this.runCount == this.runs.length) {
                int[] newRuns = new int[this.runs.length * 2];
                System.arraycopy(this.runs, 0, newRuns, 0, this.runCount);
                this.runs = newRuns;
            }
            this.runs[this.runCount++] = n;
        }
        this.free += n;
        assert (this.isHealthy());
    }

    public boolean isFragmented() {
        return this.runCount > 2 || this.runCount == 2 && this.runs[0] > 0;
    }
}

