/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphFactory;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.GraphStructureChangedListener;
import de.uni_koblenz.jgralab.GraphStructureChangedListenerWithAutoRemove;
import de.uni_koblenz.jgralab.ProgressFunction;
import de.uni_koblenz.jgralab.Record;
import de.uni_koblenz.jgralab.TraversalContext;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.VertexFilter;
import de.uni_koblenz.jgralab.eca.ECARuleManagerInterface;
import de.uni_koblenz.jgralab.exception.GraphException;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.graphmarker.SubGraphMarker;
import de.uni_koblenz.jgralab.impl.EdgeBaseImpl;
import de.uni_koblenz.jgralab.impl.EdgeIterable;
import de.uni_koblenz.jgralab.impl.FreeIndexList;
import de.uni_koblenz.jgralab.impl.InternalEdge;
import de.uni_koblenz.jgralab.impl.InternalGraph;
import de.uni_koblenz.jgralab.impl.InternalVertex;
import de.uni_koblenz.jgralab.impl.RandomIdGenerator;
import de.uni_koblenz.jgralab.impl.ReversedEdgeBaseImpl;
import de.uni_koblenz.jgralab.impl.VertexBaseImpl;
import de.uni_koblenz.jgralab.impl.VertexIterable;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.EnumDomain;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.io.DataOutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public abstract class GraphBaseImpl
implements Graph,
InternalGraph {
    private String id;
    private final Schema schema;
    protected GraphFactory graphFactory;
    private long graphVersion;
    private boolean loading;
    protected int vMax;
    protected FreeIndexList freeVertexList;
    protected int eMax;
    protected FreeIndexList freeEdgeList;
    private ThreadLocal<TraversalContext> tc = new ThreadLocal();
    private ECARuleManagerInterface ecaRuleManager;
    protected List<WeakReference<GraphStructureChangedListener>> graphStructureChangedListenersWithAutoRemoval = null;
    protected List<GraphStructureChangedListener> graphStructureChangedListeners = new ArrayList<GraphStructureChangedListener>();

    protected GraphBaseImpl(String id, GraphClass cls) {
        this(id, cls, 1000, 1000);
    }

    @Override
    public void initializeAttributesWithDefaultValues() {
        for (Attribute attr : this.getAttributedElementClass().getAttributeList()) {
            try {
                if (attr.getDefaultValueAsString() == null || attr.getDefaultValueAsString().isEmpty()) continue;
                this.internalSetDefaultValue(attr);
            }
            catch (GraphIOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void internalSetDefaultValue(Attribute attr) throws GraphIOException {
        attr.setDefaultValue(this);
    }

    protected GraphBaseImpl(String id, GraphClass cls, int vMax, int eMax) {
        if (vMax < 1) {
            throw new GraphException("vMax must not be less than 1", null);
        }
        if (eMax < 1) {
            throw new GraphException("eMax must not be less than 1", null);
        }
        this.schema = cls.getSchema();
        this.setId(id == null ? RandomIdGenerator.generateId() : id);
        this.graphVersion = -1L;
        this.setGraphVersion(0L);
        this.expandVertexArray(vMax);
        this.setFirstVertex(null);
        this.setLastVertex(null);
        this.setVCount(0);
        this.setDeleteVertexList(new LinkedList<InternalVertex>());
        this.expandEdgeArray(eMax);
        this.setFirstEdgeInGraph(null);
        this.setLastEdgeInGraph(null);
        this.setECount(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void addEdge(Edge newEdge, Vertex alpha, Vertex omega) {
        assert (newEdge != null);
        assert (alpha != null && alpha.isValid() && this.vSeqContainsVertex(alpha)) : "Alpha vertex is invalid";
        assert (omega != null && omega.isValid() && this.vSeqContainsVertex(omega)) : "Omega vertex is invalid";
        assert (newEdge.isNormal()) : "Can't add reversed edge";
        assert (alpha.getSchema() == omega.getSchema() && alpha.getSchema() == this.schema && newEdge.getSchema() == this.schema) : "The schemas of alpha, omega, newEdge and this graph don't match!";
        assert (alpha.getGraph() == omega.getGraph() && alpha.getGraph() == this && newEdge.getGraph() == this) : "The graph of alpha, omega, newEdge and this graph don't match!";
        EdgeBaseImpl e = (EdgeBaseImpl)newEdge;
        InternalVertex a = (InternalVertex)alpha;
        InternalVertex o = (InternalVertex)omega;
        EdgeClass myEC = newEdge.getAttributedElementClass();
        VertexClass aVC = a.getAttributedElementClass();
        if (!aVC.isValidFromFor(myEC)) {
            throw new GraphException("Edges of class " + myEC.getQualifiedName() + " may not start at vertices of class " + aVC.getQualifiedName());
        }
        VertexClass oVC = o.getAttributedElementClass();
        if (!oVC.isValidToFor(myEC)) {
            throw new GraphException("Edges of class " + myEC.getQualifiedName() + " may not end at vertices of class " + oVC.getQualifiedName());
        }
        int eId = e.getId();
        if (this.isLoading()) {
            if (eId <= 0) throw new GraphException("can not load an edge with id <= 0");
            if (this.containsEdgeId(eId)) {
                throw new GraphException("edge with id " + e.getId() + " already exists");
            }
            if (eId > this.eMax) {
                throw new GraphException("edge id " + e.getId() + " is bigger than eSize");
            }
        } else {
            if (!this.canAddGraphElement(eId)) {
                throw new GraphException("can not add an edge with id != 0");
            }
            eId = this.allocateEdgeIndex(eId);
            assert (eId != 0);
            e.setId(eId);
            a.appendIncidenceToISeq(e);
            o.appendIncidenceToISeq(e.reversedEdge);
        }
        this.appendEdgeToESeq(e);
        if (this.isLoading()) return;
        a.incidenceListModified();
        o.incidenceListModified();
        this.edgeListModified();
        this.internalEdgeAdded(e);
    }

    @Override
    public final void internalEdgeAdded(InternalEdge e) {
        this.notifyEdgeAdded(e);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void addVertex(Vertex newVertex) {
        InternalVertex v = (InternalVertex)newVertex;
        int vId = v.getId();
        if (this.isLoading()) {
            if (vId <= 0) throw new GraphException("can not load a vertex with id <= 0");
            if (this.containsVertexId(vId)) {
                throw new GraphException("vertex with id " + vId + " already exists");
            }
            if (vId > this.vMax) {
                throw new GraphException("vertex id " + vId + " is bigger than vSize");
            }
        } else {
            if (!this.canAddGraphElement(vId)) {
                throw new GraphException("can not add a vertex with vId " + vId);
            }
            vId = this.allocateVertexIndex(vId);
            assert (vId != 0);
            v.setId(vId);
        }
        this.appendVertexToVSeq(v);
        if (this.isLoading()) return;
        this.vertexListModified();
        this.internalVertexAdded(v);
    }

    private final boolean canAddGraphElement(int graphElementId) {
        return graphElementId == 0;
    }

    @Override
    public void internalVertexAdded(InternalVertex v) {
        this.notifyVertexAdded(v);
    }

    @Override
    public final void appendEdgeToESeq(InternalEdge e) {
        this.getEdge()[((EdgeBaseImpl)e).id] = e;
        this.getRevEdge()[((EdgeBaseImpl)e).id] = ((EdgeBaseImpl)e).reversedEdge;
        this.setECount(this.getECountInESeq() + 1);
        if (this.getFirstEdgeInESeq() == null) {
            this.setFirstEdgeInGraph(e);
        }
        if (this.getLastEdgeInESeq() != null) {
            this.getLastEdgeInESeq().setNextEdgeInGraph(e);
            e.setPrevEdgeInGraph(this.getLastEdgeInESeq());
        }
        this.setLastEdgeInGraph(e);
    }

    @Override
    public final void appendVertexToVSeq(InternalVertex v) {
        this.getVertex()[((VertexBaseImpl)v).id] = v;
        this.setVCount(this.getVCountInVSeq() + 1);
        if (this.getFirstVertexInVSeq() == null) {
            this.setFirstVertex(v);
        }
        if (this.getLastVertexInVSeq() != null) {
            this.getLastVertexInVSeq().setNextVertex(v);
            v.setPrevVertex(this.getLastVertexInVSeq());
        }
        this.setLastVertex(v);
    }

    @Override
    public final int getExpandedVertexCount() {
        return this.computeNewSize(this.vMax);
    }

    private final int computeNewSize(int n) {
        return n >= 0x100000 ? n + 131072 : (n >= 262144 ? n + 262144 : n + n);
    }

    @Override
    public final int getExpandedEdgeCount() {
        return this.computeNewSize(this.eMax);
    }

    @Override
    public final int compareTo(AttributedElement<GraphClass, Graph> a) {
        if (a == this) {
            return 0;
        }
        if (a instanceof Graph) {
            Graph g = (Graph)a;
            int x = this.hashCode() - g.hashCode();
            if (x == 0) {
                return this.id.compareTo(g.getId());
            }
            return x;
        }
        return -1;
    }

    @Override
    public final boolean containsEdge(Edge e) {
        return this.getTraversalContext() == null ? this.eSeqContainsEdge(e) : this.eSeqContainsEdge(e) && this.getTraversalContext().containsEdge(e);
    }

    @Override
    public final boolean eSeqContainsEdge(Edge e) {
        return e != null && e.getGraph() == this && this.containsEdgeId(((EdgeBaseImpl)e.getNormalEdge()).id) && this.getEdge(((EdgeBaseImpl)e.getNormalEdge()).id) == e.getNormalEdge();
    }

    private final boolean containsEdgeId(int eId) {
        if (eId < 0) {
            eId = -eId;
        }
        return eId > 0 && eId <= this.eMax && this.getEdge()[eId] != null && this.getRevEdge()[eId] != null;
    }

    @Override
    public final boolean containsVertex(Vertex v) {
        return this.getTraversalContext() == null ? this.vSeqContainsVertex(v) : this.vSeqContainsVertex(v) && this.getTraversalContext().containsVertex(v);
    }

    @Override
    public final boolean vSeqContainsVertex(Vertex v) {
        return v != null && v.getGraph() == this && this.containsVertexId(((VertexBaseImpl)v).id) && this.getVertex()[((VertexBaseImpl)v).id] == v;
    }

    private final boolean containsVertexId(int vId) {
        return vId > 0 && vId <= this.vMax && this.getVertex()[vId] != null;
    }

    @Override
    public <T extends Edge> T createEdge(EdgeClass ec, Vertex alpha, Vertex omega) {
        try {
            return (T)this.graphFactory.createEdge(ec, 0, this, alpha, omega);
        }
        catch (Exception exception) {
            if (exception instanceof GraphException) {
                throw (GraphException)exception;
            }
            throw new GraphException("Error creating edge of class " + ec.getQualifiedName(), exception);
        }
    }

    @Override
    public <T extends Vertex> T createVertex(VertexClass vc) {
        try {
            return (T)this.graphFactory.createVertex(vc, 0, this);
        }
        catch (Exception ex) {
            if (ex instanceof GraphException) {
                throw (GraphException)ex;
            }
            throw new GraphException("Error creating vertex of class " + vc.getQualifiedName(), ex);
        }
    }

    @Override
    public final void deleteEdge(Edge e) {
        assert (e != null && e.isValid() && this.eSeqContainsEdge(e));
        this.internalDeleteEdge(e);
        this.edgeListModified();
    }

    @Override
    public final void deleteVertex(Vertex v) {
        assert (v != null && v.isValid() && this.vSeqContainsVertex(v));
        this.getDeleteVertexList().add((InternalVertex)v);
        this.internalDeleteVertex();
    }

    @Override
    public final void edgeListModified() {
        this.setEdgeListVersion(this.getEdgeListVersion() + 1L);
        this.setGraphVersion(this.getGraphVersion() + 1L);
    }

    @Override
    public final Iterable<Edge> edges() {
        return new EdgeIterable<Edge>(this);
    }

    @Override
    public final Iterable<Edge> edges(EdgeClass edgeClass) {
        return new EdgeIterable<Edge>(this, edgeClass);
    }

    @Override
    public final void expandEdgeArray(int newSize) {
        if (newSize <= this.eMax) {
            throw new GraphException("newSize must be > eSize: eSize=" + this.eMax + ", newSize=" + newSize);
        }
        InternalEdge[] e = new InternalEdge[newSize + 1];
        if (this.getEdge() != null) {
            System.arraycopy(this.getEdge(), 0, e, 0, this.getEdge().length);
        }
        this.setEdge(e);
        InternalEdge[] r = new ReversedEdgeBaseImpl[newSize + 1];
        if (this.getRevEdge() != null) {
            System.arraycopy(this.getRevEdge(), 0, r, 0, this.getRevEdge().length);
        }
        this.setRevEdge(r);
        if (this.getFreeEdgeList() == null) {
            this.freeEdgeList = new FreeIndexList(newSize);
        } else {
            this.getFreeEdgeList().expandBy(newSize - this.eMax);
        }
        this.eMax = newSize;
        this.notifyMaxEdgeCountIncreased(newSize);
    }

    @Override
    public final void expandVertexArray(int newSize) {
        if (newSize <= this.vMax) {
            throw new GraphException("newSize must > vSize: vSize=" + this.vMax + ", newSize=" + newSize);
        }
        InternalVertex[] expandedArray = new InternalVertex[newSize + 1];
        if (this.getVertex() != null) {
            System.arraycopy(this.getVertex(), 0, expandedArray, 0, this.getVertex().length);
        }
        if (this.getFreeVertexList() == null) {
            this.freeVertexList = new FreeIndexList(newSize);
        } else {
            this.getFreeVertexList().expandBy(newSize - this.vMax);
        }
        this.setVertex(expandedArray);
        this.vMax = newSize;
        this.notifyMaxVertexCountIncreased(newSize);
    }

    @Override
    public final int getECount() {
        TraversalContext tc = this.getTraversalContext();
        if (tc == null) {
            return this.getECountInESeq();
        }
        if (tc instanceof SubGraphMarker) {
            return ((SubGraphMarker)tc).getECount();
        }
        int count = 0;
        for (Edge e = this.getFirstEdge(); e != null; e = e.getNextEdge()) {
            ++count;
        }
        return count;
    }

    @Override
    public final Edge getEdge(int eId) {
        assert (eId != 0) : "The edge id must be != 0, given was " + eId;
        try {
            return eId < 0 ? this.getRevEdge()[-eId] : this.getEdge()[eId];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public final Edge getFirstEdge() {
        TraversalContext tc = this.getTraversalContext();
        Edge firstEdge = this.getFirstEdgeInESeq();
        if (tc != null && firstEdge != null && !tc.containsEdge(firstEdge)) {
            firstEdge = firstEdge.getNextEdge();
        }
        return firstEdge;
    }

    @Override
    public final Edge getLastEdge() {
        TraversalContext tc = this.getTraversalContext();
        Edge lastEdge = this.getLastEdgeInESeq();
        if (tc != null && lastEdge != null && !tc.containsEdge(lastEdge)) {
            lastEdge = lastEdge.getPrevEdge();
        }
        return lastEdge;
    }

    @Override
    public final Edge getFirstEdge(EdgeClass edgeClass) {
        assert (edgeClass != null);
        Edge currentEdge = this.getFirstEdge();
        if (currentEdge == null) {
            return null;
        }
        if (currentEdge.isInstanceOf(edgeClass)) {
            return currentEdge;
        }
        return currentEdge.getNextEdge(edgeClass);
    }

    @Override
    public final Vertex getFirstVertex() {
        TraversalContext tc = this.getTraversalContext();
        Vertex firstVertex = this.getFirstVertexInVSeq();
        if (tc != null && firstVertex != null && !tc.containsVertex(firstVertex)) {
            firstVertex = firstVertex.getNextVertex();
        }
        return firstVertex;
    }

    @Override
    public final Vertex getLastVertex() {
        TraversalContext tc = this.getTraversalContext();
        Vertex lastVertex = this.getLastVertexInVSeq();
        if (tc != null && lastVertex != null && !tc.containsVertex(lastVertex)) {
            lastVertex = lastVertex.getPrevVertex();
        }
        return lastVertex;
    }

    @Override
    public final Vertex getFirstVertex(VertexClass vertexClass) {
        assert (vertexClass != null);
        Vertex firstVertex = this.getFirstVertex();
        if (firstVertex == null) {
            return null;
        }
        if (firstVertex.isInstanceOf(vertexClass)) {
            return firstVertex;
        }
        return firstVertex.getNextVertex(vertexClass);
    }

    @Override
    public final GraphClass getGraphClass() {
        return this.getAttributedElementClass();
    }

    @Override
    public long getGraphVersion() {
        return this.graphVersion;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getMaxECount() {
        return this.eMax;
    }

    @Override
    public int getMaxVCount() {
        return this.vMax;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public int getVCount() {
        TraversalContext tc = this.getTraversalContext();
        if (tc == null) {
            return this.getVCountInVSeq();
        }
        if (tc instanceof SubGraphMarker) {
            return ((SubGraphMarker)tc).getVCount();
        }
        int count = 0;
        for (Vertex v = this.getFirstVertex(); v != null; v = v.getNextVertex()) {
            ++count;
        }
        return count;
    }

    @Override
    public Vertex getVertex(int vId) {
        assert (vId > 0) : "The vertex id must be > 0, given was " + vId;
        try {
            return this.getVertex()[vId];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public void graphModified() {
        this.setGraphVersion(this.getGraphVersion() + 1L);
    }

    @Override
    public final void ecaAttributeChanging(String name, Object oldValue, Object newValue) {
        if (!this.isLoading()) {
            this.getECARuleManager().fireBeforeChangeAttributeEvents(this, name, oldValue, newValue);
        }
    }

    @Override
    public final void ecaAttributeChanged(String name, Object oldValue, Object newValue) {
        if (!this.isLoading()) {
            this.getECARuleManager().fireAfterChangeAttributeEvents(this, name, oldValue, newValue);
        }
    }

    private final void internalDeleteEdge(Edge edge) {
        assert (edge != null && edge.isValid() && this.eSeqContainsEdge(edge));
        if (this.hasECARuleManager()) {
            this.getECARuleManager().fireBeforeDeleteEdgeEvents(edge);
        }
        InternalEdge e = (InternalEdge)edge.getNormalEdge();
        if (this.hasECARuleManager()) {
            this.getECARuleManager().fireBeforeDeleteEdgeEvents(edge);
        }
        e = (InternalEdge)edge.getNormalEdge();
        this.internalEdgeDeleted(e);
        InternalVertex alpha = e.getIncidentVertex();
        alpha.removeIncidenceFromISeq(e);
        alpha.incidenceListModified();
        InternalVertex omega = ((EdgeBaseImpl)e).reversedEdge.getIncidentVertex();
        omega.removeIncidenceFromISeq(((EdgeBaseImpl)e).reversedEdge);
        omega.incidenceListModified();
        this.removeEdgeFromESeq(e);
        this.edgeListModified();
        if (this.hasECARuleManager()) {
            this.getECARuleManager().fireAfterDeleteEdgeEvents(e.getAttributedElementClass(), alpha, omega);
        }
    }

    @Override
    public final void internalEdgeDeleted(InternalEdge e) {
        assert (e != null);
        this.notifyEdgeDeleted(e);
    }

    private final void internalDeleteVertex() {
        while (!this.getDeleteVertexList().isEmpty()) {
            InternalVertex v = this.getDeleteVertexList().remove(0);
            assert (v != null && v.isValid() && this.vSeqContainsVertex(v));
            if (this.hasECARuleManager()) {
                this.getECARuleManager().fireBeforeDeleteVertexEvents(v);
            }
            this.internalVertexDeleted(v);
            Edge e = v.getFirstIncidence();
            while (e != null) {
                InternalVertex other;
                assert (e.isValid() && this.eSeqContainsEdge(e));
                if (e.getThatAggregationKind() == AggregationKind.COMPOSITE && (other = (InternalVertex)e.getThat()) != v && this.vSeqContainsVertex(other) && !this.getDeleteVertexList().contains(other)) {
                    this.getDeleteVertexList().add(other);
                }
                this.deleteEdge(e);
                e = v.getFirstIncidence();
            }
            this.removeVertexFromVSeq(v);
            this.vertexListModified();
            if (!this.hasECARuleManager()) continue;
            this.getECARuleManager().fireAfterDeleteVertexEvents(v.getAttributedElementClass());
        }
    }

    @Override
    public final void internalVertexDeleted(InternalVertex v) {
        assert (v != null);
        this.notifyVertexDeleted(v);
    }

    @Override
    public final void removeVertexFromVSeq(InternalVertex v) {
        assert (v != null);
        if (v == this.getFirstVertexInVSeq()) {
            this.setFirstVertex(v.getNextVertexInVSeq());
            if (this.getFirstVertexInVSeq() != null) {
                this.getFirstVertexInVSeq().setPrevVertex(null);
            }
            if (v == this.getLastVertexInVSeq()) {
                this.setLastVertex(null);
            }
        } else if (v == this.getLastVertexInVSeq()) {
            this.setLastVertex(v.getPrevVertexInVSeq());
            if (this.getLastVertexInVSeq() != null) {
                this.getLastVertexInVSeq().setNextVertex(null);
            }
        } else {
            v.getPrevVertexInVSeq().setNextVertex(v.getNextVertexInVSeq());
            v.getNextVertexInVSeq().setPrevVertex(v.getPrevVertexInVSeq());
        }
        this.freeVertexIndex(v.getId());
        this.getVertex()[v.getId()] = null;
        v.setPrevVertex(null);
        v.setNextVertex(null);
        v.setId(0);
        this.setVCount(this.getVCountInVSeq() - 1);
    }

    @Override
    public final void removeEdgeFromESeq(InternalEdge e) {
        assert (e != null);
        this.removeEdgeFromESeqWithoutDeletingIt(e);
        this.freeEdgeIndex(e.getId());
        this.getEdge()[e.getId()] = null;
        this.getRevEdge()[e.getId()] = null;
        e.setPrevEdgeInGraph(null);
        e.setNextEdgeInGraph(null);
        e.setId(0);
        this.setECount(this.getECountInESeq() - 1);
    }

    private final void removeEdgeFromESeqWithoutDeletingIt(InternalEdge e) {
        if (e == this.getFirstEdgeInESeq()) {
            this.setFirstEdgeInGraph(e.getNextEdgeInESeq());
            if (this.getFirstEdgeInESeq() != null) {
                this.getFirstEdgeInESeq().setPrevEdgeInGraph(null);
            }
            if (e == this.getLastEdgeInESeq()) {
                this.setLastEdgeInGraph(null);
            }
        } else if (e == this.getLastEdgeInESeq()) {
            this.setLastEdgeInGraph(e.getPrevEdgeInESeq());
            if (this.getLastEdgeInESeq() != null) {
                this.getLastEdgeInESeq().setNextEdgeInGraph(null);
            }
        } else {
            e.getPrevEdgeInESeq().setNextEdgeInGraph(e.getNextEdgeInESeq());
            e.getNextEdgeInESeq().setPrevEdgeInGraph(e.getPrevEdgeInESeq());
        }
    }

    @Override
    public final boolean isEdgeListModified(long edgeListVersion) {
        return this.getEdgeListVersion() != edgeListVersion;
    }

    @Override
    public final boolean isGraphModified(long previousVersion) {
        return this.getGraphVersion() != previousVersion;
    }

    @Override
    public final boolean isLoading() {
        return this.loading;
    }

    @Override
    public final boolean isVertexListModified(long previousVersion) {
        return this.getVertexListVersion() != previousVersion;
    }

    @Override
    public final void internalLoadingCompleted(int[] firstIncidence, int[] nextIncidence) {
        this.getFreeVertexList().reinitialize(this.getVertex());
        this.getFreeEdgeList().reinitialize(this.getEdge());
        for (int vId = 1; vId < this.getVertex().length; ++vId) {
            InternalVertex v = this.getVertex()[vId];
            if (v == null) continue;
            int eId = firstIncidence[vId];
            while (eId != 0) {
                v.appendIncidenceToISeq(eId < 0 ? this.getRevEdge()[-eId] : this.getEdge()[eId]);
                eId = nextIncidence[this.eMax + eId];
            }
        }
    }

    @Override
    public final void putEdgeAfterInGraph(InternalEdge targetEdge, InternalEdge movedEdge) {
        assert (targetEdge != null && targetEdge.isValid() && this.eSeqContainsEdge(targetEdge));
        assert (movedEdge != null && movedEdge.isValid() && this.eSeqContainsEdge(movedEdge));
        assert (targetEdge != movedEdge);
        if (targetEdge == movedEdge || targetEdge.getNextEdgeInESeq() == movedEdge) {
            return;
        }
        assert (this.getFirstEdgeInESeq() != this.getLastEdgeInESeq());
        if (movedEdge == this.getFirstEdgeInESeq()) {
            this.setFirstEdgeInGraph(movedEdge.getNextEdgeInESeq());
            movedEdge.getNextEdgeInESeq().setPrevEdgeInGraph(null);
        } else if (movedEdge == this.getLastEdgeInESeq()) {
            this.setLastEdgeInGraph(movedEdge.getPrevEdgeInESeq());
            movedEdge.getPrevEdgeInESeq().setNextEdgeInGraph(null);
        } else {
            movedEdge.getPrevEdgeInESeq().setNextEdgeInGraph(movedEdge.getNextEdgeInESeq());
            movedEdge.getNextEdgeInESeq().setPrevEdgeInGraph(movedEdge.getPrevEdgeInESeq());
        }
        if (targetEdge == this.getLastEdgeInESeq()) {
            this.setLastEdgeInGraph(movedEdge);
            movedEdge.setNextEdgeInGraph(null);
        } else {
            targetEdge.getNextEdgeInESeq().setPrevEdgeInGraph(movedEdge);
            movedEdge.setNextEdgeInGraph(targetEdge.getNextEdgeInESeq());
        }
        movedEdge.setPrevEdgeInGraph(targetEdge);
        targetEdge.setNextEdgeInGraph(movedEdge);
        this.edgeListModified();
    }

    @Override
    public final void putVertexAfter(InternalVertex targetVertex, InternalVertex movedVertex) {
        assert (targetVertex != null && targetVertex.isValid() && this.vSeqContainsVertex(targetVertex));
        assert (movedVertex != null && movedVertex.isValid() && this.vSeqContainsVertex(movedVertex));
        assert (targetVertex != movedVertex);
        InternalVertex nextVertex = targetVertex.getNextVertexInVSeq();
        if (targetVertex == movedVertex || nextVertex == movedVertex) {
            return;
        }
        assert (this.getFirstVertexInVSeq() != this.getLastVertexInVSeq());
        if (movedVertex == this.getFirstVertexInVSeq()) {
            InternalVertex newFirstVertex = movedVertex.getNextVertexInVSeq();
            this.setFirstVertex(newFirstVertex);
            newFirstVertex.setPrevVertex(null);
        } else if (movedVertex == this.getLastVertexInVSeq()) {
            this.setLastVertex(movedVertex.getPrevVertexInVSeq());
            movedVertex.getPrevVertexInVSeq().setNextVertex(null);
        } else {
            movedVertex.getPrevVertexInVSeq().setNextVertex(movedVertex.getNextVertexInVSeq());
            movedVertex.getNextVertexInVSeq().setPrevVertex(movedVertex.getPrevVertexInVSeq());
        }
        if (targetVertex == this.getLastVertexInVSeq()) {
            this.setLastVertex(movedVertex);
            movedVertex.setNextVertex(null);
        } else {
            targetVertex.getNextVertexInVSeq().setPrevVertex(movedVertex);
            movedVertex.setNextVertex(targetVertex.getNextVertexInVSeq());
        }
        movedVertex.setPrevVertex(targetVertex);
        targetVertex.setNextVertex(movedVertex);
        this.vertexListModified();
    }

    @Override
    public final void putEdgeBeforeInGraph(InternalEdge targetEdge, InternalEdge movedEdge) {
        assert (targetEdge != null && targetEdge.isValid() && this.eSeqContainsEdge(targetEdge));
        assert (movedEdge != null && movedEdge.isValid() && this.eSeqContainsEdge(movedEdge));
        assert (targetEdge != movedEdge);
        if (targetEdge == movedEdge || targetEdge.getPrevEdgeInESeq() == movedEdge) {
            return;
        }
        assert (this.getFirstEdgeInESeq() != this.getLastEdgeInESeq());
        this.removeEdgeFromESeqWithoutDeletingIt(movedEdge);
        if (targetEdge == this.getFirstEdgeInESeq()) {
            this.setFirstEdgeInGraph(movedEdge);
            movedEdge.setPrevEdgeInGraph(null);
        } else {
            InternalEdge previousEdge = targetEdge.getPrevEdgeInESeq();
            previousEdge.setNextEdgeInGraph(movedEdge);
            movedEdge.setPrevEdgeInGraph(previousEdge);
        }
        movedEdge.setNextEdgeInGraph(targetEdge);
        targetEdge.setPrevEdgeInGraph(movedEdge);
        this.edgeListModified();
    }

    @Override
    public final void putVertexBefore(InternalVertex targetVertex, InternalVertex movedVertex) {
        assert (targetVertex != null && targetVertex.isValid() && this.vSeqContainsVertex(targetVertex));
        assert (movedVertex != null && movedVertex.isValid() && this.vSeqContainsVertex(movedVertex));
        assert (targetVertex != movedVertex);
        InternalVertex prevVertex = targetVertex.getPrevVertexInVSeq();
        if (targetVertex == movedVertex || prevVertex == movedVertex) {
            return;
        }
        assert (this.getFirstVertexInVSeq() != this.getLastVertexInVSeq());
        if (movedVertex == this.getFirstVertexInVSeq()) {
            this.setFirstVertex(movedVertex.getNextVertexInVSeq());
            movedVertex.getNextVertexInVSeq().setPrevVertex(null);
        } else if (movedVertex == this.getLastVertexInVSeq()) {
            this.setLastVertex(movedVertex.getPrevVertexInVSeq());
            movedVertex.getPrevVertexInVSeq().setNextVertex(null);
        } else {
            movedVertex.getPrevVertexInVSeq().setNextVertex(movedVertex.getNextVertexInVSeq());
            movedVertex.getNextVertexInVSeq().setPrevVertex(movedVertex.getPrevVertexInVSeq());
        }
        if (targetVertex == this.getFirstVertexInVSeq()) {
            this.setFirstVertex(movedVertex);
            movedVertex.setPrevVertex(null);
        } else {
            InternalVertex previousVertex = targetVertex.getPrevVertexInVSeq();
            previousVertex.setNextVertex(movedVertex);
            movedVertex.setPrevVertex(previousVertex);
        }
        movedVertex.setNextVertex(targetVertex);
        targetVertex.setPrevVertex(movedVertex);
        this.vertexListModified();
    }

    @Override
    public final void setGraphVersion(long graphVersion) {
        this.graphVersion = graphVersion;
    }

    @Override
    public final void setId(String id) {
        this.id = id;
    }

    @Override
    public final void setLoading(boolean isLoading) {
        this.loading = isLoading;
    }

    @Override
    public final void vertexListModified() {
        this.setVertexListVersion(this.getVertexListVersion() + 1L);
        this.setGraphVersion(this.getGraphVersion() + 1L);
    }

    @Override
    public final Iterable<Vertex> vertices() {
        return new VertexIterable<Vertex>(this, null, null);
    }

    @Override
    public final Iterable<Vertex> vertices(VertexFilter<Vertex> filter) {
        return new VertexIterable<Vertex>(this, null, filter);
    }

    @Override
    public final Iterable<Vertex> vertices(VertexClass vertexClass) {
        return new VertexIterable<Vertex>(this, vertexClass, null);
    }

    @Override
    public final Iterable<Vertex> vertices(VertexClass vertexClass, VertexFilter<Vertex> filter) {
        return new VertexIterable<Vertex>(this, vertexClass, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void defragment() {
        TraversalContext tc = this.setTraversalContext(null);
        try {
            if (this.getVCountInVSeq() < this.vMax) {
                int newVMax;
                if (this.getVCountInVSeq() > 0) {
                    int vId = this.vMax;
                    while (this.getFreeVertexList().isFragmented()) {
                        while (vId >= 1 && this.getVertex()[vId] == null) {
                            --vId;
                        }
                        assert (vId >= 1);
                        InternalVertex v = this.getVertex()[vId];
                        this.getVertex()[vId] = null;
                        this.getFreeVertexList().freeIndex(vId);
                        int newId = this.allocateVertexIndex(vId);
                        assert (newId < vId);
                        v.setId(newId);
                        this.getVertex()[newId] = v;
                        --vId;
                    }
                }
                int n = newVMax = this.getVCountInVSeq() == 0 ? 1 : this.getVCountInVSeq();
                if (newVMax != this.vMax) {
                    this.vMax = newVMax;
                    InternalVertex[] newVertex = new InternalVertex[this.vMax + 1];
                    System.arraycopy(this.getVertex(), 0, newVertex, 0, newVertex.length);
                    this.setVertex(newVertex);
                }
                this.graphModified();
            }
            if (this.getECountInESeq() < this.eMax) {
                int newEMax;
                if (this.getECountInESeq() > 0) {
                    int eId = this.eMax;
                    while (this.getFreeEdgeList().isFragmented()) {
                        while (eId >= 1 && this.getEdge()[eId] == null) {
                            --eId;
                        }
                        assert (eId >= 1);
                        InternalEdge e = this.getEdge()[eId];
                        this.getEdge()[eId] = null;
                        InternalEdge r = this.getRevEdge()[eId];
                        this.getRevEdge()[eId] = null;
                        this.getFreeEdgeList().freeIndex(eId);
                        int newId = this.allocateEdgeIndex(eId);
                        assert (newId < eId);
                        e.setId(newId);
                        this.getEdge()[newId] = e;
                        this.getRevEdge()[newId] = r;
                        --eId;
                    }
                }
                int n = newEMax = this.getECountInESeq() == 0 ? 1 : this.getECountInESeq();
                if (newEMax != this.eMax) {
                    this.eMax = newEMax;
                    InternalEdge[] newEdge = new InternalEdge[this.eMax + 1];
                    System.arraycopy(this.getEdge(), 0, newEdge, 0, newEdge.length);
                    this.setEdge(newEdge);
                }
                this.graphModified();
            }
        }
        finally {
            this.setTraversalContext(tc);
        }
    }

    @Override
    public final void sortVertices(Comparator<Vertex> comp) {
        if (this.getFirstVertexInVSeq() == null) {
            return;
        }
        final class VertexList {
            InternalVertex first;
            InternalVertex last;

            VertexList() {
            }

            public void add(InternalVertex v) {
                if (this.first == null) {
                    this.first = v;
                    assert (this.last == null);
                    this.last = v;
                } else {
                    v.setPrevVertex(this.last);
                    this.last.setNextVertex(v);
                    this.last = v;
                }
                v.setNextVertex(null);
            }

            public InternalVertex remove() {
                if (this.first == null) {
                    throw new NoSuchElementException();
                }
                if (this.first == this.last) {
                    InternalVertex out = this.first;
                    this.first = null;
                    this.last = null;
                    return out;
                }
                InternalVertex out = this.first;
                this.first = out.getNextVertexInVSeq();
                this.first.setPrevVertex(null);
                return out;
            }

            public boolean isEmpty() {
                assert (this.first == null == (this.last == null));
                return this.first == null;
            }
        }
        VertexList a = new VertexList();
        VertexList b = new VertexList();
        VertexList out = a;
        VertexList l = new VertexList();
        l.first = this.getFirstVertexInVSeq();
        l.last = this.getLastVertexInVSeq();
        InternalVertex last = l.remove();
        out.add(last);
        while (!l.isEmpty()) {
            InternalVertex current = l.remove();
            if (comp.compare(current, last) < 0) {
                out = out == a ? b : a;
            }
            out.add(current);
            last = current;
        }
        if (a.isEmpty() || b.isEmpty()) {
            out = a.isEmpty() ? b : a;
            this.setFirstVertex(out.first);
            this.setLastVertex(out.last);
            return;
        }
        while (true) {
            if (a.isEmpty() || b.isEmpty()) {
                out = a.isEmpty() ? b : a;
                this.setFirstVertex(out.first);
                this.setLastVertex(out.last);
                this.edgeListModified();
                return;
            }
            VertexList c = new VertexList();
            VertexList d = new VertexList();
            out = c;
            last = null;
            while (!a.isEmpty() && !b.isEmpty()) {
                int compareBToLast;
                int compareAToLast = last != null ? comp.compare(a.first, last) : 0;
                int n = compareBToLast = last != null ? comp.compare(b.first, last) : 0;
                if (compareAToLast >= 0 && compareBToLast >= 0) {
                    if (comp.compare(a.first, b.first) <= 0) {
                        last = a.remove();
                        out.add(last);
                        continue;
                    }
                    last = b.remove();
                    out.add(last);
                    continue;
                }
                if (compareAToLast < 0 && compareBToLast < 0) {
                    out = out == c ? d : c;
                    last = null;
                    continue;
                }
                if (compareAToLast < 0 && compareBToLast >= 0) {
                    last = b.remove();
                    out.add(last);
                    continue;
                }
                last = a.remove();
                out.add(last);
            }
            while (!a.isEmpty()) {
                InternalVertex current = a.remove();
                if (comp.compare(current, last) < 0) {
                    out = out == c ? d : c;
                }
                out.add(current);
                last = current;
            }
            while (!b.isEmpty()) {
                InternalVertex current = b.remove();
                if (comp.compare(current, last) < 0) {
                    out = out == c ? d : c;
                }
                out.add(current);
                last = current;
            }
            a = c;
            b = d;
        }
    }

    @Override
    public Object getEnumConstant(EnumDomain enumDomain, String constantName) {
        Class<? extends Object> cls = enumDomain.getSchemaClass();
        Enum[] consts = (Enum[])cls.getEnumConstants();
        for (int i = 0; i < consts.length; ++i) {
            Enum c = consts[i];
            if (!c.name().equals(constantName)) continue;
            return c;
        }
        throw new GraphException("No such enum constant '" + constantName + "' in EnumDomain " + enumDomain);
    }

    @Override
    public Record createRecord(RecordDomain recordDomain, Map<String, Object> values) {
        Class<? extends Object> cls = recordDomain.getSchemaClass();
        try {
            Constructor<? extends Object> constr = cls.getConstructor(Map.class);
            return (Record)constr.newInstance(values);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GraphException(e);
        }
    }

    @Override
    public final void sortEdges(Comparator<Edge> comp) {
        if (this.getFirstEdgeInESeq() == null) {
            return;
        }
        final class EdgeList {
            InternalEdge first;
            InternalEdge last;

            EdgeList() {
            }

            public void add(InternalEdge e) {
                if (this.first == null) {
                    this.first = e;
                    assert (this.last == null);
                    this.last = e;
                } else {
                    e.setPrevEdgeInGraph(this.last);
                    this.last.setNextEdgeInGraph(e);
                    this.last = e;
                }
                e.setNextEdgeInGraph(null);
            }

            public InternalEdge remove() {
                if (this.first == null) {
                    throw new NoSuchElementException();
                }
                if (this.first == this.last) {
                    InternalEdge out = this.first;
                    this.first = null;
                    this.last = null;
                    return out;
                }
                InternalEdge out = this.first;
                this.first = out.getNextEdgeInESeq();
                this.first.setPrevEdgeInGraph(null);
                return out;
            }

            public boolean isEmpty() {
                assert (this.first == null == (this.last == null));
                return this.first == null;
            }
        }
        EdgeList a = new EdgeList();
        EdgeList b = new EdgeList();
        EdgeList out = a;
        EdgeList l = new EdgeList();
        l.first = this.getFirstEdgeInESeq();
        l.last = this.getLastEdgeInESeq();
        InternalEdge last = l.remove();
        out.add(last);
        while (!l.isEmpty()) {
            InternalEdge current = l.remove();
            if (comp.compare(current, last) < 0) {
                out = out == a ? b : a;
            }
            out.add(current);
            last = current;
        }
        if (a.isEmpty() || b.isEmpty()) {
            out = a.isEmpty() ? b : a;
            this.setFirstEdgeInGraph(out.first);
            this.setLastEdgeInGraph(out.last);
            return;
        }
        while (true) {
            if (a.isEmpty() || b.isEmpty()) {
                out = a.isEmpty() ? b : a;
                this.setFirstEdgeInGraph(out.first);
                this.setLastEdgeInGraph(out.last);
                this.edgeListModified();
                return;
            }
            EdgeList c = new EdgeList();
            EdgeList d = new EdgeList();
            out = c;
            last = null;
            while (!a.isEmpty() && !b.isEmpty()) {
                int compareBToLast;
                int compareAToLast = last != null ? comp.compare(a.first, last) : 0;
                int n = compareBToLast = last != null ? comp.compare(b.first, last) : 0;
                if (compareAToLast >= 0 && compareBToLast >= 0) {
                    if (comp.compare(a.first, b.first) <= 0) {
                        last = a.remove();
                        out.add(last);
                        continue;
                    }
                    last = b.remove();
                    out.add(last);
                    continue;
                }
                if (compareAToLast < 0 && compareBToLast < 0) {
                    out = out == c ? d : c;
                    last = null;
                    continue;
                }
                if (compareAToLast < 0 && compareBToLast >= 0) {
                    last = b.remove();
                    out.add(last);
                    continue;
                }
                last = a.remove();
                out.add(last);
            }
            while (!a.isEmpty()) {
                InternalEdge current = a.remove();
                if (comp.compare(current, last) < 0) {
                    out = out == c ? d : c;
                }
                out.add(current);
                last = current;
            }
            while (!b.isEmpty()) {
                InternalEdge current = b.remove();
                if (comp.compare(current, last) < 0) {
                    out = out == c ? d : c;
                }
                out.add(current);
                last = current;
            }
            a = c;
            b = d;
        }
    }

    @Override
    public final ECARuleManagerInterface getECARuleManager() {
        if (this.ecaRuleManager == null) {
            try {
                Constructor<?> ruleManagerConstructor = Class.forName("de.uni_koblenz.jgralab.eca.ECARuleManager").getConstructor(Graph.class);
                this.ecaRuleManager = (ECARuleManagerInterface)ruleManagerConstructor.newInstance(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            assert (this.ecaRuleManager != null);
        }
        return this.ecaRuleManager;
    }

    @Override
    public final boolean hasECARuleManager() {
        return this.ecaRuleManager != null;
    }

    private final void lazyCreateGraphStructureChangedListenersWithAutoRemoval() {
        if (this.graphStructureChangedListenersWithAutoRemoval == null) {
            this.graphStructureChangedListenersWithAutoRemoval = new LinkedList<WeakReference<GraphStructureChangedListener>>();
        }
    }

    @Override
    public void addGraphStructureChangedListener(GraphStructureChangedListener newListener) {
        assert (newListener != null);
        if (newListener instanceof GraphStructureChangedListenerWithAutoRemove) {
            this.lazyCreateGraphStructureChangedListenersWithAutoRemoval();
            this.graphStructureChangedListenersWithAutoRemoval.add(new WeakReference<GraphStructureChangedListener>(newListener));
        } else {
            this.graphStructureChangedListeners.add(newListener);
        }
    }

    @Override
    public final void removeGraphStructureChangedListener(GraphStructureChangedListener listener) {
        assert (listener != null);
        if (listener instanceof GraphStructureChangedListenerWithAutoRemove) {
            Iterator<WeakReference<GraphStructureChangedListener>> iterator = this.getListenerListIteratorForAutoRemove();
            while (iterator != null && iterator.hasNext()) {
                GraphStructureChangedListener currentListener = (GraphStructureChangedListener)iterator.next().get();
                if (currentListener != null && currentListener != listener) continue;
                iterator.remove();
            }
        } else {
            Iterator<GraphStructureChangedListener> iterator = this.getListenerListIterator();
            while (iterator != null && iterator.hasNext()) {
                GraphStructureChangedListener currentListener = iterator.next();
                if (currentListener != listener) continue;
                iterator.remove();
            }
        }
    }

    private final void setAutoListenerListToNullIfEmpty() {
        if (this.graphStructureChangedListenersWithAutoRemoval.isEmpty()) {
            this.graphStructureChangedListenersWithAutoRemoval = null;
        }
    }

    @Override
    public final void removeAllGraphStructureChangedListeners() {
        this.graphStructureChangedListenersWithAutoRemoval = null;
        this.graphStructureChangedListeners.clear();
    }

    @Override
    public final int getGraphStructureChangedListenerCount() {
        return this.graphStructureChangedListenersWithAutoRemoval == null ? this.graphStructureChangedListeners.size() : this.graphStructureChangedListenersWithAutoRemoval.size() + this.graphStructureChangedListeners.size();
    }

    private final Iterator<WeakReference<GraphStructureChangedListener>> getListenerListIteratorForAutoRemove() {
        return this.graphStructureChangedListenersWithAutoRemoval != null ? this.graphStructureChangedListenersWithAutoRemoval.iterator() : null;
    }

    private final Iterator<GraphStructureChangedListener> getListenerListIterator() {
        return this.graphStructureChangedListeners != null ? this.graphStructureChangedListeners.iterator() : null;
    }

    @Override
    public final void notifyVertexDeleted(Vertex v) {
        assert (v != null && v.isValid() && this.vSeqContainsVertex(v));
        if (this.graphStructureChangedListenersWithAutoRemoval != null) {
            Iterator<WeakReference<GraphStructureChangedListener>> iterator = this.getListenerListIteratorForAutoRemove();
            while (iterator.hasNext()) {
                GraphStructureChangedListener currentListener = (GraphStructureChangedListener)iterator.next().get();
                if (currentListener == null) {
                    iterator.remove();
                    continue;
                }
                currentListener.vertexDeleted(v);
            }
            this.setAutoListenerListToNullIfEmpty();
        }
        int n = this.graphStructureChangedListeners.size();
        for (int i = 0; i < n; ++i) {
            this.graphStructureChangedListeners.get(i).vertexDeleted(v);
        }
    }

    @Override
    public final void notifyVertexAdded(Vertex v) {
        assert (v != null && v.isValid() && this.vSeqContainsVertex(v));
        if (this.graphStructureChangedListenersWithAutoRemoval != null) {
            Iterator<WeakReference<GraphStructureChangedListener>> iterator = this.getListenerListIteratorForAutoRemove();
            while (iterator.hasNext()) {
                GraphStructureChangedListener currentListener = (GraphStructureChangedListener)iterator.next().get();
                if (currentListener == null) {
                    iterator.remove();
                    continue;
                }
                currentListener.vertexAdded(v);
            }
            this.setAutoListenerListToNullIfEmpty();
        }
        int n = this.graphStructureChangedListeners.size();
        for (int i = 0; i < n; ++i) {
            this.graphStructureChangedListeners.get(i).vertexAdded(v);
        }
    }

    @Override
    public final void notifyEdgeDeleted(Edge e) {
        assert (e != null && e.isValid() && e.isNormal() && this.eSeqContainsEdge(e));
        if (this.graphStructureChangedListenersWithAutoRemoval != null) {
            Iterator<WeakReference<GraphStructureChangedListener>> iterator = this.getListenerListIteratorForAutoRemove();
            while (iterator.hasNext()) {
                GraphStructureChangedListener currentListener = (GraphStructureChangedListener)iterator.next().get();
                if (currentListener == null) {
                    iterator.remove();
                    continue;
                }
                currentListener.edgeDeleted(e);
            }
            this.setAutoListenerListToNullIfEmpty();
        }
        int n = this.graphStructureChangedListeners.size();
        for (int i = 0; i < n; ++i) {
            this.graphStructureChangedListeners.get(i).edgeDeleted(e);
        }
    }

    @Override
    public final void notifyEdgeAdded(Edge e) {
        assert (e != null && e.isValid() && e.isNormal() && this.eSeqContainsEdge(e));
        if (this.graphStructureChangedListenersWithAutoRemoval != null) {
            Iterator<WeakReference<GraphStructureChangedListener>> iterator = this.getListenerListIteratorForAutoRemove();
            while (iterator.hasNext()) {
                GraphStructureChangedListener currentListener = (GraphStructureChangedListener)iterator.next().get();
                if (currentListener == null) {
                    iterator.remove();
                    continue;
                }
                currentListener.edgeAdded(e);
            }
            this.setAutoListenerListToNullIfEmpty();
        }
        int n = this.graphStructureChangedListeners.size();
        for (int i = 0; i < n; ++i) {
            this.graphStructureChangedListeners.get(i).edgeAdded(e);
        }
    }

    @Override
    public final void notifyMaxVertexCountIncreased(int newValue) {
        if (this.graphStructureChangedListenersWithAutoRemoval != null) {
            Iterator<WeakReference<GraphStructureChangedListener>> iterator = this.getListenerListIteratorForAutoRemove();
            while (iterator.hasNext()) {
                GraphStructureChangedListener currentListener = (GraphStructureChangedListener)iterator.next().get();
                if (currentListener == null) {
                    iterator.remove();
                    continue;
                }
                currentListener.maxVertexCountIncreased(newValue);
            }
            this.setAutoListenerListToNullIfEmpty();
        }
        int n = this.graphStructureChangedListeners.size();
        for (int i = 0; i < n; ++i) {
            this.graphStructureChangedListeners.get(i).maxVertexCountIncreased(newValue);
        }
    }

    @Override
    public final void notifyMaxEdgeCountIncreased(int newValue) {
        if (this.graphStructureChangedListenersWithAutoRemoval != null) {
            Iterator<WeakReference<GraphStructureChangedListener>> iterator = this.getListenerListIteratorForAutoRemove();
            while (iterator.hasNext()) {
                GraphStructureChangedListener currentListener = (GraphStructureChangedListener)iterator.next().get();
                if (currentListener == null) {
                    iterator.remove();
                    continue;
                }
                currentListener.maxEdgeCountIncreased(newValue);
            }
            this.setAutoListenerListToNullIfEmpty();
        }
        int n = this.graphStructureChangedListeners.size();
        for (int i = 0; i < n; ++i) {
            this.graphStructureChangedListeners.get(i).maxEdgeCountIncreased(newValue);
        }
    }

    @Override
    public final void save(String filename) throws GraphIOException {
        this.save(filename, null);
    }

    @Override
    public final void save(String filename, ProgressFunction pf) throws GraphIOException {
        GraphIO.saveGraphToFile(this, filename, pf);
    }

    @Override
    public final void save(DataOutputStream out) throws GraphIOException {
        this.save(out, null);
    }

    @Override
    public final void save(DataOutputStream out, ProgressFunction pf) throws GraphIOException {
        GraphIO.saveGraphToStream(this, out, pf);
    }

    @Override
    public final GraphFactory getGraphFactory() {
        return this.graphFactory;
    }

    @Override
    public final void setGraphFactory(GraphFactory graphFactory) {
        this.graphFactory = graphFactory;
    }

    @Override
    public boolean isInstanceOf(GraphClass cls) {
        return cls.getSchemaClass().isInstance(this);
    }

    @Override
    public final TraversalContext getTraversalContext() {
        return this.tc.get();
    }

    @Override
    public final TraversalContext setTraversalContext(TraversalContext tc) {
        TraversalContext oldTc = this.tc.get();
        this.tc.set(tc);
        return oldTc;
    }

    @Override
    public void loadingCompleted() {
    }
}

