/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.VertexFilter;
import de.uni_koblenz.jgralab.impl.IncidenceIterable;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class NeighbourIterable<E extends Edge, V extends Vertex>
implements Iterable<V> {
    private IncidenceIterable<E> it;
    private VertexFilter<V> filter;

    public NeighbourIterable(Vertex v, EdgeClass ec, EdgeDirection dir, VertexFilter<V> filter) {
        assert (v != null && v.isValid());
        this.filter = filter;
        this.it = new IncidenceIterable(v, ec, dir);
    }

    @Override
    public Iterator<V> iterator() {
        return new NeigbourIterator(this.it.iterator());
    }

    class NeigbourIterator
    implements Iterator<V> {
        Iterator<E> incidenceIterator;
        V current;

        public NeigbourIterator(Iterator<E> i) {
            this.incidenceIterator = i;
            this.getNext();
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public V next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            Object result = this.current;
            this.getNext();
            return result;
        }

        private void getNext() {
            while (this.incidenceIterator.hasNext()) {
                this.current = ((Edge)this.incidenceIterator.next()).getThat();
                if (NeighbourIterable.this.filter != null && !NeighbourIterable.this.filter.accepts(this.current)) continue;
                return;
            }
            this.current = null;
        }

        @Override
        public void remove() {
            this.incidenceIterator.remove();
        }
    }
}

