/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.impl.EdgeBaseImpl;
import de.uni_koblenz.jgralab.impl.IncidenceImpl;
import de.uni_koblenz.jgralab.impl.InternalEdge;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.EdgeClass;

public abstract class ReversedEdgeBaseImpl
extends IncidenceImpl
implements InternalEdge {
    protected final EdgeBaseImpl normalEdge;

    public ReversedEdgeBaseImpl(EdgeBaseImpl normalEdge, Graph graph) {
        super(graph);
        assert (normalEdge != null);
        this.normalEdge = normalEdge;
    }

    @Override
    public Class<? extends Edge> getSchemaClass() {
        return this.normalEdge.getSchemaClass();
    }

    @Override
    public int compareTo(AttributedElement<EdgeClass, Edge> a) {
        assert (this.isValid());
        assert (a instanceof Edge);
        Edge e = (Edge)a;
        assert (e.isValid());
        assert (this.getGraph() == e.getGraph());
        if (e == this.getNormalEdge()) {
            return 1;
        }
        return Math.abs(this.getId()) - Math.abs(e.getId());
    }

    @Override
    public void delete() {
        this.normalEdge.delete();
    }

    @Override
    public Vertex getAlpha() {
        return this.normalEdge.getIncidentVertex();
    }

    @Override
    public <T> T getAttribute(String name) {
        return this.normalEdge.getAttribute(name);
    }

    @Override
    public <T> void setAttribute(String name, T data) {
        this.normalEdge.setAttribute(name, data);
    }

    @Override
    public int getId() {
        return -this.normalEdge.getId();
    }

    @Override
    public Edge getNextEdge() {
        return this.normalEdge.getNextEdge();
    }

    @Override
    public InternalEdge getNextEdgeInESeq() {
        return this.normalEdge.getNextEdgeInESeq();
    }

    @Override
    public Edge getPrevEdge() {
        return this.normalEdge.getPrevEdge();
    }

    @Override
    public InternalEdge getPrevEdgeInESeq() {
        return this.normalEdge.getPrevEdgeInESeq();
    }

    @Override
    public Edge getNextEdge(EdgeClass anEdgeClass) {
        return this.normalEdge.getNextEdge(anEdgeClass);
    }

    @Override
    public Edge getNormalEdge() {
        return this.normalEdge;
    }

    @Override
    public Vertex getOmega() {
        assert (this.isValid());
        return this.getIncidentVertex();
    }

    @Override
    public Edge getReversedEdge() {
        return this.normalEdge;
    }

    @Override
    public Vertex getThat() {
        return this.getAlpha();
    }

    @Override
    public String getThatRole() {
        return this.normalEdge.getThisRole();
    }

    @Override
    public Vertex getThis() {
        return this.getOmega();
    }

    @Override
    public String getThisRole() {
        return this.normalEdge.getThatRole();
    }

    @Override
    public void graphModified() {
        assert (this.isValid());
        this.graph.graphModified();
    }

    @Override
    public boolean isAfterEdge(Edge e) {
        return this.normalEdge.isAfterEdge(e);
    }

    @Override
    public boolean isBeforeEdge(Edge e) {
        return this.normalEdge.isBeforeEdge(e);
    }

    @Override
    public boolean isNormal() {
        return false;
    }

    @Override
    public void putAfterEdge(Edge e) {
        this.normalEdge.putAfterEdge(e);
    }

    @Override
    public void putBeforeEdge(Edge e) {
        this.normalEdge.putBeforeEdge(e);
    }

    @Override
    public void setAlpha(Vertex alpha) {
        this.normalEdge.setAlpha(alpha);
    }

    @Override
    public void setOmega(Vertex omega) {
        this.normalEdge.setOmega(omega);
    }

    @Override
    public void setThat(Vertex v) {
        this.normalEdge.setAlpha(v);
    }

    @Override
    public void setThis(Vertex v) {
        this.normalEdge.setOmega(v);
    }

    public String toString() {
        return "-e" + this.normalEdge.getId() + ": " + this.getAttributedElementClass().getQualifiedName();
    }

    @Override
    public boolean isValid() {
        return this.graph.eSeqContainsEdge(this);
    }

    @Override
    public void setId(int id) {
        this.normalEdge.setId(id);
    }

    @Override
    public AggregationKind getAggregationKind() {
        return this.normalEdge.getAggregationKind();
    }

    @Override
    public AggregationKind getAlphaAggregationKind() {
        return this.normalEdge.getAlphaAggregationKind();
    }

    @Override
    public AggregationKind getOmegaAggregationKind() {
        return this.normalEdge.getOmegaAggregationKind();
    }

    @Override
    public AggregationKind getThisAggregationKind() {
        return this.normalEdge.getOmegaAggregationKind();
    }

    @Override
    public AggregationKind getThatAggregationKind() {
        return this.normalEdge.getAlphaAggregationKind();
    }

    @Override
    public void setNextEdgeInGraph(Edge nextEdge) {
        this.normalEdge.setNextEdgeInGraph(nextEdge);
    }

    @Override
    public void setPrevEdgeInGraph(Edge prevEdge) {
        this.normalEdge.setPrevEdgeInGraph(prevEdge);
    }
}

