/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl;

import de.uni_koblenz.jgralab.ProgressFunction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class SwingProgressFunction
implements ProgressFunction,
ActionListener {
    private JFrame wnd;
    private JProgressBar pb;
    private String title;
    private String label;
    private String itemName;
    private long totalElements;
    private long updateInterval;
    private BoundedRangeModel brm;
    private JLabel lbl;
    private long startTime;
    private Timer timer;
    private NumberFormat elementFormatter;
    private NumberFormat timeFormatter;
    Runnable timeTextUpdater = new Runnable(){

        @Override
        public void run() {
            SwingProgressFunction.this.lbl.setText(SwingProgressFunction.this.elementFormatter.format(SwingProgressFunction.this.totalElements) + " " + SwingProgressFunction.this.itemName + ", " + SwingProgressFunction.this.timeFormatter.format((double)(System.currentTimeMillis() - SwingProgressFunction.this.startTime) / 1000.0) + "s");
        }
    };
    Runnable progressUpdater = new Runnable(){

        @Override
        public void run() {
            if (SwingProgressFunction.this.brm.getValue() < SwingProgressFunction.this.brm.getMaximum()) {
                SwingProgressFunction.this.brm.setValue(SwingProgressFunction.this.brm.getValue() + 1);
                SwingProgressFunction.this.setTimeText();
            }
        }
    };

    public SwingProgressFunction(String title, String label) {
        this(title, label, "elements");
    }

    public SwingProgressFunction(String title, String label, String itemName) {
        this.title = title;
        this.label = label;
        this.itemName = itemName;
    }

    @Override
    public void finished() {
        this.invoke(new Runnable(){

            @Override
            public void run() {
                SwingProgressFunction.this.brm.setValue(SwingProgressFunction.this.brm.getMaximum());
                SwingProgressFunction.this.setTimeText();
                SwingProgressFunction.this.timer = new Timer(1000, SwingProgressFunction.this);
                SwingProgressFunction.this.timer.start();
            }
        });
    }

    @Override
    public long getUpdateInterval() {
        return this.updateInterval;
    }

    @Override
    public void init(final long totalElements) {
        this.invoke(new Runnable(){

            @Override
            public void run() {
                SwingProgressFunction.this.totalElements = totalElements;
                SwingProgressFunction.this.elementFormatter = NumberFormat.getInstance(Locale.getDefault());
                SwingProgressFunction.this.timeFormatter = NumberFormat.getInstance(Locale.getDefault());
                SwingProgressFunction.this.timeFormatter.setMinimumFractionDigits(1);
                SwingProgressFunction.this.timeFormatter.setMaximumFractionDigits(1);
                SwingProgressFunction.this.wnd = new JFrame(SwingProgressFunction.this.title);
                SwingProgressFunction.this.wnd.setDefaultCloseOperation(0);
                SwingProgressFunction.this.wnd.setResizable(false);
                SwingProgressFunction.this.pb = new JProgressBar();
                SwingProgressFunction.this.brm = new DefaultBoundedRangeModel();
                SwingProgressFunction.this.pb.setModel(SwingProgressFunction.this.brm);
                SwingProgressFunction.this.updateInterval = (long)SwingProgressFunction.this.brm.getMaximum() > totalElements ? 1L : totalElements / (long)SwingProgressFunction.this.brm.getMaximum();
                JPanel pnl = new JPanel();
                pnl.setLayout(new BorderLayout(8, 8));
                pnl.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
                SwingProgressFunction.this.wnd.getContentPane().add(pnl);
                SwingProgressFunction.this.lbl = new JLabel("#,###,### " + SwingProgressFunction.this.itemName + ", ###.#s", 0);
                pnl.add((Component)new JLabel(SwingProgressFunction.this.label, 0), "North");
                pnl.add((Component)SwingProgressFunction.this.pb, "Center");
                pnl.add((Component)SwingProgressFunction.this.lbl, "South");
                pnl.add((Component)new JPanel(), "West");
                pnl.add((Component)new JPanel(), "East");
                SwingProgressFunction.this.startTime = System.currentTimeMillis();
                SwingProgressFunction.this.wnd.pack();
                SwingProgressFunction.this.setTimeText();
                SwingProgressFunction.this.wnd.setVisible(true);
            }
        });
    }

    private void setTimeText() {
        this.invoke(this.timeTextUpdater);
    }

    private void invoke(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    @Override
    public void progress(long processedElements) {
        this.invoke(this.progressUpdater);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.timer.stop();
        this.wnd.dispose();
    }
}

