/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl.generic;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.Record;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphException;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.exception.NoSuchAttributeException;
import de.uni_koblenz.jgralab.impl.RecordImpl;
import de.uni_koblenz.jgralab.impl.generic.InternalAttributesArrayAccess;
import de.uni_koblenz.jgralab.impl.std.GraphImpl;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.BasicDomain;
import de.uni_koblenz.jgralab.schema.BooleanDomain;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.DoubleDomain;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.EnumDomain;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.IntegerDomain;
import de.uni_koblenz.jgralab.schema.LongDomain;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.io.IOException;
import java.util.Map;

public class GenericGraphImpl
extends GraphImpl
implements InternalAttributesArrayAccess {
    private GraphClass type;
    private Object[] attributes;

    protected GenericGraphImpl(GraphClass type, String id, int vmax, int emax) {
        super(id, type, vmax, emax);
        this.type = type;
        if (type.hasAttributes()) {
            this.attributes = new Object[type.getAttributeCount()];
            if (!this.isLoading()) {
                GenericGraphImpl.initializeGenericAttributeValues(this);
            }
        }
    }

    @Override
    public <T extends Vertex> T createVertex(VertexClass vc) {
        return (T)this.graphFactory.createVertex(vc, 0, this);
    }

    @Override
    public <T extends Edge> T createEdge(EdgeClass ec, Vertex alpha, Vertex omega) {
        return (T)this.graphFactory.createEdge(ec, 0, this, alpha, omega);
    }

    @Override
    public GraphClass getAttributedElementClass() {
        return this.type;
    }

    @Override
    public void readAttributeValueFromString(String attributeName, String value) throws GraphIOException, NoSuchAttributeException {
        int i = this.type.getAttributeIndex(attributeName);
        this.attributes[i] = this.type.getAttribute(attributeName).getDomain().parseGenericAttribute(GraphIO.createStringReader(value, this.getSchema()));
    }

    @Override
    public void readAttributeValues(GraphIO io) throws GraphIOException {
        for (Attribute a : this.type.getAttributeList()) {
            this.attributes[this.type.getAttributeIndex((String)a.getName())] = a.getDomain().parseGenericAttribute(io);
        }
    }

    @Override
    public String writeAttributeValueToString(String attributeName) throws IOException, GraphIOException, NoSuchAttributeException {
        GraphIO io = GraphIO.createStringWriter(this.getSchema());
        this.type.getAttribute(attributeName).getDomain().serializeGenericAttribute(io, this.getAttribute(attributeName));
        return io.getStringWriterResult();
    }

    @Override
    public void writeAttributeValues(GraphIO io) throws IOException, GraphIOException {
        for (Attribute a : this.type.getAttributeList()) {
            a.getDomain().serializeGenericAttribute(io, this.getAttribute(a.getName()));
        }
    }

    @Override
    public <T> T getAttribute(String name) {
        int i = this.getAttributedElementClass().getAttributeIndex(name);
        return (T)this.attributes[i];
    }

    @Override
    public <T> void setAttribute(String name, T data) {
        int i = this.getAttributedElementClass().getAttributeIndex(name);
        if (this.type.getAttribute(name).getDomain().isConformValue(data)) {
            if (this.hasECARuleManager()) {
                T oldValue = this.getAttribute(name);
                this.getECARuleManager().fireBeforeChangeAttributeEvents(this, name, oldValue, data);
                this.attributes[i] = data;
                this.getECARuleManager().fireAfterChangeAttributeEvents(this, name, oldValue, data);
            } else {
                this.attributes[i] = data;
            }
        } else {
            Domain d = this.type.getAttribute(name).getDomain();
            throw new ClassCastException("Expected " + (d instanceof RecordDomain ? RecordImpl.class.getName() : d.getJavaAttributeImplementationTypeName(d.getPackageName())) + " object, but received " + data == null ? data.getClass().getName() + " object instead" : data + " instead");
        }
    }

    @Override
    public void initializeAttributesWithDefaultValues() {
        GenericGraphImpl.initializeGenericAttributeValues(this);
    }

    public static Object genericAttributeDefaultValue(Domain domain) {
        if (domain instanceof BasicDomain) {
            if (domain instanceof BooleanDomain) {
                return false;
            }
            if (domain instanceof IntegerDomain) {
                return 0;
            }
            if (domain instanceof LongDomain) {
                return 0L;
            }
            if (domain instanceof DoubleDomain) {
                return 0.0;
            }
            return null;
        }
        return null;
    }

    static void initializeGenericAttributeValues(AttributedElement<?, ?> ae) {
        for (Attribute attr : ae.getAttributedElementClass().getAttributeList()) {
            if (attr.getDefaultValueAsString() != null && !attr.getDefaultValueAsString().isEmpty()) {
                try {
                    attr.setDefaultValue(ae);
                }
                catch (GraphIOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            ae.setAttribute(attr.getName(), GenericGraphImpl.genericAttributeDefaultValue(attr.getDomain()));
        }
    }

    @Override
    public boolean isInstanceOf(GraphClass cls) {
        return this.type.equals(cls);
    }

    @Override
    public Object getEnumConstant(EnumDomain enumDomain, String constantName) {
        for (String cn : enumDomain.getConsts()) {
            if (!cn.equals(constantName)) continue;
            return cn;
        }
        throw new GraphException("No such enum constant '" + constantName + "' in EnumDomain " + enumDomain);
    }

    @Override
    public Record createRecord(RecordDomain recordDomain, Map<String, Object> values) {
        RecordImpl record = RecordImpl.empty();
        for (RecordDomain.RecordComponent c : recordDomain.getComponents()) {
            if (!values.containsKey(c.getName())) {
                throw new GraphException("The provided Map misses a " + c.getName() + " key!");
            }
            record = record.plus(c.getName(), values.get(c.getName()));
        }
        return record;
    }

    @Override
    public Class<? extends Graph> getSchemaClass() {
        throw new UnsupportedOperationException("This method is not supported by the generic implementation");
    }

    @Override
    public void invokeOnAttributesArray(InternalAttributesArrayAccess.OnAttributesFunction fn) {
        this.attributes = fn.invoke(this, this.attributes);
    }
}

