/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.codegenerator;

import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import java.util.Vector;

public class CodeList
extends CodeBlock {
    Vector<CodeBlock> blocks = new Vector();

    public CodeList() {
        this(null);
    }

    public CodeList(CodeList parent) {
        super(parent);
    }

    public void remove(CodeBlock block) {
        this.blocks.remove(block);
        block.setParent(null);
    }

    public void add(CodeBlock block) {
        this.add(block, 0);
    }

    public void add(CodeBlock block, int addIndent) {
        if (block == null) {
            return;
        }
        block.additionalIndent = addIndent;
        if (block.getParent() != null) {
            block.getParent().remove(block);
        }
        this.blocks.add(block);
        block.setParent(this);
    }

    public void add(int index, CodeBlock block, int addIndent) {
        if (block == null) {
            return;
        }
        block.additionalIndent = addIndent;
        if (block.getParent() != null) {
            block.getParent().remove(block);
        }
        this.blocks.add(index, block);
        block.setParent(this);
    }

    public void addNoIndent(CodeBlock block) {
        if (block != null) {
            this.add(block);
            block.additionalIndent = -1;
        }
    }

    @Override
    public String getCode(int indentLevel) {
        StringBuilder buf = new StringBuilder();
        for (CodeBlock block : this.blocks) {
            buf.append(block.getCode(block.additionalIndent + indentLevel + 1));
        }
        return buf.toString();
    }

    @Override
    public void clear() {
        this.blocks.clear();
    }

    @Override
    public int size() {
        int result = 0;
        for (CodeBlock block : this.blocks) {
            result += block.size();
        }
        return result;
    }
}

