/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.codegenerator;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.codegenerator.AttributedElementCodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import java.util.TreeSet;

public class EdgeCodeGenerator
extends AttributedElementCodeGenerator<EdgeClass, Edge> {
    public EdgeCodeGenerator(EdgeClass edgeClass, String schemaPackageName, CodeGeneratorConfiguration config) {
        super(edgeClass, schemaPackageName, config);
        this.rootBlock.setVariable("graphElementClass", "Edge");
        this.rootBlock.setVariable("schemaElementClass", "EdgeClass");
        for (EdgeClass superClass : edgeClass.getDirectSuperClasses().plus(edgeClass.getGraphClass().getDefaultEdgeClass())) {
            this.interfaces.add(superClass.getQualifiedName());
        }
    }

    @Override
    protected String getSchemaTypeName() {
        return "EdgeClass";
    }

    @Override
    protected CodeBlock createHeader() {
        CodeList code = new CodeList();
        EdgeClass ec = (EdgeClass)this.aec;
        code.setVariable("fromVertexClass", ec.getFrom().getVertexClass().getQualifiedName());
        code.setVariable("toVertexClass", ec.getTo().getVertexClass().getQualifiedName());
        code.setVariable("fromRoleName", ec.getFrom().getRolename());
        code.setVariable("toRoleName", ec.getTo().getRolename());
        code.setVariable("ecName", ec.getQualifiedName());
        CodeSnippet snippet = new CodeSnippet();
        snippet.add("/**");
        snippet.add(" * FromVertexClass: #fromVertexClass#");
        snippet.add(" * FromRoleName : #fromRoleName#");
        snippet.add(" * ToVertexClass: #toVertexClass#");
        snippet.add(" * ToRoleName : #toRoleName#");
        snippet.add(" */");
        code.addNoIndent(snippet);
        code.addNoIndent(super.createHeader());
        return code;
    }

    @Override
    protected CodeBlock createConstructor() {
        CodeList code = new CodeList();
        this.addImports("#jgPackage#.Vertex");
        code.addNoIndent(new CodeSnippet(true, "public #simpleClassName#Impl(int id, #jgPackage#.Graph g, Vertex alpha, Vertex omega) {", "\tsuper(id, g, alpha, omega);"));
        if (this.hasDefaultAttributeValues()) {
            code.addNoIndent(new CodeSnippet("\tinitializeAttributesWithDefaultValues();"));
        }
        code.add(this.createSpecialConstructorCode());
        code.addNoIndent(new CodeSnippet("}"));
        return code;
    }

    @Override
    protected CodeBlock createSpecialConstructorCode() {
        if (this.currentCycle.isStdImpl()) {
            return new CodeSnippet("((#jgImplPackage#.InternalGraph) graph).addEdge(this, alpha, omega);");
        }
        return super.createSpecialConstructorCode();
    }

    @Override
    protected CodeBlock createBody() {
        CodeList code = (CodeList)super.createBody();
        if (this.currentCycle.isStdImpl()) {
            this.rootBlock.setVariable("baseClassName", "EdgeImpl");
            if (this.currentCycle.isStdImpl()) {
                this.addImports("#jgImplStdPackage#.#baseClassName#");
            }
        }
        if (this.config.hasTypeSpecificMethodsSupport() && !this.currentCycle.isClassOnly()) {
            code.add(this.createNextEdgeMethods());
            code.add(this.createNextIncidenceMethods());
        }
        if (this.currentCycle.isStdImpl()) {
            code.add(this.createGetAggregationKindMethod());
            code.add(this.createGetAlphaAggregationKindMethod());
            code.add(this.createGetOmegaAggregationKindMethod());
            code.add(this.createReversedEdgeMethod());
        }
        code.add(this.createGetAlphaOmegaOverrides());
        return code;
    }

    private CodeBlock createReversedEdgeMethod() {
        CodeSnippet code = new CodeSnippet(true, "protected #jgImplPackage#.ReversedEdgeBaseImpl createReversedEdge() {");
        if (this.currentCycle.isStdImpl()) {
            this.addImports("#schemaImplStdPackage#.Reversed#simpleClassName#Impl");
        }
        code.add("\treturn new Reversed#simpleClassName#Impl(this, graph);");
        code.add("}");
        return code;
    }

    private CodeBlock createGetAlphaOmegaOverrides() {
        CodeSnippet b = new CodeSnippet();
        EdgeClass ec = (EdgeClass)this.aec;
        VertexClass from = ec.getFrom().getVertexClass();
        VertexClass to = ec.getTo().getVertexClass();
        b.setVariable("fromVertexClass", from.getSimpleName());
        b.setVariable("toVertexClass", to.getSimpleName());
        if (!from.isDefaultGraphElementClass()) {
            this.addImports(this.schemaRootPackageName + "." + from.getQualifiedName());
        }
        if (!to.isDefaultGraphElementClass()) {
            this.addImports(this.schemaRootPackageName + "." + to.getQualifiedName());
        }
        if (this.currentCycle.isAbstract()) {
            if (!from.isDefaultGraphElementClass()) {
                b.add("public #fromVertexClass# getAlpha();");
            }
            if (!to.isDefaultGraphElementClass()) {
                b.add("public #toVertexClass# getOmega();");
            }
        } else {
            if (!from.isDefaultGraphElementClass()) {
                b.add("public #fromVertexClass# getAlpha() {");
                b.add("\treturn (#fromVertexClass#) super.getAlpha();");
                b.add("}");
            }
            if (!to.isDefaultGraphElementClass()) {
                b.add("public #toVertexClass# getOmega() {");
                b.add("\treturn (#toVertexClass#) super.getOmega();");
                b.add("}");
            }
        }
        return b;
    }

    private CodeBlock createNextEdgeMethods() {
        CodeList code = new CodeList();
        TreeSet<Object> superClasses = new TreeSet<Object>();
        superClasses.addAll(((EdgeClass)this.aec).getAllSuperClasses());
        superClasses.add(this.aec);
        if (this.config.hasTypeSpecificMethodsSupport()) {
            for (AttributedElementClass attributedElementClass : superClasses) {
                EdgeClass ecl = (EdgeClass)attributedElementClass;
                code.addNoIndent(this.createNextEdgeMethod(ecl));
            }
        }
        return code;
    }

    private CodeBlock createNextEdgeMethod(EdgeClass ec) {
        CodeSnippet code = new CodeSnippet(true, new String[0]);
        code.setVariable("ecQualifiedName", this.schemaRootPackageName + "." + ec.getQualifiedName());
        code.setVariable("ecCamelName", EdgeCodeGenerator.camelCase(ec.getUniqueName()));
        code.setVariable("formalParams", "");
        code.setVariable("actualParams", "");
        if (this.currentCycle.isAbstract()) {
            code.add("/**", " * @return the next #ecQualifiedName# edge in the global edge sequence");
            code.add(" */", "public #ecQualifiedName# getNext#ecCamelName#InGraph(#formalParams#);");
        }
        if (this.currentCycle.isStdImpl()) {
            code.add("public #ecQualifiedName# getNext#ecCamelName#InGraph(#formalParams#) {", "\treturn (#ecQualifiedName#)getNextEdge(#ecQualifiedName#.EC#actualParams#);", "}");
        }
        return code;
    }

    private CodeBlock createNextIncidenceMethods() {
        CodeList code = new CodeList();
        TreeSet<Object> superClasses = new TreeSet<Object>();
        superClasses.addAll(((EdgeClass)this.aec).getAllSuperClasses());
        superClasses.add(this.aec);
        if (this.config.hasTypeSpecificMethodsSupport()) {
            for (GraphElementClass graphElementClass : superClasses) {
                this.addImports("#jgPackage#.EdgeDirection");
                EdgeClass ecl = (EdgeClass)graphElementClass;
                code.addNoIndent(this.createNextIncidenceMethod(ecl, false));
                code.addNoIndent(this.createNextIncidenceMethod(ecl, true));
            }
        }
        return code;
    }

    private CodeBlock createNextIncidenceMethod(EdgeClass ec, boolean withOrientation) {
        CodeSnippet code = new CodeSnippet(true, new String[0]);
        code.setVariable("ecQualifiedName", this.schemaRootPackageName + "." + ec.getQualifiedName());
        code.setVariable("ecCamelName", EdgeCodeGenerator.camelCase(ec.getUniqueName()));
        code.setVariable("formalParams", withOrientation ? "EdgeDirection orientation" : "");
        code.setVariable("actualParams", withOrientation ? ", orientation" : "");
        if (this.currentCycle.isAbstract()) {
            code.add("/**", " * @return the next edge of class #ecQualifiedName# at the \"this\" vertex");
            if (withOrientation) {
                code.add(" * @param orientation the orientation of the edge");
            }
            code.add(" */", "public #ecQualifiedName# getNext#ecCamelName#Incidence(#formalParams#);");
        }
        if (this.currentCycle.isStdImpl()) {
            code.add("public #ecQualifiedName# getNext#ecCamelName#Incidence(#formalParams#) {", "\treturn (#ecQualifiedName#)getNextIncidence(#ecQualifiedName#.EC#actualParams#);", "}");
        }
        return code;
    }

    private CodeBlock createGetAggregationKindMethod() {
        CodeSnippet code = new CodeSnippet(true, new String[0]);
        EdgeClass ec = (EdgeClass)this.aec;
        String val = "NONE";
        if (ec.getTo().getAggregationKind() == AggregationKind.COMPOSITE || ec.getFrom().getAggregationKind() == AggregationKind.COMPOSITE) {
            val = "COMPOSITE";
        } else if (ec.getTo().getAggregationKind() == AggregationKind.SHARED || ec.getFrom().getAggregationKind() == AggregationKind.SHARED) {
            val = "SHARED";
        }
        code.setVariable("semantics", val);
        code.add("public de.uni_koblenz.jgralab.schema.AggregationKind getAggregationKind() {", "\treturn de.uni_koblenz.jgralab.schema.AggregationKind.#semantics#;", "}");
        return code;
    }

    private CodeBlock createGetAlphaAggregationKindMethod() {
        CodeSnippet code = new CodeSnippet(true, new String[0]);
        EdgeClass ec = (EdgeClass)this.aec;
        code.setVariable("semantics", ec.getFrom().getAggregationKind().toString());
        code.add("@Override", "public de.uni_koblenz.jgralab.schema.AggregationKind getAlphaAggregationKind() {", "\treturn de.uni_koblenz.jgralab.schema.AggregationKind.#semantics#;", "}");
        return code;
    }

    private CodeBlock createGetOmegaAggregationKindMethod() {
        CodeSnippet code = new CodeSnippet(true, new String[0]);
        EdgeClass ec = (EdgeClass)this.aec;
        code.setVariable("semantics", ec.getTo().getAggregationKind().toString());
        code.add("@Override", "public de.uni_koblenz.jgralab.schema.AggregationKind getOmegaAggregationKind() {", "\treturn de.uni_koblenz.jgralab.schema.AggregationKind.#semantics#;", "}");
        return code;
    }

    @Override
    protected CodeBlock createAttributedElementClassConstant() {
        CodeSnippet s = new CodeSnippet(true, "public static final #jgSchemaPackage#.#schemaElementClass# EC = #schemaPackageName#.#schemaName#.instance().getGraphClass().getEdgeClass(\"#ecQualifiedName#\");");
        s.setVariable("ecQualifiedName", ((EdgeClass)this.aec).getQualifiedName());
        return s;
    }

    @Override
    protected CodeBlock createGetAttributedElementClassMethod() {
        return new CodeSnippet(true, "@Override", "public final #jgSchemaPackage#.#schemaElementClass# getAttributedElementClass() {", "\treturn #javaClassName#.EC;", "}");
    }
}

