/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.codegenerator;

import de.uni_koblenz.jgralab.schema.EnumDomain;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;

public class EnumCodeGenerator
extends CodeGenerator {
    private EnumDomain enumDomain;

    public EnumCodeGenerator(EnumDomain enumDomain, String schemaPackageName) {
        super(schemaPackageName, enumDomain.getPackageName(), new CodeGeneratorConfiguration());
        this.rootBlock.setVariable("simpleClassName", enumDomain.getSimpleName());
        this.rootBlock.setVariable("isClassOnly", "true");
        this.enumDomain = enumDomain;
    }

    @Override
    protected CodeBlock createBody() {
        CodeList result = new CodeList();
        if (this.currentCycle.isClassOnly()) {
            CodeSnippet constCode = new CodeSnippet(true, new String[0]);
            String delim = "";
            StringBuilder constants = new StringBuilder();
            for (String s : this.enumDomain.getConsts()) {
                constants.append(delim);
                constants.append(s);
                delim = ", ";
            }
            constants.append(";");
            constCode.add(constants.toString());
            CodeSnippet valueOfCode = new CodeSnippet(true, new String[0]);
            valueOfCode.add("public static #simpleClassName# valueOfPermitNull(String val) {", "\tif (val.equals(de.uni_koblenz.jgralab.GraphIO.NULL_LITERAL)) {", "\t\treturn null;", "\t}", "\treturn valueOf(val);", "}");
            result.add(constCode);
            result.add(valueOfCode);
        }
        return result;
    }

    @Override
    protected CodeBlock createHeader() {
        if (this.currentCycle.isClassOnly()) {
            return new CodeSnippet(true, "public enum #simpleClassName# {");
        }
        return new CodeSnippet();
    }
}

