/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.codegenerator;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.codegenerator.AttributedElementCodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import java.util.HashSet;
import java.util.TreeSet;

public class GraphCodeGenerator
extends AttributedElementCodeGenerator<GraphClass, Graph> {
    public GraphCodeGenerator(GraphClass graphClass, String schemaPackageName, String schemaName, CodeGeneratorConfiguration config) {
        super(graphClass, schemaPackageName, config);
        this.rootBlock.setVariable("graphElementClass", "Graph");
        this.rootBlock.setVariable("schemaElementClass", "GraphClass");
        this.rootBlock.setVariable("schemaName", schemaName);
        this.rootBlock.setVariable("theGraph", "this");
        this.interfaces.add("Graph");
    }

    @Override
    protected String getSchemaTypeName() {
        return "GraphClass";
    }

    @Override
    protected CodeBlock createHeader() {
        return super.createHeader();
    }

    @Override
    protected CodeBlock createBody() {
        CodeList code = (CodeList)super.createBody();
        if (this.currentCycle.isStdImpl()) {
            if (this.currentCycle.isStdImpl()) {
                this.addImports("#jgImplStdPackage#.#baseClassName#");
            }
            this.rootBlock.setVariable("baseClassName", "GraphImpl");
        }
        code.add(this.createGraphElementClassMethods());
        code.add(this.createEdgeIteratorMethods());
        code.add(this.createVertexIteratorMethods());
        return code;
    }

    @Override
    protected CodeBlock createConstructor() {
        CodeSnippet code = new CodeSnippet(true, new String[0]);
        if (this.currentCycle.isStdImpl()) {
            code.setVariable("createSuffix", "STANDARD");
        }
        code.add("/**", " * DON'T USE THE CONSTRUCTOR", " * For instantiating a Graph, use the Schema and a GraphFactory", "**/", "public #simpleImplClassName#() {", "\tthis(null);", "}", "", "/**", " * DON'T USE THE CONSTRUCTOR", " * For instantiating a Graph, use the Schema and a GraphFactory", "**/", "public #simpleImplClassName#(int vMax, int eMax) {", "\tthis(null, vMax, eMax);", "}", "", "/**", " * DON'T USE THE CONSTRUCTOR", " * For instantiating a Graph, use the Schema and a GraphFactory", "**/", "public #simpleImplClassName#(java.lang.String id, int vMax, int eMax) {", "\tsuper(id, #javaClassName#.GC, vMax, eMax);", "\tinitializeAttributesWithDefaultValues();", "}", "", "/**", " * DON'T USE THE CONSTRUCTOR", " * For instantiating a Graph, use the Schema and a GraphFactory", "**/", "public #simpleImplClassName#(java.lang.String id) {", "\tsuper(id, #javaClassName#.GC);", "\tinitializeAttributesWithDefaultValues();", "}");
        return code;
    }

    private CodeBlock createGraphElementClassMethods() {
        CodeList code = new CodeList();
        GraphClass gc = (GraphClass)this.aec;
        TreeSet sortedClasses = new TreeSet();
        sortedClasses.addAll(gc.getGraphElementClasses());
        for (GraphElementClass graphElementClass : sortedClasses) {
            CodeList gecCode = new CodeList();
            code.addNoIndent(gecCode);
            gecCode.addNoIndent(new CodeSnippet(true, "// ------------------------ Code for #ecQualifiedName# ------------------------"));
            gecCode.setVariable("ecSimpleName", graphElementClass.getSimpleName());
            gecCode.setVariable("ecUniqueName", graphElementClass.getUniqueName());
            gecCode.setVariable("ecQualifiedName", graphElementClass.getQualifiedName());
            gecCode.setVariable("ecJavaClassName", this.schemaRootPackageName + "." + graphElementClass.getQualifiedName());
            gecCode.setVariable("ecType", graphElementClass instanceof VertexClass ? "Vertex" : "Edge");
            gecCode.setVariable("ecTypeInComment", graphElementClass instanceof VertexClass ? "vertex" : "edge");
            gecCode.setVariable("ecTypeAecConstant", graphElementClass instanceof VertexClass ? "VC" : "EC");
            gecCode.setVariable("ecCamelName", GraphCodeGenerator.camelCase(graphElementClass.getUniqueName()));
            gecCode.setVariable("ecImplName", graphElementClass.isAbstract() ? "**ERROR**" : GraphCodeGenerator.camelCase(graphElementClass.getQualifiedName()) + "Impl");
            gecCode.addNoIndent(this.createGetFirstMethods(graphElementClass));
            gecCode.addNoIndent(this.createFactoryMethods(graphElementClass));
        }
        return code;
    }

    private CodeBlock createGetFirstMethods(GraphElementClass<?, ?> gec) {
        CodeList code = new CodeList();
        if (this.config.hasTypeSpecificMethodsSupport()) {
            code.addNoIndent(this.createGetFirstMethod(gec));
        }
        return code;
    }

    private CodeBlock createGetFirstMethod(GraphElementClass<?, ?> gec) {
        CodeSnippet code = new CodeSnippet(true, new String[0]);
        if (this.currentCycle.isAbstract()) {
            code.add("/**", " * @return the first #ecSimpleName# #ecTypeInComment# in this graph");
            code.add(" */", "public #ecJavaClassName# getFirst#ecCamelName#();");
        }
        if (this.currentCycle.isStdImpl()) {
            code.add("public #ecJavaClassName# getFirst#ecCamelName#() {", "\treturn (#ecJavaClassName#)getFirst#ecType#(#ecJavaClassName#.#ecTypeAecConstant#);", "}");
        }
        return code;
    }

    private CodeBlock createFactoryMethods(GraphElementClass<?, ?> gec) {
        if (gec.isAbstract()) {
            return null;
        }
        CodeList code = new CodeList();
        code.addNoIndent(this.createFactoryMethod(gec, false));
        if (this.currentCycle.isStdImpl()) {
            code.addNoIndent(this.createFactoryMethod(gec, true));
        }
        return code;
    }

    private CodeBlock createFactoryMethod(GraphElementClass<?, ?> gec, boolean withId) {
        CodeSnippet code = new CodeSnippet(true, new String[0]);
        if (this.currentCycle.isAbstract()) {
            code.add("/**", " * Creates a new #ecUniqueName# #ecTypeInComment# in this graph.", " *");
            if (withId) {
                code.add(" * @param id the <code>id</code> of the #ecTypeInComment#");
            }
            if (gec instanceof EdgeClass) {
                code.add(" * @param alpha the start vertex of the edge", " * @param omega the target vertex of the edge");
            }
            code.add("*/", "public #ecJavaClassName# create#ecCamelName#(#formalParams#);");
        }
        if (this.currentCycle.isStdImpl()) {
            code.add("public #ecJavaClassName# create#ecCamelName#(#formalParams#) {", "\treturn graphFactory.<#ecJavaClassName#> create#ecType#(#ecJavaClassName#.#ecTypeAecConstant#, #newActualParams#, this#additionalParams#);", "}");
            code.setVariable("additionalParams", "");
        }
        if (gec instanceof EdgeClass) {
            EdgeClass ec = (EdgeClass)gec;
            String fromClass = ec.getFrom().getVertexClass().getQualifiedName();
            String toClass = ec.getTo().getVertexClass().getQualifiedName();
            if (fromClass.equals("Vertex")) {
                code.setVariable("fromClass", "#jgPackage#.Vertex");
            } else {
                code.setVariable("fromClass", "#schemaPackage#." + fromClass);
            }
            if (toClass.equals("Vertex")) {
                code.setVariable("toClass", "#jgPackage#.Vertex");
            } else {
                code.setVariable("toClass", "#schemaPackage#." + toClass);
            }
            code.setVariable("formalParams", (withId ? "int id, " : "") + "#fromClass# alpha, #toClass# omega");
            code.setVariable("addActualParams", ", alpha, omega");
            code.setVariable("additionalParams", ", alpha, omega");
        } else {
            code.setVariable("formalParams", withId ? "int id" : "");
            code.setVariable("addActualParams", "");
        }
        code.setVariable("newActualParams", withId ? "id" : "0");
        return code;
    }

    private CodeBlock createEdgeIteratorMethods() {
        GraphClass gc = (GraphClass)this.aec;
        CodeList code = new CodeList();
        if (!this.config.hasTypeSpecificMethodsSupport()) {
            return code;
        }
        for (EdgeClass edge : gc.getEdgeClasses()) {
            if (this.currentCycle.isStdImpl()) {
                this.addImports("#jgImplPackage#.EdgeIterable");
            }
            CodeSnippet s = new CodeSnippet(true, new String[0]);
            code.addNoIndent(s);
            s.setVariable("edgeUniqueName", GraphCodeGenerator.camelCase(edge.getUniqueName()));
            s.setVariable("edgeQualifiedName", edge.getQualifiedName());
            s.setVariable("edgeJavaClassName", this.schemaRootPackageName + "." + edge.getQualifiedName());
            if (this.currentCycle.isAbstract()) {
                s.add("/**");
                s.add(" * @return an Iterable for all edges of this graph that are of type #edgeQualifiedName# or subtypes.");
                s.add(" */");
                s.add("public Iterable<#edgeJavaClassName#> get#edgeUniqueName#Edges();");
            }
            if (this.currentCycle.isStdImpl()) {
                s.add("public Iterable<#edgeJavaClassName#> get#edgeUniqueName#Edges() {");
                s.add("\treturn new EdgeIterable<#edgeJavaClassName#>(this, #edgeJavaClassName#.EC);");
                s.add("}");
            }
            s.add("");
        }
        return code;
    }

    private CodeBlock createVertexIteratorMethods() {
        GraphClass gc = (GraphClass)this.aec;
        CodeList code = new CodeList();
        if (!this.config.hasTypeSpecificMethodsSupport()) {
            return code;
        }
        HashSet<VertexClass> vertexClassSet = new HashSet<VertexClass>();
        vertexClassSet.addAll(gc.getVertexClasses());
        for (VertexClass vertex : vertexClassSet) {
            if (this.currentCycle.isStdImpl()) {
                this.addImports("#jgImplPackage#.VertexIterable");
            }
            CodeSnippet s = new CodeSnippet(true, new String[0]);
            code.addNoIndent(s);
            s.setVariable("vertexQualifiedName", vertex.getQualifiedName());
            s.setVariable("vertexJavaClassName", "#schemaPackage#." + vertex.getQualifiedName());
            s.setVariable("vertexCamelName", GraphCodeGenerator.camelCase(vertex.getUniqueName()));
            if (this.currentCycle.isAbstract()) {
                s.add("/**");
                s.add(" * @return an Iterable for all vertices of this graph that are of type #vertexQualifiedName# or subtypes.");
                s.add(" */");
                s.add("public Iterable<#vertexJavaClassName#> get#vertexCamelName#Vertices();");
                s.add("", "public Iterable<#vertexJavaClassName#> get#vertexCamelName#Vertices(#jgPackage#.VertexFilter<#vertexJavaClassName#> filter);");
            }
            if (this.currentCycle.isStdImpl()) {
                s.add("public Iterable<#vertexJavaClassName#> get#vertexCamelName#Vertices() {");
                s.add("\treturn new VertexIterable<#vertexJavaClassName#>(this, #vertexJavaClassName#.VC, null);");
                s.add("}");
                s.add("", "public Iterable<#vertexJavaClassName#> get#vertexCamelName#Vertices(#jgPackage#.VertexFilter<#vertexJavaClassName#> filter) {");
                s.add("\treturn new VertexIterable<#vertexJavaClassName#>(this, #vertexJavaClassName#.VC, filter);");
                s.add("}");
            }
            s.add("");
        }
        return code;
    }

    @Override
    protected void addCheckValidityCode(CodeSnippet code) {
    }

    @Override
    protected CodeBlock createAttributedElementClassConstant() {
        return new CodeSnippet(true, "public static final #jgSchemaPackage#.#schemaElementClass# GC = #schemaPackageName#.#schemaName#.instance().getGraphClass();");
    }

    @Override
    protected CodeBlock createGetAttributedElementClassMethod() {
        return new CodeSnippet(true, "@Override", "public final #jgSchemaPackage#.#schemaElementClass# getAttributedElementClass() {", "\treturn #javaClassName#.GC;", "}");
    }
}

