/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.codegenerator;

import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;

public class GraphFactoryGenerator
extends CodeGenerator {
    private final Schema schema;

    public GraphFactoryGenerator(Schema schema, String schemaPackageName, CodeGeneratorConfiguration config) {
        super(schemaPackageName, "", config);
        this.schema = schema;
        this.rootBlock.setVariable("schemaName", schema.getQualifiedName());
        this.rootBlock.setVariable("simpleClassName", schema.getGraphClass().getSimpleName() + "Factory");
        this.rootBlock.setVariable("simpleImplClassName", schema.getGraphClass().getSimpleName() + "FactoryImpl");
        this.rootBlock.setVariable("isClassOnly", "false");
    }

    @Override
    protected CodeBlock createHeader() {
        CodeSnippet code = new CodeSnippet(true, new String[0]);
        if (this.currentCycle.isAbstract()) {
            this.addImports("#jgPackage#.GraphFactory");
            code.add("public interface #simpleClassName# extends GraphFactory {");
        } else {
            this.addImports("#schemaPackage#.#simpleClassName#");
            this.addImports("#jgImplPackage#.GraphFactoryImpl");
            this.addImports("#jgPackage#.ImplementationType");
            code.add("public class #simpleImplClassName# extends GraphFactoryImpl implements #simpleClassName# {");
        }
        return code;
    }

    @Override
    protected CodeBlock createBody() {
        CodeList code = new CodeList();
        if (this.currentCycle.isStdImpl()) {
            code.add(this.createConstructor());
        }
        return code;
    }

    protected CodeBlock createConstructor() {
        CodeList code = new CodeList();
        if (this.currentCycle.isStdImpl()) {
            code.setVariable("implTypeInfix", "STANDARD");
        }
        CodeSnippet s = new CodeSnippet(true, new String[0]);
        s.add("public #simpleImplClassName#() {", "\tsuper(#schemaName#.instance(), ImplementationType.#implTypeInfix#);", "\tcreateMaps();");
        code.addNoIndent(s);
        code.add(this.createFillTableMethod());
        code.addNoIndent(new CodeSnippet("}"));
        return code;
    }

    protected CodeBlock createFillTableMethod() {
        if (this.currentCycle.isAbstract()) {
            return null;
        }
        CodeList code = new CodeList();
        GraphClass graphClass = this.schema.getGraphClass();
        code.addNoIndent(this.createFillTableForGraph(graphClass));
        for (VertexClass vertexClass : graphClass.getVertexClasses()) {
            code.addNoIndent(this.createFillTableForVertex(vertexClass));
        }
        for (EdgeClass edgeClass : graphClass.getEdgeClasses()) {
            code.addNoIndent(this.createFillTableForEdge(edgeClass));
        }
        return code;
    }

    protected CodeBlock createFillTableForGraph(GraphClass graphClass) {
        if (graphClass.isAbstract()) {
            return null;
        }
        CodeSnippet code = new CodeSnippet(false, new String[0]);
        code.setVariable("graphName", graphClass.getQualifiedName() + ".GC");
        code.setVariable("graphImplName", "#schemaImplStdPackage#." + graphClass.getQualifiedName() + "Impl");
        code.setVariable("graphTransactionImplName", "#schemaImplTransPackage#." + graphClass.getQualifiedName() + "Impl");
        code.setVariable("graphDatabaseImplName", "#schemaImplDbPackage#." + graphClass.getQualifiedName() + "Impl");
        if (!graphClass.isAbstract() && this.currentCycle.isStdImpl()) {
            code.add("setGraphImplementationClass(#schemaPackage#.#graphName#, #graphImplName#.class);");
        }
        return code;
    }

    protected CodeBlock createFillTableForVertex(VertexClass vertexClass) {
        if (vertexClass.isAbstract()) {
            return null;
        }
        CodeSnippet code = new CodeSnippet(false, new String[0]);
        code.setVariable("vertexName", vertexClass.getQualifiedName() + ".VC");
        code.setVariable("vertexImplName", "#schemaImplStdPackage#." + vertexClass.getQualifiedName() + "Impl");
        code.setVariable("vertexTransactionImplName", "#schemaImplTransPackage#." + vertexClass.getQualifiedName() + "Impl");
        code.setVariable("vertexDatabaseImplName", "#schemaImplDbPackage#." + vertexClass.getQualifiedName() + "Impl");
        if (!vertexClass.isAbstract() && this.currentCycle.isStdImpl()) {
            code.add("setVertexImplementationClass(#schemaPackage#.#vertexName#, #vertexImplName#.class);");
        }
        return code;
    }

    protected CodeBlock createFillTableForEdge(EdgeClass edgeClass) {
        CodeSnippet code = new CodeSnippet(false, new String[0]);
        code.setVariable("edgeName", edgeClass.getQualifiedName() + ".EC");
        code.setVariable("edgeImplName", "#schemaImplStdPackage#." + edgeClass.getQualifiedName() + "Impl");
        code.setVariable("edgeTransactionImplName", "#schemaImplTransPackage#." + edgeClass.getQualifiedName() + "Impl");
        code.setVariable("edgeDatabaseImplName", "#schemaImplDbPackage#." + edgeClass.getQualifiedName() + "Impl");
        if (!edgeClass.isAbstract() && this.currentCycle.isStdImpl()) {
            code.add("setEdgeImplementationClass(#schemaPackage#.#edgeName#, #edgeImplName#.class);");
        }
        return code;
    }
}

