/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.codegenerator;

import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import java.util.SortedSet;
import java.util.TreeSet;

public class ImportCodeSnippet
extends CodeSnippet {
    private SortedSet<String> imports;
    private boolean separatePackages;

    public ImportCodeSnippet() {
        this(null, true);
    }

    public ImportCodeSnippet(boolean separatePackages) {
        this(null, separatePackages);
    }

    public ImportCodeSnippet(CodeList parent) {
        this(parent, true);
    }

    public ImportCodeSnippet(CodeList parent, boolean separatePackages) {
        super(parent, true, new String[0]);
        this.separatePackages = separatePackages;
        this.imports = new TreeSet<String>();
    }

    @Override
    public void add(String ... addedLines) {
        if (addedLines != null) {
            for (String line : addedLines) {
                this.imports.add(line);
            }
        }
    }

    @Override
    public String getCode(int indent) {
        this.lines.clear();
        String lastPackageName = null;
        for (String imp : this.imports) {
            String packageName = imp.substring(0, imp.indexOf(46));
            if (this.separatePackages && lastPackageName != null && !lastPackageName.equals(packageName)) {
                this.lines.add("");
            }
            this.lines.add("import " + imp + ";");
            lastPackageName = packageName;
        }
        return super.getCode(indent);
    }

    @Override
    public void clear() {
        super.clear();
        this.imports.clear();
    }

    @Override
    public int size() {
        return this.imports.size();
    }
}

