/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.codegenerator;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.codegenerator.AttributedElementCodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import java.util.List;
import java.util.TreeSet;

public class ReversedEdgeCodeGenerator
extends AttributedElementCodeGenerator<EdgeClass, Edge> {
    public ReversedEdgeCodeGenerator(EdgeClass edgeClass, String schemaPackageName, CodeGeneratorConfiguration config) {
        super(edgeClass, schemaPackageName, config);
        this.rootBlock.setVariable("graphElementClass", "ReversedEdge");
        this.rootBlock.setVariable("schemaElementClass", "EdgeClass");
        this.rootBlock.setVariable("isImplementationClassOnly", "true");
        this.rootBlock.setVariable("className", "Reversed" + edgeClass.getSimpleName());
        this.rootBlock.setVariable("simpleClassName", "Reversed" + edgeClass.getSimpleName());
        this.rootBlock.setVariable("simpleImplClassName", "Reversed" + edgeClass.getSimpleName() + "Impl");
        this.rootBlock.setVariable("normalQualifiedClassName", this.schemaRootPackageName + "." + edgeClass.getQualifiedName());
        for (EdgeClass superClass : edgeClass.getDirectSuperClasses().plus(edgeClass.getGraphClass().getDefaultEdgeClass())) {
            this.interfaces.add(superClass.getQualifiedName());
        }
    }

    @Override
    protected String getSchemaTypeName() {
        return "EdgeClass";
    }

    @Override
    protected CodeBlock createBody() {
        CodeList code = (CodeList)super.createBody();
        if (this.currentCycle.isStdImpl()) {
            this.rootBlock.setVariable("baseClassName", "ReversedEdgeImpl");
            if (this.currentCycle.isStdImpl()) {
                this.addImports("#jgImplStdPackage#.#baseClassName#");
            }
            if (this.config.hasTypeSpecificMethodsSupport()) {
                code.add(this.createNextEdgeMethods());
                code.add(this.createNextIncidenceMethods());
            }
            code.add(this.createGetAlphaOmegaOverrides());
        }
        return code;
    }

    private CodeBlock createGetAlphaOmegaOverrides() {
        CodeSnippet b = new CodeSnippet();
        EdgeClass ec = (EdgeClass)this.aec;
        VertexClass from = ec.getFrom().getVertexClass();
        VertexClass to = ec.getTo().getVertexClass();
        b.setVariable("fromVertexClass", from.getSimpleName());
        b.setVariable("toVertexClass", to.getSimpleName());
        this.addImports(this.schemaRootPackageName + "." + from.getQualifiedName());
        this.addImports(this.schemaRootPackageName + "." + to.getQualifiedName());
        if (!this.currentCycle.isAbstract()) {
            b.add("public #fromVertexClass# getAlpha() {");
            b.add("\treturn (#fromVertexClass#) super.getAlpha();");
            b.add("}");
            b.add("public #toVertexClass# getOmega() {");
            b.add("\treturn (#toVertexClass#) super.getOmega();");
            b.add("}");
        }
        return b;
    }

    @Override
    protected CodeBlock createConstructor() {
        if (this.currentCycle.isStdImpl()) {
            this.addImports("#jgImplStdPackage#.EdgeImpl", "#jgPackage#.Graph");
        }
        return new CodeSnippet(true, "#className#Impl(EdgeImpl e, Graph g) {", "\tsuper(e, g);", "}");
    }

    @Override
    protected CodeBlock createGetter(Attribute a) {
        CodeSnippet code = new CodeSnippet(true, new String[0]);
        code.setVariable("name", a.getName());
        code.setVariable("type", a.getDomain().getJavaAttributeImplementationTypeName(this.schemaRootPackageName));
        code.setVariable("isOrGet", a.getDomain().isBoolean() ? "is" : "get");
        if (this.currentCycle.isStdImpl()) {
            code.add("public #type# #isOrGet#_#name#() {", "\treturn ((#normalQualifiedClassName#)normalEdge).#isOrGet#_#name#();", "}");
        }
        if (this.currentCycle.isAbstract()) {
            code.add("public #type# #isOrGet#_#name#();");
        }
        return code;
    }

    @Override
    protected CodeBlock createSetter(Attribute a) {
        CodeSnippet code = new CodeSnippet(true, new String[0]);
        code.setVariable("name", a.getName());
        code.setVariable("type", a.getDomain().getJavaAttributeImplementationTypeName(this.schemaRootPackageName));
        if (this.currentCycle.isStdImpl()) {
            code.add("public void set_#name#(#type# _#name#) {", "\t((#normalQualifiedClassName#)normalEdge).set_#name#(_#name#);", "}");
        }
        if (this.currentCycle.isAbstract()) {
            code.add("public void set_#name#(#type# _#name#);");
        }
        return code;
    }

    @Override
    protected CodeBlock createGenericGetter(List<Attribute> attributes) {
        return null;
    }

    @Override
    protected CodeBlock createGenericSetter(List<Attribute> attributes) {
        return null;
    }

    private CodeBlock createNextEdgeMethods() {
        CodeList code = new CodeList();
        TreeSet<Object> superClasses = new TreeSet<Object>();
        superClasses.addAll(((EdgeClass)this.aec).getAllSuperClasses());
        superClasses.add(this.aec);
        for (GraphElementClass graphElementClass : superClasses) {
            EdgeClass ecl = (EdgeClass)graphElementClass;
            code.addNoIndent(this.createNextEdgeMethod(ecl));
        }
        return code;
    }

    private CodeBlock createNextEdgeMethod(EdgeClass ec) {
        CodeSnippet code = new CodeSnippet(true, "public #ecName# getNext#ecCamelName#InGraph(#formalParams#) {", "\treturn ((#ecName#)normalEdge).getNext#ecCamelName#InGraph(#actualParams#);", "}");
        code.setVariable("ecName", this.schemaRootPackageName + "." + ec.getQualifiedName());
        code.setVariable("ecCamelName", ReversedEdgeCodeGenerator.camelCase(ec.getUniqueName()));
        code.setVariable("formalParams", "");
        code.setVariable("actualParams", "");
        return code;
    }

    private CodeBlock createNextIncidenceMethods() {
        CodeList code = new CodeList();
        TreeSet<Object> superClasses = new TreeSet<Object>();
        superClasses.addAll(((EdgeClass)this.aec).getAllSuperClasses());
        superClasses.add(this.aec);
        for (GraphElementClass graphElementClass : superClasses) {
            this.addImports("#jgPackage#.EdgeDirection");
            EdgeClass ecl = (EdgeClass)graphElementClass;
            code.addNoIndent(this.createNextIncidenceMethod(ecl, false));
            code.addNoIndent(this.createNextIncidenceMethod(ecl, true));
        }
        return code;
    }

    private CodeBlock createNextIncidenceMethod(EdgeClass ec, boolean withOrientation) {
        CodeSnippet code = new CodeSnippet(true, "public #ecName# getNext#ecCamelName#Incidence(#formalParams#) {", "\treturn (#ecName#)getNextIncidence(#ecName#.EC#actualParams#);", "}");
        code.setVariable("ecName", this.schemaRootPackageName + "." + ec.getQualifiedName());
        code.setVariable("ecCamelName", ReversedEdgeCodeGenerator.camelCase(ec.getUniqueName()));
        code.setVariable("formalParams", withOrientation ? "EdgeDirection orientation" : "");
        code.setVariable("actualParams", withOrientation ? ", orientation" : "");
        return code;
    }

    @Override
    protected CodeBlock createStaticImplementationClassField() {
        return null;
    }

    @Override
    protected CodeBlock createFields(List<Attribute> attributes) {
        return null;
    }

    @Override
    protected CodeBlock createGetSchemaClassMethod() {
        return null;
    }

    @Override
    protected CodeBlock createReadAttributesFromStringMethod(List<Attribute> attributes) {
        CodeList code = new CodeList();
        this.addImports("#jgPackage#.GraphIO", "#jgPackage#.exception.GraphIOException");
        code.addNoIndent(new CodeSnippet(true, "public void readAttributeValueFromString(String attributeName, String value) throws GraphIOException {"));
        code.add(new CodeSnippet("throw new GraphIOException(\"Can not call readAttributeValuesFromString for reversed Edges.\");"));
        code.addNoIndent(new CodeSnippet("}"));
        return code;
    }

    @Override
    protected CodeBlock createWriteAttributeToStringMethod(List<Attribute> attributes) {
        CodeList code = new CodeList();
        this.addImports("#jgPackage#.GraphIO", "#jgPackage#.exception.GraphIOException");
        code.addNoIndent(new CodeSnippet(true, "public String writeAttributeValueToString(String _attributeName) throws IOException, GraphIOException {"));
        code.add(new CodeSnippet("throw new GraphIOException(\"Can not call writeAttributeValueToString for reversed Edges.\");"));
        code.addNoIndent(new CodeSnippet("}"));
        return code;
    }

    @Override
    protected CodeBlock createReadAttributesMethod(List<Attribute> attributes) {
        CodeList code = new CodeList();
        this.addImports("#jgPackage#.GraphIO", "#jgPackage#.exception.GraphIOException");
        code.addNoIndent(new CodeSnippet(true, "public void readAttributeValues(GraphIO io) throws GraphIOException {"));
        code.add(new CodeSnippet("throw new GraphIOException(\"Can not call readAttributeValues for reversed Edges.\");"));
        code.addNoIndent(new CodeSnippet("}"));
        return code;
    }

    @Override
    protected CodeBlock createWriteAttributesMethod(List<Attribute> attributes) {
        CodeList code = new CodeList();
        this.addImports("#jgPackage#.GraphIO", "#jgPackage#.exception.GraphIOException", "java.io.IOException");
        code.addNoIndent(new CodeSnippet(true, "public void writeAttributeValues(GraphIO io) throws GraphIOException, IOException {"));
        code.add(new CodeSnippet("throw new GraphIOException(\"Can not call writeAttributeValues for reversed Edges.\");"));
        code.addNoIndent(new CodeSnippet("}"));
        return code;
    }

    @Override
    protected CodeBlock createAttributedElementClassConstant() {
        return null;
    }

    @Override
    protected CodeBlock createGetAttributedElementClassMethod() {
        return new CodeSnippet(true, "@Override", "public final #jgSchemaPackage#.#schemaElementClass# getAttributedElementClass() {", "\treturn getNormalEdge().getAttributedElementClass();", "}");
    }
}

