/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.codegenerator;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.IncidenceClass;
import de.uni_koblenz.jgralab.schema.IncidenceDirection;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import java.util.HashSet;

public class RolenameCodeGenerator {
    private final VertexClass vertexClass;
    private final String schemaRootPackageName;

    RolenameCodeGenerator(VertexClass vertexClass) {
        this.vertexClass = vertexClass;
        this.schemaRootPackageName = vertexClass.getSchema().getPackagePrefix() + ".";
    }

    private CodeBlock createRemoveAdjacenceSnippet(String rolename, EdgeClass edgeClass, VertexClass definingVertexClass, EdgeDirection dir, boolean createClass) {
        CodeSnippet code = new CodeSnippet();
        code.setVariable("rolename", rolename);
        code.setVariable("edgeClass", "#schemaPackage#." + edgeClass.getSimpleName() + ".EC");
        code.setVariable("edgeClassName", this.schemaRootPackageName + edgeClass.getQualifiedName());
        code.setVariable("dir", "EdgeDirection." + dir.toString());
        code.setVariable("definingVertexClassName", this.schemaRootPackageName + definingVertexClass.getQualifiedName());
        if (!createClass) {
            code.add("/**", " * removes the given vertex as <code>#rolename#</code> from this vertex, i.e. ", " * deletes the <code>#edgeClassName#</code> edge connections of this vertex with ", " * the given one.", " */", "public boolean remove_#rolename#(#definingVertexClassName# vertex);");
        } else {
            code.add("@Override", "public boolean remove_#rolename#(#definingVertexClassName# vertex) {", "\tboolean elementRemoved = false;", "\t#edgeClassName# edge = (#edgeClassName#) getFirstIncidence(#edgeClassName#.EC, #dir#);", "\twhile (edge != null) {", "\t\t#edgeClassName# next = (#edgeClassName#) edge.getNextIncidence(#edgeClassName#.EC, #dir#);", "\t\tif (edge.getThat().equals(vertex)) {\t\t\tedge.delete();", "\t\t\telementRemoved = true;", "\t\t}", "\t\tedge = next;", "\t}", "\treturn elementRemoved;", "}");
        }
        return code;
    }

    private CodeBlock createRemoveAllAdjacencesSnippet(String rolename, EdgeClass edgeClass, VertexClass otherVertexClass, EdgeDirection dir, boolean createClass) {
        CodeSnippet code = new CodeSnippet();
        code.setVariable("rolename", rolename);
        code.setVariable("edgeClassName", this.schemaRootPackageName + edgeClass.getQualifiedName());
        code.setVariable("dir", "EdgeDirection." + dir.toString());
        code.setVariable("vertexClassName", this.schemaRootPackageName + otherVertexClass.getQualifiedName());
        if (!createClass) {
            code.add("/**", " * removes all #rolename# adjacences to all vertices by ", " * deleting the <code>#edgeClassName#</code> edges of this vertex to ", " * all other ones, but doesn't delete those vertices.", " *", " * @return the adjacent vertices prior to removal of incidences", " */", "public java.util.List<? extends #vertexClassName#> remove_#rolename#();");
        } else {
            code.add("@Override", "public java.util.List<? extends #vertexClassName#> remove_#rolename#() {", "\tjava.util.List<#vertexClassName#> adjacences = new java.util.ArrayList<#vertexClassName#>();", "\t#edgeClassName# edge = (#edgeClassName#) getFirstIncidence(#edgeClassName#.EC, #dir#);", "\twhile (edge != null) {", "\t\t#edgeClassName# next = (#edgeClassName#) edge.getNextIncidence(#edgeClassName#.EC, #dir#);", "\t\tadjacences.add((#vertexClassName#) edge.getThat());", "\t\tedge.delete();", "\t\tedge = next;", "\t}", "\treturn adjacences;", "}");
        }
        return code;
    }

    private CodeBlock createGetAdjacencesSnippet(IncidenceClass incClass, VertexClass allowedVertexClass, VertexClass definingVertexClass, EdgeDirection dir, boolean createClass) {
        CodeSnippet code = new CodeSnippet();
        code.setVariable("rolename", incClass.getRolename());
        code.setVariable("edgeClassName", this.schemaRootPackageName + incClass.getEdgeClass().getQualifiedName());
        code.setVariable("dir", "EdgeDirection." + dir.toString());
        code.setVariable("vertexClassName", this.schemaRootPackageName + allowedVertexClass.getQualifiedName());
        code.setVariable("definingVertexClassName", this.schemaRootPackageName + definingVertexClass.getQualifiedName());
        if (incClass.getMax() == 1) {
            if (!createClass) {
                code.add("/**", " * @return the vertex to this one with the rolename '#rolename#' ", " *         (connected with a <code>#edgeClassName#</code> edge), or null if no such vertex exists", " */", "public #vertexClassName# get_#rolename#();");
            } else {
                code.add("@Override", "public #vertexClassName# get_#rolename#() {", "\t#edgeClassName# edge = (#edgeClassName#) getFirstIncidence(#edgeClassName#.EC, #dir#);", "\tif (edge != null) {", "\t\treturn (#vertexClassName#) edge.getThat();", "\t}", "\treturn null;", "}");
            }
        } else if (!createClass) {
            code.add("/**", " * @return an Iterable of all vertices adjacent to this one with the rolename '#rolename#'", " *         (connected with a <code>#edgeClassName#</code> edge).", " */", "public <V extends #definingVertexClassName#> Iterable<V> get_#rolename#();", "", "public <V extends #definingVertexClassName#> Iterable<V> get_#rolename#(#jgPackage#.VertexFilter<V> filter);");
        } else {
            code.add("@Override", "public <V extends #definingVertexClassName#> Iterable<V> get_#rolename#() {", "\treturn new de.uni_koblenz.jgralab.impl.NeighbourIterable<#edgeClassName#, V>(this, #edgeClassName#.EC, #dir#, null);", "}", "", "@Override", "public <V extends #definingVertexClassName#> Iterable<V> get_#rolename#(#jgPackage#.VertexFilter<V> filter) {", "\treturn new de.uni_koblenz.jgralab.impl.NeighbourIterable<#edgeClassName#, V>(this, #edgeClassName#.EC, #dir#, filter);", "}");
        }
        return code;
    }

    private CodeBlock createAddRolenameSnippet(String rolename, EdgeClass edgeClass, VertexClass definingVertexClass, VertexClass allowedVertexClass, EdgeDirection dir, boolean createClass) {
        CodeSnippet code = new CodeSnippet();
        code.setVariable("rolename", rolename);
        code.setVariable("edgeClassName", this.schemaRootPackageName + edgeClass.getQualifiedName());
        code.setVariable("edgeClass", "#edgeClassName#.EC");
        code.setVariable("graphClassName", this.schemaRootPackageName + edgeClass.getGraphClass().getQualifiedName());
        code.setVariable("definingVertexClassName", this.schemaRootPackageName + definingVertexClass.getQualifiedName());
        code.setVariable("allowedVertexClassName", this.schemaRootPackageName + allowedVertexClass.getQualifiedName());
        code.setVariable("thisVertexClassName", this.schemaRootPackageName + this.vertexClass.getQualifiedName());
        if (dir == EdgeDirection.OUT) {
            code.setVariable("alpha", "this");
            code.setVariable("alphaVertexClassName", this.schemaRootPackageName + this.vertexClass.getQualifiedName());
            code.setVariable("omega", "vertex");
            code.setVariable("omegaVertexClassName", this.schemaRootPackageName + allowedVertexClass.getQualifiedName());
        } else {
            code.setVariable("alpha", "vertex");
            code.setVariable("alphaVertexClassName", this.schemaRootPackageName + allowedVertexClass.getQualifiedName());
            code.setVariable("omega", "this");
            code.setVariable("omegaVertexClassName", this.schemaRootPackageName + this.vertexClass.getQualifiedName());
        }
        if (!createClass) {
            code.add("/**", " * adds the given vertex as <code>#rolename#</code> to this vertex, i.e. creates an", " * <code>#edgeClassName#</code> edge from this vertex to the given ", " * one and returns the created edge.", " * @return  a newly created edge of type <code>#edgeClassName#</code>", " *          between this vertex and the given one.", " */", "public #edgeClassName# add_#rolename#(#definingVertexClassName# vertex);");
        } else {
            code.add("@Override", "public #edgeClassName# add_#rolename#(#definingVertexClassName# vertex) {");
            code.add("\treturn ((#graphClassName#)getGraph()).createEdge(#edgeClass#, (#alphaVertexClassName#) #alpha#, (#omegaVertexClassName#) #omega#);", "}");
        }
        return code;
    }

    public CodeBlock createRolenameMethods(boolean createClass) {
        CodeList list = new CodeList();
        HashSet<IncidenceClass> validFarICs = new HashSet<IncidenceClass>();
        validFarICs.addAll(this.vertexClass.getValidFromFarIncidenceClasses());
        validFarICs.addAll(this.vertexClass.getValidToFarIncidenceClasses());
        for (IncidenceClass ic : validFarICs) {
            list.add(this.createMethodsForOneIncidenceClass(ic, ic, createClass));
        }
        return list;
    }

    private CodeList createMethodsForOneIncidenceClass(IncidenceClass allowedIncidenceClass, IncidenceClass definingIncidenceClass, boolean createClass) {
        CodeList list = new CodeList();
        String rolename = definingIncidenceClass.getRolename();
        if (!rolename.isEmpty()) {
            EdgeClass ec = allowedIncidenceClass.getEdgeClass();
            VertexClass vc = definingIncidenceClass.getVertexClass();
            VertexClass allowedVC = allowedIncidenceClass.getVertexClass();
            EdgeDirection dir = allowedIncidenceClass.getDirection() == IncidenceDirection.OUT ? EdgeDirection.IN : EdgeDirection.OUT;
            list.addNoIndent(this.createAddRolenameSnippet(rolename, ec, vc, allowedVC, dir, createClass));
            list.addNoIndent(this.createRemoveAllAdjacencesSnippet(rolename, ec, allowedVC, dir, createClass));
            list.addNoIndent(this.createRemoveAdjacenceSnippet(rolename, ec, vc, dir, createClass));
            list.addNoIndent(this.createGetAdjacencesSnippet(definingIncidenceClass, allowedVC, vc, dir, createClass));
        }
        return list;
    }
}

