/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.codegenerator;

import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.CompositeDomain;
import de.uni_koblenz.jgralab.schema.Constraint;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.EnumDomain;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.ListDomain;
import de.uni_koblenz.jgralab.schema.MapDomain;
import de.uni_koblenz.jgralab.schema.NamedElement;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.SetDomain;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import java.util.List;
import java.util.Stack;

public class SchemaCodeGenerator
extends CodeGenerator {
    private final Schema schema;

    public SchemaCodeGenerator(Schema schema, String schemaPackageName, CodeGeneratorConfiguration config) {
        super(schemaPackageName, "", config);
        this.schema = schema;
        this.rootBlock.setVariable("simpleClassName", schema.getName());
        this.rootBlock.setVariable("baseClassName", "SchemaImpl");
        this.rootBlock.setVariable("isClassOnly", "true");
        this.rootBlock.setVariable("gcName", schema.getGraphClass().getQualifiedName());
        this.rootBlock.setVariable("gcCamelName", SchemaCodeGenerator.camelCase(schema.getGraphClass().getQualifiedName()));
        this.rootBlock.setVariable("gcImplName", schema.getGraphClass().getQualifiedName() + "Impl");
    }

    @Override
    protected CodeBlock createHeader() {
        this.addImports("#jgSchemaImplPackage#.#baseClassName#");
        this.addImports("#jgSchemaPackage#.VertexClass");
        this.addImports("#jgSchemaPackage#.EdgeClass");
        this.addImports("java.lang.ref.WeakReference");
        CodeSnippet code = new CodeSnippet(true, "/**", " * The schema #simpleClassName# is implemented following the singleton pattern.", " * To get the instance, use the static method <code>instance()</code>.", " */", "public class #simpleClassName# extends #baseClassName# {");
        return code;
    }

    @Override
    protected CodeBlock createBody() {
        CodeList code = new CodeList();
        if (this.currentCycle.isClassOnly()) {
            code.add(this.createConstructor());
            code.add(this.createGetDefaultGraphFactoryMethod());
            code.add(this.createGraphFactoryMethods());
            code.add(this.createReopenMethod());
        }
        return code;
    }

    private CodeBlock createGetDefaultGraphFactoryMethod() {
        CodeList code = new CodeList();
        code.addNoIndent(new CodeSnippet(true, "@Override", "public #jgPackage#.GraphFactory createDefaultGraphFactory(#jgPackage#.ImplementationType implementationType) {"));
        code.add(new CodeSnippet("switch(implementationType) {"));
        code.add(new CodeSnippet("\tcase GENERIC:", "\t\treturn new #jgImplPackage#.generic.GenericGraphFactoryImpl(this);"));
        code.add(new CodeSnippet("\tcase STANDARD:", "\t\treturn new #schemaImplStdPackage#.#gcCamelName#FactoryImpl();"));
        code.add(new CodeSnippet("}", "throw new UnsupportedOperationException(\"No \" + implementationType + \" support compiled.\");"));
        code.addNoIndent(new CodeSnippet("}"));
        return code;
    }

    private CodeBlock createGraphFactoryMethods() {
        this.addImports("#jgPackage#.GraphIO", "#jgPackage#.exception.GraphIOException");
        CodeList code = new CodeList();
        code.addNoIndent(new CodeSnippet(true, "/**", " * Creates a new #gcName# graph.", "*/", "public #gcName# create#gcCamelName#(#jgPackage#.ImplementationType implType) {", "\treturn create#gcCamelName#(implType, null, 100, 100);", "}"));
        code.addNoIndent(new CodeSnippet(true, "/**", " * Creates a new #gcName# graph with initial vertex and edge counts <code>vMax</code>, <code>eMax</code>.", " *", " * @param vMax initial vertex count", " * @param eMax initial edge count", "*/", "public #gcName# create#gcCamelName#(#jgPackage#.ImplementationType implType, String id, int vMax, int eMax) {", "\t#jgPackage#.GraphFactory factory = createDefaultGraphFactory(implType);", "\treturn factory.createGraph(getGraphClass(), id, vMax, eMax);", "}"));
        code.addNoIndent(new CodeSnippet(true, "/**", " * Creates a new #gcName# graph.", "*/", "public #gcName# create#gcCamelName#(#jgPackage#.GraphFactory factory) {", "\treturn factory.createGraph(getGraphClass(), null, 100, 100);", "}"));
        code.addNoIndent(new CodeSnippet(true, "/**", " * Creates a new #gcName# graph.", "*/", "public #gcName# create#gcCamelName#(#jgPackage#.GraphFactory factory, String id, int vMax, int eMax) {", "\treturn factory.createGraph(getGraphClass(), id, vMax, eMax);", "}"));
        code.addNoIndent(new CodeSnippet(true, "public #gcName# load#gcCamelName#(String filename) throws GraphIOException {", "\t#jgPackage#.GraphFactory factory = createDefaultGraphFactory(#jgPackage#.ImplementationType.STANDARD);", "\treturn load#gcCamelName#(filename, factory, null);", "}"));
        code.addNoIndent(new CodeSnippet(true, "public #gcName# load#gcCamelName#(String filename, #jgPackage#.ProgressFunction pf) throws GraphIOException {", "\t#jgPackage#.GraphFactory factory = createDefaultGraphFactory(#jgPackage#.ImplementationType.STANDARD);", "\treturn load#gcCamelName#(filename, factory, pf);", "}"));
        code.addNoIndent(new CodeSnippet(true, "public #gcName# load#gcCamelName#(String filename, #jgPackage#.ImplementationType implType) throws GraphIOException {", "\t#jgPackage#.GraphFactory factory = createDefaultGraphFactory(implType);", "\treturn load#gcCamelName#(filename, factory, null);", "}"));
        code.addNoIndent(new CodeSnippet(true, "", "public #gcName# load#gcCamelName#(String filename, #jgPackage#.ImplementationType implType, #jgPackage#.ProgressFunction pf) throws GraphIOException {", "\t#jgPackage#.GraphFactory factory = createDefaultGraphFactory(implType);", "\treturn load#gcCamelName#(filename, factory, pf);", "}"));
        code.addNoIndent(new CodeSnippet(true, "public #gcName# load#gcCamelName#(String filename, #jgPackage#.GraphFactory factory) throws GraphIOException {", "\treturn GraphIO.loadGraphFromFile(filename, factory, null);", "}"));
        code.addNoIndent(new CodeSnippet(true, "public #gcName# load#gcCamelName#(String filename, #jgPackage#.GraphFactory factory, #jgPackage#.ProgressFunction pf) throws GraphIOException {", "\treturn GraphIO.loadGraphFromFile(filename, factory, pf);", "}"));
        return code;
    }

    private CodeBlock createConstructor() {
        CodeList code = new CodeList();
        code.addNoIndent(new CodeSnippet(true, "/**", " * reference to the singleton instance", " */", "static WeakReference<#simpleClassName#> theInstance = new WeakReference<#simpleClassName#>(null);", "", "/**", " * @return the singleton instance of #simpleClassName#", " */", "public static synchronized #simpleClassName# instance() {", "\t#simpleClassName# s = theInstance.get();", "\tif (s != null) {", "\t\treturn s;", "\t}", "\ts = new #simpleClassName#();", "\ttheInstance = new WeakReference<#simpleClassName#>(s);", "\treturn s;", "}", "", "/**", " * Creates a #simpleClassName# and builds its schema classes.", " * This constructor is private. Use the <code>instance()</code> method", " * to access the schema.", " */", "private #simpleClassName#() {", "\tsuper(\"#simpleClassName#\", \"#schemaPackage#\");"));
        code.add(this.createEnumDomains());
        code.add(this.createCompositeDomains());
        code.add(this.createGraphClass());
        code.add(this.createPackageComments());
        code.addNoIndent(new CodeSnippet(true, "\tfinish();", "}"));
        return code;
    }

    private CodeBlock createPackageComments() {
        CodeList code = new CodeList();
        Package pkg = this.schema.getDefaultPackage();
        Stack<Package> s = new Stack<Package>();
        s.push(pkg);
        boolean hasComment = false;
        while (!s.isEmpty()) {
            pkg = (Package)s.pop();
            for (Package sub : pkg.getSubPackages()) {
                s.push(sub);
            }
            List<String> comments = pkg.getComments();
            if (comments.isEmpty()) continue;
            if (!hasComment) {
                code.addNoIndent(new CodeSnippet(true, "{"));
                hasComment = true;
            }
            for (String comment : comments) {
                code.add(new CodeSnippet("getPackage(\"" + pkg.getQualifiedName() + "\").addComment(\"" + SchemaCodeGenerator.stringQuote(comment) + "\");"));
            }
        }
        if (hasComment) {
            code.addNoIndent(new CodeSnippet(false, "}"));
        }
        return code;
    }

    private CodeBlock createGraphClass() {
        GraphClass gc = this.schema.getGraphClass();
        CodeList code = new CodeList();
        this.addImports("#jgSchemaPackage#.GraphClass");
        code.setVariable("gcVariable", "gc");
        code.setVariable("aecVariable", "gc");
        code.setVariable("gcAbstract", gc.isAbstract() ? "true" : "false");
        code.addNoIndent(new CodeSnippet(true, "{", "\tGraphClass #gcVariable# = createGraphClass(\"#gcName#\");"));
        code.addNoIndent(this.createAttributes(gc));
        code.addNoIndent(this.createConstraints(gc));
        code.addNoIndent(this.createComments("gc", gc));
        code.addNoIndent(this.createVertexClasses(gc));
        code.addNoIndent(this.createEdgeClasses(gc));
        code.addNoIndent(new CodeSnippet(false, "}"));
        return code;
    }

    private CodeBlock createComments(String variableName, NamedElement ne) {
        CodeList code = new CodeList();
        code.setVariable("namedElement", variableName);
        for (String comment : ne.getComments()) {
            code.addNoIndent(new CodeSnippet("#namedElement#.addComment(" + GraphIO.toUtfString(comment) + ");"));
        }
        return code;
    }

    private CodeBlock createEdgeClasses(GraphClass gc) {
        CodeList code = new CodeList();
        for (EdgeClass ec : this.schema.getGraphClass().getEdgeClasses()) {
            code.addNoIndent(this.createEdgeClass(ec));
        }
        return code;
    }

    private CodeBlock createEdgeClass(EdgeClass ec) {
        CodeList code = new CodeList();
        this.addImports("#jgSchemaPackage#.EdgeClass");
        code.setVariable("ecType", "EdgeClass");
        code.setVariable("ecName", ec.getQualifiedName());
        code.setVariable("aecVariable", this.gecVarName(ec));
        code.setVariable("ecAbstract", ec.isAbstract() ? "true" : "false");
        code.setVariable("fromClass", this.gecVarName(ec.getFrom().getVertexClass()));
        code.setVariable("fromRole", ec.getFrom().getRolename());
        code.setVariable("toClass", this.gecVarName(ec.getTo().getVertexClass()));
        code.setVariable("toRole", ec.getTo().getRolename());
        code.setVariable("toAggregation", AggregationKind.class.getCanonicalName() + "." + ec.getTo().getAggregationKind().toString());
        code.setVariable("fromAggregation", AggregationKind.class.getCanonicalName() + "." + ec.getFrom().getAggregationKind().toString());
        code.setVariable("fromPart", "#fromClass#, " + ec.getFrom().getMin() + ", " + ec.getFrom().getMax() + ", \"#fromRole#\"" + ", #fromAggregation#");
        code.setVariable("toPart", "#toClass#, " + ec.getTo().getMin() + ", " + ec.getTo().getMax() + ", \"#toRole#\"" + ", #toAggregation#");
        code.addNoIndent(new CodeSnippet(true, "\t#ecType# #aecVariable# = #gcVariable#.create#ecType#(\"#ecName#\",", "\t\t#fromPart#,", "\t\t#toPart#);", "\t#aecVariable#.setAbstract(#ecAbstract#);"));
        for (EdgeClass superClass : ec.getDirectSuperClasses()) {
            CodeSnippet s = new CodeSnippet("#aecVariable#.addSuperClass(#superClassName#);");
            s.setVariable("superClassName", this.gecVarName(superClass));
            code.add(s);
        }
        code.add(this.createAttributes(ec));
        code.add(this.createConstraints(ec));
        code.add(this.createComments(this.gecVarName(ec), ec));
        return code;
    }

    private CodeBlock createVertexClasses(GraphClass gc) {
        CodeList code = new CodeList();
        for (VertexClass vc : this.schema.getGraphClass().getVertexClasses()) {
            code.addNoIndent(this.createVertexClass(vc));
        }
        return code;
    }

    private String gecVarName(GraphElementClass<?, ?> gec) {
        StringBuilder sb = new StringBuilder();
        if (gec instanceof VertexClass) {
            sb.append("vc_");
        } else {
            sb.append("ec_");
        }
        sb.append(gec.getUniqueName());
        return sb.toString();
    }

    private CodeBlock createVertexClass(VertexClass vc) {
        CodeList code = new CodeList();
        code.setVariable("vcName", vc.getQualifiedName());
        code.setVariable("aecVariable", this.gecVarName(vc));
        code.setVariable("vcAbstract", vc.isAbstract() ? "true" : "false");
        code.addNoIndent(new CodeSnippet(true, "\tVertexClass #aecVariable# = #gcVariable#.createVertexClass(\"#vcName#\");", "\t#aecVariable#.setAbstract(#vcAbstract#);"));
        for (VertexClass superClass : vc.getDirectSuperClasses()) {
            CodeSnippet s = new CodeSnippet("#aecVariable#.addSuperClass(#superClassName#);");
            s.setVariable("superClassName", this.gecVarName(superClass));
            code.add(s);
        }
        code.add(this.createAttributes(vc));
        code.add(this.createConstraints(vc));
        code.add(this.createComments(this.gecVarName(vc), vc));
        return code;
    }

    private CodeBlock createAttributes(AttributedElementClass<?, ?> aec) {
        CodeList code = new CodeList();
        List<Attribute> attributes = aec instanceof GraphElementClass ? ((GraphElementClass)aec).getOwnAttributeList() : aec.getAttributeList();
        for (Attribute attr : attributes) {
            CodeSnippet s = new CodeSnippet(false, "#aecVariable#.createAttribute(\"#attrName#\", getDomain(\"#domainName#\"), #defaultValue#);");
            s.setVariable("attrName", attr.getName());
            s.setVariable("domainName", attr.getDomain().getQualifiedName());
            s.setVariable("aecName", aec.getQualifiedName());
            if (attr.getDefaultValueAsString() == null) {
                s.setVariable("defaultValue", "null");
            } else {
                String defaultValue = attr.getDefaultValueAsString().replaceAll("([\\\"])", "\\\\$1");
                defaultValue = defaultValue.replaceAll("#", "\\u0023");
                s.setVariable("defaultValue", "\"" + defaultValue + "\"");
            }
            code.addNoIndent(s);
        }
        return code;
    }

    private CodeBlock createConstraints(AttributedElementClass<?, ?> aec) {
        CodeList code = new CodeList();
        for (Constraint constraint : aec.getConstraints()) {
            this.addImports("#jgSchemaImplPackage#.ConstraintImpl");
            CodeSnippet constraintSnippet = new CodeSnippet(false, new String[0]);
            constraintSnippet.add("#aecVariable#.addConstraint(new ConstraintImpl(#message#, #predicate#, #offendingElements#));");
            constraintSnippet.setVariable("message", "\"" + SchemaCodeGenerator.stringQuote(constraint.getMessage()) + "\"");
            constraintSnippet.setVariable("predicate", "\"" + SchemaCodeGenerator.stringQuote(constraint.getPredicate()) + "\"");
            if (constraint.getOffendingElementsQuery() != null) {
                constraintSnippet.setVariable("offendingElements", "\"" + SchemaCodeGenerator.stringQuote(constraint.getOffendingElementsQuery()) + "\"");
            } else {
                constraintSnippet.setVariable("offendingElements", "null");
            }
            code.addNoIndent(constraintSnippet);
        }
        return code;
    }

    private CodeBlock createEnumDomains() {
        CodeList code = new CodeList();
        for (EnumDomain dom : this.schema.getEnumDomains()) {
            CodeSnippet s = new CodeSnippet(true, new String[0]);
            s.setVariable("domName", dom.getQualifiedName());
            code.addNoIndent(s);
            this.addImports("#jgSchemaPackage#.EnumDomain");
            s.add("{", "\tEnumDomain dom = createEnumDomain(\"#domName#\");");
            for (String c : dom.getConsts()) {
                s.add("\tdom.addConst(\"" + c + "\");");
            }
            code.add(this.createComments("dom", dom));
            code.addNoIndent(new CodeSnippet("}"));
        }
        return code;
    }

    private CodeBlock createCompositeDomains() {
        CodeList code = new CodeList();
        for (CompositeDomain dom : this.schema.getCompositeDomains()) {
            CodeSnippet s = new CodeSnippet(true, new String[0]);
            s.setVariable("domName", dom.getQualifiedName());
            code.addNoIndent(s);
            if (dom instanceof ListDomain) {
                s.setVariable("componentDomainName", ((ListDomain)dom).getBaseDomain().getQualifiedName());
                s.add("createListDomain(getDomain(\"#componentDomainName#\"));");
                continue;
            }
            if (dom instanceof SetDomain) {
                s.setVariable("componentDomainName", ((SetDomain)dom).getBaseDomain().getQualifiedName());
                s.add("createSetDomain(getDomain(\"#componentDomainName#\"));");
                continue;
            }
            if (dom instanceof MapDomain) {
                MapDomain mapDom = (MapDomain)dom;
                s.setVariable("keyDomainName", mapDom.getKeyDomain().getQualifiedName());
                s.setVariable("valueDomainName", mapDom.getValueDomain().getQualifiedName());
                s.add("createMapDomain(getDomain(\"#keyDomainName#\"), getDomain(\"#valueDomainName#\"));");
                continue;
            }
            if (dom instanceof RecordDomain) {
                this.addImports("#jgSchemaPackage#.RecordDomain");
                s.add("{", "\tRecordDomain dom = createRecordDomain(\"#domName#\");");
                RecordDomain rd = (RecordDomain)dom;
                for (RecordDomain.RecordComponent c : rd.getComponents()) {
                    s.add("\tdom.addComponent(\"" + c.getName() + "\", getDomain(\"" + c.getDomain().getQualifiedName() + "\"));");
                }
                code.add(this.createComments("dom", rd));
                code.addNoIndent(new CodeSnippet("}"));
                continue;
            }
            throw new RuntimeException("FIXME!");
        }
        return code;
    }

    private CodeBlock createReopenMethod() {
        CodeSnippet s = new CodeSnippet();
        s.add("", "@Override", "public boolean reopen() {", "\tthrow new UnsupportedOperationException(\"Cannot reopen a compiled Schema.\");", "}");
        return s;
    }
}

