/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.codegenerator;

import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.codegenerator.AttributedElementCodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import de.uni_koblenz.jgralab.schema.codegenerator.RolenameCodeGenerator;
import java.util.HashSet;
import java.util.TreeSet;

public class VertexCodeGenerator
extends AttributedElementCodeGenerator<VertexClass, Vertex> {
    private RolenameCodeGenerator rolenameGenerator;

    public VertexCodeGenerator(VertexClass vertexClass, String schemaPackageName, CodeGeneratorConfiguration config) {
        super(vertexClass, schemaPackageName, config);
        this.rootBlock.setVariable("graphElementClass", "Vertex");
        this.rootBlock.setVariable("schemaElementClass", "VertexClass");
        this.rolenameGenerator = new RolenameCodeGenerator((VertexClass)this.aec);
        for (VertexClass superClass : vertexClass.getDirectSuperClasses().plus(vertexClass.getGraphClass().getDefaultVertexClass())) {
            this.interfaces.add(superClass.getQualifiedName());
        }
    }

    @Override
    protected String getSchemaTypeName() {
        return "VertexClass";
    }

    @Override
    protected CodeBlock createHeader() {
        return super.createHeader();
    }

    @Override
    protected CodeBlock createBody() {
        CodeList code = (CodeList)super.createBody();
        if (this.currentCycle.isStdImpl()) {
            if (this.currentCycle.isStdImpl()) {
                this.addImports("#jgImplStdPackage#.#baseClassName#");
            }
            this.rootBlock.setVariable("baseClassName", "VertexImpl");
        }
        if (this.config.hasTypeSpecificMethodsSupport() && !this.currentCycle.isClassOnly()) {
            code.add(this.createNextVertexMethods());
            code.add(this.createFirstIncidenceMethods());
            code.add(this.rolenameGenerator.createRolenameMethods(this.currentCycle.isStdImpl()));
            code.add(this.createIncidenceIteratorMethods());
        }
        return code;
    }

    private CodeBlock createFirstIncidenceMethods() {
        CodeList code = new CodeList();
        VertexClass vc = (VertexClass)this.aec;
        HashSet<EdgeClass> edgeClassSet = new HashSet<EdgeClass>();
        if (this.currentCycle.isStdImpl()) {
            edgeClassSet.addAll(vc.getConnectedEdgeClasses());
        }
        if (this.currentCycle.isAbstract()) {
            edgeClassSet.addAll(vc.getOwnConnectedEdgeClasses());
            if (vc.getAllSuperClasses().size() == 1) {
                for (EdgeClass ec : vc.getConnectedEdgeClasses()) {
                    VertexClass dvc = vc.getGraphClass().getDefaultVertexClass();
                    if (ec.getTo().getVertexClass() != dvc && ec.getFrom().getVertexClass() != dvc) continue;
                    edgeClassSet.add(ec);
                }
            }
        }
        for (EdgeClass ec : edgeClassSet) {
            this.addImports("#jgPackage#.EdgeDirection");
            if (!this.config.hasTypeSpecificMethodsSupport()) continue;
            code.addNoIndent(this.createFirstIncidenceMethod(ec, false));
            code.addNoIndent(this.createFirstIncidenceMethod(ec, true));
        }
        return code;
    }

    private CodeBlock createFirstIncidenceMethod(EdgeClass ec, boolean withOrientation) {
        CodeSnippet code = new CodeSnippet(true, new String[0]);
        code.setVariable("ecQualifiedName", this.absoluteName(ec));
        code.setVariable("ecCamelName", VertexCodeGenerator.camelCase(ec.getUniqueName()));
        code.setVariable("formalParams", withOrientation ? "EdgeDirection orientation" : "");
        code.setVariable("actualParams", withOrientation ? ", orientation" : "");
        if (this.currentCycle.isAbstract()) {
            code.add("/**", " * @return the first edge of class #ecCamelName# at this vertex");
            if (withOrientation) {
                code.add(" * @param orientation the orientation of the edge");
            }
            code.add(" */", "public #ecQualifiedName# getFirst#ecCamelName#Incidence(#formalParams#);");
        }
        if (this.currentCycle.isStdImpl()) {
            code.add("@Override", "public #ecQualifiedName# getFirst#ecCamelName#Incidence(#formalParams#) {", "\treturn (#ecQualifiedName#)getFirstIncidence(#ecQualifiedName#.EC#actualParams#);", "}");
        }
        return code;
    }

    private CodeBlock createNextVertexMethods() {
        CodeList code = new CodeList();
        TreeSet<Object> superClasses = new TreeSet<Object>();
        superClasses.addAll(((VertexClass)this.aec).getAllSuperClasses());
        superClasses.add(this.aec);
        if (this.config.hasTypeSpecificMethodsSupport()) {
            for (GraphElementClass graphElementClass : superClasses) {
                VertexClass vc = (VertexClass)graphElementClass;
                code.addNoIndent(this.createNextVertexMethod(vc));
            }
        }
        return code;
    }

    private CodeBlock createNextVertexMethod(VertexClass vc) {
        CodeSnippet code = new CodeSnippet(true, new String[0]);
        code.setVariable("vcQualifiedName", this.absoluteName(vc));
        code.setVariable("vcCamelName", VertexCodeGenerator.camelCase(vc.getUniqueName()));
        code.setVariable("formalParams", "");
        code.setVariable("actualParams", "");
        if (this.currentCycle.isAbstract()) {
            code.add("/**", " * @return the next #vcQualifiedName# vertex in the global vertex sequence");
            code.add(" */", "public #vcQualifiedName# getNext#vcCamelName#(#formalParams#);");
        }
        if (this.currentCycle.isStdImpl()) {
            code.add("@Override", "public #vcQualifiedName# getNext#vcCamelName#(#formalParams#) {", "\treturn (#vcQualifiedName#)getNextVertex(#vcQualifiedName#.VC#actualParams#);", "}");
        }
        return code;
    }

    private CodeBlock createIncidenceIteratorMethods() {
        VertexClass vc = (VertexClass)this.aec;
        CodeList code = new CodeList();
        HashSet<EdgeClass> edgeClassSet = new HashSet<EdgeClass>();
        if (this.currentCycle.isStdImpl()) {
            edgeClassSet.addAll(vc.getConnectedEdgeClasses());
        }
        if (this.currentCycle.isAbstract()) {
            edgeClassSet.addAll(vc.getOwnConnectedEdgeClasses());
            if (vc.getAllSuperClasses().size() == 1) {
                for (EdgeClass ec : vc.getConnectedEdgeClasses()) {
                    VertexClass dvc = vc.getGraphClass().getDefaultVertexClass();
                    if (ec.getTo().getVertexClass() != dvc && ec.getFrom().getVertexClass() != dvc) continue;
                    edgeClassSet.add(ec);
                }
            }
        }
        for (EdgeClass ec : edgeClassSet) {
            if (this.currentCycle.isStdImpl()) {
                this.addImports("#jgImplPackage#.IncidenceIterable");
            }
            CodeSnippet s = new CodeSnippet(true, new String[0]);
            code.addNoIndent(s);
            String targetClassName = this.schemaRootPackageName + "." + ec.getQualifiedName();
            s.setVariable("edgeClassSimpleName", ec.getSimpleName());
            s.setVariable("edgeClassQualifiedName", targetClassName);
            s.setVariable("edgeClassUniqueName", ec.getUniqueName());
            if (this.currentCycle.isAbstract()) {
                s.add("/**");
                s.add(" * Returns an Iterable for all incidence edges of this vertex that are of type #edgeClassSimpleName# or subtypes.");
                s.add(" */");
                s.add("public Iterable<#edgeClassQualifiedName#> get#edgeClassUniqueName#Incidences();");
            }
            if (this.currentCycle.isStdImpl()) {
                s.add("@Override");
                s.add("public Iterable<#edgeClassQualifiedName#> get#edgeClassUniqueName#Incidences() {");
                s.add("\treturn new IncidenceIterable<#edgeClassQualifiedName#>(this, #edgeClassQualifiedName#.EC);");
                s.add("}");
            }
            s.add("");
            if (this.currentCycle.isAbstract()) {
                s.add("/**");
                s.add(" * Returns an Iterable for all incidence edges of this vertex that are of type #edgeClassSimpleName#.");
                s.add(" * @param direction EdgeDirection.IN or EdgeDirection.OUT, only edges of this direction will be included in the Iterable");
                s.add(" */");
                s.add("public Iterable<#edgeClassQualifiedName#> get#edgeClassUniqueName#Incidences(EdgeDirection direction);");
            }
            if (!this.currentCycle.isStdImpl()) continue;
            s.add("@Override");
            s.add("public Iterable<#edgeClassQualifiedName#> get#edgeClassUniqueName#Incidences(EdgeDirection direction) {");
            s.add("\treturn new IncidenceIterable<#edgeClassQualifiedName#>(this, #edgeClassQualifiedName#.EC, direction);");
            s.add("}");
        }
        return code;
    }

    @Override
    protected CodeBlock createAttributedElementClassConstant() {
        CodeSnippet s = new CodeSnippet(true, "public static final #jgSchemaPackage#.#schemaElementClass# VC = #schemaPackageName#.#schemaName#.instance().getGraphClass().getVertexClass(\"#vcQualifiedName#\");");
        s.setVariable("vcQualifiedName", ((VertexClass)this.aec).getQualifiedName());
        return s;
    }

    @Override
    protected CodeBlock createGetAttributedElementClassMethod() {
        return new CodeSnippet(true, "@Override", "public final #jgSchemaPackage#.#schemaElementClass# getAttributedElementClass() {", "\treturn #javaClassName#.VC;", "}");
    }
}

