/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.AttributedElementClassImpl;
import de.uni_koblenz.jgralab.schema.impl.DomainImpl;
import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;
import java.util.regex.Pattern;

public class AttributeImpl
implements Attribute,
Comparable<Attribute> {
    private static final Pattern ATTRIBUTE_NAME_PATTERN = Pattern.compile("\\p{Lower}\\w*");
    private String name;
    private final Domain domain;
    private final AttributedElementClass<?, ?> aec;
    private final String sortKey;
    private String defaultValueAsString;
    private Object defaultValue;
    private Object defaultTransactionValue;
    private boolean defaultTransactionValueComputed;
    private boolean defaultValueComputed;

    AttributeImpl(String name, Domain domain, AttributedElementClass<?, ?> aec, String defaultValue) {
        if (!ATTRIBUTE_NAME_PATTERN.matcher(name).matches()) {
            throw new SchemaException("Invalid attribute name '" + name + "'.");
        }
        this.name = name;
        this.domain = domain;
        this.aec = aec;
        this.sortKey = name + ":" + domain.getQualifiedName();
        this.setDefaultValueAsString(defaultValue);
        DomainImpl d = (DomainImpl)this.domain;
        d.registerAttribute(this);
    }

    @Override
    public String toString() {
        return "Attribute " + this.sortKey;
    }

    @Override
    public Domain getDomain() {
        return this.domain;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AttributedElementClass<?, ?> getAttributedElementClass() {
        return this.aec;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return this.sortKey.hashCode() + this.aec.hashCode();
    }

    @Override
    public int compareTo(Attribute o) {
        int i = this.sortKey.compareTo(o.getSortKey());
        if (i != 0) {
            return i;
        }
        return this.aec.compareTo(o.getAttributedElementClass());
    }

    @Override
    public String getSortKey() {
        return this.sortKey;
    }

    @Override
    public String getDefaultValueAsString() {
        return this.defaultValueAsString;
    }

    @Override
    public void setDefaultValueAsString(String defaultValue) throws SchemaException {
        if (this.defaultValueAsString != null) {
            throw new SchemaException("Cannot assign a new default value to Attribute " + this.name + " of " + this.aec.getQualifiedName() + ".");
        }
        this.defaultValueAsString = defaultValue;
    }

    @Override
    public void setDefaultTransactionValue(AttributedElement<?, ?> element) throws GraphIOException {
        if (this.defaultValueAsString != null) {
            if (this.defaultTransactionValueComputed) {
                element.setAttribute(this.name, this.defaultTransactionValue);
            } else {
                if (this.defaultValueAsString != null) {
                    element.readAttributeValueFromString(this.name, this.defaultValueAsString);
                }
                this.defaultTransactionValue = element.getAttribute(this.name);
                this.defaultTransactionValueComputed = true;
            }
        }
    }

    @Override
    public void setDefaultValue(AttributedElement<?, ?> element) throws GraphIOException {
        if (this.defaultValueComputed) {
            element.setAttribute(this.name, this.defaultValue);
        } else {
            if (this.defaultValueAsString != null) {
                element.readAttributeValueFromString(this.name, this.defaultValueAsString);
            }
            this.defaultValue = element.getAttribute(this.name);
            this.defaultValueComputed = true;
        }
    }

    @Override
    public void delete() {
        ((SchemaImpl)this.aec.getSchema()).assertNotFinished();
        ((AttributedElementClassImpl)this.aec).deleteAttribute(this);
        DomainImpl d = (DomainImpl)this.domain;
        d.attributes = d.attributes.minus(this);
    }

    @Override
    public void setName(String newName) {
        ((SchemaImpl)this.aec.getSchema()).assertNotFinished();
        if (!ATTRIBUTE_NAME_PATTERN.matcher(newName).matches()) {
            throw new SchemaException("Invalid attribute name '" + newName + "'.");
        }
        this.name = newName;
    }
}

