/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.schema.exception.CycleException;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.DirectedGraph;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.pcollections.ArrayPSet;
import org.pcollections.ArrayPVector;
import org.pcollections.PSet;
import org.pcollections.PVector;

public class DirectedAcyclicGraph<T>
extends DirectedGraph<T> {
    private PVector<T> topologicalOrder = ArrayPVector.empty();
    private HashMap<T, PSet<T>> cachedPredecessors;
    private HashMap<T, PSet<T>> cachedSuccessors;
    private boolean transitive;

    public DirectedAcyclicGraph() {
        this(false);
    }

    public DirectedAcyclicGraph(boolean transitive) {
        this.transitive = transitive;
    }

    protected boolean computeTopologicalOrder() {
        LinkedList<DirectedGraph.Node> q = new LinkedList<DirectedGraph.Node>();
        for (DirectedGraph.Node n : this.nodes) {
            n.mark = n.predecessors.size();
            if (n.mark != 0) continue;
            q.offer(n);
        }
        this.topologicalOrder = ArrayPVector.empty();
        while (!q.isEmpty()) {
            DirectedGraph.Node n = (DirectedGraph.Node)q.poll();
            this.topologicalOrder = this.topologicalOrder.plus(n.data);
            for (Object c : n.successors) {
                DirectedGraph.Node o = (DirectedGraph.Node)this.entries.get(c);
                --o.mark;
                if (o.mark != 0) continue;
                q.offer(o);
            }
        }
        assert (this.topologicalOrder.size() <= this.nodes.size());
        return this.topologicalOrder.size() == this.nodes.size();
    }

    @Override
    public T createNode(T data) {
        super.createNode(data);
        this.computeTopologicalOrder();
        return data;
    }

    @Override
    public void finish() {
        if (this.finished) {
            return;
        }
        this.cachedPredecessors = new HashMap();
        this.cachedSuccessors = new HashMap();
        for (DirectedGraph.Node n : this.nodes) {
            this.cachedPredecessors.put(n.data, this.getAllPredecessorsInTopologicalOrder(n.data));
            this.cachedSuccessors.put(n.data, this.getAllSuccessorsInTopologicalOrder(n.data));
        }
        super.finish();
        if (this.transitive) {
            for (Object data : this.topologicalOrder) {
                DirectedGraph.Node n = (DirectedGraph.Node)this.entries.get(data);
                Set indirectSuccessors = this.getIndirectSuccessors(data);
                indirectSuccessors.retainAll(n.successors);
                n.successors = n.successors.minusAll(indirectSuccessors);
                for (Object p : indirectSuccessors) {
                    DirectedGraph.Node np = (DirectedGraph.Node)this.entries.get(p);
                    np.predecessors = np.predecessors.minus(data);
                }
            }
        }
    }

    private Set<T> getIndirectSuccessors(T data) {
        if (!this.finished) {
            throw new SchemaException();
        }
        DirectedGraph.Node n = (DirectedGraph.Node)this.entries.get(data);
        HashSet s = new HashSet();
        LinkedList<Object> q = new LinkedList<Object>();
        for (Object p : n.successors) {
            q.addAll(((DirectedGraph.Node)this.entries.get(p)).successors);
        }
        while (!q.isEmpty()) {
            n = (DirectedGraph.Node)this.entries.get(q.poll());
            if (s.contains(n.data)) continue;
            s.add(n.data);
            for (Object x : n.successors) {
                q.offer(x);
            }
        }
        return s;
    }

    public PSet<T> getAllPredecessorsInTopologicalOrder(T data) {
        if (this.finished) {
            return this.cachedPredecessors.get(data);
        }
        DirectedGraph.Node n = (DirectedGraph.Node)this.entries.get(data);
        HashSet s = new HashSet();
        LinkedList q = new LinkedList(n.predecessors);
        while (!q.isEmpty()) {
            n = (DirectedGraph.Node)this.entries.get(q.poll());
            if (s.contains(n.data)) continue;
            s.add(n.data);
            for (Object x : n.predecessors) {
                q.offer(x);
            }
        }
        PSet<Object> result = ArrayPSet.empty();
        for (Object x : this.topologicalOrder) {
            if (!s.contains(x)) continue;
            result = result.plus(x);
        }
        return result;
    }

    public PSet<T> getAllSuccessorsInTopologicalOrder(T data) {
        if (this.finished) {
            return this.cachedSuccessors.get(data);
        }
        DirectedGraph.Node n = (DirectedGraph.Node)this.entries.get(data);
        HashSet s = new HashSet();
        LinkedList q = new LinkedList(n.successors);
        while (!q.isEmpty()) {
            n = (DirectedGraph.Node)this.entries.get(q.poll());
            if (s.contains(n.data)) continue;
            s.add(n.data);
            for (Object x : n.successors) {
                q.offer(x);
            }
        }
        PSet<Object> result = ArrayPSet.empty();
        for (Object x : this.topologicalOrder) {
            if (!s.contains(x)) continue;
            result = result.plus(x);
        }
        return result;
    }

    @Override
    public void createEdge(T alpha, T omega) {
        super.createEdge(alpha, omega);
        if (!this.computeTopologicalOrder()) {
            DirectedGraph.Node fromNode = (DirectedGraph.Node)this.entries.get(alpha);
            DirectedGraph.Node toNode = (DirectedGraph.Node)this.entries.get(omega);
            fromNode.successors = fromNode.successors.minus(toNode);
            toNode.predecessors = toNode.predecessors.minus(fromNode);
            this.computeTopologicalOrder();
            throw new CycleException(alpha, omega);
        }
    }

    public PVector<T> getNodesInTopologicalOrder() {
        return this.topologicalOrder;
    }

    public String toString() {
        HashMap idx = new HashMap();
        StringBuilder sb = new StringBuilder();
        sb.append("digraph g {\n");
        int i = 0;
        for (Object data : this.topologicalOrder) {
            idx.put(data, i);
            sb.append("\tn").append(i).append(" [ label=\"").append(data.toString()).append("\" ];\n");
            ++i;
        }
        for (Object data : this.topologicalOrder) {
            DirectedGraph.Node n = (DirectedGraph.Node)this.entries.get(data);
            for (Object s : n.successors) {
                sb.append("\tn").append(idx.get(data)).append(" -> n").append(idx.get(s)).append(";\n");
            }
        }
        sb.append("}\n");
        return sb.toString();
    }

    public void reopen() {
        this.cachedPredecessors = null;
        this.cachedSuccessors = null;
        this.finished = false;
    }

    @Override
    public void delete(T data) {
        super.delete(data);
        this.computeTopologicalOrder();
    }
}

