/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import java.util.HashMap;
import java.util.Map;
import org.pcollections.ArrayPSet;
import org.pcollections.PSet;

public class DirectedGraph<T> {
    protected PSet<Node<T>> nodes = ArrayPSet.empty();
    protected final Map<T, Node<T>> entries = new HashMap<T, Node<T>>();
    protected boolean finished;
    protected PSet<T> nodeValues = ArrayPSet.empty();

    public void finish() {
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void createEdge(T alpha, T omega) {
        if (this.finished) {
            throw new IllegalStateException("Graph is already finished.");
        }
        if (!this.nodeValues.contains(alpha)) {
            throw new IllegalArgumentException("alpha doesn't belong to this graph.");
        }
        if (!this.nodeValues.contains(omega)) {
            throw new IllegalArgumentException("omega doesn't belong to this graph.");
        }
        if (alpha.equals(omega)) {
            throw new SchemaException("Loops are not supported.");
        }
        Node<T> fromNode = this.entries.get(alpha);
        if (fromNode.successors.contains(omega)) {
            return;
        }
        assert (fromNode != null);
        Node<T> toNode = this.entries.get(omega);
        assert (toNode != null);
        fromNode.successors = fromNode.successors.plus(omega);
        toNode.predecessors = toNode.predecessors.plus(alpha);
    }

    public T createNode(T data) {
        if (this.finished) {
            throw new IllegalStateException("Graph is already finished.");
        }
        assert (!this.nodeValues.contains(data));
        assert (this.entries.get(data) == null);
        this.nodeValues = this.nodeValues.plus(data);
        Node<T> n = new Node<T>(data);
        this.nodes = this.nodes.plus(n);
        this.entries.put(data, n);
        return data;
    }

    public int getNodeCount() {
        return this.nodeValues.size();
    }

    public PSet<T> getNodes() {
        return this.nodeValues;
    }

    public boolean isConnected(T alpha, T omega) {
        return this.entries.get(alpha).successors.contains(omega);
    }

    public PSet<T> getDirectPredecessors(T data) {
        assert (this.nodeValues.contains(data));
        return this.entries.get(data).predecessors;
    }

    public PSet<T> getDirectSuccessors(T data) {
        assert (this.nodeValues.contains(data));
        return this.entries.get(data).successors;
    }

    public void delete(T data) {
        if (this.finished) {
            throw new IllegalStateException("Graph is already finished.");
        }
        Node<T> node = this.entries.get(data);
        this.entries.remove(data);
        this.nodes = this.nodes.minus(node);
        this.nodeValues = this.nodeValues.minus(node);
        for (Object pred : node.predecessors) {
            Node<T> predNode = this.entries.get(pred);
            predNode.successors = predNode.successors.minus(data);
        }
        for (Object succ : node.successors) {
            Node<T> succNode = this.entries.get(succ);
            succNode.predecessors = succNode.predecessors.minus(data);
        }
    }

    protected static class Node<T> {
        final T data;
        PSet<T> successors;
        PSet<T> predecessors;
        int mark;

        Node(T data) {
            assert (data != null);
            this.data = data;
            this.successors = ArrayPSet.empty();
            this.predecessors = ArrayPSet.empty();
        }
    }
}

