/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.schema.DoubleDomain;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import de.uni_koblenz.jgralab.schema.impl.BasicDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.PackageImpl;
import java.io.IOException;

public final class DoubleDomainImpl
extends BasicDomainImpl
implements DoubleDomain {
    DoubleDomainImpl(Schema schema) {
        super("Double", (PackageImpl)schema.getDefaultPackage());
    }

    @Override
    public String getJavaAttributeImplementationTypeName(String schemaRootPackagePrefix) {
        return "double";
    }

    @Override
    public String getJavaClassName(String schemaRootPackagePrefix) {
        return "java.lang.Double";
    }

    @Override
    public CodeBlock getReadMethod(String schemaPrefix, String variableName, String graphIoVariableName) {
        return new CodeSnippet(variableName + " = " + graphIoVariableName + ".matchDouble();");
    }

    @Override
    public String getTGTypeName(Package pkg) {
        return "Double";
    }

    @Override
    public CodeBlock getWriteMethod(String schemaRootPackagePrefix, String variableName, String graphIoVariableName) {
        return new CodeSnippet(graphIoVariableName + ".writeDouble(" + variableName + ");");
    }

    @Override
    public CodeBlock getTransactionReadMethod(String schemaPrefix, String variableName, String graphIoVariableName) {
        return new CodeSnippet(this.getJavaAttributeImplementationTypeName(schemaPrefix) + " " + variableName + " = " + graphIoVariableName + ".matchDouble();");
    }

    @Override
    public CodeBlock getTransactionWriteMethod(String schemaRootPackagePrefix, String variableName, String graphIoVariableName) {
        return this.getWriteMethod(schemaRootPackagePrefix, "get" + CodeGenerator.camelCase(variableName) + "()", graphIoVariableName);
    }

    @Override
    public String getTransactionJavaAttributeImplementationTypeName(String schemaRootPackagePrefix) {
        return "java.lang.Double";
    }

    @Override
    public String getTransactionJavaClassName(String schemaRootPackagePrefix) {
        return this.getJavaClassName(schemaRootPackagePrefix);
    }

    @Override
    public String getVersionedClass(String schemaRootPackagePrefix) {
        return "de.uni_koblenz.jgralab.impl.trans.VersionedReferenceImpl<" + this.getTransactionJavaClassName(schemaRootPackagePrefix) + ">";
    }

    @Override
    public String getInitialValue() {
        return "0.0";
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public Object parseGenericAttribute(GraphIO io) throws GraphIOException {
        return io.matchDouble();
    }

    @Override
    public void serializeGenericAttribute(GraphIO io, Object data) throws IOException {
        io.writeDouble((Double)data);
    }

    @Override
    public boolean isConformValue(Object value) {
        return Double.class.isInstance(value);
    }
}

