/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.IncidenceClass;
import de.uni_koblenz.jgralab.schema.IncidenceDirection;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.GraphClassImpl;
import de.uni_koblenz.jgralab.schema.impl.GraphElementClassImpl;
import de.uni_koblenz.jgralab.schema.impl.IncidenceClassImpl;
import de.uni_koblenz.jgralab.schema.impl.PackageImpl;
import de.uni_koblenz.jgralab.schema.impl.VertexClassImpl;

public class EdgeClassImpl
extends GraphElementClassImpl<EdgeClass, Edge>
implements EdgeClass {
    private final IncidenceClass from;
    private final IncidenceClass to;

    protected EdgeClassImpl(String simpleName, PackageImpl pkg, GraphClassImpl gc, VertexClass from, int fromMin, int fromMax, String fromRoleName, AggregationKind aggrFrom, VertexClass to, int toMin, int toMax, String toRoleName, AggregationKind aggrTo) {
        super(simpleName, pkg, gc, gc.edgeClassDag);
        if (!(pkg.isDefaultPackage() && simpleName.equals("Edge") || pkg.isDefaultPackage() && simpleName.equals("TemporaryEdgeClass") || from != this.graphClass.getDefaultVertexClass() && to != this.graphClass.getDefaultVertexClass())) {
            throw new SchemaException("EdgeClasses from/to the default vertex class are forbidden!\n Tried to create edge class " + simpleName + ": " + to.getQualifiedName() + " -> " + to.getQualifiedName());
        }
        IncidenceClassImpl fromInc = new IncidenceClassImpl(this, from, fromRoleName, fromMin, fromMax, IncidenceDirection.OUT, aggrFrom);
        IncidenceClassImpl toInc = new IncidenceClassImpl(this, to, toRoleName, toMin, toMax, IncidenceDirection.IN, aggrTo);
        this.from = fromInc;
        this.to = toInc;
        ((VertexClassImpl)from).addOutIncidenceClass(fromInc);
        ((VertexClassImpl)to).addInIncidenceClass(toInc);
        this.parentPackage.addEdgeClass(this);
        this.graphClass.addEdgeClass(this);
    }

    @Override
    public void addSuperClass(EdgeClass superClass) {
        this.assertNotFinished();
        if (superClass == this) {
            return;
        }
        EdgeClassImpl.checkIncidenceClassSpecialization(this.getFrom(), superClass.getFrom());
        EdgeClassImpl.checkIncidenceClassSpecialization(this.getTo(), superClass.getTo());
        super.addSuperClass(superClass);
        ((IncidenceClassImpl)this.getFrom()).addSubsettedIncidenceClass(superClass.getFrom());
        ((IncidenceClassImpl)this.getTo()).addSubsettedIncidenceClass(superClass.getTo());
    }

    @Override
    public final IncidenceClass getFrom() {
        return this.from;
    }

    @Override
    public final IncidenceClass getTo() {
        return this.to;
    }

    static void checkIncidenceClassSpecialization(IncidenceClass special, IncidenceClass general) {
        if (!general.getVertexClass().equals(special.getVertexClass()) && !general.getVertexClass().isSuperClassOf(special.getVertexClass())) {
            String dir = special.getDirection() == IncidenceDirection.OUT ? "Alpha" : "Omega";
            throw new SchemaException("An IncidenceClass may specialize only IncidenceClasses whose connected vertex class is identical or a superclass of the own one. Offending EdgeClasses are " + special.getEdgeClass().getQualifiedName() + " which wants to specialize " + general.getEdgeClass().getQualifiedName() + " at end " + dir + ". Connected VertexClass of special IncidenceClass ist " + special.getVertexClass().getQualifiedName() + " and of general VertexClass is " + general.getVertexClass().getQualifiedName() + ".");
        }
        if (special.getMax() > general.getMax()) {
            String dir = special.getDirection() == IncidenceDirection.OUT ? "Alpha" : "Omega";
            throw new SchemaException("The multiplicity of an edge class may not be larger than the multiplicities of its superclass. Offending EdgeClasses are " + special.getEdgeClass().getQualifiedName() + " and " + general.getEdgeClass().getQualifiedName() + " at end " + dir);
        }
        if (general.getRolename().equals(special.getRolename()) && !general.getRolename().isEmpty() && !special.getRolename().isEmpty()) {
            String dir = special.getDirection() == IncidenceDirection.OUT ? "Alpha" : "Omega";
            throw new SchemaException("An IncidenceClass may only subset an IncidenceClass with a different name. OffendingEdgeClasses are " + special.getEdgeClass().getQualifiedName() + " and " + general.getEdgeClass().getQualifiedName() + " at end " + dir);
        }
        for (IncidenceClass ic : general.getSubsettedIncidenceClasses()) {
            if (!ic.getRolename().equals(special.getRolename()) || general.getRolename().isEmpty() || ic.getRolename().isEmpty()) continue;
            String dir = ic.getDirection() == IncidenceDirection.OUT ? "Alpha" : "Omega";
            throw new SchemaException("An IncidenceClass may only subset an IncidenceClass with a different name. OffendingEdgeClasses are " + special.getEdgeClass().getQualifiedName() + " and " + ic.getEdgeClass().getQualifiedName() + " at end " + dir);
        }
    }

    @Override
    protected void register() {
        super.register();
        this.graphClass.edgeClasses.put(this.qualifiedName, this);
        this.parentPackage.edgeClasses.put(this.simpleName, this);
    }

    @Override
    protected void unregister() {
        super.unregister();
        this.graphClass.edgeClasses.remove(this.qualifiedName);
        this.parentPackage.edgeClasses.remove(this.simpleName);
    }

    @Override
    public void delete() {
        if (this == this.graphClass.getDefaultEdgeClass()) {
            throw new SchemaException("The default edge class cannot be deleted.");
        }
        VertexClassImpl fromVC = (VertexClassImpl)this.from.getVertexClass();
        VertexClassImpl toVC = (VertexClassImpl)this.to.getVertexClass();
        fromVC.unlink(this.from);
        toVC.unlink(this.to);
        super.delete();
        this.graphClass.edgeClasses.remove(this.qualifiedName);
        this.graphClass.edgeClassDag.delete(this);
        this.parentPackage.edgeClasses.remove(this.simpleName);
    }

    @Override
    protected EdgeClass getDefaultClass() {
        return this.graphClass.getDefaultEdgeClass();
    }

    @Override
    public boolean isDefaultGraphElementClass() {
        return this == this.graphClass.getDefaultEdgeClass();
    }
}

