/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.AttributeImpl;
import de.uni_koblenz.jgralab.schema.impl.AttributedElementClassImpl;
import de.uni_koblenz.jgralab.schema.impl.DirectedAcyclicGraph;
import de.uni_koblenz.jgralab.schema.impl.GraphClassImpl;
import de.uni_koblenz.jgralab.schema.impl.NamedElementImpl;
import de.uni_koblenz.jgralab.schema.impl.PackageImpl;
import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;
import java.util.BitSet;
import java.util.List;
import java.util.TreeSet;
import org.pcollections.ArrayPVector;
import org.pcollections.PSet;
import org.pcollections.PVector;

public abstract class GraphElementClassImpl<SC extends GraphElementClass<SC, IC>, IC extends GraphElement<SC, IC>>
extends AttributedElementClassImpl<SC, IC>
implements GraphElementClass<SC, IC> {
    protected final GraphClassImpl graphClass;
    protected PVector<Attribute> ownAttributes = ArrayPVector.empty();
    protected PSet<SC> allSubClasses;
    protected BitSet allSubClassesBitSet;
    protected PSet<SC> allSuperClasses;
    protected BitSet allSuperClassesBitSet;
    protected final DirectedAcyclicGraph<GraphElementClass<SC, IC>> subclassDag;
    protected final int classId;

    protected GraphElementClassImpl(String simpleName, PackageImpl pkg, GraphClassImpl graphClass, DirectedAcyclicGraph<SC> dag) {
        super(simpleName, pkg, graphClass.schema);
        this.subclassDag = dag;
        this.subclassDag.createNode(this);
        this.graphClass = graphClass;
        this.classId = this.schema.getNextGraphElementClassId();
    }

    @Override
    protected Attribute createAttribute(Attribute anAttribute) {
        this.assertNotFinished();
        if (this.subclassContainsAttribute(anAttribute.getName())) {
            throw new SchemaException("Duplicate attribute '" + anAttribute.getName() + "' in AttributedElementClass '" + this.getQualifiedName() + "'. A derived AttributedElementClass already contains this Attribute.");
        }
        super.createAttribute(anAttribute);
        TreeSet<Attribute> s = new TreeSet<Attribute>(this.ownAttributes);
        s.add(anAttribute);
        this.ownAttributes = ArrayPVector.empty().plusAll(s);
        return anAttribute;
    }

    @Override
    public GraphClass getGraphClass() {
        return this.graphClass;
    }

    protected void addSuperClass(SC superClass) {
        this.assertNotFinished();
        if (superClass == this) {
            return;
        }
        for (Attribute a : superClass.getAttributeList()) {
            if (this.getAttribute(a.getName()) == null || this.getAttribute(a.getName()) == a) continue;
            throw new SchemaException("Cannot add " + superClass.getQualifiedName() + " as superclass of " + this.getQualifiedName() + ". Cause: Attribute " + a.getName() + " is declared in both classes");
        }
        this.subclassDag.createEdge((GraphElementClass<SC, IC>)superClass, this);
    }

    @Override
    public PSet<SC> getDirectSubClasses() {
        return this.subclassDag.getDirectSuccessors(this);
    }

    protected abstract SC getDefaultClass();

    @Override
    public PSet<SC> getDirectSuperClasses() {
        return this.subclassDag.getDirectPredecessors(this).minus(this.getDefaultClass());
    }

    @Override
    public PSet<SC> getAllSubClasses() {
        if (this.finished) {
            return this.allSubClasses;
        }
        return this.subclassDag.getAllSuccessorsInTopologicalOrder(this);
    }

    @Override
    public PSet<SC> getAllSuperClasses() {
        if (this.finished) {
            return this.allSuperClasses;
        }
        return this.subclassDag.getAllPredecessorsInTopologicalOrder(this).minus(this.getDefaultClass());
    }

    @Override
    public final boolean isSubClassOf(SC anAttributedElementClass) {
        if (this.finished) {
            return this.allSuperClassesBitSet.get(anAttributedElementClass.getGraphElementClassIdInSchema());
        }
        return this.getAllSuperClasses().contains(anAttributedElementClass);
    }

    @Override
    public final boolean isSuperClassOf(SC anAttributedElementClass) {
        if (this.finished) {
            return this.allSubClassesBitSet.get(anAttributedElementClass.getGraphElementClassIdInSchema());
        }
        return this.getAllSubClasses().contains(anAttributedElementClass);
    }

    private boolean subclassContainsAttribute(String name) {
        for (GraphElementClass subClass : this.getAllSubClasses()) {
            if (subClass.getAttribute(name) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void finish() {
        this.allSuperClasses = this.getAllSuperClasses();
        this.allSuperClassesBitSet = new BitSet();
        for (GraphElementClass superClass : this.allSuperClasses) {
            this.allSuperClassesBitSet.set(superClass.getGraphElementClassIdInSchema(), true);
        }
        this.allSubClasses = this.getAllSubClasses();
        this.allSubClassesBitSet = new BitSet();
        for (GraphElementClass subClass : this.allSubClasses) {
            this.allSubClassesBitSet.set(subClass.getGraphElementClassIdInSchema(), true);
        }
        TreeSet<Attribute> s = new TreeSet<Attribute>(this.ownAttributes);
        for (AttributedElementClass attributedElementClass : this.subclassDag.getDirectPredecessors(this)) {
            s.addAll(attributedElementClass.getAttributeList());
        }
        this.allAttributes = ArrayPVector.empty().plusAll(s);
        super.finish();
    }

    @Override
    public int getAttributeCount() {
        if (this.finished) {
            return this.allAttributes.size();
        }
        int attrCount = this.getOwnAttributeCount();
        for (AttributedElementClass attributedElementClass : this.subclassDag.getDirectPredecessors(this)) {
            attrCount += attributedElementClass.getAttributeCount();
        }
        return attrCount;
    }

    @Override
    public List<Attribute> getAttributeList() {
        if (this.finished) {
            return this.allAttributes;
        }
        TreeSet<Attribute> attrList = new TreeSet<Attribute>();
        attrList.addAll(this.ownAttributes);
        for (AttributedElementClass attributedElementClass : this.subclassDag.getDirectPredecessors(this)) {
            attrList.addAll(attributedElementClass.getAttributeList());
        }
        return ArrayPVector.empty().plusAll(attrList);
    }

    @Override
    public Attribute getAttribute(String name) {
        if (this.finished) {
            return super.getAttribute(name);
        }
        Attribute ownAttr = this.getOwnAttribute(name);
        if (ownAttr != null) {
            return ownAttr;
        }
        for (AttributedElementClass attributedElementClass : this.subclassDag.getDirectPredecessors(this)) {
            Attribute inheritedAttr = attributedElementClass.getAttribute(name);
            if (inheritedAttr == null) continue;
            return inheritedAttr;
        }
        return null;
    }

    @Override
    public Attribute getOwnAttribute(String name) {
        for (Attribute a : this.ownAttributes) {
            if (!a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }

    @Override
    public int getOwnAttributeCount() {
        return this.ownAttributes.size();
    }

    @Override
    public List<Attribute> getOwnAttributeList() {
        return this.ownAttributes;
    }

    @Override
    public boolean hasOwnAttributes() {
        return !this.ownAttributes.isEmpty();
    }

    public String getDescriptionString() {
        StringBuilder output = new StringBuilder(this.getClass().getSimpleName() + " '" + this.getQualifiedName() + "'");
        if (this.isAbstract()) {
            output.append(" (abstract)");
        }
        output.append(":\n");
        output.append("Subclasses of '" + this.getQualifiedName() + "': ");
        for (GraphElementClass aec : this.getAllSubClasses()) {
            output.append("'" + aec.getQualifiedName() + "' ");
        }
        output.append("\nSuperclasses of '" + this.getQualifiedName() + "': ");
        for (GraphElementClass aec : this.getAllSuperClasses()) {
            output.append("'" + aec.getQualifiedName() + "' ");
        }
        output.append("\nDirect Superclasses of '" + this.getQualifiedName() + "': ");
        for (GraphElementClass aec : this.getDirectSuperClasses()) {
            output.append("'" + aec.getQualifiedName() + "' ");
        }
        output.append(this.attributesToString());
        output.append("\n");
        return output.toString();
    }

    @Override
    public int getGraphElementClassIdInSchema() {
        return this.classId;
    }

    @Override
    public void setQualifiedName(String newQName) {
        if (this.qualifiedName.equals(newQName)) {
            return;
        }
        if (this.schema.knows(newQName)) {
            throw new SchemaException(newQName + " is already known to the schema.");
        }
        String[] ps = SchemaImpl.splitQualifiedName(newQName);
        String newPackageName = ps[0];
        String newSimpleName = ps[1];
        if (!NamedElementImpl.ATTRELEM_OR_NOCOLLDOMAIN_PATTERN.matcher(newSimpleName).matches()) {
            throw new SchemaException("Invalid graph element class name '" + newSimpleName + "'.");
        }
        this.unregister();
        this.qualifiedName = newQName;
        this.simpleName = newSimpleName;
        this.parentPackage = this.schema.createPackageWithParents(newPackageName);
        this.register();
    }

    @Override
    protected void reopen() {
        this.allSuperClasses = null;
        this.allSuperClassesBitSet = null;
        this.allSubClasses = null;
        this.allSubClassesBitSet = null;
        super.reopen();
    }

    @Override
    protected void deleteAttribute(AttributeImpl attr) {
        this.allAttributes = this.allAttributes.minus(attr);
        this.ownAttributes = this.ownAttributes.minus(attr);
    }

    @Override
    public void delete() {
        for (Attribute a : this.ownAttributes) {
            a.delete();
        }
        this.ownAttributes = null;
        this.allAttributes = null;
        this.schema.namedElements.remove(this.qualifiedName);
    }
}

