/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.MapDomain;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.CompositeDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.DomainImpl;
import de.uni_koblenz.jgralab.schema.impl.PackageImpl;
import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;
import java.io.IOException;
import java.util.Iterator;
import org.pcollections.PMap;

public final class MapDomainImpl
extends CompositeDomainImpl
implements MapDomain {
    private final Domain keyDomain;
    private final Domain valueDomain;

    MapDomainImpl(Schema schema, Domain aKeyDomain, Domain aValueDomain) {
        super("Map<" + aKeyDomain.getTGTypeName(schema.getDefaultPackage()) + ", " + aValueDomain.getTGTypeName(schema.getDefaultPackage()) + ">", (PackageImpl)schema.getDefaultPackage());
        if (this.parentPackage.getSchema().getDomain(aKeyDomain.getQualifiedName()) == null) {
            throw new SchemaException("Key domain '" + aKeyDomain.getQualifiedName() + "' not existent in schema " + this.parentPackage.getSchema().getQualifiedName());
        }
        if (this.parentPackage.getSchema().getDomain(aValueDomain.getQualifiedName()) == null) {
            throw new SchemaException("Value domain '" + aValueDomain.getQualifiedName() + "' not existent in schema " + this.parentPackage.getSchema().getQualifiedName());
        }
        this.keyDomain = aKeyDomain;
        this.valueDomain = aValueDomain;
        ((SchemaImpl)schema).addDomainDependency(this, this.keyDomain);
        ((SchemaImpl)schema).addDomainDependency(this, this.valueDomain);
    }

    @Override
    public String getJavaAttributeImplementationTypeName(String schemaRootPackagePrefix) {
        return "org.pcollections.PMap<" + this.keyDomain.getJavaClassName(schemaRootPackagePrefix) + ", " + this.valueDomain.getJavaClassName(schemaRootPackagePrefix) + ">";
    }

    @Override
    public String getJavaClassName(String schemaRootPackagePrefix) {
        return this.getJavaAttributeImplementationTypeName(schemaRootPackagePrefix);
    }

    @Override
    public Domain getKeyDomain() {
        return this.keyDomain;
    }

    @Override
    public CodeBlock getReadMethod(String schemaRootPackagePrefix, String variableName, String graphIoVariableName) {
        CodeList code = new CodeList();
        code.setVariable("init", "");
        this.internalGetReadMethod(code, schemaRootPackagePrefix, variableName, graphIoVariableName);
        return code;
    }

    @Override
    public String getTGTypeName(Package pkg) {
        return "Map<" + this.keyDomain.getTGTypeName(pkg) + ", " + this.valueDomain.getTGTypeName(pkg) + ">";
    }

    @Override
    public Domain getValueDomain() {
        return this.valueDomain;
    }

    @Override
    public CodeBlock getWriteMethod(String schemaRootPackagePrefix, String variableName, String graphIoVariableName) {
        CodeList code = new CodeList();
        code.setVariable("name", variableName);
        this.internalGetWriteMethod(code, schemaRootPackagePrefix, variableName, graphIoVariableName);
        return code;
    }

    @Override
    public String toString() {
        return "domain Map<" + this.keyDomain.toString() + ", " + this.valueDomain.toString() + ">";
    }

    private void internalGetReadMethod(CodeList code, String schemaRootPackagePrefix, String variableName, String graphIoVariableName) {
        code.setVariable("name", variableName);
        code.setVariable("empty", "de.uni_koblenz.jgralab.JGraLab.map()");
        code.setVariable("keydom", this.getKeyDomain().getJavaClassName(schemaRootPackagePrefix));
        code.setVariable("keytype", this.getKeyDomain().getJavaAttributeImplementationTypeName(schemaRootPackagePrefix));
        code.setVariable("valuedom", this.getValueDomain().getJavaClassName(schemaRootPackagePrefix));
        code.setVariable("valuetype", this.getValueDomain().getJavaAttributeImplementationTypeName(schemaRootPackagePrefix));
        code.setVariable("io", graphIoVariableName);
        code.addNoIndent(new CodeSnippet("#init#"));
        code.addNoIndent(new CodeSnippet("if (#io#.isNextToken(\"{\")) {"));
        code.add(new CodeSnippet("org.pcollections.PMap<#keydom#, #valuedom#> $#name# = #empty#;"));
        code.add(new CodeSnippet("#io#.match(\"{\");", "while (!#io#.isNextToken(\"}\")) {"));
        if (this.getKeyDomain().isComposite()) {
            code.add(new CodeSnippet("\t#keytype# #name#Key = null;"));
        } else {
            code.add(new CodeSnippet("\t#keytype# #name#Key;"));
        }
        if (this.getValueDomain().isComposite()) {
            code.add(new CodeSnippet("\t\t#valuetype# #name#Value = null;"));
        } else {
            code.add(new CodeSnippet("\t\t#valuetype# #name#Value;"));
        }
        code.add(this.getKeyDomain().getReadMethod(schemaRootPackagePrefix, variableName + "Key", graphIoVariableName), 1);
        code.add(new CodeSnippet("\t#io#.match(\"-\");"));
        code.add(this.getValueDomain().getReadMethod(schemaRootPackagePrefix, variableName + "Value", graphIoVariableName), 1);
        code.add(new CodeSnippet("\t$#name# = $#name#.plus(#name#Key, #name#Value);", "}", "#io#.match(\"}\");", "#name# = $#name#;"));
        code.addNoIndent(new CodeSnippet("} else if (#io#.isNextToken(GraphIO.NULL_LITERAL)) {"));
        code.add(new CodeSnippet("#io#.match();", "#name# = null;"));
        code.addNoIndent(new CodeSnippet("} else {", "\t#name# = null;", "}"));
    }

    private void internalGetWriteMethod(CodeList code, String schemaRootPackagePrefix, String variableName, String graphIoVariableName) {
        code.setVariable("nameKey", "key");
        code.setVariable("nameValue", "value");
        code.setVariable("keytype", this.getKeyDomain().getJavaAttributeImplementationTypeName(schemaRootPackagePrefix));
        code.setVariable("valuetype", this.getValueDomain().getJavaAttributeImplementationTypeName(schemaRootPackagePrefix));
        code.setVariable("io", graphIoVariableName);
        code.addNoIndent(new CodeSnippet("if (#name# != null) {"));
        code.add(new CodeSnippet("#io#.writeSpace();", "#io#.write(\"{\");", "#io#.noSpace();"));
        code.add(new CodeSnippet("for (#keytype# #nameKey#: #name#.keySet()) {"));
        code.add(new CodeSnippet("#valuetype# #nameValue# = #name#.get(#nameKey#);"), 1);
        code.add(this.getKeyDomain().getWriteMethod(schemaRootPackagePrefix, code.getVariable("nameKey"), graphIoVariableName), 1);
        code.add(new CodeSnippet("\t#io#.write(\" -\");"));
        code.add(this.getValueDomain().getWriteMethod(schemaRootPackagePrefix, code.getVariable("nameValue"), graphIoVariableName), 1);
        code.add(new CodeSnippet("}", "#io#.write(\"}\");", "#io#.space();"));
        code.addNoIndent(new CodeSnippet("} else {"));
        code.add(new CodeSnippet(graphIoVariableName + ".writeIdentifier(GraphIO.NULL_LITERAL);"));
        code.addNoIndent(new CodeSnippet("}"));
    }

    @Override
    public CodeBlock getTransactionReadMethod(String schemaPrefix, String variableName, String graphIoVariableName) {
        CodeList code = new CodeList();
        code.setVariable("name", "get" + CodeGenerator.camelCase(variableName) + "()");
        code.setVariable("init", "org.pcollections.PMap<#keydom#, #valuedom#> #name# = null;");
        this.internalGetReadMethod(code, schemaPrefix, variableName, graphIoVariableName);
        return code;
    }

    @Override
    public CodeBlock getTransactionWriteMethod(String schemaRootPackagePrefix, String variableName, String graphIoVariableName) {
        CodeList code = new CodeList();
        code.setVariable("name", "get" + CodeGenerator.camelCase(variableName) + "()");
        this.internalGetWriteMethod(code, schemaRootPackagePrefix, variableName, graphIoVariableName);
        return code;
    }

    @Override
    public String getTransactionJavaAttributeImplementationTypeName(String schemaRootPackagePrefix) {
        return this.getJavaAttributeImplementationTypeName(schemaRootPackagePrefix);
    }

    @Override
    public String getTransactionJavaClassName(String schemaRootPackagePrefix) {
        return this.getJavaAttributeImplementationTypeName(schemaRootPackagePrefix);
    }

    @Override
    public String getVersionedClass(String schemaRootPackagePrefix) {
        return "de.uni_koblenz.jgralab.impl.trans.VersionedReferenceImpl<" + this.getTransactionJavaAttributeImplementationTypeName(schemaRootPackagePrefix) + ">";
    }

    @Override
    public String getInitialValue() {
        return "null";
    }

    @Override
    public Object parseGenericAttribute(GraphIO io) throws GraphIOException {
        if (io.isNextToken("{")) {
            PMap<Object, Object> result = JGraLab.map();
            io.match("{");
            while (!io.isNextToken("}")) {
                Object mapKey = null;
                Object mapValue = null;
                mapKey = this.getKeyDomain().parseGenericAttribute(io);
                io.match("-");
                mapValue = this.getValueDomain().parseGenericAttribute(io);
                result = result.plus(mapKey, mapValue);
            }
            io.match("}");
            return result;
        }
        if (io.isNextToken("n")) {
            io.match();
            return null;
        }
        return null;
    }

    @Override
    public void serializeGenericAttribute(GraphIO io, Object data) throws IOException {
        if (data != null) {
            io.writeSpace();
            io.write("{");
            io.noSpace();
            for (Object key : ((PMap)data).keySet()) {
                this.getKeyDomain().serializeGenericAttribute(io, key);
                io.write(" -");
                this.getValueDomain().serializeGenericAttribute(io, ((PMap)data).get(key));
            }
            io.write("}");
            io.space();
        } else {
            io.writeIdentifier("n");
        }
    }

    @Override
    protected void registerAttribute(Attribute a) {
        this.attributes = this.attributes.plus(a);
        ((DomainImpl)this.keyDomain).registerAttribute(a);
        ((DomainImpl)this.valueDomain).registerAttribute(a);
    }

    @Override
    public boolean isConformValue(Object value) {
        boolean result = true;
        if (value == null) {
            return result;
        }
        if (!(result &= value instanceof PMap)) {
            return false;
        }
        Iterator iterator = ((PMap)value).keySet().iterator();
        while (iterator.hasNext() && result) {
            Object key = iterator.next();
            result &= this.getKeyDomain().isConformValue(key) && this.getValueDomain().isConformValue(((PMap)value).get(key));
        }
        return result;
    }
}

