/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.NamedElement;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.NamedElementImpl;
import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.pcollections.ArrayPSet;
import org.pcollections.PSet;

public final class PackageImpl
extends NamedElementImpl
implements Package {
    final Map<String, Domain> domains = new TreeMap<String, Domain>();
    final Map<String, EdgeClass> edgeClasses = new TreeMap<String, EdgeClass>();
    final Map<String, VertexClass> vertexClasses = new TreeMap<String, VertexClass>();
    private final Map<String, Package> subPackages = new TreeMap<String, Package>();

    static PackageImpl createDefaultPackage(Schema schema) {
        assert (schema.getDefaultPackage() == null) : "DefaultPackage already created!";
        return new PackageImpl((SchemaImpl)schema);
    }

    private PackageImpl(SchemaImpl schema) {
        this("", null, schema);
    }

    PackageImpl(String simpleName, PackageImpl parentPackage, SchemaImpl schema) {
        super(simpleName, parentPackage, schema);
        if (parentPackage != null) {
            parentPackage.addSubPackage(this);
        }
        schema.addPackage(this);
    }

    void addDomain(Domain dom) {
        assert (dom.getPackage() == this) : "The domain does not belong into this package (" + this.getQualifiedName() + "). It belongs here: " + dom.getPackageName();
        assert (!this.domains.containsKey(dom.getSimpleName()) && !this.domains.containsValue(dom)) : "This package (" + this.getQualifiedName() + ") already contains a domain called " + dom.getSimpleName();
        this.domains.put(dom.getSimpleName(), dom);
    }

    void addEdgeClass(EdgeClass ec) {
        assert (ec.getPackage() == this) : "The edge class '" + ec.getQualifiedName() + "' does not belong into the package '" + this.getQualifiedName() + "' but into '" + ec.getPackageName() + "'.";
        assert (!this.edgeClasses.containsKey(ec.getSimpleName()) && !this.edgeClasses.containsValue(ec)) : "This package (" + this.getQualifiedName() + ") already contains an edge class called " + ec.getSimpleName();
        if (!(this.isDefaultPackage() && ec.getSimpleName().equals("Edge") || this.isDefaultPackage() && ec.getSimpleName().equals("TemporaryEdgeClass"))) {
            this.edgeClasses.put(ec.getSimpleName(), ec);
        }
    }

    void addSubPackage(Package subPkg) {
        assert (subPkg.getPackage() == this) : "The subpackage does not belong into the package '" + this.getQualifiedName() + "' but into '" + subPkg.getPackageName() + "'.";
        assert (!this.subPackages.containsKey(subPkg.getSimpleName())) : "The package '" + this.getQualifiedName() + "' already contains a subpackage called '" + subPkg.getSimpleName() + "'.";
        this.subPackages.put(subPkg.getSimpleName(), subPkg);
    }

    void addVertexClass(VertexClass vc) {
        assert (vc.getPackage() == this) : "The vertex class '" + vc.getQualifiedName() + "' does not belong into the package '" + this.getQualifiedName() + "' but into '" + vc.getPackageName() + "'";
        assert (!this.vertexClasses.containsKey(vc.getSimpleName()) && !this.vertexClasses.containsValue(vc)) : "This package (" + this.getQualifiedName() + ") already contains a vertex class called \"" + vc.getSimpleName() + "\"";
        if (!(this.isDefaultPackage() && vc.getSimpleName().equals("Vertex") || this.isDefaultPackage() && vc.getSimpleName().equals("TemporaryVertexClass"))) {
            this.vertexClasses.put(vc.getSimpleName(), vc);
        }
    }

    @Override
    public boolean containsNamedElement(String sn) {
        return this.domains.containsKey(sn) || this.edgeClasses.containsKey(sn) || this.vertexClasses.containsKey(sn) || this.subPackages.containsKey(sn);
    }

    @Override
    public PSet<Domain> getDomains() {
        return ArrayPSet.empty().plusAll(this.domains.values());
    }

    @Override
    public PSet<EdgeClass> getEdgeClasses() {
        return ArrayPSet.empty().plusAll(this.edgeClasses.values());
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public Package getSubPackage(String sn) {
        return this.subPackages.get(sn);
    }

    @Override
    public PSet<Package> getSubPackages() {
        return ArrayPSet.empty().plusAll(this.subPackages.values());
    }

    @Override
    public PSet<VertexClass> getVertexClasses() {
        return ArrayPSet.empty().plusAll(this.vertexClasses.values());
    }

    @Override
    public boolean isDefaultPackage() {
        return this == this.schema.getDefaultPackage();
    }

    @Override
    public String toString() {
        return "package " + this.qualifiedName;
    }

    @Override
    public String getUniqueName() {
        return this.qualifiedName;
    }

    @Override
    public void setQualifiedName(String newQName) {
        if (this.schema.getDefaultPackage() == this) {
            throw new SchemaException("Cannot rename the default package.");
        }
        if (this.qualifiedName.equals(newQName)) {
            return;
        }
        if (this.schema.knows(newQName)) {
            throw new SchemaException(newQName + " is already known to the schema.");
        }
        String[] ps = SchemaImpl.splitQualifiedName(newQName);
        String newPackageName = ps[0];
        String newSimpleName = ps[1];
        if (!NamedElementImpl.PACKAGE_NAME_PATTERN.matcher(newSimpleName).matches()) {
            throw new SchemaException("Invalid package name '" + newSimpleName + "'.");
        }
        this.unregister();
        this.qualifiedName = newQName;
        this.simpleName = newSimpleName;
        this.parentPackage = this.schema.createPackageWithParents(newPackageName);
        LinkedList<NamedElement> l = new LinkedList<NamedElement>();
        l.addAll(this.vertexClasses.values());
        l.addAll(this.edgeClasses.values());
        l.addAll(this.subPackages.values());
        for (NamedElement ne : l) {
            ne.setQualifiedName(this.qualifiedName + "." + ne.getSimpleName());
        }
        this.register();
    }

    @Override
    protected final void register() {
        super.register();
        this.parentPackage.subPackages.put(this.simpleName, this);
    }

    @Override
    protected final void unregister() {
        super.unregister();
        this.parentPackage.subPackages.remove(this.simpleName);
    }

    @Override
    public void delete() {
        this.schema.assertNotFinished();
        if (this.isDefaultPackage()) {
            throw new SchemaException("The default package cannot be deleted.");
        }
        if (this.domains.size() != 0 || this.vertexClasses.size() != 0 || this.edgeClasses.size() != 0) {
            throw new SchemaException("Only empty packages can be deleted!");
        }
        this.parentPackage.subPackages.remove(this.simpleName);
        this.schema.packages.remove(this.qualifiedName);
        this.schema.namedElements.remove(this.qualifiedName);
    }

    @Override
    public EdgeClass getEdgeClass(String simpleName) {
        return this.edgeClasses.get(simpleName);
    }

    @Override
    public Domain getDomain(String simpleName) {
        return this.domains.get(simpleName);
    }

    @Override
    public VertexClass getVertexClass(String simpleName) {
        return this.vertexClasses.get(simpleName);
    }
}

