/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl.compilation;

import de.uni_koblenz.jgralab.schema.impl.compilation.InMemoryClassFile;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class SchemaClassManager
extends ClassLoader {
    private static HashMap<String, WeakReference<SchemaClassManager>> instances = new HashMap();
    private Map<String, InMemoryClassFile> schemaClassFiles;
    private String schemaQName = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SchemaClassManager instance(String qualifiedName) {
        WeakReference<SchemaClassManager> ref = instances.get(qualifiedName);
        SchemaClassManager result = null;
        if (ref != null) {
            result = (SchemaClassManager)ref.get();
        }
        if (result != null) return result;
        Class<SchemaClassManager> clazz = SchemaClassManager.class;
        synchronized (SchemaClassManager.class) {
            ref = instances.get(qualifiedName);
            if (ref != null) {
                result = (SchemaClassManager)ref.get();
            }
            if (result != null) return result;
            result = new SchemaClassManager(qualifiedName);
            instances.put(qualifiedName, new WeakReference<SchemaClassManager>(result));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result;
        }
    }

    private SchemaClassManager(String schemaQName) {
        this.schemaQName = schemaQName;
        this.schemaClassFiles = new HashMap<String, InMemoryClassFile>();
    }

    public void putSchemaClass(String className, InMemoryClassFile cfa) {
        this.schemaClassFiles.put(className, cfa);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        InMemoryClassFile inMemClassFile = this.schemaClassFiles.get(name);
        if (inMemClassFile != null) {
            byte[] bytes = inMemClassFile.getBytecode();
            Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length);
            this.schemaClassFiles.remove(name);
            return clazz;
        }
        return Class.forName(name);
    }

    public String toString() {
        return "SchemaClassManager for schema '" + this.schemaQName + "'";
    }
}

