/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.argouml2tg;

import de.uni_koblenz.ist.utilities.option_handler.OptionHandler;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.functions.entries.FunctionEntry;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.graphmarker.BooleanGraphMarker;
import de.uni_koblenz.jgralab.graphmarker.GraphMarker;
import de.uni_koblenz.jgralab.graphmarker.IntegerVertexMarker;
import de.uni_koblenz.jgralab.graphvalidator.ConstraintViolation;
import de.uni_koblenz.jgralab.graphvalidator.GraphValidator;
import de.uni_koblenz.jgralab.grumlschema.GrumlSchema;
import de.uni_koblenz.jgralab.grumlschema.SchemaGraph;
import de.uni_koblenz.jgralab.grumlschema.domains.BooleanDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.Domain;
import de.uni_koblenz.jgralab.grumlschema.domains.EnumDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.HasRecordDomainComponent;
import de.uni_koblenz.jgralab.grumlschema.domains.ListDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.MapDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.RecordDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.SetDomain;
import de.uni_koblenz.jgralab.grumlschema.structure.AggregationKind;
import de.uni_koblenz.jgralab.grumlschema.structure.Annotates;
import de.uni_koblenz.jgralab.grumlschema.structure.Attribute;
import de.uni_koblenz.jgralab.grumlschema.structure.AttributedElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.Comment;
import de.uni_koblenz.jgralab.grumlschema.structure.Constraint;
import de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass;
import de.uni_koblenz.jgralab.grumlschema.structure.GraphClass;
import de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.IncidenceClass;
import de.uni_koblenz.jgralab.grumlschema.structure.NamedElement;
import de.uni_koblenz.jgralab.grumlschema.structure.Package;
import de.uni_koblenz.jgralab.grumlschema.structure.Schema;
import de.uni_koblenz.jgralab.grumlschema.structure.SpecializesEdgeClass;
import de.uni_koblenz.jgralab.grumlschema.structure.SpecializesVertexClass;
import de.uni_koblenz.jgralab.grumlschema.structure.VertexClass;
import de.uni_koblenz.jgralab.utilities.rsa2tg.ProcessingException;
import de.uni_koblenz.jgralab.utilities.rsa2tg.SchemaGraph2Tg;
import de.uni_koblenz.jgralab.utilities.tg2dot.Tg2Dot;
import de.uni_koblenz.jgralab.utilities.xml2tg.Xml2Tg;
import de.uni_koblenz.jgralab.utilities.xml2tg.XmlGraphUtilities;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.Element;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.HasChild;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.pcollections.PVector;

public class ArgoUml2Tg
extends Xml2Tg {
    private final Logger logger = JGraLab.getLogger(ArgoUml2Tg.class);
    private static final String OPTION_FILENAME_VALIDATION = "r";
    private static final String OPTION_FILENAME_SCHEMA_GRAPH = "s";
    private static final String OPTION_FILENAME_DOT = "e";
    private static final String OPTION_FILENAME_SCHEMA = "o";
    private static final String OPTION_USE_NAVIGABILITY = "n";
    private static final String OPTION_REMOVE_UNUSED_DOMAINS = "u";
    private static final String OPTION_KEEP_EMPTY_PACKAGES = "k";
    private static final String OPTION_USE_ROLE_NAME = "f";
    private boolean useFromRole;
    private boolean removeUnusedDomains;
    private boolean keepEmptyPackages;
    private boolean useNavigability;
    private boolean suppressOutput;
    private String filenameSchema;
    private String filenameSchemaGraph;
    private String filenameDot;
    private String filenameValidation;
    static final String ST_GRAPHCLASS = "-64--88-111--125-2048530b:13717182953:-8000:0000000000000D6A";
    static final String ST_RECORD = "-64--88-111--125-2048530b:13717182953:-8000:0000000000000D6B";
    static final String ST_ABSTRACT = "-64--88-111--125-2048530b:13717182953:-8000:0000000000000D6C";
    static final String DT_DOUBLE = "-115-26-95--20--17a78cb8:13718617229:-8000:0000000000000D76";
    static final String DT_INTEGER = "-115-26-95--20--17a78cb8:13718617229:-8000:00000000000019DA";
    static final String DT_UML_INTEGER = "-84-17--56-5-43645a83:11466542d86:-8000:000000000000087C";
    static final String DT_LONG = "-115-26-95--20--17a78cb8:13718617229:-8000:0000000000000D77";
    static final String DT_BOOLEAN = "-115-26-95--20--17a78cb8:13718617229:-8000:00000000000019DB";
    static final String DT_STRING = "-115-26-95--20--17a78cb8:13718617229:-8000:00000000000019DC";
    static final String DT_UML_STRING = "-84-17--56-5-43645a83:11466542d86:-8000:000000000000087E";
    static final String TV_UML_DERIVED = "-64--88-0-101--2259be85:11dd526880c:-8000:000000000000E4A7";
    private XmlGraphUtilities xu;
    private HashMap<String, Vertex> qnMap;
    private HashMap<String, Package> packageMap;
    private HashMap<String, Domain> domainMap;
    private HashMap<String, Domain> profileIdMap;
    private HashMap<String, Vertex> xmiIdMap;
    private SchemaGraph sg;
    private Schema schema;
    private Package defaultPackage;
    private GraphClass graphClass;

    public static void main(String[] args) throws IOException {
        boolean noOutputOptionSelected;
        System.out.println("ArgoUML to TG");
        System.out.println("=========");
        JGraLab.setLogLevel(Level.OFF);
        CommandLine cli = ArgoUml2Tg.processCommandLineOptions(args);
        assert (cli != null) : "No CommandLine object has been generated!";
        File input = new File(cli.getOptionValue('i'));
        ArgoUml2Tg a2tg = new ArgoUml2Tg();
        a2tg.setUseFromRole(cli.hasOption(OPTION_USE_ROLE_NAME));
        a2tg.setRemoveUnusedDomains(cli.hasOption(OPTION_REMOVE_UNUSED_DOMAINS));
        a2tg.setKeepEmptyPackages(cli.hasOption(OPTION_KEEP_EMPTY_PACKAGES));
        a2tg.setUseNavigability(cli.hasOption(OPTION_USE_NAVIGABILITY));
        a2tg.setFilenameSchema(cli.getOptionValue(OPTION_FILENAME_SCHEMA));
        a2tg.setFilenameSchemaGraph(cli.getOptionValue(OPTION_FILENAME_SCHEMA_GRAPH));
        a2tg.setFilenameDot(cli.getOptionValue(OPTION_FILENAME_DOT));
        a2tg.setFilenameValidation(cli.getOptionValue(OPTION_FILENAME_VALIDATION));
        boolean bl = noOutputOptionSelected = !cli.hasOption(OPTION_FILENAME_SCHEMA) && !cli.hasOption(OPTION_FILENAME_SCHEMA_GRAPH) && !cli.hasOption(OPTION_FILENAME_DOT) && !cli.hasOption(OPTION_FILENAME_VALIDATION);
        if (noOutputOptionSelected) {
            System.out.println("No output option has been selected. A TG-file for the Schema will be written.");
            a2tg.setFilenameSchema(ArgoUml2Tg.createFilename(input));
        }
        try {
            a2tg.process(input.getPath());
        }
        catch (Exception e) {
            System.err.println("An Exception occured while processing " + input + ".");
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        System.out.println("Fini.");
    }

    public static CommandLine processCommandLineOptions(String[] args) {
        String toolString = "java " + ArgoUml2Tg.class.getName();
        String versionString = JGraLab.getInfo(false);
        OptionHandler oh = new OptionHandler(toolString, versionString);
        Option validate = new Option(OPTION_FILENAME_VALIDATION, "report", true, "(optional): writes a validation report to the given filename. Free naming, but should look like this: '<filename>.html'");
        validate.setRequired(false);
        validate.setArgName("filename");
        oh.addOption(validate);
        Option export = new Option(OPTION_FILENAME_DOT, "export", true, "(optional): writes a GraphViz DOT file to the given filename. Free naming, but should look like this: '<filename>.dot'");
        export.setRequired(false);
        export.setArgName("filename");
        oh.addOption(export);
        Option schemaGraph = new Option(OPTION_FILENAME_SCHEMA_GRAPH, "schemaGraph", true, "(optional): writes a TG-file of the Schema as graph instance to the given filename. Free naming, but should look like this:  '<filename>.tg'");
        schemaGraph.setRequired(false);
        schemaGraph.setArgName("filename");
        oh.addOption(schemaGraph);
        Option input = new Option("i", "input", true, "(required): UML 1.2-XMI exchange model file of the Schema.");
        input.setRequired(true);
        input.setArgName("filename");
        oh.addOption(input);
        Option output = new Option(OPTION_FILENAME_SCHEMA, "output", true, "(optional): writes a TG-file of the Schema to the given filename. Free naming, but should look like this: '<filename>.argouml.tg.'");
        output.setRequired(false);
        output.setArgName("filename");
        oh.addOption(output);
        Option fromRole = new Option(OPTION_USE_ROLE_NAME, "useFromRole", false, "(optional): if this flag is set, the name of from roles will be used for creating undefined EdgeClass names.");
        fromRole.setRequired(false);
        oh.addOption(fromRole);
        Option unusedDomains = new Option(OPTION_REMOVE_UNUSED_DOMAINS, "removeUnusedDomains", false, "(optional): if this flag is set, all unused domains be deleted.");
        unusedDomains.setRequired(false);
        oh.addOption(unusedDomains);
        Option emptyPackages = new Option(OPTION_KEEP_EMPTY_PACKAGES, "keepEmptyPackages", false, "(optional): if this flag is set, empty packages will be retained.");
        unusedDomains.setRequired(false);
        oh.addOption(emptyPackages);
        Option navigability = new Option(OPTION_USE_NAVIGABILITY, "useNavigability", false, "(optional): if this flag is set, navigability information will be interpreted as reading direction.");
        navigability.setRequired(false);
        oh.addOption(navigability);
        return oh.parse(args);
    }

    public static String createFilename(File file) {
        StringBuilder filenameBuilder = new StringBuilder();
        filenameBuilder.append(file.getParent());
        filenameBuilder.append(File.separatorChar);
        String filename = file.getName();
        int periodePosition = filename.lastIndexOf(46);
        if (periodePosition != -1) {
            filename = filename.substring(0, periodePosition);
        }
        filenameBuilder.append(filename);
        filenameBuilder.append(".argouml.tg");
        return filenameBuilder.toString();
    }

    public ArgoUml2Tg() {
        this.setIgnoreCharacters(false);
        this.addIgnoredElements("XMI.header");
        this.addIdAttributes("*/xmi.id");
        this.addIdRefAttributes("*/xmi.idref");
    }

    @Override
    public void process(String fileName) throws FileNotFoundException, XMLStreamException {
        this.defaultPackage = null;
        this.graphClass = null;
        this.domainMap = new HashMap();
        this.packageMap = new HashMap();
        this.profileIdMap = new HashMap();
        this.qnMap = new HashMap();
        this.xmiIdMap = new HashMap();
        this.schema = null;
        this.sg = null;
        System.out.println("Process " + fileName + "...");
        super.process(fileName);
        this.convertToTg(this.getFilenameSchema());
    }

    private void convertToTg(String filename) {
        this.qnMap = new HashMap();
        this.packageMap = new HashMap();
        this.domainMap = new HashMap();
        this.profileIdMap = new HashMap();
        this.xmiIdMap = new HashMap();
        this.xu = new XmlGraphUtilities(this.getXmlGraph());
        Element model = this.xu.firstChildWithName(this.xu.firstChildWithName(this.xu.getRootElement(), "XMI.content"), "UML:Model");
        String schemaName = this.xu.getAttributeValue(model, "name");
        this.sg = GrumlSchema.instance().createSchemaGraph(ImplementationType.STANDARD, schemaName + "#" + this.xu.getAttributeValue(model, "xmi.id"), 100, 100);
        this.schema = this.sg.createSchema();
        int p = schemaName.lastIndexOf(46);
        if (p == -1) {
            throw new ProcessingException(this.getParser(), this.getFileName(), "A Schema must have a package prefix!\nProcessed qualified name: " + schemaName);
        }
        this.schema.set_name(schemaName.substring(p + 1));
        this.schema.set_packagePrefix(schemaName.substring(0, p));
        this.defaultPackage = this.sg.createPackage();
        this.defaultPackage.set_qualifiedName("");
        this.sg.createContainsDefaultPackage(this.schema, this.defaultPackage);
        this.packageMap.put("", this.defaultPackage);
        this.createPrimitiveDomains();
        this.createEnumDomains();
        this.createRecordDomains();
        this.createGraphClass();
        this.createVertexClasses();
        this.createEdgeClasses();
        this.createGeneralizations();
        this.createCommentsAndConstraints();
        this.removeRedundantGeneralization();
        this.checkAttributes();
        if (this.isRemoveUnusedDomains()) {
            this.removeUnusedDomains();
        }
        this.handlesEmptyPackages();
        if (!this.suppressOutput) {
            try {
                this.writeOutput();
            }
            catch (GraphIOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void checkAttributes() {
        GraphClass graphClass = this.sg.getFirstGraphClass();
        HashMap<String, AttributedElementClass> definedAttributes = new HashMap<String, AttributedElementClass>();
        for (Attribute a : graphClass.get_attributes()) {
            if (definedAttributes.containsKey(a)) {
                throw new RuntimeException("Attribute " + a.get_name() + " at " + graphClass.get_qualifiedName() + " is duplicate.");
            }
            definedAttributes.put(a.get_name(), graphClass);
        }
        for (GraphElementClass gec : this.sg.getGraphElementClassVertices()) {
            boolean isVertexClass = gec.isInstanceOf(VertexClass.VC);
            definedAttributes = new HashMap();
            BooleanGraphMarker alreadyChecked = new BooleanGraphMarker(this.sg);
            LinkedList<GraphElementClass> queue = new LinkedList<GraphElementClass>();
            queue.add(gec);
            while (!queue.isEmpty()) {
                GraphElementClass current = (GraphElementClass)queue.poll();
                if (alreadyChecked.isMarked(current)) continue;
                for (Attribute att : current.get_attributes()) {
                    if (definedAttributes.containsKey(att.get_name())) {
                        AttributedElementClass childClass = (AttributedElementClass)definedAttributes.get(att.get_name());
                        throw new RuntimeException("The name of the " + (childClass == gec && current != gec ? "" : "inherited ") + "attribute " + att.get_name() + " of " + (isVertexClass ? "VertexClass" : "EdgeClass") + " " + childClass.get_qualifiedName() + (current == gec ? " is duplicate" : " is the same name as the inherited attribute of " + (isVertexClass ? "VertexClass" : "EdgeClass") + " " + current.get_qualifiedName()) + ".");
                    }
                    definedAttributes.put(att.get_name(), current);
                }
                alreadyChecked.mark(current);
                for (Edge toSuperClass : current.incidences(isVertexClass ? SpecializesVertexClass.EC : SpecializesEdgeClass.EC, EdgeDirection.OUT)) {
                    GraphElementClass superClass = (GraphElementClass)toSuperClass.getThat();
                    if (alreadyChecked.isMarked(superClass)) continue;
                    queue.add(superClass);
                }
            }
        }
    }

    private void removeRedundantGeneralization() {
        Iterator<GraphElementClass> i$ = this.sg.getGraphElementClassVertices().iterator();
        while (i$.hasNext()) {
            GraphElementClass gec;
            boolean isVertexClass = (gec = i$.next()).isInstanceOf(VertexClass.VC);
            if (gec.getDegree(isVertexClass ? SpecializesVertexClass.EC : SpecializesEdgeClass.EC, EdgeDirection.OUT) <= 1) continue;
            LinkedList<GraphElementClass> queue = new LinkedList<GraphElementClass>();
            IntegerVertexMarker longestDistance = new IntegerVertexMarker(this.sg);
            GraphMarker<Edge> startGeneralization = new GraphMarker<Edge>(this.sg);
            longestDistance.mark(gec, 0);
            Edge spezializesEdgeClass = gec.getFirstIncidence(isVertexClass ? SpecializesVertexClass.EC : SpecializesEdgeClass.EC, EdgeDirection.OUT);
            while (spezializesEdgeClass != null) {
                Edge next = spezializesEdgeClass.getNextIncidence(isVertexClass ? SpecializesVertexClass.EC : SpecializesEdgeClass.EC, EdgeDirection.OUT);
                GraphElementClass directSuperClass = (GraphElementClass)spezializesEdgeClass.getThat();
                if (directSuperClass == this) {
                    spezializesEdgeClass.delete();
                } else if (longestDistance.isMarked(directSuperClass)) {
                    spezializesEdgeClass.delete();
                } else {
                    queue.add(directSuperClass);
                    longestDistance.mark(directSuperClass, 1);
                    startGeneralization.mark(directSuperClass, spezializesEdgeClass);
                }
                spezializesEdgeClass = next;
            }
            while (!queue.isEmpty()) {
                GraphElementClass current = (GraphElementClass)queue.poll();
                Edge toSuperClass = current.getFirstIncidence(isVertexClass ? SpecializesVertexClass.EC : SpecializesEdgeClass.EC, EdgeDirection.OUT);
                int n = longestDistance.get(current) + 1;
                Edge startGen = (Edge)startGeneralization.get(current);
                while (toSuperClass != null) {
                    Edge next = toSuperClass.getNextIncidence(isVertexClass ? SpecializesVertexClass.EC : SpecializesEdgeClass.EC, EdgeDirection.OUT);
                    GraphElementClass superClass = (GraphElementClass)toSuperClass.getThat();
                    if (longestDistance.isMarked(superClass)) {
                        int prevDistance = longestDistance.getMark(superClass);
                        if (n > prevDistance) {
                            queue.add(superClass);
                            longestDistance.mark(superClass, n);
                            startGeneralization.mark(superClass, startGen);
                        }
                    } else {
                        queue.add(superClass);
                        longestDistance.mark(superClass, n);
                        startGeneralization.mark(superClass, startGen);
                    }
                    toSuperClass = next;
                }
            }
            HashSet importantSpecializations = new HashSet();
            for (FunctionEntry functionEntry : startGeneralization) {
                importantSpecializations.add(functionEntry.getSecond());
            }
            spezializesEdgeClass = gec.getFirstIncidence(isVertexClass ? SpecializesVertexClass.EC : SpecializesEdgeClass.EC, EdgeDirection.OUT);
            while (spezializesEdgeClass != null) {
                Edge edge = spezializesEdgeClass.getNextIncidence(isVertexClass ? SpecializesVertexClass.EC : SpecializesEdgeClass.EC, EdgeDirection.OUT);
                if (!importantSpecializations.contains(spezializesEdgeClass)) {
                    spezializesEdgeClass.delete();
                }
                spezializesEdgeClass = edge;
            }
        }
    }

    private void removeUnusedDomains() {
        System.out.println("Removing unused domains...");
        Domain d = this.sg.getFirstDomain();
        while (d != null) {
            Domain n = d.getNextDomain();
            if (d.getDegree(EdgeDirection.IN) - d.getDegree(Annotates.EC, EdgeDirection.IN) <= 1) {
                this.logger.fine("...remove unused domain '" + d.get_qualifiedName() + "'");
                List<? extends Comment> comments = d.remove_comments();
                for (Comment comment : comments) {
                    comment.delete();
                }
                d.delete();
                d = this.sg.getFirstDomain();
                continue;
            }
            d = n;
        }
    }

    public void writeOutput() throws GraphIOException {
        boolean fileCreated = false;
        if (this.filenameDot != null) {
            try {
                this.printTypeAndFilename("GraphvViz DOT file", this.filenameDot);
                this.writeDotFile(this.filenameDot);
                fileCreated = true;
            }
            catch (IOException e) {
                System.out.println("Could not create DOT file.");
                System.out.println("Exception was " + e);
            }
        }
        if (this.filenameSchemaGraph != null) {
            this.printTypeAndFilename("schemagraph", this.filenameSchemaGraph);
            this.writeSchemaGraph(this.filenameSchemaGraph);
            fileCreated = true;
        }
        this.validateGraph(this.filenameValidation);
        if (this.filenameValidation != null) {
            fileCreated = true;
        }
        if (this.filenameSchema != null) {
            this.printTypeAndFilename("schema", this.filenameSchema);
            this.writeSchema(this.filenameSchema);
            fileCreated = true;
        }
        if (!fileCreated) {
            System.out.println("No files have been created.");
        }
    }

    private void writeDotFile(String dotName) throws IOException {
        Tg2Dot tg2Dot = new Tg2Dot();
        tg2Dot.setGraph(this.sg);
        tg2Dot.setPrintEdgeAttributes(true);
        tg2Dot.setOutputFile(dotName);
        tg2Dot.convert();
    }

    private void writeSchemaGraph(String schemaGraphName) throws GraphIOException {
        this.sg.save(schemaGraphName);
    }

    private void writeSchema(String schemaName) {
        try {
            SchemaGraph2Tg sg2tg = new SchemaGraph2Tg(this.sg, schemaName);
            sg2tg.process();
        }
        catch (IOException e) {
            throw new RuntimeException("SchemaGraph2Tg failed with an IOException!", e);
        }
    }

    private void printTypeAndFilename(String type, String filename) {
        System.out.println("Writing " + type + " to: " + filename);
    }

    private boolean validateGraph(String filePath) {
        if (filePath != null) {
            this.printTypeAndFilename("validation report", filePath);
        }
        System.out.println("Validate schema graph...");
        GraphValidator gv = new GraphValidator(this.sg);
        SortedSet<ConstraintViolation> violations = gv.validate();
        if (violations.size() > 0) {
            try {
                System.out.println("Schema graph is invalid. Please look at " + filePath);
                gv.createValidationReport(filePath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    private void handlesEmptyPackages() {
        if (!this.isKeepEmptyPackages()) {
            System.out.println("Remove empty packages...");
            Package p = this.sg.getFirstPackage();
            int removed = 0;
            while (p != null) {
                Package n = p.getNextPackage();
                int commentCount = p.getDegree(Annotates.EC);
                if (p.getDegree() - commentCount == 1 && p.get_qualifiedName().length() > 0) {
                    this.logger.fine("\t- empty package '" + p.get_qualifiedName() + "' removed" + (commentCount > 0 ? (commentCount == 1 ? " including 1 comment" : " including " + commentCount + " comments") : ""));
                    if (commentCount > 0) {
                        Annotates a = p.getFirstAnnotatesIncidence();
                        while (a != null) {
                            a.getThat().delete();
                            a = p.getFirstAnnotatesIncidence();
                        }
                    }
                    p.delete();
                    ++removed;
                    p = this.sg.getFirstPackage();
                    continue;
                }
                p = n;
            }
            this.logger.fine("Removed " + removed + " package" + (removed == 1 ? "" : OPTION_FILENAME_SCHEMA_GRAPH) + ".");
        } else {
            System.out.println("Create empty packages...");
            for (Element el : this.xu.elementsWithName("UML:Package")) {
                String qn = this.getQualifiedName(el, false);
                if (!this.packageMap.containsKey(qn)) {
                    this.logger.fine("Created empty package " + qn + ".");
                }
                this.getPackage(qn);
            }
        }
    }

    private void createCommentsAndConstraints() {
        for (Element el : this.xu.elementsWithName("UML:Comment")) {
            if (!this.xu.hasAttribute(el, "body")) continue;
            NamedElement annotatedNamedElement = null;
            Element annotatedElement = this.xu.firstChildWithName(el, "UML:Comment.annotatedElement");
            if (annotatedElement == null) {
                annotatedNamedElement = this.graphClass;
            } else {
                assert (annotatedElement.getDegree(HasChild.EC, EdgeDirection.OUT) == 1);
                annotatedElement = (Element)annotatedElement.getFirstHasChildIncidence(EdgeDirection.OUT).getThat();
                assert (annotatedElement.get_name().equals("UML:Class") || annotatedElement.get_name().equals("UML:AssociationClass") || annotatedElement.get_name().equals("UML:Association") || annotatedElement.get_name().equals("UML:Enumeration") || annotatedElement.get_name().equals("UML:Package"));
                annotatedElement = this.xu.getReferencedElement(annotatedElement, "xmi.idref");
                assert (annotatedElement != null);
                String qn = this.getQualifiedName(annotatedElement, !annotatedElement.get_name().equals("UML:Package"));
                annotatedNamedElement = (NamedElement)this.qnMap.get(qn);
                if (annotatedNamedElement == null) {
                    annotatedNamedElement = this.graphClass;
                }
            }
            String commentContent = this.xu.getAttributeValue(el, "body");
            if (annotatedNamedElement.isInstanceOf(AttributedElementClass.VC) && this.addGreqlConstraint((AttributedElementClass)annotatedNamedElement, commentContent)) continue;
            Comment comment = this.sg.createComment();
            comment.set_text(commentContent);
            this.sg.createAnnotates(comment, annotatedNamedElement);
        }
    }

    private boolean addGreqlConstraint(AttributedElementClass constrainedClass, String text) {
        if (!(text = text.trim()).startsWith("{") || !text.endsWith("}")) {
            return false;
        }
        text = text.substring(1, text.length() - 1).trim();
        assert (constrainedClass != null);
        Constraint constraint = this.sg.createConstraint();
        int stringCount = 0;
        char[] ch = text.toCharArray();
        boolean inString = false;
        boolean escape = false;
        int beginIndex = 0;
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            if (inString) {
                if (c == '\\') {
                    escape = true;
                    continue;
                }
                if (!escape && c == '\"') {
                    ++stringCount;
                    String constraintText = text.substring(beginIndex + 1, i).trim().replaceAll("\\\\(.)", "$1");
                    if (constraintText.isEmpty()) {
                        constraintText = null;
                    }
                    switch (stringCount) {
                        case 1: {
                            constraint.set_message(constraintText);
                            break;
                        }
                        case 2: {
                            constraint.set_predicateQuery(constraintText);
                            break;
                        }
                        case 3: {
                            constraint.set_offendingElementsQuery(constraintText);
                            break;
                        }
                        default: {
                            constraint.delete();
                            return false;
                        }
                    }
                    inString = false;
                    continue;
                }
                if (!escape || c != '\"') continue;
                escape = false;
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            if (c == '\"') {
                inString = true;
                beginIndex = i;
                continue;
            }
            constraint.delete();
            return false;
        }
        if (inString || escape || stringCount < 2 || stringCount > 3) {
            constraint.delete();
            return false;
        }
        this.sg.createHasConstraint(constrainedClass, constraint);
        return true;
    }

    private void createGeneralizations() {
        this.logger.fine("Creating generalization:");
        for (Element el : this.xu.elementsWithName("UML:Generalization")) {
            if (!this.xu.hasAttribute(el, "xmi.id")) continue;
            Element child = this.xu.firstChildWithName(el, "UML:Generalization.child");
            Element e = this.xu.firstChildWithName(child, "UML:Class");
            if (e == null) {
                e = this.xu.firstChildWithName(child, "UML:Association");
            }
            if (e == null) {
                e = this.xu.firstChildWithName(child, "UML:AssociationClass");
            }
            if (e == null) {
                throw new RuntimeException("Unexpected Generalization child " + el);
            }
            child = e;
            Vertex cv = this.xmiIdMap.get(this.xu.getAttributeValue(child, "xmi.idref"));
            assert (cv != null);
            Element parent = this.xu.firstChildWithName(el, "UML:Generalization.parent");
            e = this.xu.firstChildWithName(parent, "UML:Class");
            if (e == null) {
                e = this.xu.firstChildWithName(parent, "UML:Association");
            }
            if (e == null) {
                e = this.xu.firstChildWithName(parent, "UML:AssociationClass");
            }
            if (e == null) {
                throw new RuntimeException("Unexpected Generalization parent " + el);
            }
            parent = e;
            Vertex pv = this.xmiIdMap.get(this.xu.getAttributeValue(parent, "xmi.idref"));
            assert (pv != null);
            assert (cv.getAttributedElementClass() == pv.getAttributedElementClass());
            if (pv.isInstanceOf(VertexClass.VC)) {
                this.sg.createSpecializesVertexClass((VertexClass)cv, (VertexClass)pv);
                this.logger.fine("\t" + ((VertexClass)cv).get_qualifiedName() + ": " + ((VertexClass)pv).get_qualifiedName());
                continue;
            }
            if (pv.isInstanceOf(EdgeClass.VC)) {
                this.logger.fine("\t" + ((EdgeClass)cv).get_qualifiedName() + ": " + ((EdgeClass)pv).get_qualifiedName());
                EdgeClass sub = (EdgeClass)cv;
                EdgeClass sup = (EdgeClass)pv;
                this.sg.createSpecializesEdgeClass(sub, sup);
                continue;
            }
            throw new RuntimeException("Unexpected generalization between " + pv.getSchemaClass().getName() + " vertices.");
        }
    }

    private void createGraphClass() {
        for (Element el : this.xu.elementsWithName("UML:Class")) {
            if (!this.hasStereotype(el, ST_GRAPHCLASS)) continue;
            assert (!this.hasStereotype(el, ST_ABSTRACT));
            assert (!this.hasStereotype(el, ST_RECORD));
            if (this.graphClass != null) {
                throw new RuntimeException("Multiple classes marked with <<graphclass>>, only one is allowed. Offending element: " + el + " (name=" + this.xu.getAttributeValue(el, "name") + ")");
            }
            this.graphClass = this.sg.createGraphClass();
            this.sg.createDefinesGraphClass(this.schema, this.graphClass);
            this.graphClass.set_qualifiedName(this.xu.getAttributeValue(el, "name", true));
            this.qnMap.put(this.graphClass.get_qualifiedName(), this.graphClass);
            this.xmiIdMap.put(this.xu.getAttributeValue(el, "xmi.id"), this.graphClass);
            this.logger.fine("GraphClass " + this.graphClass.get_qualifiedName());
            this.createAttributes(el, this.graphClass);
        }
    }

    private void createEdgeClasses() {
        for (Element el : this.xu.elementsWithName("UML:Association")) {
            if (!this.xu.hasAttribute(el, "xmi.id") || this.isDerived(el)) continue;
            this.createEdgeClass(el);
        }
        for (Element el : this.xu.elementsWithName("UML:AssociationClass")) {
            if (!this.xu.hasAttribute(el, "xmi.id") || this.isDerived(el)) continue;
            this.createEdgeClass(el);
        }
    }

    private void createEdgeClass(Element el) {
        Package pkg = this.getPackage(this.getPackageName(el));
        String qn = this.getQualifiedName(el, true);
        assert (qn != null && !qn.isEmpty()) : "The EdgeClass " + this.xu.getAttributeValue(el, "xmi.id") + " must have a name.";
        String name = this.xu.getAttributeValue(el, "name", true);
        if (name.length() == 0) {
            name = null;
        }
        boolean isAbstract = this.hasStereotype(el, ST_ABSTRACT) || this.xu.hasAttribute(el, "isAbstract") && this.xu.getAttributeValue(el, "isAbstract").equals("true");
        this.logger.fine((isAbstract ? "abstract " : "") + "EdgeClass " + (name != null ? qn : "<<name will be generated>>"));
        EdgeClass ec = this.sg.createEdgeClass();
        ec.set_abstract(isAbstract);
        this.sg.createContainsGraphElementClass(pkg, ec);
        this.createAttributes(el, ec);
        Element conn = this.xu.firstChildWithName(el, "UML:Association.connection");
        assert (conn != null);
        Iterator<Element> it = this.xu.childrenWithName(conn, "UML:AssociationEnd").iterator();
        assert (it.hasNext());
        Element from = it.next();
        IncidenceClass icFrom = this.createIncidenceClass(from);
        assert (it.hasNext());
        Element to = it.next();
        IncidenceClass icTo = this.createIncidenceClass(to);
        if (this.useNavigability) {
            boolean tn;
            boolean fn = this.xu.hasAttribute(from, "isNavigable") && this.xu.getAttributeValue(from, "isNavigable").equals("true");
            boolean bl = tn = this.xu.hasAttribute(to, "isNavigable") && this.xu.getAttributeValue(to, "isNavigable").equals("true");
            if (fn && !tn) {
                IncidenceClass tmp = icFrom;
                icFrom = icTo;
                icTo = tmp;
            }
        }
        AggregationKind tmp = icFrom.get_aggregation();
        icFrom.set_aggregation(icTo.get_aggregation());
        icTo.set_aggregation(tmp);
        ec.add_from(icFrom);
        ec.add_to(icTo);
        if (name == null) {
            String toRole = icTo.get_roleName();
            if (toRole == null || toRole.equals("")) {
                toRole = ((VertexClass)icTo.getFirstEndsAtIncidence().getThat()).get_qualifiedName();
                int p = toRole.lastIndexOf(46);
                if (p >= 0) {
                    toRole = toRole.substring(p + 1);
                }
            } else {
                toRole = Character.toUpperCase(toRole.charAt(0)) + toRole.substring(1);
            }
            if (toRole == null || toRole.length() <= 0) {
                throw new RuntimeException("Undefined 'to' role name for EdgeClass " + ec);
            }
            name = icFrom.get_aggregation() != AggregationKind.NONE || icTo.get_aggregation() != AggregationKind.NONE ? (icTo.get_aggregation() != AggregationKind.NONE ? "Contains" + toRole : "IsPartOf" + toRole) : "LinksTo" + toRole;
            if (this.useFromRole) {
                String fromRole = icFrom.get_roleName();
                if (fromRole == null || fromRole.equals("")) {
                    fromRole = ((VertexClass)icFrom.getFirstEndsAtIncidence().getThat()).get_qualifiedName();
                    int p = fromRole.lastIndexOf(46);
                    if (p >= 0) {
                        fromRole = fromRole.substring(p + 1);
                    }
                } else {
                    fromRole = Character.toUpperCase(fromRole.charAt(0)) + fromRole.substring(1);
                }
                if (fromRole == null || fromRole.length() == 0) {
                    throw new RuntimeException("Undefined 'from' role name for EdgeClass " + ec);
                }
                name = fromRole + name;
            }
            qn = pkg.get_qualifiedName() + "." + name;
        }
        ec.set_qualifiedName(qn);
        assert (this.qnMap.get(qn) == null) : "There already exists an EdgeClass with name: " + qn;
        this.qnMap.put(qn, ec);
        this.xmiIdMap.put(this.xu.getAttributeValue(el, "xmi.id"), ec);
    }

    private IncidenceClass createIncidenceClass(Element associationEnd) {
        IncidenceClass ic = this.sg.createIncidenceClass();
        String role = this.xu.hasAttribute(associationEnd, "name") ? this.xu.getAttributeValue(associationEnd, "name") : "";
        ic.set_roleName(role.trim());
        String aggregation = this.xu.getAttributeValue(associationEnd, "aggregation");
        if (aggregation.equals("none")) {
            ic.set_aggregation(AggregationKind.NONE);
        } else if (aggregation.equals("aggregate")) {
            ic.set_aggregation(AggregationKind.SHARED);
        } else if (aggregation.equals("composite")) {
            ic.set_aggregation(AggregationKind.COMPOSITE);
        } else {
            throw new RuntimeException("Unexpected aggregation value '" + aggregation + "'");
        }
        int min = 0;
        int max = Integer.MAX_VALUE;
        Element mult = this.xu.firstChildWithName(associationEnd, "UML:AssociationEnd.multiplicity");
        if (mult != null) {
            mult = this.xu.firstChildWithName(mult, "UML:Multiplicity");
        }
        if (mult != null) {
            mult = this.xu.firstChildWithName(mult, "UML:Multiplicity.range");
        }
        if (mult != null) {
            mult = this.xu.firstChildWithName(mult, "UML:MultiplicityRange");
        }
        if (mult != null) {
            min = Integer.parseInt(this.xu.getAttributeValue(mult, "lower"));
            max = Integer.parseInt(this.xu.getAttributeValue(mult, "upper"));
            if (max < 0) {
                max = Integer.MAX_VALUE;
            }
        }
        ic.set_min(min);
        ic.set_max(max);
        Element participant = this.xu.firstChildWithName(associationEnd, "UML:AssociationEnd.participant");
        assert (participant != null);
        VertexClass vc = (VertexClass)this.xmiIdMap.get(this.xu.getAttributeValue(this.xu.firstChildWithName(participant, "UML:Class"), "xmi.idref"));
        ic.add_targetclass(vc);
        this.checkMultiplicities(ic);
        return ic;
    }

    private void checkMultiplicities(IncidenceClass inc) {
        int min = inc.get_min();
        int max = inc.get_max();
        assert (min >= 0);
        assert (max > 0);
        if (min == Integer.MAX_VALUE) {
            throw new ProcessingException(this.getFileName(), "Error in multiplicities: lower bound must not be * at association end " + inc);
        }
        if (min > max) {
            throw new ProcessingException(this.getFileName(), "Error in multiplicities: lower bound (" + min + ") must be <= upper bound (" + max + ") at association end " + inc);
        }
    }

    private void createVertexClasses() {
        for (Element el : this.xu.elementsWithName("UML:Class")) {
            if (!this.xu.hasAttribute(el, "name") || this.hasStereotype(el, ST_RECORD) || this.hasStereotype(el, ST_GRAPHCLASS) || this.isDerived(el)) continue;
            boolean isAbstract = this.hasStereotype(el, ST_ABSTRACT) || this.xu.hasAttribute(el, "isAbstract") && this.xu.getAttributeValue(el, "isAbstract").equals("true");
            Package pkg = this.getPackage(this.getPackageName(el));
            String qn = this.getQualifiedName(el, true);
            assert (qn != null && !qn.isEmpty()) : "The VertexClass " + this.xu.getAttributeValue(el, "xmi.id") + " must have a name.";
            assert (this.qnMap.get(qn) == null);
            this.logger.fine((isAbstract ? "abstract " : "") + "VertexClass " + qn);
            VertexClass vc = this.sg.createVertexClass();
            vc.set_qualifiedName(qn);
            vc.set_abstract(isAbstract);
            this.sg.createContainsGraphElementClass(pkg, vc);
            this.qnMap.put(qn, vc);
            this.xmiIdMap.put(this.xu.getAttributeValue(el, "xmi.id"), vc);
            this.createAttributes(el, vc);
        }
    }

    private void createAttributes(Element el, AttributedElementClass aec) {
        Element sf = this.xu.firstChildWithName(el, "UML:Classifier.feature");
        if (sf != null) {
            for (Element at : this.xu.childrenWithName(sf, "UML:Attribute")) {
                if (this.isDerived(at)) continue;
                Domain dom = this.getAttributeDomain(at);
                assert (dom != null);
                this.logger.fine("\t" + this.xu.getAttributeValue(at, "name") + ": " + dom.get_qualifiedName());
                Attribute attr = this.sg.createAttribute();
                attr.set_name(this.xu.getAttributeValue(at, "name"));
                attr.set_defaultValue(this.getDefaultValue(at, dom));
                attr.add_domain(dom);
                aec.add_attributes(attr);
            }
        }
    }

    private boolean isDerived(Element element) {
        Element modelElementTaggedValue = this.xu.firstChildWithName(element, "UML:ModelElement.taggedValue");
        if (modelElementTaggedValue == null) {
            return false;
        }
        for (Element taggedValue : this.xu.childrenWithName(modelElementTaggedValue, "UML:TaggedValue")) {
            Element taggedValueType = this.xu.firstChildWithName(taggedValue, "UML:TaggedValue.type");
            Element tagDefinition = this.xu.firstChildWithName(taggedValueType, "UML:TagDefinition");
            if (!this.xu.getAttributeValue(tagDefinition, "href").endsWith("#-64--88-0-101--2259be85:11dd526880c:-8000:000000000000E4A7")) continue;
            Element taggedValueDataValue = this.xu.firstChildWithName(taggedValue, "UML:TaggedValue.dataValue");
            return !this.xu.getText(taggedValueDataValue).equals("false");
        }
        return false;
    }

    private String getDefaultValue(Element attribute, Domain domain) {
        Element defaultValue = this.xu.firstChildWithName(attribute, "UML:Attribute.initialValue");
        if (defaultValue == null) {
            return null;
        }
        Element defaultValueExpression = this.xu.firstChildWithName(defaultValue, "UML:Expression");
        assert (defaultValueExpression != null);
        String value = this.xu.getAttributeValue(defaultValueExpression, "body");
        if (value != null) {
            if (domain.isInstanceOf(BooleanDomain.VC) && (value.equals("true") || value.equals("false"))) {
                value = value.substring(0, 1);
            }
            if (value.equals("null")) {
                value = OPTION_USE_NAVIGABILITY;
            }
        }
        return value;
    }

    private void createRecordDomains() {
        for (Element el : this.xu.elementsWithName("UML:Class")) {
            if (!this.hasStereotype(el, ST_RECORD)) continue;
            assert (!this.hasStereotype(el, ST_GRAPHCLASS));
            assert (!this.hasStereotype(el, ST_ABSTRACT));
            Package pkg = this.getPackage(this.getPackageName(el));
            String qn = this.getQualifiedName(el, true);
            assert (qn != null && !qn.isEmpty()) : "The RecordDomain " + this.xu.getAttributeValue(el, "xmi.id") + " must have a name.";
            RecordDomain rd = (RecordDomain)this.domainMap.get(qn);
            if (rd == null) {
                assert (this.qnMap.get(qn) == null);
                rd = this.sg.createRecordDomain();
                rd.set_qualifiedName(qn);
                this.sg.createContainsDomain(pkg, rd);
                this.qnMap.put(qn, rd);
                this.domainMap.put(qn, rd);
                this.xmiIdMap.put(this.xu.getAttributeValue(el, "xmi.id"), rd);
            }
            this.logger.fine("RecordDomain " + qn);
            Element sf = this.xu.firstChildWithName(el, "UML:Classifier.feature");
            if (sf == null) continue;
            for (Element at : this.xu.childrenWithName(sf, "UML:Attribute")) {
                this.logger.fine("\t" + this.xu.getAttributeValue(at, "name"));
                Domain dom = this.getAttributeDomain(at);
                assert (dom != null);
                HasRecordDomainComponent c = this.sg.createHasRecordDomainComponent(rd, dom);
                c.set_name(this.xu.getAttributeValue(at, "name"));
            }
        }
    }

    private Domain getAttributeDomain(Element attr) {
        Element type = this.xu.firstChildWithName(attr, "UML:StructuralFeature.type");
        assert (type != null);
        Element dt = this.xu.firstChildWithName(type, "UML:DataType");
        if (dt != null) {
            if (this.xu.hasAttribute(dt, "xmi.idref")) {
                Element dom = this.xu.getReferencedElement(dt, "xmi.idref");
                return this.createCompositeDomain(this.xu.getAttributeValue(dom, "name"));
            }
            if (this.xu.hasAttribute(dt, "href")) {
                return this.getPrimitiveDomainByProfileId(this.xu.getAttributeValue(dt, "href"));
            }
            throw new RuntimeException("FIXME: Unhandled UML:DataType");
        }
        dt = this.xu.firstChildWithName(type, "UML:Enumeration");
        if (dt != null) {
            return (Domain)this.xmiIdMap.get(this.xu.getAttributeValue(dt, "xmi.idref"));
        }
        dt = this.xu.firstChildWithName(type, "UML:Class");
        if (dt != null) {
            Vertex v = this.xmiIdMap.get(this.xu.getAttributeValue(dt, "xmi.idref"));
            if (v != null) {
                assert (v.isInstanceOf(RecordDomain.VC));
                return (Domain)v;
            }
            Element el = this.xu.getReferencedElement(dt, "xmi.idref");
            assert (el.get_name().equals("UML:Class") && this.hasStereotype(el, ST_RECORD) && !this.hasStereotype(el, ST_ABSTRACT) && !this.hasStereotype(el, ST_GRAPHCLASS)) : dt;
            Package pkg = this.getPackage(this.getPackageName(el));
            String qn = this.getQualifiedName(el, true);
            assert (qn != null && !qn.isEmpty()) : "The domain of attribute " + this.xu.getAttributeValue(el, "xmi.id") + " must have a name.";
            RecordDomain rd = this.sg.createRecordDomain();
            rd.set_qualifiedName(qn);
            this.domainMap.put(qn, rd);
            this.qnMap.put(qn, rd);
            this.xmiIdMap.put(this.xu.getAttributeValue(el, "xmi.id"), rd);
            this.sg.createContainsDomain(pkg, rd);
            return rd;
        }
        throw new RuntimeException("FIXME: Unhandled UML:DataType");
    }

    private Domain createCompositeDomain(String name) {
        Domain dom = this.domainMap.get(name = name.trim().replaceAll("\\s+", ""));
        if (dom != null) {
            return dom;
        }
        this.logger.fine("CompositeDomain " + name);
        if (name.startsWith("Map<")) {
            int p;
            MapDomain md = this.sg.createMapDomain();
            dom = md;
            int b = 0;
            for (p = 4; p < name.length(); ++p) {
                char c = name.charAt(p);
                if (b == 0 && c == ',') break;
                if (c == '<') {
                    ++b;
                    continue;
                }
                if (c != '>') continue;
                --b;
            }
            String keyName = name.substring(4, p);
            String valName = name.substring(p + 1, name.length() - 1);
            md.add_keydomain(this.createCompositeDomain(keyName));
            md.add_valuedomain(this.createCompositeDomain(valName));
        } else if (name.startsWith("List<")) {
            ListDomain ld = this.sg.createListDomain();
            dom = ld;
            String compName = name.substring(5, name.length() - 1);
            ld.add_basedomain(this.createCompositeDomain(compName));
        } else if (name.startsWith("Set<")) {
            SetDomain sd = this.sg.createSetDomain();
            dom = sd;
            String compName = name.substring(4, name.length() - 1);
            sd.add_basedomain(this.createCompositeDomain(compName));
        } else {
            throw new RuntimeException("Unknown domain name '" + name + "'");
        }
        dom.set_qualifiedName(name.replaceAll(",", ", "));
        this.domainMap.put(name, dom);
        this.sg.createContainsDomain(this.defaultPackage, dom);
        return dom;
    }

    private Domain getPrimitiveDomainByProfileId(String href) {
        int p = href.indexOf(35);
        if (p >= 0) {
            href = href.substring(p + 1);
        }
        return this.profileIdMap.get(href);
    }

    private boolean hasStereotype(Element el, String st_id) {
        Element st = this.xu.firstChildWithName(el, "UML:ModelElement.stereotype");
        if (st == null) {
            return false;
        }
        st = this.xu.firstChildWithName(st, "UML:Stereotype");
        return this.xu.getAttributeValue(st, "href").endsWith("#" + st_id);
    }

    private void createPrimitiveDomains() {
        this.createPrimitiveDomain(this.sg.createBooleanDomain(), "Boolean", DT_BOOLEAN);
        this.createPrimitiveDomain(this.sg.createIntegerDomain(), "Integer", DT_INTEGER, DT_UML_INTEGER);
        this.createPrimitiveDomain(this.sg.createLongDomain(), "Long", DT_LONG);
        this.createPrimitiveDomain(this.sg.createDoubleDomain(), "Double", DT_DOUBLE);
        this.createPrimitiveDomain(this.sg.createStringDomain(), "String", DT_STRING, DT_UML_STRING);
    }

    private void createPrimitiveDomain(Domain d, String qn, String ... profileIds) {
        this.logger.fine("PrimitiveDomain " + qn);
        d.set_qualifiedName(qn);
        this.sg.createContainsDomain(this.packageMap.get(""), d);
        for (String id : profileIds) {
            this.profileIdMap.put(id, d);
        }
        this.domainMap.put(qn, d);
        this.qnMap.put(qn, d);
    }

    private void createEnumDomains() {
        for (Element el : this.xu.elementsWithName("UML:Enumeration")) {
            if (!this.xu.hasAttribute(el, "xmi.id")) continue;
            String qn = this.getQualifiedName(el, true);
            assert (qn != null && !qn.isEmpty()) : "The EnumDomain " + this.xu.getAttributeValue(el, "xmi.id") + " must have a name.";
            assert (this.qnMap.get(qn) == null);
            this.logger.fine("EnumDomain " + qn);
            EnumDomain ed = this.sg.createEnumDomain();
            ed.set_qualifiedName(qn);
            this.domainMap.put(qn, ed);
            this.qnMap.put(qn, ed);
            this.xmiIdMap.put(this.xu.getAttributeValue(el, "xmi.id"), ed);
            this.sg.createContainsDomain(this.getPackage(this.getPackageName(el)), ed);
            Element literals = this.xu.firstChildWithName(el, "UML:Enumeration.literal");
            PVector<String> constants = JGraLab.vector();
            for (Element enumLiteral : this.xu.childrenWithName(literals, "UML:EnumerationLiteral")) {
                String cn = this.xu.getAttributeValue(enumLiteral, "name");
                this.logger.fine("\t" + cn);
                constants = constants.plus(cn);
            }
            ed.set_enumConstants(constants);
        }
    }

    private String getQualifiedName(Element el, boolean upperCaseFirstLetter) {
        String pkgName = this.getPackageName(el);
        Package pkg = this.getPackage(pkgName);
        String name = this.xu.getAttributeValue(el, "name", upperCaseFirstLetter);
        return pkg == this.defaultPackage ? name : pkg.get_qualifiedName() + "." + name;
    }

    private Package getPackage(String qn) {
        Package pkg = this.packageMap.get(qn);
        if (pkg == null) {
            if (qn.length() == 0) {
                pkg = this.packageMap.get("");
            } else {
                pkg = this.sg.createPackage();
                pkg.set_qualifiedName(qn);
                int p = qn.lastIndexOf(46);
                Package parentPackage = this.getPackage(p < 0 ? "" : qn.substring(0, p));
                parentPackage.add_subpackages(pkg);
                this.packageMap.put(qn, pkg);
                this.qnMap.put(qn, pkg);
            }
        }
        return pkg;
    }

    private String getPackageName(Element el) {
        String result = "";
        for (el = el.get_parent(); el != null; el = el.get_parent()) {
            if (!el.get_name().equals("UML:Package")) continue;
            result = result.length() == 0 ? this.xu.getAttributeValue(el, "name") : this.xu.getAttributeValue(el, "name") + "." + result;
        }
        return result;
    }

    public void setUseFromRole(boolean useFromRole) {
        this.useFromRole = useFromRole;
    }

    public boolean isUseFromRole() {
        return this.useFromRole;
    }

    public void setRemoveUnusedDomains(boolean removeUnusedDomains) {
        this.removeUnusedDomains = removeUnusedDomains;
    }

    public boolean isRemoveUnusedDomains() {
        return this.removeUnusedDomains;
    }

    public void setUseNavigability(boolean useNavigability) {
        this.useNavigability = useNavigability;
    }

    public boolean isUseNavigability() {
        return this.useNavigability;
    }

    public SchemaGraph getSchemaGraph() {
        return this.sg;
    }

    public void setSuppressOutput(boolean suppressOutput) {
        this.suppressOutput = suppressOutput;
    }

    public String getFilenameSchema() {
        return this.filenameSchema;
    }

    public void setFilenameSchema(String filenameSchema) {
        this.filenameSchema = filenameSchema;
    }

    public String getFilenameSchemaGraph() {
        return this.filenameSchemaGraph;
    }

    public void setFilenameSchemaGraph(String filenameSchemaGraph) {
        this.filenameSchemaGraph = filenameSchemaGraph;
    }

    public String getFilenameDot() {
        return this.filenameDot;
    }

    public void setFilenameDot(String filenameDot) {
        this.filenameDot = filenameDot;
    }

    public String getFilenameValidation() {
        return this.filenameValidation;
    }

    public void setFilenameValidation(String filenameValidation) {
        this.filenameValidation = filenameValidation;
    }

    public boolean isKeepEmptyPackages() {
        return this.keepEmptyPackages;
    }

    public void setKeepEmptyPackages(boolean removeEmptyPackages) {
        this.keepEmptyPackages = removeEmptyPackages;
    }
}

