/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.csv2tg;

import de.uni_koblenz.ist.utilities.csvreader.CsvReader;
import de.uni_koblenz.ist.utilities.option_handler.OptionHandler;
import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.exception.NoSuchAttributeException;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import de.uni_koblenz.jgralab.schema.impl.compilation.SchemaClassManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class Csv2Tg
implements FilenameFilter {
    private static final String CLI_OPTION_OUTPUT_FILE = "output";
    private static final String CLI_OPTION_CSV_FILES = "input";
    private static final String CLI_OPTION_SCHEMA = "schema";
    private static final Object COMMENT_STRING = "#";
    private Schema schema;
    private String[] csvFiles;
    private Map<VertexClass, CsvReader> vertexInstances;
    private Map<EdgeClass, CsvReader> edgeInstances;
    private Map<CsvReader, String> reader2FilenameMap;
    private CsvReader currentReader;
    private String outputFile;
    private Graph graph;
    private Map<String, Vertex> vertices;

    public static void main(String[] args) throws GraphIOException {
        Csv2Tg converter = new Csv2Tg();
        converter.getOptions(args);
        converter.process();
        System.out.println("Fini.");
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    protected final CommandLine processCommandLineOptions(String[] args) {
        OptionHandler oh = this.createOptionHandler();
        return oh.parse(args);
    }

    protected void getOptions(String[] args) throws GraphIOException {
        CommandLine comLine = this.processCommandLineOptions(args);
        assert (comLine != null);
        this.setSchema(comLine.getOptionValue(CLI_OPTION_SCHEMA));
        this.setCsvFiles(comLine.getOptionValues(CLI_OPTION_CSV_FILES));
        this.setOutputFile(comLine.getOptionValue(CLI_OPTION_OUTPUT_FILE));
    }

    private void setSchema(String filename) throws GraphIOException {
        System.out.print("Loading Schema ... ");
        Schema schema = GraphIO.loadSchemaFromFile(filename);
        if (!this.isCompiled(schema)) {
            System.out.print("compiling ... ");
            schema.compile(CodeGeneratorConfiguration.MINIMAL);
        }
        this.setSchema(schema);
        System.out.println("done.");
    }

    private boolean isCompiled(Schema schema) {
        try {
            Class.forName(schema.getQualifiedName(), true, SchemaClassManager.instance(schema.getQualifiedName()));
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
        return true;
    }

    protected final OptionHandler createOptionHandler() {
        String toolString = "java " + this.getClass().getName();
        String versionString = JGraLab.getInfo(false);
        OptionHandler oh = new OptionHandler(toolString, versionString);
        Option schema = new Option("s", CLI_OPTION_SCHEMA, true, "(required): the schema according to which the graph should be constructed.");
        schema.setRequired(true);
        schema.setArgName("file");
        oh.addOption(schema);
        Option csvFiles = new Option("i", CLI_OPTION_CSV_FILES, true, "(required): set of csv-file containing vertex / edge instance informations.");
        csvFiles.setRequired(true);
        csvFiles.setArgs(-2);
        csvFiles.setArgName("files_or_folder");
        csvFiles.setValueSeparator(' ');
        oh.addOption(csvFiles);
        Option output = new Option("o", CLI_OPTION_OUTPUT_FILE, true, "(required): the output file name, or empty for stdout");
        output.setRequired(true);
        output.setArgName("file");
        oh.addOption(output);
        return oh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        this.setUp();
        try {
            this.loadCsvFiles();
            this.processVertexFiles();
            this.processEdgeFiles();
            System.out.println("Finished Processing.");
            System.out.print("Saving Graph ...");
            GraphIO.saveGraphToFile(this.graph, this.outputFile, null);
            System.out.print("done.");
        }
        catch (NoSuchAttributeException e) {
            e.printStackTrace();
        }
        catch (GraphIOException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("An error occured while processing " + this.currentReader.getLineNumber() + " in file \"" + this.reader2FilenameMap.get(this.currentReader) + "\".");
            e.printStackTrace();
        }
        finally {
            try {
                this.tearDown();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void setUp() {
        this.vertices = new HashMap<String, Vertex>();
        this.vertexInstances = new HashMap<VertexClass, CsvReader>();
        this.edgeInstances = new HashMap<EdgeClass, CsvReader>();
        this.reader2FilenameMap = new HashMap<CsvReader, String>();
        this.graph = this.schema.createGraph(ImplementationType.GENERIC);
    }

    private void tearDown() throws IOException {
        this.vertices = null;
        this.graph = null;
        this.closeAllReader(this.vertexInstances.values());
        this.closeAllReader(this.edgeInstances.values());
        this.vertexInstances = null;
        this.edgeInstances = null;
        this.reader2FilenameMap = null;
    }

    private void closeAllReader(Collection<CsvReader> readers) throws IOException {
        for (CsvReader reader : readers) {
            reader.close();
        }
    }

    private void processEdgeFiles() throws NoSuchAttributeException, IOException, GraphIOException {
        for (Map.Entry<EdgeClass, CsvReader> entry : this.edgeInstances.entrySet()) {
            this.currentReader = entry.getValue();
            System.out.println("\tprocessing file: " + this.reader2FilenameMap.get(this.currentReader));
            while (this.currentReader.readRecord()) {
                this.createEdge(this.currentReader, entry.getKey());
            }
        }
    }

    private void processVertexFiles() throws NoSuchAttributeException, IOException, GraphIOException {
        for (Map.Entry<VertexClass, CsvReader> entry : this.vertexInstances.entrySet()) {
            this.currentReader = entry.getValue();
            while (this.currentReader.readRecord()) {
                this.createVertex(this.currentReader, entry.getKey());
            }
            System.out.println("\tprocessing file: " + this.reader2FilenameMap.get(this.currentReader));
        }
    }

    private void loadCsvFiles() throws NoSuchAttributeException, GraphIOException, IOException {
        for (String csvFile : this.csvFiles) {
            this.loadCsvFile(csvFile);
        }
    }

    private void loadCsvFile(String csvFile) throws NoSuchAttributeException, GraphIOException, IOException {
        CsvReader reader = this.openCvsFile(csvFile);
        this.reader2FilenameMap.put(reader, csvFile);
        String attributeClassName = reader.getFieldNames().get(0);
        Object aec = this.schema.getAttributedElementClass(attributeClassName);
        if (aec instanceof VertexClass) {
            this.vertexInstances.put((VertexClass)aec, reader);
        } else {
            this.edgeInstances.put((EdgeClass)aec, reader);
        }
    }

    private CsvReader openCvsFile(String csvFile) {
        try {
            CsvReader openFileReader = new CsvReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(csvFile), "UTF-8")), 1);
            return openFileReader;
        }
        catch (FileNotFoundException cause) {
            throw new RuntimeException("An error occured while opening the file \"" + csvFile + "\".", cause);
        }
        catch (IOException cause) {
            throw new RuntimeException("An error occured while opening the file \"" + csvFile + "\".", cause);
        }
    }

    private void createVertex(CsvReader reader, VertexClass vc) throws NoSuchAttributeException, GraphIOException {
        Object vertex = this.graph.createVertex(vc);
        this.insertAttribute((AttributedElement<?, ?>)vertex, reader, 1);
        String uniqueName = reader.getFieldAt(0);
        if (this.vertices.containsKey(uniqueName)) {
            throw new RuntimeException("The unique name \"" + uniqueName + "\" isn't in fact unique. This error occured while " + "processing the file \"" + this.reader2FilenameMap.get(reader) + "\".");
        }
        this.vertices.put(uniqueName, (Vertex)vertex);
    }

    private void createEdge(CsvReader reader, EdgeClass ec) throws NoSuchAttributeException, GraphIOException {
        Vertex alpha = this.getVertex(reader, 1);
        Vertex omega = this.getVertex(reader, 2);
        Object edge = this.graph.createEdge(ec, alpha, omega);
        this.insertAttribute((AttributedElement<?, ?>)edge, reader, 3);
    }

    private void insertAttribute(AttributedElement<?, ?> element, CsvReader reader, int startColumnIndex) throws NoSuchAttributeException, GraphIOException {
        List<String> header = reader.getFieldNames();
        for (int index = startColumnIndex; index < header.size(); ++index) {
            String attributeName = header.get(index);
            String valueString = reader.getFieldAt(index);
            if (attributeName.equals(COMMENT_STRING) || valueString.isEmpty()) continue;
            String transformedString = this.transformCsvStringValue(valueString);
            try {
                element.readAttributeValueFromString(attributeName, transformedString);
                continue;
            }
            catch (NoSuchAttributeException ex) {
                throw new RuntimeException("The attribute \"" + attributeName + "\" with value \"" + transformedString + "\" in line " + index + " is not a valid attribute name for " + element.getGraphClass().getQualifiedName(), ex);
            }
        }
    }

    private String transformCsvStringValue(String csvStringValue) {
        if (csvStringValue.startsWith("\"") && csvStringValue.endsWith("\"")) {
            csvStringValue = GraphIO.toUtfString(csvStringValue.substring(1, csvStringValue.length() - 1).replace("\\\"", "\""));
        }
        return csvStringValue;
    }

    private Vertex getVertex(CsvReader reader, int fieldNumber) {
        String vertexName = reader.getFieldAt(fieldNumber);
        Vertex vertex = this.vertices.get(vertexName);
        if (vertex == null) {
            throw new RuntimeException("Couldn't find vertex \"" + vertexName + "\" in line: " + reader.getLineNumber() + "in file \"" + this.reader2FilenameMap.get(reader) + "\".");
        }
        return vertex;
    }

    public String[] getCsvFiles() {
        return this.csvFiles;
    }

    public void setCsvFiles(String[] vertexFiles) {
        this.csvFiles = this.getFilesInFolder(vertexFiles);
    }

    private String[] getFilesInFolder(String[] filenames) {
        HashSet<String> fileList = new HashSet<String>();
        for (String filename : filenames) {
            File file = new File(filename).getAbsoluteFile();
            if (!file.exists()) {
                throw new RuntimeException("File or folder \"" + filename + "\" does not exist!");
            }
            if (file.isDirectory()) {
                for (File foundFile : file.listFiles(this)) {
                    fileList.add(foundFile.getAbsolutePath());
                }
                continue;
            }
            fileList.add(file.getAbsolutePath());
        }
        if (fileList.isEmpty()) {
            throw new RuntimeException("No csv-files to convert to a tg-file.");
        }
        return fileList.toArray(new String[0]);
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    @Override
    public boolean accept(File dir, String name) {
        return name.endsWith(".csv");
    }
}

