/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.greqlgui;

import de.uni_koblenz.ist.utilities.gui.SwingApplication;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.greql.funlib.FunLib;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.utilities.greqlgui.GreqlGui;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLDocument;
import javax.swing.undo.UndoManager;

public class QueryEditorPanel
extends JPanel {
    private static final long serialVersionUID = -5113284469152114552L;
    private GreqlGui gui;
    private JTextArea queryArea;
    private UndoManager undoManager;
    private File queryFile;
    private boolean modified;
    CompletionEntryType lookupType;
    private CompletionTableModel completions;
    private Set<CompletionEntry> greqlEntries;
    private JTextPane descriptionTextPane;
    private boolean fontSet;
    private JTable selectTable;
    private JDialog selectWindow;
    private JTextField prefixField;

    public QueryEditorPanel(GreqlGui parent) throws IOException {
        this(parent, null);
    }

    public QueryEditorPanel(GreqlGui app, File f) throws IOException {
        this.gui = app;
        this.queryFile = null;
        this.queryArea = new JTextArea(15, 50);
        this.queryArea.setEditable(true);
        this.queryArea.setFont(this.gui.getQueryFont());
        this.queryArea.setToolTipText(MessageFormat.format(this.gui.getMessage("GreqlGui.QueryArea.ToolTip"), this.gui.getEvaluateQueryShortcut()));
        this.queryArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isControlDown() && e.getKeyCode() == 32 && !QueryEditorPanel.this.gui.isGraphLoading() && !QueryEditorPanel.this.gui.isEvaluating()) {
                    QueryEditorPanel.this.lookupWord();
                }
            }
        });
        this.undoManager = new UndoManager();
        this.undoManager.setLimit(10000);
        Document doc = this.queryArea.getDocument();
        if (f == null) {
            this.newFile();
        } else {
            this.loadFromFile(f);
        }
        doc.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                QueryEditorPanel.this.undoManager.addEdit(evt.getEdit());
                QueryEditorPanel.this.setModified(true);
                QueryEditorPanel.this.gui.updateActions();
            }
        });
        JScrollPane queryScrollPane = new JScrollPane(this.queryArea);
        this.setLayout(new BorderLayout());
        this.add((Component)queryScrollPane, "Center");
    }

    private CompletionTableModel getCompletionTableModel(String prefix, CompletionEntryType lookupType) {
        TreeSet<CompletionEntry> completionEntries = new TreeSet<CompletionEntry>();
        switch (lookupType) {
            case GREQL_FUNCTION: {
                this.addMatchingGreqlFunctions(prefix, completionEntries);
                break;
            }
            case VERTEXCLASS: 
            case EDGECLASS: 
            case ATTRIBUTE: 
            case GRAPHELEMENTCLASS: {
                this.addMatchingSchemaInformation(prefix, completionEntries, lookupType);
                break;
            }
            default: {
                throw new RuntimeException("FIXME!");
            }
        }
        return new CompletionTableModel(completionEntries, lookupType);
    }

    private void addMatchingSchemaInformation(String prefix, TreeSet<CompletionEntry> completionEntries, CompletionEntryType lookupType) {
        Graph g = this.gui.getGraph();
        if (g != null) {
            Schema schema = g.getSchema();
            Stack<Package> s = new Stack<Package>();
            s.push(schema.getDefaultPackage());
            prefix = prefix.toLowerCase();
            while (!s.isEmpty()) {
                Package pkg = (Package)s.pop();
                if (lookupType == CompletionEntryType.ATTRIBUTE) {
                    for (VertexClass vc : pkg.getVertexClasses()) {
                        for (Attribute attr : vc.getOwnAttributeList()) {
                            if (!attr.getName().toLowerCase().startsWith(prefix)) continue;
                            completionEntries.add(new CompletionEntry(CompletionEntryType.ATTRIBUTE, attr.getName() + " in " + vc.getSimpleName(), attr.getName(), this.getDescription(vc, attr)));
                        }
                    }
                    for (EdgeClass ec : pkg.getEdgeClasses()) {
                        for (Attribute attr : ec.getOwnAttributeList()) {
                            if (!attr.getName().toLowerCase().startsWith(prefix)) continue;
                            completionEntries.add(new CompletionEntry(CompletionEntryType.ATTRIBUTE, attr.getName() + " in " + ec.getSimpleName(), attr.getName(), this.getDescription(ec, attr)));
                        }
                    }
                }
                if (lookupType == CompletionEntryType.VERTEXCLASS || lookupType == CompletionEntryType.GRAPHELEMENTCLASS) {
                    for (VertexClass vc : pkg.getVertexClasses()) {
                        if (!vc.getSimpleName().toLowerCase().startsWith(prefix) && !vc.getQualifiedName().toLowerCase().startsWith(prefix)) continue;
                        completionEntries.add(new CompletionEntry(CompletionEntryType.VERTEXCLASS, vc.getSimpleName(), vc.getQualifiedName(), this.getDescription(vc)));
                    }
                }
                if (lookupType == CompletionEntryType.EDGECLASS || lookupType == CompletionEntryType.GRAPHELEMENTCLASS) {
                    for (EdgeClass ec : pkg.getEdgeClasses()) {
                        if (!ec.getSimpleName().toLowerCase().startsWith(prefix) && !ec.getQualifiedName().toLowerCase().startsWith(prefix)) continue;
                        completionEntries.add(new CompletionEntry(CompletionEntryType.EDGECLASS, ec.getSimpleName(), ec.getQualifiedName(), this.getDescription(ec)));
                    }
                }
                for (Package sub : pkg.getSubPackages()) {
                    s.push(sub);
                }
            }
        }
    }

    private String getDescription(GraphElementClass<?, ?> gec) {
        String delim;
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body>");
        sb.append("<p>").append(gec.isAbstract() ? "abstract " : "").append(gec instanceof VertexClass ? "Vertex" : "Edge").append("Class <strong>").append(gec.getQualifiedName()).append("</strong></p><dl>");
        if (gec instanceof EdgeClass) {
            EdgeClass ec = (EdgeClass)gec;
            sb.append("<dt>from</dt><dd>").append(ec.getFrom().getVertexClass().getQualifiedName()).append(" (").append(ec.getFrom().getMin()).append(", ").append(ec.getFrom().getMax() == Integer.MAX_VALUE ? "*" : "" + ec.getFrom().getMax()).append(")");
            String role = ec.getFrom().getRolename();
            if (role != null && !role.isEmpty()) {
                sb.append(" role ").append(role);
            }
            sb.append(" aggregation ").append((Object)ec.getFrom().getAggregationKind());
            sb.append("</dd><dt>to</dt><dd>").append(ec.getTo().getVertexClass().getQualifiedName()).append(" (").append(ec.getTo().getMin()).append(", ").append(ec.getTo().getMax() == Integer.MAX_VALUE ? "*" : "" + ec.getTo().getMax()).append(")");
            role = ec.getTo().getRolename();
            if (role != null && !role.isEmpty()) {
                sb.append(" role ").append(role);
            }
            sb.append(" aggregation ").append((Object)ec.getTo().getAggregationKind());
            sb.append("</dd>");
        }
        if (!gec.getAllSuperClasses().isEmpty()) {
            delim = "<dt>Superclasses:</dt><dd>";
            for (GraphElementClass sup : gec.getAllSuperClasses()) {
                sb.append(delim).append(sup.getQualifiedName());
                delim = ", ";
            }
            sb.append("</dd>");
        }
        if (!gec.getAllSubClasses().isEmpty()) {
            delim = "<dt>Subclasses:</dt><dd>";
            for (GraphElementClass sub : gec.getAllSubClasses()) {
                sb.append(delim).append(sub.getQualifiedName());
                delim = ", ";
            }
            sb.append("</dd>");
        }
        if (gec.getAttributeCount() > 0) {
            sb.append("<dt>Attributes:</dt>");
            for (Attribute attr : gec.getAttributeList()) {
                sb.append("<dd><strong>").append(attr.getName()).append("</strong>: <font color=\"purple\">").append(attr.getDomain().getQualifiedName()).append("</font></dd>");
            }
            sb.append("</p>");
        }
        sb.append("</dl></body></html>");
        return sb.toString();
    }

    private String getDescription(GraphElementClass<?, ?> gec, Attribute attr) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body>");
        sb.append("<p>Attribute <strong>").append(attr.getName()).append("</strong>: <font color=\"purple\">").append(attr.getDomain().getQualifiedName()).append("</font></p><p>&nbsp;&nbsp;in ").append(gec instanceof VertexClass ? "Vertex" : "Edge").append("Class ").append(gec.getQualifiedName()).append("</p>");
        sb.append("</body></html>");
        return sb.toString();
    }

    private Set<CompletionEntry> getGreqlEntries() {
        if (this.greqlEntries != null) {
            return this.greqlEntries;
        }
        this.greqlEntries = new TreeSet<CompletionEntry>();
        Set<String> funcs = FunLib.getFunctionNames();
        for (String s : funcs) {
            this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_FUNCTION, s, s + "()", FunLib.getFunctionInfo(s).getHtmlDescription(), -1));
        }
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "V", "V{}", this.getDescriptionFromResources("vertexset.html"), -1));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "E", "E{}", this.getDescriptionFromResources("edgeset.html"), -1));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "false", "false", "Boolean constant"));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "true", "true", "Boolean constant"));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "undefined", "undefined", "Undefined constant"));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "tv", "thisVertex", this.getDescriptionFromResources("thisliteral.html")));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "te", "thisEdge", this.getDescriptionFromResources("thisliteral.html")));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "fwr", "from\n\t\nwith\n\t\nreport\n\t\nend", this.getDescriptionFromResources("listcomp.html"), -20));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "fwr set", "from\n\t\nwith\n\t\nreportSet\n\t\nend", this.getDescriptionFromResources("setcomp.html"), -23));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "fwr map", "from\n\t\nwith\n\t\nreportMap\n\t\nend", this.getDescriptionFromResources("mapcomp.html"), -23));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "exists", "exists @ ", this.getDescriptionFromResources("exists.html"), -2));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "exists!", "exists!  @ ", this.getDescriptionFromResources("exists1.html"), -3));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "forall", "forall  @ ", this.getDescriptionFromResources("forall.html"), -3));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "let", "let  in ", this.getDescriptionFromResources("let.html"), -4));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "where", "\nwhere ", this.getDescriptionFromResources("where.html"), -7));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "list", "list()", this.getDescriptionFromResources("list.html"), -1));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "set", "set()", this.getDescriptionFromResources("set.html"), -1));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "map", "map()", this.getDescriptionFromResources("map.html"), -1));
        this.greqlEntries.add(new CompletionEntry(CompletionEntryType.GREQL_IDIOM, "tup", "tup()", this.getDescriptionFromResources("tup.html"), -1));
        return this.greqlEntries;
    }

    private String getDescriptionFromResources(String filename) {
        InputStream is = this.getClass().getResourceAsStream("resources/completion/" + filename);
        BufferedReader rdr = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        try {
            String line = rdr.readLine();
            while (line != null) {
                sb.append(line);
                line = rdr.readLine();
            }
            rdr.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return sb.toString();
    }

    private void addMatchingGreqlFunctions(String prefix, TreeSet<CompletionEntry> completionEntries) {
        prefix = prefix.toLowerCase();
        for (CompletionEntry e : this.getGreqlEntries()) {
            if (!e.name.toLowerCase().startsWith(prefix) && !e.replacement.toLowerCase().startsWith(prefix)) continue;
            completionEntries.add(e);
        }
    }

    private void setDescription(String text) {
        this.descriptionTextPane.setContentType("text/html");
        this.descriptionTextPane.setText(text);
        Font font = UIManager.getFont("Label.font");
        String bodyRule = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; }";
        ((HTMLDocument)this.descriptionTextPane.getDocument()).getStyleSheet().addRule(bodyRule);
        this.descriptionTextPane.setCaretPosition(0);
    }

    protected void lookupWord() {
        int prefixStart;
        int dot;
        int p;
        int caretPosition = this.queryArea.getCaretPosition();
        char[] a = this.queryArea.getText().toCharArray();
        for (p = caretPosition - 1; p >= 0 && (Character.isLetterOrDigit(a[p]) || a[p] == '_'); --p) {
        }
        for (dot = p; dot >= 0 && Character.isWhitespace(a[dot]); --dot) {
        }
        final int insertPos = prefixStart = p + 1;
        final int insertLength = caretPosition - prefixStart;
        while (p >= 0 && a[p] != '{' && (Character.isWhitespace(a[p]) || Character.isLetterOrDigit(a[p]) || a[p] == '_' || a[p] == '$' || a[p] == '^' || a[p] == ',' || a[p] == '.' || a[p] == '!')) {
            --p;
        }
        this.lookupType = null;
        if (p >= 0 && a[p] == '{') {
            --p;
            while (p >= 0 && Character.isWhitespace(a[p])) {
                --p;
            }
            if (p >= 0) {
                if (a[p] == 'V' || a[p] == '&') {
                    this.lookupType = CompletionEntryType.VERTEXCLASS;
                } else if (a[p] == 'E' || a[p] == '-' || a[p] == '>') {
                    this.lookupType = CompletionEntryType.EDGECLASS;
                }
            }
            if (this.lookupType == null) {
                this.lookupType = CompletionEntryType.GRAPHELEMENTCLASS;
            }
        }
        if (this.lookupType == null && dot >= 0 && a[dot] == '.') {
            this.lookupType = CompletionEntryType.ATTRIBUTE;
        }
        if (this.lookupType == null) {
            this.lookupType = CompletionEntryType.GREQL_FUNCTION;
        }
        String prefix = "";
        try {
            prefix = this.queryArea.getText(insertPos, insertLength).toLowerCase();
        }
        catch (BadLocationException e) {
            return;
        }
        this.descriptionTextPane = new JTextPane();
        this.descriptionTextPane.setContentType("text/html");
        this.descriptionTextPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.descriptionTextPane.setEditable(false);
        this.descriptionTextPane.addPropertyChangeListener("page", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                if (!QueryEditorPanel.this.fontSet) {
                    MutableAttributeSet attrs = QueryEditorPanel.this.descriptionTextPane.getInputAttributes();
                    StyleConstants.setFontFamily(attrs, "SansSerif");
                    StyledDocument doc = QueryEditorPanel.this.descriptionTextPane.getStyledDocument();
                    doc.setCharacterAttributes(0, doc.getLength() + 1, attrs, false);
                    QueryEditorPanel.this.fontSet = true;
                }
            }
        });
        this.selectTable = new CompletionTable(null);
        this.selectWindow = new JDialog((Frame)this.gui, this.lookupType.toString());
        this.prefixField = new JTextField(prefix);
        if (SwingApplication.RUNS_ON_MAC_OS_X) {
            this.prefixField.setCaret(new DefaultCaret());
            this.prefixField.putClientProperty("JTextField.variant", "search");
        }
        this.prefixField.getCaret().setDot(this.prefixField.getDocument().getLength());
        this.prefixField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                QueryEditorPanel.this.updateCompletion();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                QueryEditorPanel.this.updateCompletion();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                QueryEditorPanel.this.updateCompletion();
            }
        });
        KeyAdapter l = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    e.consume();
                    QueryEditorPanel.this.selectWindow.setVisible(false);
                    QueryEditorPanel.this.queryArea.requestFocus();
                } else if (e.getKeyCode() == 10) {
                    e.consume();
                    if (QueryEditorPanel.this.selectTable.getSelectedRow() >= 0) {
                        try {
                            QueryEditorPanel.this.queryArea.getDocument().remove(insertPos, insertLength);
                            CompletionEntry entry = QueryEditorPanel.this.completions.getEntry(QueryEditorPanel.this.selectTable.getSelectedRow());
                            String completion = entry.replacement;
                            QueryEditorPanel.this.queryArea.getDocument().insertString(insertPos, completion, null);
                            QueryEditorPanel.this.queryArea.setCaretPosition(QueryEditorPanel.this.queryArea.getCaretPosition() + ((QueryEditorPanel)QueryEditorPanel.this).completions.getEntry((int)((QueryEditorPanel)QueryEditorPanel.this).selectTable.getSelectedRow()).offset);
                        }
                        catch (BadLocationException e1) {
                            e1.printStackTrace();
                        }
                    }
                    QueryEditorPanel.this.selectWindow.setVisible(false);
                    QueryEditorPanel.this.queryArea.requestFocus();
                } else if (e.getKeyCode() == 38) {
                    e.consume();
                    int r = QueryEditorPanel.this.selectTable.getSelectedRow() - 1;
                    if (r >= 0) {
                        QueryEditorPanel.this.selectTable.changeSelection(r, 0, false, false);
                    }
                } else if (e.getKeyCode() == 40) {
                    e.consume();
                    int r = QueryEditorPanel.this.selectTable.getSelectedRow() + 1;
                    if (r < QueryEditorPanel.this.completions.getRowCount()) {
                        QueryEditorPanel.this.selectTable.changeSelection(r, 0, false, false);
                    }
                }
            }
        };
        this.prefixField.addKeyListener(l);
        this.selectTable.addKeyListener(l);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        leftPanel.add((Component)this.prefixField, "North");
        JScrollPane scp = new JScrollPane(this.selectTable);
        scp.setPreferredSize(new Dimension(200, 300));
        leftPanel.add((Component)scp, "Center");
        JScrollPane scp1 = new JScrollPane(this.descriptionTextPane);
        scp1.setPreferredSize(new Dimension(500, 300));
        this.descriptionTextPane.setBackground(new Color(254, 254, 189));
        scp1.setHorizontalScrollBarPolicy(31);
        JSplitPane sp = new JSplitPane(1, leftPanel, scp1);
        sp.setContinuousLayout(true);
        this.selectWindow.getContentPane().add(sp);
        this.updateCompletion();
        this.selectWindow.pack();
        try {
            Rectangle r = this.queryArea.modelToView(caretPosition);
            Point caretCoordinates = SwingUtilities.convertPoint(this.queryArea, new Point(r.x, r.y - 32), this.gui);
            SwingUtilities.convertPointToScreen(caretCoordinates, this.gui);
            this.selectWindow.setLocation(caretCoordinates);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.selectWindow.setVisible(true);
        this.selectWindow.toFront();
    }

    private void updateCompletion() {
        this.completions = this.getCompletionTableModel(this.prefixField.getText(), this.lookupType);
        this.selectTable.setModel(this.completions);
        if (this.completions.getRowCount() > 0) {
            this.selectTable.changeSelection(0, 0, false, false);
        } else {
            this.setDescription("No matches :-(");
        }
    }

    public void setSelection(int offset, int length) {
        if (offset < 0) {
            return;
        }
        int start = Math.max(0, Math.min(offset, this.queryArea.getDocument().getLength()));
        int end = Math.max(start, Math.min(start + length, this.queryArea.getDocument().getLength()));
        this.queryArea.setSelectionStart(start);
        this.queryArea.setSelectionEnd(end);
    }

    public boolean canUndo() {
        return this.undoManager.canUndo();
    }

    public boolean canRedo() {
        return this.undoManager.canRedo();
    }

    public void undo() {
        this.undoManager.undo();
        this.setModified(true);
    }

    public void redo() {
        this.undoManager.redo();
        this.setModified(true);
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void cut() {
        this.queryArea.cut();
    }

    public void copy() {
        this.queryArea.copy();
    }

    public void paste() {
        this.queryArea.paste();
    }

    public String getText() {
        return this.queryArea.getText();
    }

    public void removeJavaQuotes() {
        String text = this.queryArea.getText().trim();
        text = text.replaceAll("\"\\s*\\+\\s*\"", "");
        text = text.replace("\\\"", "\uffff");
        text = text.replace("\"", "");
        text = text.replace("\\n", "\n");
        text = text.replace("\\t", "\t");
        text = text.replace("\\\"", "\"");
        text = text.replace("\\\\", "\\");
        text = text.replace("\uffff", "\"");
        this.queryArea.setText(text);
    }

    public void insertJavaQuotes() {
        String text = this.queryArea.getText();
        String[] lines = text.split("\n");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            line = line.replace("\\", "\\\\");
            line = line.replace("\"", "\\\"");
            line = line.replace("\t", "\\t");
            sb.append("\"").append(line);
            if (i < lines.length - 1) {
                sb.append("\\n\" +\n");
                continue;
            }
            sb.append("\"");
        }
        text = sb.toString();
        this.queryArea.setText(text);
        this.setSelection(0, this.queryArea.getDocument().getLength());
        this.queryArea.copy();
    }

    @Override
    public void requestFocus() {
        this.queryArea.requestFocus();
    }

    public void setQuery(File queryFile, String queryText) {
        this.queryFile = queryFile;
        this.queryArea.setText(queryText);
        this.undoManager.discardAllEdits();
        this.setModified(false);
    }

    public File getQueryFile() {
        return this.queryFile;
    }

    public void setQueryFile(File queryFile) {
        this.queryFile = queryFile;
    }

    public void loadFromFile(File f) throws IOException {
        BufferedReader rdr = new BufferedReader(new FileReader(f));
        StringBuilder sb = new StringBuilder();
        String line = rdr.readLine();
        while (line != null) {
            sb.append(line).append("\n");
            line = rdr.readLine();
        }
        rdr.close();
        this.setQuery(f, sb.toString());
    }

    public void saveToFile(File f) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(f));
        pw.print(this.queryArea.getText());
        pw.close();
        this.queryFile = f;
        this.setModified(false);
    }

    private void newFile() {
        this.setQuery(null, this.gui.getMessage("GreqlGui.NewQuery.Text"));
        this.setSelection(0, this.queryArea.getDocument().getLength());
    }

    public String getFileName() {
        return this.queryFile == null ? this.gui.getMessage("GreqlGui.NewQuery.Title") : this.queryFile.getName();
    }

    public void setQueryFont(Font queryFont) {
        this.queryArea.setFont(queryFont);
    }

    private class CompletionTable
    extends JTable {
        private static final long serialVersionUID = 8741021448180241310L;

        public CompletionTable(TableModel model) {
            this.setRowSelectionAllowed(true);
            this.setColumnSelectionAllowed(false);
            this.setModel(model);
        }

        private void installSelectionListener() {
            this.getSelectionModel().setSelectionMode(0);
            this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int row = CompletionTable.this.getSelectedRow();
                    if (QueryEditorPanel.this.completions != null && row >= 0) {
                        QueryEditorPanel.this.setDescription(((QueryEditorPanel)QueryEditorPanel.this).completions.getEntry((int)row).description);
                    } else {
                        QueryEditorPanel.this.setDescription("");
                    }
                }
            });
        }

        @Override
        public void setModel(TableModel dataModel) {
            if (dataModel == null) {
                dataModel = new DefaultTableModel();
            }
            super.setModel(dataModel);
            if (dataModel.getRowCount() > 0) {
                this.changeSelection(0, 0, false, false);
            }
            this.installSelectionListener();
        }

        @Override
        public Point getToolTipLocation(MouseEvent event) {
            return new Point(event.getX() + 15, event.getY());
        }
    }

    private class CompletionTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 4313285792993087566L;
        ArrayList<CompletionEntry> entries;
        CompletionEntryType lookupType;

        public CompletionTableModel(Collection<CompletionEntry> e, CompletionEntryType t) {
            this.entries = new ArrayList<CompletionEntry>(e);
            this.lookupType = t;
        }

        @Override
        public boolean isCellEditable(int arg0, int arg1) {
            return false;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return this.lookupType == CompletionEntryType.ATTRIBUTE ? "Attribute" : "Name";
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.entries.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            CompletionEntry e = this.entries.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return e.name;
                }
            }
            return null;
        }

        CompletionEntry getEntry(int row) {
            return this.entries.get(row);
        }
    }

    private static class CompletionEntry
    implements Comparable<CompletionEntry> {
        CompletionEntryType type;
        String name;
        String replacement;
        String description;
        int offset;

        public CompletionEntry(CompletionEntryType type, String name, String replacement, String description) {
            this.type = type;
            this.name = name;
            this.replacement = replacement;
            this.description = description;
        }

        public CompletionEntry(CompletionEntryType type, String name, String replacement, String description, int offset) {
            this(type, name, replacement, description);
            this.offset = offset;
        }

        @Override
        public int compareTo(CompletionEntry c) {
            return this.name.compareTo(c.name);
        }
    }

    private static enum CompletionEntryType {
        GREQL_FUNCTION,
        GREQL_IDIOM,
        VERTEXCLASS,
        EDGECLASS,
        ATTRIBUTE,
        GRAPHELEMENTCLASS;

    }
}

