/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.greqlgui;

import de.uni_koblenz.ist.utilities.gui.FontSelectionDialog;
import de.uni_koblenz.jgralab.utilities.greqlgui.GreqlGui;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SettingsDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = -5656234050436317561L;
    private GreqlGui gui;
    private JButton cancelButton;
    private JButton okButton;
    private Font queryFont;
    private JTextField queryFontLabel;
    private JButton queryFontButton;
    private Font resultFont;
    private JTextField resultFontLabel;
    private JButton resultFontButton;
    private JList greqlFunctionList;
    private DefaultListModel greqlFunctionModel;
    private Action removeAction;
    private Action addAction;
    private JTextField functionNameField;

    public SettingsDialog(GreqlGui app, Font qf, Font rf, List<String> greqlFunctions) {
        super(app, app.getApplicationName() + app.getMessage("SettingsDialog.Title"), true);
        this.gui = app;
        JPanel pnl = new JPanel();
        pnl.setLayout(new BorderLayout(8, 8));
        pnl.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.getContentPane().add(pnl);
        this.queryFont = qf;
        this.resultFont = rf;
        JPanel fontSettingsPanel = new JPanel();
        fontSettingsPanel.setLayout(new GridBagLayout());
        fontSettingsPanel.setBorder(BorderFactory.createTitledBorder(this.gui.getMessage("SettingsDialog.FontTitle")));
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridy = 0;
        c.gridx = 0;
        JLabel lbl = new JLabel(this.gui.getMessage("SettingsDialog.QueryFontLabel"), 4);
        lbl.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        fontSettingsPanel.add((Component)lbl, c);
        ++c.gridx;
        this.queryFontLabel = new JTextField(FontSelectionDialog.getFontName(this.gui, this.queryFont), 30);
        this.queryFontLabel.setEditable(false);
        fontSettingsPanel.add((Component)this.queryFontLabel, c);
        this.queryFontButton = new JButton(this.gui.getMessage("SettingsDialog.QueryFontButtonText"));
        ++c.gridx;
        fontSettingsPanel.add((Component)this.queryFontButton, c);
        this.queryFontButton.addActionListener(this);
        c.gridy = 1;
        c.gridx = 0;
        lbl = new JLabel(this.gui.getMessage("SettingsDialog.ResultFontLabel"), 4);
        lbl.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        fontSettingsPanel.add((Component)lbl, c);
        ++c.gridx;
        this.resultFontLabel = new JTextField(FontSelectionDialog.getFontName(this.gui, this.resultFont), 30);
        this.resultFontLabel.setEditable(false);
        fontSettingsPanel.add((Component)this.resultFontLabel, c);
        this.resultFontButton = new JButton(this.gui.getMessage("SettingsDialog.ResultFontButtonText"));
        ++c.gridx;
        fontSettingsPanel.add((Component)this.resultFontButton, c);
        this.resultFontButton.addActionListener(this);
        JPanel funcListPanel = new JPanel();
        funcListPanel.setLayout(new GridBagLayout());
        funcListPanel.setBorder(BorderFactory.createTitledBorder(this.gui.getMessage("SettingsDialog.FunctionsTitle")));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridwidth = 4;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 1;
        this.greqlFunctionModel = new DefaultListModel();
        for (String s : greqlFunctions) {
            this.greqlFunctionModel.addElement(s);
        }
        this.greqlFunctionList = new JList(this.greqlFunctionModel);
        this.greqlFunctionList.setSelectionMode(0);
        this.greqlFunctionList.setToolTipText(this.gui.getMessage("SettingsDialog.FunctionListToolTip"));
        JScrollPane scp = new JScrollPane(this.greqlFunctionList);
        funcListPanel.add((Component)scp, c);
        c.gridy = 1;
        c.gridx = 0;
        c.fill = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.removeAction = new AbstractAction(this.gui.getMessage("SettingsDialog.RemoveFunctionAction")){
            private static final long serialVersionUID = 5701993491246301105L;
            {
                this.setEnabled(false);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = SettingsDialog.this.greqlFunctionList.getSelectedIndex();
                SettingsDialog.this.functionNameField.setText((String)SettingsDialog.this.greqlFunctionModel.getElementAt(index));
                SettingsDialog.this.functionNameField.requestFocusInWindow();
                SettingsDialog.this.greqlFunctionModel.remove(index);
                int size = SettingsDialog.this.greqlFunctionModel.getSize();
                if (size == 0) {
                    SettingsDialog.this.removeAction.setEnabled(false);
                } else {
                    if (index == SettingsDialog.this.greqlFunctionModel.getSize()) {
                        --index;
                    }
                    SettingsDialog.this.greqlFunctionList.setSelectedIndex(index);
                    SettingsDialog.this.greqlFunctionList.ensureIndexIsVisible(index);
                }
            }
        };
        funcListPanel.add((Component)new JButton(this.removeAction), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.functionNameField = new JTextField();
        this.functionNameField.setToolTipText(this.gui.getMessage("SettingsDialog.FunctionNameToolTip"));
        funcListPanel.add((Component)this.functionNameField, c);
        c.weightx = 0.0;
        ++c.gridx;
        this.addAction = new AbstractAction(this.gui.getMessage("SettingsDialog.AddFunctionAction")){
            private static final long serialVersionUID = 727631592422400160L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int index;
                String name = SettingsDialog.this.functionNameField.getText().trim();
                if (name.equals("") || SettingsDialog.this.greqlFunctionModel.contains(name)) {
                    Toolkit.getDefaultToolkit().beep();
                    SettingsDialog.this.functionNameField.requestFocusInWindow();
                    SettingsDialog.this.functionNameField.selectAll();
                    return;
                }
                for (index = 0; index < SettingsDialog.this.greqlFunctionModel.size() && name.compareTo((String)SettingsDialog.this.greqlFunctionModel.getElementAt(index)) >= 0; ++index) {
                }
                SettingsDialog.this.greqlFunctionModel.insertElementAt(name, index);
                SettingsDialog.this.functionNameField.requestFocusInWindow();
                SettingsDialog.this.functionNameField.setText("");
                SettingsDialog.this.greqlFunctionList.setSelectedIndex(index);
                SettingsDialog.this.greqlFunctionList.ensureIndexIsVisible(index);
            }
        };
        funcListPanel.add((Component)new JButton(this.addAction), c);
        this.greqlFunctionList.addListSelectionListener(this);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        c.fill = 2;
        c.weightx = 1.0;
        lbl = new JLabel(this.gui.getMessage("SettingsDialog.FunctionInfoText"), 0);
        funcListPanel.add((Component)lbl, c);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 4, 4));
        this.cancelButton = new JButton(this.gui.getMessage("SettingsDialog.CancelButtonText"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.cancelButton);
        this.okButton = new JButton(this.gui.getMessage("SettingsDialog.OkButtonText"));
        this.okButton.addActionListener(this);
        this.okButton.setDefaultCapable(true);
        buttonPanel.add(this.okButton);
        pnl.add((Component)fontSettingsPanel, "North");
        pnl.add((Component)funcListPanel, "Center");
        pnl.add((Component)buttonPanel, "South");
        this.pack();
        this.okButton.requestFocus();
        this.setLocationRelativeTo(this.gui);
        this.setVisible(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            if (this.greqlFunctionList.getSelectedIndex() == -1) {
                this.removeAction.setEnabled(false);
            } else {
                this.removeAction.setEnabled(true);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Font newFont;
        if (e.getSource() == this.cancelButton) {
            this.dispose();
        }
        if (e.getSource() == this.okButton && this.isOk()) {
            this.gui.saveSettings(this);
            this.dispose();
        }
        if (e.getSource() == this.resultFontButton && (newFont = FontSelectionDialog.selectFont(this.gui, this.gui.getMessage("SettingsDialog.ResultFontTitle"), this.resultFont, false)) != null) {
            this.resultFont = newFont;
            this.resultFontLabel.setText(FontSelectionDialog.getFontName(this.gui, this.resultFont));
        }
        if (e.getSource() == this.queryFontButton && (newFont = FontSelectionDialog.selectFont(this.gui, this.gui.getMessage("SettingsDialog.QueryFontTitle"), this.queryFont, false)) != null) {
            this.queryFont = newFont;
            this.queryFontLabel.setText(FontSelectionDialog.getFontName(this.gui, this.queryFont));
        }
    }

    public Font getQueryFont() {
        return this.queryFont;
    }

    public Font getResultFont() {
        return this.resultFont;
    }

    public List<String> getGreqlFunctionList() {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration e = this.greqlFunctionModel.elements();
        while (e.hasMoreElements()) {
            result.add((String)e.nextElement());
        }
        return result;
    }

    private boolean isOk() {
        return true;
    }
}

