/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.greqlserver;

import de.uni_koblenz.ist.utilities.option_handler.OptionHandler;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.WorkInProgress;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlEnvironmentAdapter;
import de.uni_koblenz.jgralab.greql.exception.GreqlException;
import de.uni_koblenz.jgralab.greql.serialising.HTMLOutputWriter;
import de.uni_koblenz.jgralab.impl.ConsoleProgressFunction;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

@WorkInProgress(responsibleDevelopers="dbildh")
public class GReQLConsole {
    private Graph graph = null;
    private boolean verbose = false;

    public GReQLConsole(String filename, boolean loadSchema, boolean verbose) {
        this.verbose = verbose;
        try {
            if (loadSchema) {
                if (verbose) {
                    System.out.println("Loading schema from file");
                }
                Schema schema = GraphIO.loadSchemaFromFile(filename);
                schema.compile(CodeGeneratorConfiguration.MINIMAL);
            }
            this.graph = GraphIO.loadGraphFromFile(filename, verbose ? new ConsoleProgressFunction("Loading") : null);
        }
        catch (GraphIOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> loadQueries(File queryFile) throws IOException {
        ArrayList<String> queries = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new FileReader(queryFile));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("//--")) {
                    queries.add(builder.toString());
                    builder = new StringBuilder();
                    continue;
                }
                builder.append(line + " \n");
            }
        }
        if (builder.length() != 0) {
            String query = builder.toString();
            queries.add(query);
        }
        return queries;
    }

    private Object performQuery(File queryFile) {
        Object result = null;
        try {
            for (String query : this.loadQueries(queryFile)) {
                if (this.verbose) {
                    System.out.println("Evaluating query: ");
                    System.out.println(query);
                }
                result = GreqlQuery.createQuery(query).evaluate(this.graph, new GreqlEnvironmentAdapter(), this.verbose ? new ConsoleProgressFunction() : null);
                if (!this.verbose || !(result instanceof Collection)) continue;
                System.out.println("Result size is: " + ((Collection)result).size());
            }
        }
        catch (GreqlException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private void resultToHTML(Object result, String outputFile) throws IOException {
        HTMLOutputWriter w = new HTMLOutputWriter(this.graph);
        w.writeValue(result, new File(outputFile));
    }

    public static void main(String[] args) {
        CommandLine comLine = GReQLConsole.processCommandLineOptions(args);
        assert (comLine != null);
        String queryFile = comLine.getOptionValue("q");
        String graphFile = comLine.getOptionValue("g");
        boolean loadSchema = comLine.hasOption("s");
        JGraLab.setLogLevel(Level.SEVERE);
        GReQLConsole console = new GReQLConsole(graphFile, loadSchema, comLine.hasOption('v'));
        Object result = console.performQuery(new File(queryFile));
        if (comLine.hasOption("o")) {
            try {
                console.resultToHTML(result, comLine.getOptionValue("o"));
            }
            catch (IOException e) {
                System.err.println("Exception while creating HTML output:");
                e.printStackTrace();
            }
        } else {
            System.out.println("Result: " + result);
        }
    }

    private static CommandLine processCommandLineOptions(String[] args) {
        String toolString = "java " + GReQLConsole.class.getName();
        String versionString = JGraLab.getInfo(false);
        OptionHandler oh = new OptionHandler(toolString, versionString);
        Option queryfile = new Option("q", "queryfile", true, "(required): queryfile which should be executed. May contain many queries separated by //-- on a line");
        queryfile.setRequired(true);
        queryfile.setArgName("file");
        oh.addOption(queryfile);
        Option inputFile = new Option("g", "graph", true, "(optional): the tg-file of the graph");
        inputFile.setRequired(false);
        inputFile.setArgName("file");
        oh.addOption(inputFile);
        Option output = new Option("o", "output", true, "(optional): HTML-file to be generated");
        output.setArgName("file");
        oh.addOption(output);
        Option loadschema = new Option("s", "loadschema", false, "(optional): Loads also the schema from the file");
        oh.addOption(loadschema);
        Option verbose = new Option("v", "verbose", false, "(optional): Produce verbose output");
        oh.addOption(verbose);
        return oh.parse(args);
    }
}

