/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.greqlserver;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.BooleanGraphMarker;
import de.uni_koblenz.jgralab.graphmarker.SubGraphMarker;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.GreqlQueryCache;
import de.uni_koblenz.jgralab.greql.types.Path;
import de.uni_koblenz.jgralab.greql.types.PathSystem;
import de.uni_koblenz.jgralab.greql.types.Types;
import de.uni_koblenz.jgralab.impl.ConsoleProgressFunction;
import de.uni_koblenz.jgralab.utilities.tg2dot.Tg2Dot;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class GreqlServer
extends Thread {
    private static Thread clientHandlerLoop;
    private static HashSet<GreqlServer> clients;
    private final Socket socket;
    private final BufferedReader in;
    private final PrintWriter out;
    private Graph graph;
    private String graphFile;
    private static Map<String, Graph> dataGraphs;
    private final GreqlQueryCache cache = new GreqlQueryCache();

    public GreqlServer(Socket s) throws IOException {
        this.socket = s;
        this.in = new BufferedReader(new InputStreamReader(s.getInputStream()));
        this.out = new PrintWriter(new OutputStreamWriter(s.getOutputStream()));
        this.println("Hi! I'm your GreqlServer (" + this.socket.getInetAddress() + ")", PrintTarget.BOTH, true);
    }

    private void println(String message, PrintTarget target, boolean flush) {
        switch (target) {
            case CLIENT: {
                this.out.println(message);
                break;
            }
            case SERVER: {
                System.out.println(message);
                break;
            }
            case BOTH: {
                this.out.println(message);
                System.out.println(message);
                break;
            }
        }
        if (flush) {
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Object line = null;
            while ((line = this.in.readLine()) != null && !this.isInterrupted()) {
                if (((String)line).startsWith("g:")) {
                    this.graphFile = ((String)line).substring(2);
                    Graph g = dataGraphs.get(this.graphFile);
                    if (g == null) {
                        this.println("Loading " + this.graphFile + ".", PrintTarget.BOTH, true);
                        g = GraphIO.loadGraphFromFile(this.graphFile, new ConsoleProgressFunction("Loading"));
                        dataGraphs.put(this.graphFile, g);
                    }
                    this.graph = g;
                } else if (((String)line).startsWith("q:")) {
                    this.evalQuery(((String)line).substring(2));
                } else if (((String)line).startsWith("d:")) {
                    String queryFile = ((String)line).substring(2);
                    this.saveAsDot(this.evalQuery(queryFile), queryFile + ".dot");
                } else {
                    this.println("Don't understand line '" + (String)line + "'.", PrintTarget.BOTH, true);
                }
                this.out.println("\f");
                this.out.flush();
            }
            this.println("GreqlServer says goodbye!", PrintTarget.BOTH, true);
            this.in.close();
            this.socket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            e.printStackTrace(this.out);
        }
        finally {
            this.out.close();
            Class<GreqlServer> clazz = GreqlServer.class;
            synchronized (GreqlServer.class) {
                clients.remove(this);
                // ** MonitorExit[var1_3] (shouldn't be in output)
            }
        }
    }

    private void saveAsDot(Object val, String dotFileName) throws IOException {
        Graph g = this.graph;
        BooleanGraphMarker marker = new BooleanGraphMarker(g);
        this.markResultElements(val, marker);
        for (Edge e : g.edges()) {
            if (!marker.isMarked(e.getAlpha()) || !marker.isMarked(e.getOmega())) continue;
            marker.mark(e);
        }
        Tg2Dot.convertGraph(marker, dotFileName);
    }

    private void markResultElements(Object val, BooleanGraphMarker marker) {
        if (val instanceof Collection) {
            Collection coll = (Collection)val;
            for (Object v : coll) {
                this.markResultElements(v, marker);
            }
        } else if (val instanceof Map) {
            for (Map.Entry e : ((Map)val).entrySet()) {
                this.markResultElements(e.getKey(), marker);
                this.markResultElements(e.getValue(), marker);
            }
        } else if (val instanceof SubGraphMarker) {
            SubGraphMarker slice = (SubGraphMarker)val;
            for (GraphElement<?, ?> elem : slice.getMarkedElements()) {
                marker.mark(elem);
            }
        } else if (val instanceof PathSystem) {
            PathSystem pathSystem = (PathSystem)val;
            for (Vertex v : pathSystem.getVertices()) {
                marker.mark(v);
            }
            for (Edge e : pathSystem.getEdges()) {
                marker.mark(e);
            }
        } else if (val instanceof Path) {
            Path path = (Path)val;
            for (Vertex v : path.getVertexTrace()) {
                marker.mark(v);
            }
            for (Edge e : path.getEdgeTrace()) {
                marker.mark(e);
            }
        } else if (val instanceof GraphElement) {
            marker.mark((GraphElement)val);
        } else {
            this.println("'" + val + "' is no AttributedElement, " + "so it won't be considered for DOT output.", PrintTarget.BOTH, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object evalQuery(String queryFile) throws IOException {
        this.println("Evaling query file " + queryFile + ".", PrintTarget.BOTH, true);
        StringBuilder sb = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new FileReader(queryFile));){
            String line;
            while ((line = in.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
            }
        }
        GreqlQuery query = this.cache.getQuery(sb.toString());
        Object result = null;
        try {
            long startTime = System.currentTimeMillis();
            result = query.evaluate(this.graph);
            long evalTime = System.currentTimeMillis() - startTime;
            this.println("<result not printed>", PrintTarget.SERVER, false);
            this.out.println();
            this.out.println("Evaluation took " + evalTime + "ms.");
            this.out.println();
            this.out.println("Evaluation Result:");
            this.out.println("==================");
            if (result instanceof Collection) {
                Collection coll = (Collection)result;
                this.println("Result collection (" + coll.getClass().getSimpleName() + ") contains " + coll.size() + " elements.\n", PrintTarget.CLIENT, true);
                for (Object jv : coll) {
                    this.println(jv.toString(), PrintTarget.CLIENT, false);
                }
            } else if (result instanceof Map) {
                Map map = (Map)result;
                this.println("Result map contains " + map.size() + " map entries.\n", PrintTarget.CLIENT, true);
                for (Map.Entry e : map.entrySet()) {
                    this.println(e.getKey() + " --> " + e.getValue(), PrintTarget.CLIENT, false);
                }
            } else {
                this.println("Result is a single element of type " + Types.getGreqlTypeName(result) + ".\n", PrintTarget.CLIENT, true);
                this.println(result.toString(), PrintTarget.CLIENT, false);
            }
            this.out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            e.printStackTrace(this.out);
        }
        return result;
    }

    public static void main(String[] args) throws IOException {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                GreqlServer.terminateServer();
            }
        });
        int port = 10101;
        clientHandlerLoop = new Thread(){
            ServerSocket socket = new ServerSocket(10101);

            @Override
            public void run() {
                while (!this.isInterrupted()) {
                    Socket s = null;
                    try {
                        s = this.socket.accept();
                        GreqlServer client = new GreqlServer(s);
                        clients.add(client);
                        client.start();
                    }
                    catch (IOException e) {
                        System.err.println("Exception while accepting client...");
                        e.printStackTrace();
                    }
                }
            }
        };
        clientHandlerLoop.start();
        System.out.println("GreqlServer listening on port 10101");
    }

    private static void terminateServer() {
        clientHandlerLoop.interrupt();
        for (GreqlServer client : clients) {
            client.interrupt();
        }
    }

    static {
        clients = new HashSet();
        dataGraphs = Collections.synchronizedMap(new HashMap());
    }

    private static enum PrintTarget {
        CLIENT,
        SERVER,
        BOTH;

    }
}

