/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.gui.xdot;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.graphmarker.GraphMarker;
import de.uni_koblenz.jgralab.utilities.gui.xdot.TextShape;
import de.uni_koblenz.jgralab.utilities.gui.xdot.XDotShape;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XDotParser {
    private Color lineColor = Color.black;
    private Color fillColor = Color.black;
    private HashMap<String, Color> colorMap;
    private Font font = null;
    private Graph graph;
    private AttributedElement<?, ?> currentElement;
    private List<XDotShape> shapes;
    private GraphMarker<List<XDotShape>> elementShapes;
    private Rectangle2D bounds;

    public XDotParser(Graph g, GraphMarker<List<XDotShape>> es) {
        this.graph = g;
        this.elementShapes = es;
        this.colorMap = new HashMap();
        this.colorMap.put("black", Color.BLACK);
        this.colorMap.put("white", Color.WHITE);
        this.colorMap.put("red", Color.RED);
        this.colorMap.put("green", Color.GREEN);
        this.colorMap.put("blue", Color.BLUE);
        this.colorMap.put("yellow", Color.YELLOW);
        this.colorMap.put("cyan", Color.CYAN);
        this.colorMap.put("magenta", Color.MAGENTA);
        this.colorMap.put("gray", Color.GRAY);
    }

    private void parseDrawActions(String s) {
        Lexer l = new Lexer(s);
        char action = l.nextChar();
        while (action != '\u0000') {
            switch (action) {
                case 'C': 
                case 'c': {
                    String color = l.nextString();
                    Color c = this.colorMap.get(color);
                    if (c == null) {
                        if (color.charAt(0) == '#') {
                            int r = Integer.parseInt(color.substring(1, 3), 16);
                            int g = Integer.parseInt(color.substring(3, 5), 16);
                            int b = Integer.parseInt(color.substring(5, 7), 16);
                            if (color.length() == 9) {
                                int a = Integer.parseInt(color.substring(7, 9), 16);
                                c = new Color(r, g, b, a);
                            } else {
                                c = new Color(r, g, b);
                            }
                        } else {
                            c = Color.black;
                        }
                        this.colorMap.put(color, c);
                    }
                    if (action == 'c') {
                        this.lineColor = c;
                        break;
                    }
                    this.fillColor = c;
                    break;
                }
                case 'B': 
                case 'L': 
                case 'P': 
                case 'b': 
                case 'p': {
                    XDotShape xs;
                    int i;
                    Path2D.Double p;
                    int n = l.nextInt();
                    double[] xp = new double[n];
                    double[] yp = new double[n];
                    for (int i2 = 0; i2 < n; ++i2) {
                        xp[i2] = l.nextDouble();
                        yp[i2] = l.nextDouble();
                    }
                    if (action == 'p' || action == 'P' || action == 'L') {
                        p = new Path2D.Double();
                        for (i = 0; i < n - 1; ++i) {
                            p.append(new Line2D.Double(xp[i], yp[i], xp[i + 1], yp[i + 1]), i != 0);
                        }
                        if (action != 'L') {
                            p.closePath();
                        }
                        xs = new XDotShape(p, this.lineColor, action == 'P' ? this.fillColor : null, null, null);
                    } else {
                        p = new Path2D.Double();
                        for (i = 0; i < n - 1; i += 3) {
                            p.append(new CubicCurve2D.Double(xp[i], yp[i], xp[i + 1], yp[i + 1], xp[i + 2], yp[i + 2], xp[i + 3], yp[i + 3]), i != 0);
                        }
                        xs = new XDotShape(p, this.lineColor, action == 'b' ? this.fillColor : null, null, null);
                    }
                    this.shapes.add(xs);
                    this.addShapeToCurrentElement(xs);
                    break;
                }
                case 'E': 
                case 'e': {
                    double x = l.nextDouble();
                    double y = l.nextDouble();
                    double w = l.nextDouble();
                    double h = l.nextDouble();
                    Ellipse2D.Double e = new Ellipse2D.Double(x - w, y - h, w * 2.0, h * 2.0);
                    XDotShape xs = new XDotShape(e, this.lineColor, action == 'E' ? this.fillColor : null, null, null);
                    this.shapes.add(xs);
                    this.addShapeToCurrentElement(xs);
                    break;
                }
                case 'F': {
                    double size = l.nextDouble();
                    String name = l.nextString();
                    this.font = new Font(name, 0, (int)size);
                    break;
                }
                case 'T': {
                    double x = l.nextDouble();
                    double y = l.nextDouble();
                    int j = l.nextInt();
                    double w = l.nextDouble();
                    String text = l.nextString();
                    TextShape t = new TextShape(x, y, j, w, text, this.font);
                    XDotShape xs = new XDotShape(t, null, null, this.lineColor, null);
                    this.shapes.add(xs);
                    this.addShapeToCurrentElement(xs);
                    break;
                }
                case 'S': {
                    String style = l.nextString();
                    break;
                }
                default: {
                    throw new RuntimeException("FIXME: Unknown action '" + action + "'");
                }
            }
            action = l.nextChar();
        }
    }

    public void addShapeToCurrentElement(XDotShape xs) {
        if (this.currentElement == null) {
            return;
        }
        xs.setElement(this.currentElement);
        ArrayList<XDotShape> l = (ArrayList<XDotShape>)this.elementShapes.get(this.currentElement);
        if (l == null) {
            l = new ArrayList<XDotShape>();
            this.elementShapes.mark(this.currentElement, l);
        }
        l.add(xs);
    }

    public List<XDotShape> parseXDotFile(InputStream is) throws IOException {
        this.shapes = new ArrayList<XDotShape>();
        this.elementShapes.clear();
        this.bounds = null;
        BufferedReader rdr = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        Pattern pd = Pattern.compile("(_(l|h|t|hl|tl)?draw_)\\s*=\\s*\"([^\"]*)\"");
        Pattern pi = Pattern.compile("(id\\s*=\\s*|cluster_)(\\w+)");
        Pattern pb = Pattern.compile("bb\\s*=\\s*\"(-?\\d+\\.?\\d*),(-?\\d+\\.?\\d*),(-?\\d+\\.?\\d*),(-?\\d+\\.?\\d*)\"");
        this.setCurrentElement(this.graph);
        String l = rdr.readLine();
        while (l != null) {
            Matcher mi;
            Matcher mb;
            StringBuilder sb = new StringBuilder();
            while (l != null && l.endsWith("\\")) {
                sb.append(l.substring(0, l.length() - 1));
                l = rdr.readLine();
            }
            if (l != null) {
                sb.append(l);
            }
            l = sb.toString().replace("\\\"", "\u0001");
            if (this.bounds == null && (mb = pb.matcher(l)).find()) {
                double x0 = Double.parseDouble(mb.group(1));
                double y0 = Double.parseDouble(mb.group(2));
                double x1 = Double.parseDouble(mb.group(3));
                double y1 = Double.parseDouble(mb.group(4));
                this.bounds = new Rectangle2D.Double(x0, y0, x1, y1);
            }
            if ((mi = pi.matcher(l)).find()) {
                String id = mi.group(2);
                if (id.charAt(0) == 'v') {
                    this.setCurrentElement(this.graph.getVertex(Integer.parseInt(id.substring(1))));
                } else if (id.charAt(0) == 'e') {
                    this.setCurrentElement(this.graph.getEdge(Integer.parseInt(id.substring(1))));
                } else {
                    throw new RuntimeException("FIXME: unexpected id format '" + id + "'");
                }
            }
            Matcher md = pd.matcher(l);
            while (md.find()) {
                String drawActions = md.group(3).replace("\u0001", "\"");
                this.parseDrawActions(drawActions);
            }
            l = rdr.readLine();
        }
        rdr.close();
        return this.shapes;
    }

    private void setCurrentElement(AttributedElement<?, ?> el) {
        if (this.currentElement != el) {
            this.currentElement = el;
        }
    }

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    final class Lexer {
        final String s;
        final char[] c;
        int p;

        Lexer(String s) {
            this.s = s;
            this.c = s.toCharArray();
            this.p = 0;
            this.consumeWhitespace();
        }

        final void consumeWhitespace() {
            while (this.p < this.c.length && Character.isWhitespace(this.c[this.p])) {
                ++this.p;
            }
        }

        final char nextChar() {
            if (this.p >= this.c.length) {
                return '\u0000';
            }
            char result = this.c[this.p++];
            this.consumeWhitespace();
            return result;
        }

        final int nextInt() {
            if (this.p >= this.c.length) {
                throw new NoSuchElementException();
            }
            int b = this.p;
            while (this.p < this.c.length && !Character.isWhitespace(this.c[this.p])) {
                ++this.p;
            }
            int result = Integer.parseInt(this.s.substring(b, this.p));
            this.consumeWhitespace();
            return result;
        }

        final double nextDouble() {
            if (this.p >= this.c.length) {
                throw new NoSuchElementException();
            }
            int b = this.p;
            while (this.p < this.c.length && !Character.isWhitespace(this.c[this.p])) {
                ++this.p;
            }
            double result = Double.parseDouble(this.s.substring(b, this.p));
            this.consumeWhitespace();
            return result;
        }

        final String nextString() {
            if (this.p >= this.c.length) {
                throw new NoSuchElementException();
            }
            int l = this.nextInt();
            this.consumeWhitespace();
            if (this.p >= this.c.length) {
                throw new NoSuchElementException();
            }
            if (this.c[this.p] != '-') {
                throw new IllegalArgumentException();
            }
            ++this.p;
            String result = this.s.substring(this.p, this.p + l);
            this.p += l;
            this.consumeWhitespace();
            return result;
        }
    }
}

