/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.gui.xdot;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.utilities.gui.xdot.TextShape;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

public class XDotShape {
    private final Shape shape;
    private Color lineColor;
    private Color fillColor;
    private Color textColor;
    private Stroke stroke;
    private AttributedElement<?, ?> element;

    public XDotShape(Shape s, Color l, Color f, Color t, Stroke st) {
        this.shape = s;
        this.lineColor = l;
        this.fillColor = f;
        this.textColor = t;
        this.stroke = st;
    }

    public AttributedElement<?, ?> getElement() {
        return this.element;
    }

    public void setElement(AttributedElement<?, ?> element) {
        this.element = element;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public void draw(Graphics2D g2) {
        if (this.stroke != null) {
            g2.setStroke(this.stroke);
        }
        if (this.fillColor != null) {
            g2.setColor(this.fillColor);
            g2.fill(this.shape);
        }
        if (this.shape instanceof TextShape && this.textColor != null) {
            TextShape ts = (TextShape)this.shape;
            ts.justify(g2);
            AffineTransform a = g2.getTransform();
            g2.scale(1.0, -1.0);
            g2.setFont(ts.getFont());
            g2.setColor(this.textColor);
            g2.drawString(ts.getText(), (float)ts.x, (float)(-ts.y));
            g2.setTransform(a);
        }
        if (this.lineColor != null) {
            g2.setColor(this.lineColor);
            g2.draw(this.shape);
        }
    }
}

