/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.rsa2tg;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.grumlschema.SchemaGraph;
import de.uni_koblenz.jgralab.grumlschema.domains.Domain;
import de.uni_koblenz.jgralab.grumlschema.domains.EnumDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.HasRecordDomainComponent;
import de.uni_koblenz.jgralab.grumlschema.domains.RecordDomain;
import de.uni_koblenz.jgralab.grumlschema.structure.Annotates;
import de.uni_koblenz.jgralab.grumlschema.structure.Attribute;
import de.uni_koblenz.jgralab.grumlschema.structure.AttributedElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.Comment;
import de.uni_koblenz.jgralab.grumlschema.structure.Constraint;
import de.uni_koblenz.jgralab.grumlschema.structure.ContainsDomain;
import de.uni_koblenz.jgralab.grumlschema.structure.ContainsGraphElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.ContainsSubPackage;
import de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass;
import de.uni_koblenz.jgralab.grumlschema.structure.GraphClass;
import de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.HasAttribute;
import de.uni_koblenz.jgralab.grumlschema.structure.HasConstraint;
import de.uni_koblenz.jgralab.grumlschema.structure.IncidenceClass;
import de.uni_koblenz.jgralab.grumlschema.structure.NamedElement;
import de.uni_koblenz.jgralab.grumlschema.structure.Package;
import de.uni_koblenz.jgralab.grumlschema.structure.Schema;
import de.uni_koblenz.jgralab.grumlschema.structure.SpecializesEdgeClass;
import de.uni_koblenz.jgralab.grumlschema.structure.SpecializesVertexClass;
import de.uni_koblenz.jgralab.grumlschema.structure.VertexClass;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class SchemaGraph2Tg {
    private boolean useShortNames = true;
    private static final String SPACE = " ";
    private static final String EMPTY = "";
    private static final String STAR = "*";
    private static final String DOT = ".";
    private static final String COMMA = ",";
    private static final String DELIMITER = ";";
    private static final String COLON = ":";
    private static final String CURLY_BRACKET_OPENED = "{";
    private static final String CURLY_BRACKET_CLOSED = "}";
    private static final String SQUARE_BRACKET_OPENED = "[";
    private static final String SQUARE_BRACKET_CLOSED = "]";
    private static final String ROUND_BRACKET_OPENED = "(";
    private static final String ROUND_BRACKET_CLOSED = ")";
    private static final String FROM = "from";
    private static final String TO = "to";
    private static final String ROLE = "role";
    private static final String SCHEMA = "Schema";
    private static final String PACKAGE = "Package";
    private static final String COMMENT = "Comment";
    private static final String ABSTRACT = "abstract";
    private static final String VERTEX_CLASS = "VertexClass";
    private static final String GRAPH_CLASS = "GraphClass";
    private static final String RECORD_DOMAIN = "RecordDomain";
    private static final String ENUM_DOMAIN = "EnumDomain";
    private static final String EDGE_CLASS = "EdgeClass";
    private static final String AGGREGATION = "aggregation";
    private static final String AGG_SHARED = "shared";
    private static final String AGG_COMPOSITE = "composite";
    private static final String TGRAPH = "TGraph";
    private static final String TGRAPH_VERSION = "2";
    private static final String ASSIGN = "=";
    private static final String NEWLINE = "\n";
    private final SchemaGraph schemaGraph;
    private final String outputFilename;
    private String currentPackageName;
    private Writer stream;

    public boolean isUseShortNames() {
        return this.useShortNames;
    }

    public void setUseShortNames(boolean useShortNames) {
        this.useShortNames = useShortNames;
    }

    public SchemaGraph2Tg(SchemaGraph sg, String outputFilename) {
        this.schemaGraph = sg;
        this.outputFilename = outputFilename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws IOException {
        try {
            assert (this.outputFilename != null && !this.outputFilename.equals(EMPTY)) : "No output filename specified!";
            assert (this.schemaGraph != null) : "No SchemaGraph specified!";
            this.stream = new PrintWriter(this.outputFilename);
            this.printTGSchema(this.schemaGraph);
            this.stream.append(NEWLINE);
            this.stream.flush();
        }
        finally {
            this.stream.close();
            this.stream = null;
        }
    }

    public void setStream(StringWriter stream) {
        this.stream = stream;
    }

    private void printTGSchema(SchemaGraph schemaGraph) {
        this.println(TGRAPH, SPACE, TGRAPH_VERSION, DELIMITER, NEWLINE);
        Schema schema = schemaGraph.getFirstSchema();
        assert (schema != null);
        this.println(SCHEMA, SPACE, schema.get_packagePrefix(), DOT, schema.get_name(), DELIMITER, NEWLINE);
        Package defaultPackage = (Package)schema.getFirstContainsDefaultPackageIncidence(EdgeDirection.OUT).getThat();
        this.setCurrentPackageName(defaultPackage);
        GraphClass gc = schema.getFirstDefinesGraphClassIncidence(EdgeDirection.OUT).getOmega();
        this.printGraphClass(gc);
        this.printComments(gc);
        this.printPackageWithElements((Package)schema.getFirstContainsDefaultPackageIncidence(EdgeDirection.OUT).getThat());
    }

    private void printPackageWithElements(Package gPackage) {
        this.setCurrentPackageName(gPackage);
        this.printComments(gPackage);
        if (gPackage.get_qualifiedName() != null && !gPackage.get_qualifiedName().isEmpty() || gPackage.getDegree(Annotates.EC) > 0) {
            this.println(PACKAGE, SPACE, this.currentPackageName, DELIMITER);
        }
        for (ContainsDomain cd : gPackage.getContainsDomainIncidences(EdgeDirection.OUT)) {
            this.printDomain((Domain)cd.getThat());
        }
        for (ContainsGraphElementClass cgec : gPackage.getContainsGraphElementClassIncidences(EdgeDirection.OUT)) {
            GraphElementClass gec = (GraphElementClass)cgec.getThat();
            if (gec instanceof EdgeClass) {
                this.printEdgeClass((EdgeClass)gec);
                continue;
            }
            this.printVertexClass((VertexClass)gec);
        }
        for (ContainsSubPackage csp : gPackage.getContainsSubPackageIncidences(EdgeDirection.OUT)) {
            this.printPackageWithElements((Package)csp.getThat());
        }
    }

    private void setCurrentPackageName(Package pkg) {
        this.currentPackageName = pkg.get_qualifiedName();
    }

    private void printComments(NamedElement ne) {
        for (Annotates ann : ne.getAnnotatesIncidences(EdgeDirection.IN)) {
            Comment com = (Comment)ann.getThat();
            this.println(COMMENT, SPACE, ne.get_qualifiedName(), SPACE, GraphIO.toUtfString(com.get_text()), DELIMITER);
        }
    }

    public void printVertexClass(VertexClass vc) {
        this.printComments(vc);
        if (vc.is_abstract()) {
            this.print(ABSTRACT, SPACE);
        }
        this.print(VERTEX_CLASS, SPACE, this.shortName(vc.get_qualifiedName()));
        if (vc.getFirstSpecializesVertexClassIncidence(EdgeDirection.OUT) != null) {
            this.print(COLON, SPACE);
            boolean first = true;
            for (SpecializesVertexClass svc : vc.getSpecializesVertexClassIncidences(EdgeDirection.OUT)) {
                if (first) {
                    first = false;
                } else {
                    this.print(COMMA, SPACE);
                }
                VertexClass superVC = (VertexClass)svc.getThat();
                this.print(this.shortName(superVC.get_qualifiedName()));
            }
        }
        this.printAttributes(vc);
        this.printConstraints(vc);
        this.println(DELIMITER);
    }

    public void printEdgeClass(EdgeClass ec) {
        this.printComments(ec);
        if (ec.is_abstract()) {
            this.print(ABSTRACT, SPACE);
        }
        this.print(EDGE_CLASS, SPACE, this.shortName(ec.get_qualifiedName()));
        if (ec.getFirstSpecializesEdgeClassIncidence(EdgeDirection.OUT) != null) {
            this.print(COLON, SPACE);
            boolean first = true;
            for (SpecializesEdgeClass svc : ec.getSpecializesEdgeClassIncidences(EdgeDirection.OUT)) {
                if (first) {
                    first = false;
                } else {
                    this.print(COMMA, SPACE);
                }
                EdgeClass superEC = (EdgeClass)svc.getThat();
                this.print(this.shortName(superEC.get_qualifiedName()));
            }
        }
        IncidenceClass fromIC = (IncidenceClass)ec.getFirstComesFromIncidence(EdgeDirection.OUT).getThat();
        IncidenceClass toIC = (IncidenceClass)ec.getFirstGoesToIncidence(EdgeDirection.OUT).getThat();
        VertexClass fromVC = (VertexClass)fromIC.getFirstEndsAtIncidence(EdgeDirection.OUT).getThat();
        VertexClass toVC = (VertexClass)toIC.getFirstEndsAtIncidence(EdgeDirection.OUT).getThat();
        this.print(SPACE, FROM, SPACE, this.shortName(fromVC.get_qualifiedName()));
        this.printMultiplicitiesAndRoles(fromIC);
        this.print(SPACE, TO, SPACE, this.shortName(toVC.get_qualifiedName()));
        this.printMultiplicitiesAndRoles(toIC);
        this.printAttributes(ec);
        this.printConstraints(ec);
        this.println(DELIMITER);
    }

    private void printAggregation(IncidenceClass inc) {
        assert (inc != null);
        switch (inc.get_aggregation()) {
            case NONE: {
                break;
            }
            case SHARED: {
                this.print(SPACE, AGGREGATION, SPACE, AGG_SHARED);
                break;
            }
            case COMPOSITE: {
                this.print(SPACE, AGGREGATION, SPACE, AGG_COMPOSITE);
            }
        }
    }

    private String shortName(String qname) {
        if (!this.useShortNames || this.isPredefinedDomainName(qname)) {
            return qname;
        }
        int lastDotIdx = qname.lastIndexOf(46);
        if (lastDotIdx == -1 && !this.currentPackageName.isEmpty()) {
            return '.' + qname;
        }
        if (lastDotIdx != -1 && this.currentPackageName.equals(qname.substring(0, lastDotIdx))) {
            return qname.substring(lastDotIdx + 1);
        }
        return qname;
    }

    private boolean isPredefinedDomainName(String qname) {
        return qname.equals("Integer") || qname.equals("String") || qname.equals("Long") || qname.equals("Double") || qname.startsWith("List<") || qname.startsWith("Set<") || qname.startsWith("Map<") || qname.equals("Boolean");
    }

    private void printMultiplicitiesAndRoles(IncidenceClass ic) {
        String min = ic.get_min() == Integer.MAX_VALUE ? STAR : String.valueOf(ic.get_min());
        String max = ic.get_max() == Integer.MAX_VALUE ? STAR : String.valueOf(ic.get_max());
        this.print(SPACE, ROUND_BRACKET_OPENED, min, COMMA, max, ROUND_BRACKET_CLOSED);
        if (ic.get_roleName() != null && !ic.get_roleName().isEmpty()) {
            this.print(SPACE, ROLE, SPACE, ic.get_roleName());
        }
        this.printAggregation(ic);
    }

    private void printDomain(Domain dom) {
        if (dom instanceof RecordDomain) {
            this.printRecordDomain((RecordDomain)dom);
            return;
        }
        if (dom instanceof EnumDomain) {
            this.printEnumDomain((EnumDomain)dom);
            return;
        }
    }

    private void printEnumDomain(EnumDomain dom) {
        this.printComments(dom);
        this.print(ENUM_DOMAIN, SPACE, this.shortName(dom.get_qualifiedName()), SPACE, ROUND_BRACKET_OPENED);
        boolean first = true;
        for (String constant : dom.get_enumConstants()) {
            if (first) {
                first = false;
            } else {
                this.print(COMMA, SPACE);
            }
            this.print(constant);
        }
        this.println(ROUND_BRACKET_CLOSED, DELIMITER);
    }

    private void printRecordDomain(RecordDomain dom) {
        this.printComments(dom);
        this.print(RECORD_DOMAIN, SPACE, dom.get_qualifiedName(), SPACE, ROUND_BRACKET_OPENED);
        boolean first = true;
        for (HasRecordDomainComponent hc : dom.getHasRecordDomainComponentIncidences(EdgeDirection.OUT)) {
            if (first) {
                first = false;
            } else {
                this.print(COMMA, SPACE);
            }
            Domain compDom = (Domain)hc.getThat();
            this.print(hc.get_name(), COLON, SPACE, this.shortName(compDom.get_qualifiedName()));
        }
        this.println(ROUND_BRACKET_CLOSED, DELIMITER);
    }

    private void printGraphClass(GraphClass gc) {
        this.print(GRAPH_CLASS, SPACE, gc.get_qualifiedName());
        this.printAttributes(gc);
        this.printConstraints(gc);
        this.println(DELIMITER, NEWLINE);
    }

    private void printConstraints(AttributedElementClass aec) {
        for (HasConstraint hc : aec.getHasConstraintIncidences(EdgeDirection.OUT)) {
            Constraint constr = (Constraint)hc.getThat();
            this.print(SPACE, SQUARE_BRACKET_OPENED);
            this.print(GraphIO.toUtfString(constr.get_message()), SPACE);
            this.print(GraphIO.toUtfString(constr.get_predicateQuery()));
            String offElemQ = constr.get_offendingElementsQuery();
            if (offElemQ != null) {
                this.print(SPACE, GraphIO.toUtfString(offElemQ));
            }
            this.print(SQUARE_BRACKET_CLOSED);
        }
    }

    private void printAttributes(AttributedElementClass aec) {
        if (aec.getFirstHasAttributeIncidence(EdgeDirection.OUT) == null) {
            return;
        }
        this.print(SPACE, CURLY_BRACKET_OPENED);
        boolean first = true;
        for (HasAttribute ha : aec.getHasAttributeIncidences(EdgeDirection.OUT)) {
            if (first) {
                first = false;
            } else {
                this.print(COMMA, SPACE);
            }
            Attribute attr = (Attribute)ha.getThat();
            Domain dom = (Domain)attr.getFirstHasDomainIncidence(EdgeDirection.OUT).getThat();
            this.print(attr.get_name(), COLON, SPACE, this.shortName(dom.get_qualifiedName()));
            String defaultValue = attr.get_defaultValue();
            if (defaultValue == null) continue;
            this.print(SPACE, ASSIGN, SPACE, GraphIO.toUtfString(defaultValue));
        }
        this.print(CURLY_BRACKET_CLOSED);
    }

    private void println(String ... strings) {
        this.print(strings);
        try {
            this.stream.write(NEWLINE);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void print(String ... strings) {
        try {
            for (int i = 0; i < strings.length - 1; ++i) {
                this.stream.write(strings[i]);
            }
            this.stream.write(strings[strings.length - 1]);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }
}

