/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tg2dot;

import de.uni_koblenz.ist.utilities.option_handler.OptionHandler;
import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.AbstractBooleanGraphMarker;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.utilities.tg2dot.dot.DotWriter;
import de.uni_koblenz.jgralab.utilities.tg2dot.dot.GraphType;
import de.uni_koblenz.jgralab.utilities.tg2dot.dot.GraphVizLayouter;
import de.uni_koblenz.jgralab.utilities.tg2dot.dot.GraphVizOutputFormat;
import de.uni_koblenz.jgralab.utilities.tg2dot.dot.GraphVizProgram;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.GraphLayout;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.GraphLayoutFactory;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.definition.Definition;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.definition.ElementDefinition;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.definition.TypeDefinition;
import de.uni_koblenz.jgralab.utilities.tg2dot.greql.GreqlEvaluatorFacade;
import de.uni_koblenz.jgralab.utilities.tg2whatever.Tg2Whatever;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class Tg2Dot
extends Tg2Whatever {
    private boolean abbreviateEdgeAttributeNames = false;
    private boolean printIncidenceIndices = false;
    private boolean printElementSequenceIndices = false;
    private String graphLayoutFilename;
    private GraphLayout layout;
    private GreqlEvaluatorFacade evaluator;
    private DotWriter writer;
    private GraphVizLayouter graphVizLayouter;
    private GraphVizOutputFormat graphVizOutputFormat;
    private Level jGraLabLogLevel;

    public static void main(String[] args) {
        Tg2Dot converter = new Tg2Dot();
        converter.getOptions(args);
        System.out.print("Starting processing of graph...");
        try {
            converter.convert();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Finished Processing.");
    }

    @Override
    public void convert() throws IOException {
        if (this.graphVizOutputFormat == null) {
            super.convert();
            return;
        }
        GraphVizProgram prog = new GraphVizProgram().layouter(this.graphVizLayouter).outputFormat(this.graphVizOutputFormat);
        this.pipeToGraphViz(prog);
    }

    public static Tg2Dot createConverterAndSetAttributes(Graph graph, boolean reversedEdges) {
        Tg2Dot converter = new Tg2Dot();
        converter.setGraph(graph);
        converter.setReversedEdges(reversedEdges);
        converter.setPrintEdgeAttributes(true);
        return converter;
    }

    public static void convertGraph(Graph graph, String outputFileName) throws IOException {
        Tg2Dot.convertGraph(graph, outputFileName, false, GraphVizOutputFormat.XDOT);
    }

    public static void convertGraph(Graph graph, String outputFileName, boolean reversedEdges) throws IOException {
        Tg2Dot.convertGraph(graph, outputFileName, reversedEdges, GraphVizOutputFormat.XDOT);
    }

    public static void convertGraph(Graph graph, String outputFileName, GraphVizOutputFormat format) throws IOException {
        Tg2Dot.convertGraph(graph, outputFileName, false, format);
    }

    public static void convertGraph(Graph graph, String outputFileName, boolean reversedEdges, GraphVizOutputFormat format) throws IOException {
        Tg2Dot converter = Tg2Dot.createConverterAndSetAttributes(graph, reversedEdges);
        converter.setOutputFile(outputFileName);
        converter.setGraphVizOutputFormat(format);
        converter.convert();
    }

    public static void convertGraph(AbstractBooleanGraphMarker marker, String outputFileName) throws IOException {
        Tg2Dot.convertGraph(marker, outputFileName, false);
    }

    public static void convertGraph(AbstractBooleanGraphMarker marker, String outputFileName, boolean reversedEdges) throws IOException {
        Tg2Dot.convertGraph(marker, outputFileName, GraphVizOutputFormat.PDF, reversedEdges);
    }

    public static void convertGraph(AbstractBooleanGraphMarker marker, String outputFileName, GraphVizOutputFormat format, boolean reversedEdges) throws IOException {
        Tg2Dot converter = Tg2Dot.createConverterAndSetAttributes(marker.getGraph(), reversedEdges);
        converter.setOutputFile(outputFileName);
        converter.setGraphMarker(marker);
        converter.convert();
    }

    public void pipeToGraphViz(GraphVizProgram prog) throws IOException {
        String executionString = String.format("%s%s -T%s -o%s", new Object[]{prog.path, prog.layouter, prog.outputFormat, this.outputName});
        final Process process = Runtime.getRuntime().exec(executionString);
        new Thread(){

            @Override
            public void run() {
                PrintStream ps = new PrintStream(process.getOutputStream());
                Tg2Dot.this.convert(ps);
                ps.flush();
                ps.close();
            }
        }.start();
        try {
            int retVal = process.waitFor();
            if (retVal != 0) {
                throw new RuntimeException("GraphViz process failed! Error code = " + retVal);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream convertToGraphVizStream(GraphVizProgram prog) throws IOException {
        String executionString = String.format("%s%s -T%s", new Object[]{prog.path, prog.layouter, prog.outputFormat});
        final Process process = Runtime.getRuntime().exec(executionString);
        BufferedInputStream inputStream = new BufferedInputStream(process.getInputStream());
        new Thread(){

            @Override
            public void run() {
                PrintStream ps = new PrintStream(process.getOutputStream());
                Tg2Dot.this.convert(ps);
                ps.flush();
                ps.close();
            }
        }.start();
        return inputStream;
    }

    public ImageIcon convertToGraphVizImageIcon(GraphVizProgram prog) throws IOException {
        BufferedInputStream imageStream = new BufferedInputStream(this.convertToGraphVizStream(prog));
        return new ImageIcon(ImageIO.read(imageStream));
    }

    @Override
    protected void getAdditionalOptions(CommandLine comLine) {
        String gvOutputFormat;
        this.initializeGraphAndSchema();
        this.graphLayoutFilename = comLine.getOptionValue('p');
        this.printIncidenceIndices = comLine.hasOption('i');
        this.printElementSequenceIndices = comLine.hasOption('m');
        String gvLayouter = comLine.getOptionValue('l');
        if (gvLayouter != null) {
            try {
                this.graphVizLayouter = GraphVizLayouter.valueOf(gvLayouter);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Unknown layouter '" + gvLayouter + "'. Possible values are " + GraphVizLayouter.describeValues());
            }
        }
        if ((gvOutputFormat = comLine.getOptionValue('t')) != null) {
            try {
                this.graphVizOutputFormat = GraphVizOutputFormat.valueOf(gvOutputFormat.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Unknown output format  '" + gvOutputFormat + "'. Possible values are " + GraphVizOutputFormat.describeValues());
            }
        }
    }

    @Override
    protected void addAdditionalOptions(OptionHandler optionHandler) {
        Option pListLayout = new Option("p", "pListLayout", true, "(optional): declares a PList-layout file, which should be used to lay out the given graph.");
        pListLayout.setRequired(false);
        optionHandler.addOption(pListLayout);
        Option incidenceIndices = new Option("i", "incidenceIndices", false, "(optional): prints the incidence index to every edge.");
        incidenceIndices.setRequired(false);
        optionHandler.addOption(incidenceIndices);
        Option elementSequenceIndices = new Option("m", "elementSequenceIndices", false, "(optional): prints the element sequence index of every vertex and edge.");
        elementSequenceIndices.setRequired(false);
        optionHandler.addOption(elementSequenceIndices);
        Option gvFormat = new Option("t", "graphVizFormat", true, "(optional): determines the GraphViz output format");
        gvFormat.setRequired(false);
        optionHandler.addOption(gvFormat);
        Option gvLayouter = new Option("l", "graphVizLayouter", true, "(optional): determines the GraphViz layout program (default: 'dot')");
        gvLayouter.setRequired(false);
        optionHandler.addOption(gvLayouter);
    }

    @Override
    protected void graphStart(PrintStream out) {
        this.jGraLabLogLevel = JGraLab.getRootLogger().getLevel();
        JGraLab.setLogLevel(Level.OFF);
        this.initializeEvaluator();
        this.initializeGraphLayout();
        this.setGlobalVariables();
        this.setCommandLineVariables();
        this.createDotWriter(out);
        this.startDotGraph();
    }

    private void initializeEvaluator() {
        this.evaluator = new GreqlEvaluatorFacade(this.graph);
    }

    private void initializeGraphLayout() {
        GraphLayoutFactory factory = new GraphLayoutFactory(this.evaluator);
        if (this.graphLayoutFilename != null) {
            File layoutFile = new File(this.graphLayoutFilename);
            factory.setPListGraphLayoutFilename(layoutFile);
        }
        this.layout = factory.createGraphLayout();
    }

    private void setGlobalVariables() {
        this.evaluator.setVariablesWithGreqlValues(this.layout.getGlobalVariables());
    }

    private void setCommandLineVariables() {
        this.evaluator.setVariable("printRolenames", this.roleNames);
        this.evaluator.setVariable("printIncidenceIndices", this.printIncidenceIndices);
        this.evaluator.setVariable("printElementSequenceIndices", this.printElementSequenceIndices);
        this.evaluator.setVariable("printDomainNames", this.domainNames);
        this.evaluator.setVariable("shortenStrings", this.shortenStrings);
        this.evaluator.setVariable("abbreviateEdgeAttributeNames", this.abbreviateEdgeAttributeNames);
        this.evaluator.setVariable("printEdgeAttributes", this.edgeAttributes);
    }

    private void createDotWriter(PrintStream out) {
        this.writer = new DotWriter(out);
    }

    private void startDotGraph() {
        this.writer.startGraph(GraphType.DIRECTED, this.graph.getAttributedElementClass().getQualifiedName(), this.graph.getId() + " / " + this.graph.getGraphVersion());
    }

    @Override
    protected void printVertex(PrintStream out, Vertex vertex) {
        Definition definition = this.getCorrespondingDefinition(vertex);
        this.evaluator.setStaticVariablesOfGreqlEvaluator((AttributedElementClass<?, ?>)vertex.getAttributedElementClass());
        this.writeLayoutedVertex(vertex, definition);
    }

    private Definition getCorrespondingDefinition(AttributedElement<?, ?> attributedElement) {
        if (this.layout.isDefinedbyElementDefinitions(attributedElement)) {
            return this.constructSpecificElementDefinition(attributedElement);
        }
        TypeDefinition definition = this.layout.getTypeDefinition(attributedElement);
        return definition;
    }

    private Definition constructSpecificElementDefinition(AttributedElement<?, ?> element) {
        Definition definition = this.layout.getTypeDefinition(element);
        definition = definition.clone();
        for (ElementDefinition elementDefinition : this.layout.getElementDefinitions()) {
            if (!elementDefinition.hasElement(element)) continue;
            definition.overwriteAttributes(elementDefinition);
        }
        return definition;
    }

    private void writeLayoutedVertex(Vertex vertex, Definition definition) {
        this.evaluator.setVariablesOfGreqlEvaluator(vertex, this.getCurrentElementSequenceIndex());
        String name = this.getVertexName(vertex);
        Map<String, String> evalutatedList = this.createEvaluatedStyleAttributeList(definition);
        if (!evalutatedList.containsKey("id")) {
            evalutatedList.put("id", name);
        }
        this.writer.writeNode(name, evalutatedList);
    }

    private String getVertexName(Vertex vertex) {
        return "v" + vertex.getId();
    }

    private Map<String, String> createEvaluatedStyleAttributeList(Definition spec) {
        HashMap<String, String> evaluatedList = new HashMap<String, String>();
        for (String attributeName : spec.getAttributeNames()) {
            String query = spec.getAttributeValue(attributeName);
            Object result = this.evaluator.evaluate(query);
            evaluatedList.put(attributeName, result.toString());
        }
        return evaluatedList;
    }

    @Override
    protected void printEdge(PrintStream out, Edge edge) {
        Definition definition = this.getCorrespondingDefinition(edge);
        this.evaluator.setStaticVariablesOfGreqlEvaluator((AttributedElementClass<?, ?>)edge.getAttributedElementClass());
        this.writeLayoutedEdge(edge, definition);
    }

    private void writeLayoutedEdge(Edge edge, Definition definition) {
        this.evaluator.setVariablesOfGreqlEvaluator(edge, this.getCurrentElementSequenceIndex());
        boolean isReversedEdge = this.isReversedEdges();
        Vertex alpha = !isReversedEdge ? edge.getAlpha() : edge.getOmega();
        Vertex omega = !isReversedEdge ? edge.getOmega() : edge.getAlpha();
        String alphaVertex = this.getVertexName(alpha);
        String omegaVertex = this.getVertexName(omega);
        Map<String, String> evaluatedList = this.createEvaluatedStyleAttributeList(definition);
        if (isReversedEdge) {
            this.reverseEdgeAttributes(evaluatedList);
        }
        if (!evaluatedList.containsKey("id")) {
            evaluatedList.put("id", "e" + edge.getNormalEdge().getId());
        }
        this.writer.writeEdge(alphaVertex, omegaVertex, evaluatedList);
    }

    private void reverseEdgeAttributes(Map<String, String> evaluatedList) {
        for (Map.Entry<String, String> entry : DotWriter.reversableEdgeAttributePairs.entrySet()) {
            this.swapAttributes(entry.getKey(), entry.getValue(), evaluatedList);
        }
    }

    private void swapAttributes(String head, String tail, Map<String, String> evaluatedList) {
        String headValue = evaluatedList.remove(head);
        String tailValue = evaluatedList.remove(tail);
        if (headValue != null) {
            evaluatedList.put(tail, headValue);
        }
        if (tailValue != null) {
            evaluatedList.put(head, tailValue);
        }
    }

    @Override
    protected void graphEnd(PrintStream out) {
        this.writer.close();
        this.writer = null;
        JGraLab.setLogLevel(this.jGraLabLogLevel);
    }

    @Override
    protected String stringQuote(String s) {
        throw new RuntimeException("This method should have been called!");
    }

    public boolean printsIncidenceNumbers() {
        return this.printIncidenceIndices;
    }

    public void setPrintIncidenceNumbers(boolean printIncidenceNumbers) {
        this.printIncidenceIndices = printIncidenceNumbers;
    }

    public boolean isAbbreviateAttributeNames() {
        return this.abbreviateEdgeAttributeNames;
    }

    public void setAbbreviateAttributeNames(boolean abbreviateAttributeNames) {
        this.abbreviateEdgeAttributeNames = abbreviateAttributeNames;
    }

    public GraphLayout getGraphLayout() {
        return this.layout;
    }

    public void setGraphLayout(GraphLayout layout) {
        this.layout = layout;
    }

    public boolean isAbbreviateEdgeAttributeNames() {
        return this.abbreviateEdgeAttributeNames;
    }

    public void setAbbreviateEdgeAttributeNames(boolean abbreviateEdgeAttributeNames) {
        this.abbreviateEdgeAttributeNames = abbreviateEdgeAttributeNames;
    }

    public boolean isPrintElementSequenceIndices() {
        return this.printElementSequenceIndices;
    }

    public void setPrintElementSequenceIndices(boolean printElementSequenceIndices) {
        this.printElementSequenceIndices = printElementSequenceIndices;
    }

    public String getGraphLayoutFilename() {
        return this.graphLayoutFilename;
    }

    public void setPListGraphLayoutFilename(String graphLayoutFilename) {
        this.graphLayoutFilename = graphLayoutFilename;
    }

    public GraphVizLayouter getGraphVizLayouter() {
        return this.graphVizLayouter;
    }

    public void setGraphVizLayouter(GraphVizLayouter graphVizLayouter) {
        this.graphVizLayouter = graphVizLayouter;
    }

    public GraphVizOutputFormat getGraphVizOutputFormat() {
        return this.graphVizOutputFormat;
    }

    public void setGraphVizOutputFormat(GraphVizOutputFormat graphVizOutputFormat) {
        this.graphVizOutputFormat = graphVizOutputFormat;
    }
}

