/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tg2dot.dot;

import de.uni_koblenz.jgralab.utilities.tg2dot.dot.GraphElementType;
import de.uni_koblenz.jgralab.utilities.tg2dot.dot.GraphType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DotWriter {
    private static final String QUOTATIONMARKS = "\"";
    private static final String TABULATOR = "  ";
    public static final Set<String> allowedDotEdgeAttributes;
    public static final Set<String> allowedDotNodeAttributes;
    private PrintStream out;
    private int nestedDepth;
    public static final Map<String, String> reversableEdgeAttributePairs;

    public DotWriter(String filename) throws FileNotFoundException {
        this.out = new PrintStream(filename);
    }

    public DotWriter(File file) throws FileNotFoundException {
        this.out = new PrintStream(file);
    }

    public DotWriter(PrintStream out) {
        this.out = out;
    }

    public void startGraph(GraphType type, String name, String idAndVersion) {
        this.out.println("# Graph ID / Version: " + idAndVersion);
        this.startElement();
        this.out.print(type.name + " " + name + " ");
        this.startAbstractGroup();
    }

    public void startGroup() {
        this.startElement();
        this.startAbstractGroup();
    }

    private void startAbstractGroup() {
        ++this.nestedDepth;
        this.out.println('{');
    }

    public void endGroup() {
        --this.nestedDepth;
        this.startElement();
        this.out.println('}');
    }

    public void endGraph() {
        int depth = this.nestedDepth;
        for (int i = 0; i < depth; ++i) {
            this.endGroup();
        }
    }

    public void writeGeneralAttributeList(GraphElementType type, Map<String, String> attributeList) {
        this.startElement();
        this.out.print(type.name);
        this.writeAttributeList(attributeList);
        this.endElement();
    }

    private void writeAttributeList(Map<String, String> attributeList) {
        if (attributeList.isEmpty()) {
            return;
        }
        this.startAttributeList();
        String delimiter = "";
        for (Map.Entry<String, String> entry : attributeList.entrySet()) {
            this.out.print(delimiter);
            delimiter = ", ";
            this.writeAttribute(entry.getKey(), entry.getValue());
        }
        this.endAttributeList();
    }

    private void startAttributeList() {
        this.out.print('[');
    }

    private void writeAttribute(String name, String value) {
        this.out.print(name + " = ");
        boolean isHtml = value.startsWith("<<") && value.endsWith(">>");
        String quotationMarks = isHtml ? "" : QUOTATIONMARKS;
        this.out.print(quotationMarks + value + quotationMarks);
    }

    private void endAttributeList() {
        this.out.print(']');
    }

    private void startElement() {
        this.writeIndent();
    }

    private void writeIndent() {
        for (int i = 0; i < this.nestedDepth; ++i) {
            this.out.print(TABULATOR);
        }
    }

    private void endElement() {
        this.out.println(';');
    }

    public void writeEdge(String startNode, String endNode, Map<String, String> attributeList) {
        String[] endNodeList = new String[]{endNode};
        this.writeEdge(startNode, endNodeList, attributeList);
    }

    public void writeEdge(String startNode, String[] endNodes, Map<String, String> attributeList) {
        this.startElement();
        this.out.print(this.processName(startNode) + " -> ");
        this.writeNodeList(endNodes);
        if (attributeList != null) {
            this.writeAttributeList(attributeList);
        }
        this.endElement();
    }

    public void writeNode(String name) {
        this.writeNode(name, null);
    }

    public void writeNode(String name, Map<String, String> attributeList) {
        this.startElement();
        name = this.processName(name);
        this.out.print(name);
        if (attributeList != null) {
            this.writeAttributeList(attributeList);
        }
        this.endElement();
    }

    private String processName(String name) {
        if (name.contains(" ")) {
            name = QUOTATIONMARKS + name + QUOTATIONMARKS;
        }
        return name;
    }

    private void writeNodeList(String[] nodeNames) {
        String delimiter = "";
        for (String name : nodeNames) {
            this.out.print(delimiter);
            delimiter = ", ";
            this.out.print(this.processName(name));
        }
    }

    public void startSubgraph() {
        this.startElement();
        this.out.print("subgraph");
        this.startAbstractGroup();
    }

    public void startCluster(String name) {
        this.startElement();
        this.out.print("subgraph " + name);
        this.startAbstractGroup();
    }

    public void close() {
        this.endGraph();
        this.out.flush();
    }

    private static Map<String, String> createReversableEdgeAttributePairMap() {
        HashMap<String, String> edgeAttributePairs = new HashMap<String, String>();
        edgeAttributePairs.put("headURL", "tailURL");
        edgeAttributePairs.put("headclip", "tailclip");
        edgeAttributePairs.put("headhref", "tailhref");
        edgeAttributePairs.put("headlabel", "taillabel");
        edgeAttributePairs.put("headport", "tailport");
        edgeAttributePairs.put("headtarget", "tailtarget");
        edgeAttributePairs.put("headtooltip", "tailtooltip");
        edgeAttributePairs.put("arrowhead", "arrowtail");
        edgeAttributePairs.put("lhead", "ltail");
        edgeAttributePairs.put("samehead", "sametail");
        return Collections.unmodifiableMap(edgeAttributePairs);
    }

    private static Set<String> createAllowedDotEdgeAttributes() {
        String[] allowedDotAttributes = new String[]{"URL", "arrowhead", "arrowsize", "arrowtail", "color", "colorscheme", "comment", "constraint", "decorate", "dir", "edgeURL", "edgehref", "edgetarget", "edgetooltip", "fontcolor", "fontname", "fontsize", "headURL", "headclip", "headhref", "headlabel", "headport", "headtarget", "headtooltip", "href", "id", "label", "labelURL", "labelangle", "labeldistance", "labelfloat", "labelfontcolor", "labelfontname", "labelfontsize", "labelhref", "labeltarget", "labeltooltip", "layer", "len", "lhead", "lp", "ltail", "minlen", "nojustify", "penwidth", "pos", "samehead", "sametail", "showboxes", "style", "tailURL", "tailclip", "tailhref", "taillabel", "tailport", "tailtarget", "tailtooltip", "target", "tooltip", "weight"};
        List<String> allowedDotEdgeAttributes = Arrays.asList(allowedDotAttributes);
        return Collections.unmodifiableSet(new HashSet<String>(allowedDotEdgeAttributes));
    }

    public static Set<String> createAllowedDotNodeAttributes() {
        String[] allowedNodeAttribute = new String[]{"URL", "color", "colorscheme", "comment", "distortion", "fillcolor", "fixedsize", "fontcolor", "fontname", "fontsize", "group", "height", "id", "image", "imagescale", "label", "labelloc", "layer", "margin", "nojustify", "orientation", "penwidth", "peripheries", "pin", "pos", "rects", "regular", "root", "samplepoints", "shape", "shapefile", "showboxes", "sides", "skew", "sortv", "style", "target", "tooltip", "vertices", "width"};
        List<String> allowedDotNodeAttributes = Arrays.asList(allowedNodeAttribute);
        return Collections.unmodifiableSet(new HashSet<String>(allowedDotNodeAttributes));
    }

    static {
        reversableEdgeAttributePairs = DotWriter.createReversableEdgeAttributePairMap();
        allowedDotEdgeAttributes = DotWriter.createAllowedDotEdgeAttributes();
        allowedDotNodeAttributes = DotWriter.createAllowedDotNodeAttributes();
    }
}

