/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout;

import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.GraphLayout;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.definition.Definition;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.definition.ElementDefinition;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.definition.TypeDefinition;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.reader.GraphLayoutReader;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.reader.plist.PListGraphLayoutReader;
import de.uni_koblenz.jgralab.utilities.tg2dot.greql.GreqlEvaluatorFacade;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.pcollections.PSet;

public class GraphLayoutFactory {
    private Schema schema;
    private GreqlEvaluatorFacade evaluator;
    private GraphLayout currentGraphLayout;
    private GraphLayoutReader reader;
    private File graphLayoutFile;

    public GraphLayoutFactory(GreqlEvaluatorFacade evaluator) {
        this.evaluator = evaluator;
        this.schema = evaluator.getSchema();
    }

    public void setPListGraphLayoutFilename(File graphLayoutFile) {
        this.graphLayoutFile = graphLayoutFile;
        this.reader = new PListGraphLayoutReader(this.evaluator);
    }

    public GraphLayout createGraphLayout() {
        try {
            this.createAndLoadGraphLayoutFromFile();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return this.currentGraphLayout;
    }

    public void createAndLoadGraphLayoutFromFile() throws FileNotFoundException {
        this.validate();
        this.initializeProcessingStructures();
        this.loadFromFile();
        this.applyHierarchieToTypeDefinitions();
        this.evaluateElementDefinitions();
    }

    private void loadFromFile() throws FileNotFoundException {
        if (this.reader == null) {
            return;
        }
        this.reader.startProcessing(this.graphLayoutFile, this.currentGraphLayout);
    }

    private void validate() {
        if (this.schema == null || this.evaluator == null) {
            throw new RuntimeException("The Schema, GreqlEvaluator or both are not set.");
        }
    }

    private void initializeProcessingStructures() {
        this.currentGraphLayout = new GraphLayout();
        this.currentGraphLayout.setSchema(this.schema);
        this.currentGraphLayout.initiateAllTypeDefinitions();
        this.setDefaultVertexLayout();
        this.setDefaultEdgeLayout();
    }

    private void setDefaultVertexLayout() {
        TypeDefinition definition = this.currentGraphLayout.getTypeDefinition(this.schema.getGraphClass().getDefaultVertexClass());
        definition.setAttribute("label", "'{{v' ++ id(el) ++ (printElementSequenceIndices ? ' (' ++ elementSequenceIndex ++ ')'  : '') ++ ' | ' ++ typeName(el) ++ '}|' ++ joinWithCollection(\"\\l\", from attr:attributeNames(el) reportSet (attr ++ ' = ' ++ (shortenStrings ? shortenString(toDotString(attrVal), 17) : toDotString(attrVal) ++ (printDomainNames ? ': ' ++ attributeType(el, attr) : ''))) end where attrVal := getValue(el, attr)) ++ '}'");
        definition.setAttribute("shape", "'record'");
        definition.setAttribute("color", "'#999999'");
        definition.setAttribute("fontsize", "14");
        definition.setAttribute("fontname", "'Sans Serif'");
        definition.setAttribute("margin", "'0.02,0.005'");
    }

    private void setDefaultEdgeLayout() {
        TypeDefinition definition = this.currentGraphLayout.getTypeDefinition(this.schema.getGraphClass().getDefaultEdgeClass());
        definition.setAttribute("color", "'gray'");
        definition.setAttribute("label", "'e' ++ id(el) ++ ' : ' ++ typeName(el) ++ (printElementSequenceIndices ? ' (' ++ elementSequenceIndex ++ ')'  : '') ++ (printEdgeAttributes ? '\\n' ++ joinWithCollection('\\l', from attr:attributeNames(el) reportSet ((abbreviateEdgeAttributeNames ? abbreviateString(attr) : attr) ++ ' = ' ++ (shortenStrings ? shortenString(toDotString(attrVal), 17) : toDotString(attrVal) ++ (printDomainNames ? ': ' ++ attributeType(el, attr) : ''))) end where attrVal := getValue(el, attr)) : '')");
        definition.setAttribute("arrowhead", "((sharedThis)? 'odiamond' :(compositeThis)? 'diamond': '') ++ 'normal'");
        definition.setAttribute("arrowtail", "(sharedThat) ? 'odiamond' :(compositeThat) ? 'diamond' : 'none'");
        definition.setAttribute("taillabel", "((printIncidenceIndices) ? alphaIncidenceNumber(el) : '') ++ ((printIncidenceIndices and printRolenames and nequals(alphaRolename(el), '')) ? '; ' : '') ++ ((printRolenames) ? alphaRolename(el) : '')");
        definition.setAttribute("headlabel", "((printIncidenceIndices) ? omegaIncidenceNumber(el) : '') ++ ((printIncidenceIndices and printRolenames and nequals(omegaRolename(el), '')) ? '; ' : '') ++ ((printRolenames) ? omegaRolename(el) : '')");
        definition.setAttribute("dir", "'both'");
        definition.setAttribute("fontsize", "14");
        definition.setAttribute("fontname", "'Sans Serif'");
        definition.setAttribute("labelfontsize", "10");
        definition.setAttribute("labelfontname", "'Sans Serif'");
    }

    private void applyHierarchieToTypeDefinitions() {
        this.applyHierarchie(this.currentGraphLayout.vertexTypeDefinitions, true);
        this.applyHierarchie(this.currentGraphLayout.edgeTypeDefinitions, false);
    }

    private <T extends GraphElementClass<?, ?>> void applyHierarchie(Map<T, TypeDefinition> map, boolean isVertexClasses) {
        ArrayList<GraphElementClass<VertexClass, Vertex>> allSchemaTypes = new ArrayList<GraphElementClass<VertexClass, Vertex>>();
        if (isVertexClasses) {
            allSchemaTypes.addAll(this.schema.getGraphClass().getVertexClasses());
        } else {
            allSchemaTypes.addAll(this.schema.getGraphClass().getEdgeClasses());
        }
        for (Map.Entry<T, TypeDefinition> entry : map.entrySet()) {
            GraphElementClass type = (GraphElementClass)entry.getKey();
            ArrayList<GraphElementClass<VertexClass, Vertex>> allSuperClasses = new ArrayList<GraphElementClass<VertexClass, Vertex>>(allSchemaTypes);
            allSuperClasses.retainAll(type.getAllSuperClasses());
            if (isVertexClasses) {
                allSuperClasses.add(0, type.getGraphClass().getDefaultVertexClass());
            } else {
                allSuperClasses.add(0, type.getGraphClass().getDefaultEdgeClass());
            }
            Collections.reverse(allSuperClasses);
            for (AttributedElementClass attributedElementClass : allSuperClasses) {
                Definition spec = map.get(attributedElementClass);
                entry.getValue().addNonExistingAttributes(spec);
            }
        }
    }

    private void evaluateElementDefinitions() {
        for (ElementDefinition definition : this.currentGraphLayout.elementDefinitions) {
            Object result = this.evaluator.evaluate(definition.getGreqlString());
            if (result instanceof PSet) {
                PSet set = (PSet)result;
                this.evaluateJValueSet(set, definition);
                continue;
            }
            if (!(result instanceof GraphElement)) continue;
            this.addGraphElementToElementDefinition(definition, (GraphElement)result);
        }
    }

    private void evaluateJValueSet(PSet<GraphElement<?, ?>> result, ElementDefinition definition) {
        for (GraphElement graphElement : result) {
            this.addGraphElementToElementDefinition(definition, graphElement);
        }
    }

    private void addGraphElementToElementDefinition(ElementDefinition definition, GraphElement<?, ?> el) {
        if (el != null) {
            definition.add(el);
            this.currentGraphLayout.attributedElementsDefinedByElementDefinitions.add(el);
        }
    }
}

