/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.reader.plist;

import de.uni_koblenz.ist.utilities.plist.PList;
import de.uni_koblenz.ist.utilities.plist.PListDict;
import de.uni_koblenz.ist.utilities.plist.PListException;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.GraphLayout;
import de.uni_koblenz.jgralab.utilities.tg2dot.graph_layout.reader.AbstractGraphLayoutReader;
import de.uni_koblenz.jgralab.utilities.tg2dot.greql.GreqlEvaluatorFacade;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Map;

public class PListGraphLayoutReader
extends AbstractGraphLayoutReader {
    public PListGraphLayoutReader(GreqlEvaluatorFacade evaluator) {
        super(evaluator);
    }

    @Override
    public void startProcessing(File file, GraphLayout layout) throws FileNotFoundException {
        this.startProcessing(file.getPath(), layout);
    }

    @Override
    public void startProcessing(String path, GraphLayout graphLayout) throws FileNotFoundException {
        this.graphLayout = graphLayout;
        try {
            PList plist = new PList(path);
            PListDict dict = plist.getDict();
            this.readOut(dict);
        }
        catch (PListException e) {
            e.printStackTrace();
        }
    }

    private void readOut(PListDict dict) {
        for (Map.Entry<String, Object> entry : dict.entrySet()) {
            String key = entry.getKey();
            if (this.isGlobalVariable(key)) {
                this.processGlobalVariable(key, dict.getString(key, "''"));
                continue;
            }
            this.definitionStarted(key);
            this.processDefinitionAttributes(dict.getDict(key));
            this.definitionEnded();
        }
    }

    private void processDefinitionAttributes(PListDict dict) {
        for (Map.Entry<String, Object> attribute : dict.entrySet()) {
            this.processDefinitionAttribute(attribute.getKey(), attribute.getValue().toString());
        }
    }
}

