/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tg2schemagraph;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class TGComparer {
    public static boolean compareTGFiles(String filename1, String filename2) {
        return new TGComparer().compare(filename1, filename2);
    }

    public boolean compare(String filename1, String filename2) {
        try {
            ArrayList<String> tg1 = this.readIn(filename1);
            ArrayList<String> tg2 = this.readIn(filename2);
            System.out.println("Comparing (left) Filename:  " + filename1);
            System.out.println("with (right) Filename:      " + filename2);
            Collections.sort(tg1);
            Collections.sort(tg2);
            this.dropEmptyLines(tg1);
            this.dropEmptyLines(tg2);
            this.lineDiff(tg1, tg2);
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
        return false;
    }

    private void dropEmptyLines(ArrayList<String> lines) {
        ArrayList<String> dropList = new ArrayList<String>();
        for (String line : lines) {
            if (line.trim().length() != 0) continue;
            dropList.add(line);
        }
        for (String line : dropList) {
            lines.remove(line);
        }
    }

    private void lineDiff(ArrayList<String> linesLeft, ArrayList<String> linesRight) {
        if (linesLeft.size() != linesRight.size()) {
            System.out.println("Number of lines are different.");
        }
        for (int i = 0; i < linesLeft.size() && i < linesRight.size(); ++i) {
            String[] rightSplit;
            String left = linesLeft.get(i);
            String right = linesRight.get(i);
            String[] leftSplit = this.split(left);
            boolean equal = leftSplit.length == (rightSplit = this.split(right)).length;
            int min = leftSplit.length < rightSplit.length ? leftSplit.length : rightSplit.length;
            for (int j = 0; j < min; ++j) {
                String leftTemp = leftSplit[j];
                String rightTemp = rightSplit[j];
                if (leftTemp.contains("{") && rightTemp.contains("{")) {
                    if (j % 2 == 0) {
                        equal &= this.compareSubLine(leftTemp, rightTemp);
                        continue;
                    }
                    equal &= this.compareString(leftTemp, rightTemp);
                    continue;
                }
                equal &= !leftSplit[j].contains("{") && !rightSplit[j].contains("{");
            }
            if (equal) continue;
            System.out.println("error");
            System.out.println("left : " + left);
            System.out.println("right: " + right);
        }
    }

    private boolean compareAttributes(String left, String right) {
        Object[] rightSplit;
        Object[] leftSplit = left.split(",");
        if (leftSplit.length != (rightSplit = right.split(",")).length) {
            return false;
        }
        for (int i = 0; i < leftSplit.length; ++i) {
            leftSplit[i] = ((String)leftSplit[i]).trim();
            rightSplit[i] = ((String)rightSplit[i]).trim();
        }
        Arrays.sort(leftSplit);
        Arrays.sort(rightSplit);
        boolean equal = true;
        for (int i = 0; i < leftSplit.length; ++i) {
            equal &= ((String)leftSplit[i]).equals(rightSplit[i]);
        }
        return equal;
    }

    private boolean compareString(String left, String right) {
        return left.equals(right);
    }

    private boolean compareSubLine(String left, String right) {
        String[] rightSplit;
        left = left.replace('{', '\"');
        right = right.replace('{', '\"');
        left = left.replace('}', '\"');
        right = right.replace('}', '\"');
        String[] leftSplit = left.split("\"");
        if (leftSplit.length != (rightSplit = right.split("\"")).length) {
            return false;
        }
        boolean equal = leftSplit[0].equals(rightSplit[0]);
        if (leftSplit.length == 2) {
            return false;
        }
        if (leftSplit.length > 2) {
            equal &= this.compareAttributes(leftSplit[1], rightSplit[1]);
            equal &= rightSplit[2].equals(rightSplit[2]);
        }
        if (leftSplit.length > 3) {
            for (int i = 3; i < leftSplit.length; ++i) {
                equal &= leftSplit[i].equals(rightSplit[i]);
            }
        }
        return equal;
    }

    private String[] split(String string) {
        return string.split("\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> readIn(String filename) throws IOException {
        ArrayList<String> stringList = null;
        try (BufferedReader br = null;){
            br = new BufferedReader(new FileReader(filename));
            stringList = new ArrayList<String>();
            while (br.ready()) {
                stringList.add(br.readLine());
            }
        }
        return stringList;
    }

    public static void main(String[] args) {
        for (String filename : args) {
            TGComparer comp = new TGComparer();
            comp.compare(filename, filename + ".testSCHEMA");
        }
        System.out.println("Fini.");
    }
}

