/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tg2whatever;

import de.uni_koblenz.ist.utilities.option_handler.OptionHandler;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.graphmarker.AbstractBooleanGraphMarker;
import de.uni_koblenz.jgralab.impl.ConsoleProgressFunction;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public abstract class Tg2Whatever {
    protected Graph graph = null;
    protected String graphFileName = null;
    protected String schemaFileName = null;
    protected Schema schema = null;
    protected String outputName = null;
    protected boolean domainNames = false;
    protected boolean edgeAttributes = false;
    private boolean reversedEdges = false;
    private int currentElementSequenceIndex = -1;
    protected boolean roleNames = false;
    protected boolean shortenStrings = false;
    protected AbstractBooleanGraphMarker marker = null;

    public boolean isReversedEdges() {
        return this.reversedEdges;
    }

    public void setReversedEdges(boolean reversedEdges) {
        this.reversedEdges = reversedEdges;
    }

    public void setGraphMarker(AbstractBooleanGraphMarker m) {
        this.marker = m;
    }

    public void setSchema(Schema s) {
        this.schema = s;
    }

    public void setSchema(String fileName) {
        this.schemaFileName = fileName;
    }

    public void setGraph(Graph g) {
        this.graph = g;
    }

    public void setGraph(String fileName) throws GraphIOException {
        this.graphFileName = fileName;
        this.graph = GraphIO.loadGraphFromFile(this.graphFileName, new ConsoleProgressFunction("Loading"));
    }

    public void setOutputFile(String file) {
        this.outputName = file;
    }

    public void setPrintRoleNames(boolean print) {
        this.roleNames = print;
    }

    public void setShortenStrings(boolean shorten) {
        this.shortenStrings = shorten;
    }

    public void setPrintEdgeAttributes(boolean print) {
        this.edgeAttributes = print;
    }

    public void setPrintReversedEdges(boolean print) {
        this.reversedEdges = print;
    }

    public void setPrintDomainNames(boolean print) {
        this.domainNames = print;
    }

    public void convert() throws IOException {
        if (this.outputName == null || this.outputName.equals("")) {
            this.convert(System.out);
        } else {
            PrintStream out = new PrintStream(new FileOutputStream(this.outputName));
            this.convert(out);
            out.close();
        }
    }

    public void convert(PrintStream out) {
        this.initializeGraphAndSchema();
        this.graphStart(out);
        this.printVertices(out);
        this.printEdges(out);
        this.graphEnd(out);
    }

    private void printEdges(PrintStream out) {
        this.currentElementSequenceIndex = 0;
        for (Edge e : this.graph.edges()) {
            ++this.currentElementSequenceIndex;
            if (this.marker != null && !this.marker.isMarked(e)) continue;
            this.printEdge(out, e);
        }
    }

    private void printVertices(PrintStream out) {
        this.currentElementSequenceIndex = 0;
        for (Vertex v : this.graph.vertices()) {
            ++this.currentElementSequenceIndex;
            if (this.marker != null && !this.marker.isMarked(v)) continue;
            this.printVertex(out, v);
        }
    }

    public int getCurrentElementSequenceIndex() {
        return this.currentElementSequenceIndex;
    }

    private void loadGraph() {
        try {
            System.out.println("Loading graph from file " + this.graphFileName);
            this.graph = GraphIO.loadGraphFromFile(this.graphFileName, this.schema, ImplementationType.STANDARD, new ConsoleProgressFunction("Loading"));
            System.out.println("Graph loaded");
        }
        catch (GraphIOException ex) {
            System.err.println("Graph in file '" + this.graphFileName + "' could not be read.");
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private void loadSchemaFromGraph() {
        try {
            System.out.println("Loading Schema from Graph");
            this.schema = GraphIO.loadSchemaFromFile(this.graphFileName);
            this.schema.compile(CodeGeneratorConfiguration.MINIMAL);
            System.out.println("Schema loaded");
        }
        catch (GraphIOException ex) {
            System.err.println("Graph in file '" + this.graphFileName + "' could not be read.");
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private void loadSchema() {
        try {
            System.out.println("Loaded schema");
            this.schema = GraphIO.loadSchemaFromFile(this.schemaFileName);
            System.out.println("Schema loaded");
        }
        catch (GraphIOException ex) {
            System.err.println("Schema in file '" + this.schemaFileName + "' could not be read.");
            System.exit(1);
        }
    }

    protected abstract void graphStart(PrintStream var1);

    protected abstract void graphEnd(PrintStream var1);

    protected abstract void printVertex(PrintStream var1, Vertex var2);

    protected abstract void printEdge(PrintStream var1, Edge var2);

    protected abstract String stringQuote(String var1);

    protected void getOptions(String[] args) {
        CommandLine comLine = this.processCommandLineOptions(args);
        assert (comLine != null);
        String graphName = null;
        String schemaName = null;
        if (comLine.hasOption("g")) {
            try {
                graphName = comLine.getOptionValue("g");
                this.setGraph(graphName);
            }
            catch (GraphIOException e) {
                System.err.println("Coundn't load graph in file '" + graphName + "': " + e.getMessage());
                if (e.getCause() != null) {
                    e.getCause().printStackTrace();
                }
                System.exit(1);
            }
        }
        if (comLine.hasOption("o")) {
            this.outputName = comLine.getOptionValue("o").trim();
        }
        if (comLine.hasOption("a")) {
            schemaName = comLine.getOptionValue("a");
            this.setSchema(schemaName);
        }
        this.reversedEdges = comLine.hasOption("r");
        this.domainNames = comLine.hasOption("d");
        this.edgeAttributes = comLine.hasOption("e");
        this.roleNames = comLine.hasOption("n");
        this.shortenStrings = comLine.hasOption("s");
        this.getAdditionalOptions(comLine);
    }

    protected void getAdditionalOptions(CommandLine comLine) {
    }

    protected void initializeGraphAndSchema() {
        if (this.graph == null) {
            if (this.schema == null) {
                if (this.schemaFileName != null) {
                    this.loadSchema();
                } else {
                    this.loadSchemaFromGraph();
                }
            }
            this.loadGraph();
        }
    }

    protected final CommandLine processCommandLineOptions(String[] args) {
        OptionHandler oh = this.createOptionHandler();
        this.addAdditionalOptions(oh);
        return oh.parse(args);
    }

    protected void addAdditionalOptions(OptionHandler optionHandler) {
    }

    protected final OptionHandler createOptionHandler() {
        String toolString = "java " + this.getClass().getName();
        String versionString = JGraLab.getInfo(false);
        OptionHandler oh = new OptionHandler(toolString, versionString);
        Option graph = new Option("g", "graph", true, "(required): the graph to be converted");
        graph.setRequired(true);
        graph.setArgName("file");
        oh.addOption(graph);
        Option alternativeSchema = new Option("a", "alternative-schema", true, "(optional): the schema that should be used instead of the one included in the graph file");
        alternativeSchema.setRequired(false);
        graph.setArgName("file");
        oh.addOption(alternativeSchema);
        Option domains = new Option("d", "domains", false, "(optional): if set, domain names of attributes will be printed");
        domains.setRequired(false);
        oh.addOption(domains);
        Option edgeAttributes = new Option("e", "edgeattr", false, "(optional): if set, edge attributes will be printed");
        edgeAttributes.setRequired(false);
        oh.addOption(edgeAttributes);
        Option rolenames = new Option("n", "rolenames", false, "(optional): if set, role names will be printed");
        rolenames.setRequired(false);
        oh.addOption(rolenames);
        Option output = new Option("o", "output", true, "(required): the output file name, or empty for stdout");
        output.setRequired(true);
        output.setArgName("file");
        oh.addOption(output);
        Option reversed = new Option("r", "reversed", false, "(optional): useful if edges run from child nodes to their parents results in a tree with root node at top");
        reversed.setRequired(false);
        oh.addOption(reversed);
        Option shortenStrings = new Option("s", "shorten-strings", false, "(optional): if set, strings are shortened");
        shortenStrings.setRequired(false);
        oh.addOption(shortenStrings);
        return oh;
    }
}

