/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tgraphbrowser;

import de.uni_koblenz.ist.utilities.option_handler.OptionHandler;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.utilities.tgraphbrowser.RequestThread;
import de.uni_koblenz.jgralab.utilities.tgraphbrowser.StateRepository;
import de.uni_koblenz.jgralab.utilities.tgraphbrowser.TabularVisualizer;
import de.uni_koblenz.jgralab.utilities.tgraphbrowser.TwoDVisualizer;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class TGraphBrowserServer
extends Thread {
    private static final String[] versionInfo;
    private static final String[] copyrightInfo;
    public static Logger logger;
    public static long starttime;
    public static final String VERSION = "SimpleWebServer  http://www.jibble.org/";
    private static final int DEFAULT_PORT = 8080;
    private String workspace;
    private final ServerSocket _serverSocket;
    private final boolean _running = true;

    public TGraphBrowserServer(int port, String path, String maximumFileSize, String maximumWorkspaceSize) throws IOException {
        this.workspace = path;
        if (path != null && (this.workspace.startsWith("\"") || this.workspace.startsWith("'"))) {
            this.workspace = this.workspace.substring(1, this.workspace.length() - 1);
        }
        RequestThread.MAXIMUM_FILE_SIZE = maximumFileSize == null ? null : Long.valueOf(Long.parseLong(maximumFileSize) * 1024L * 1024L);
        File ws = new File(this.workspace);
        RequestThread.MAXIMUM_WORKSPACE_SIZE = maximumWorkspaceSize == null ? ws.getFreeSpace() + ws.getTotalSpace() : Long.parseLong(maximumWorkspaceSize) * 1024L * 1024L;
        this._serverSocket = new ServerSocket(port);
    }

    @Override
    public void run() {
        System.out.println(this.getClass().getSimpleName() + " is running on port " + this._serverSocket.getLocalPort());
        System.out.println("The current workspace is: " + this.workspace);
        System.out.println("Press CTRL + C to quit.");
        while (true) {
            try {
                while (true) {
                    Socket socket = this._serverSocket.accept();
                    RequestThread requestThread = new RequestThread(socket, this.workspace);
                    requestThread.start();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.interrupt();
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        CommandLine comLine = TGraphBrowserServer.processCommandLineOptions(args);
        assert (comLine != null);
        try {
            String workspacePath;
            starttime = System.currentTimeMillis();
            String portnumber = comLine.getOptionValue("p");
            if (comLine.hasOption("r")) {
                TwoDVisualizer.PRINT_ROLE_NAMES = true;
            }
            if (comLine.hasOption("w")) {
                workspacePath = comLine.getOptionValue("w");
            } else {
                File workspace = new File(System.getProperty("java.io.tmpdir") + File.separator + "tgraphbrowser");
                if (!workspace.exists() && !workspace.mkdir()) {
                    logger.info("The temp folder " + workspace.getAbsolutePath() + " could not be created.");
                }
                if (!(workspace = new File(workspace.getAbsoluteFile() + File.separator + "workspace")).exists() && !workspace.mkdir()) {
                    logger.info("The default workspace " + workspace.getAbsolutePath() + " could not be created.");
                }
                workspacePath = workspace.getAbsolutePath();
            }
            new TGraphBrowserServer(portnumber == null ? 8080 : Integer.parseInt(portnumber), workspacePath, comLine.getOptionValue("m"), comLine.getOptionValue("s")).start();
            if (comLine.getOptionValue("ic") != null) {
                TabularVisualizer.NUMBER_OF_INCIDENCES_PER_PAGE = Math.max(Integer.parseInt(comLine.getOptionValue("ic")), 1);
            }
            if (comLine.hasOption("d")) {
                StateRepository.dot = comLine.getOptionValue("d");
            } else {
                System.out.println("The 2D-Visualization is disabled because parameter -d is not set.");
            }
            String timeout = comLine.getOptionValue("t");
            String checkIntervall = comLine.getOptionValue("i");
            new DeleteUnusedStates(timeout == null ? 600L : (long)Integer.parseInt(timeout), checkIntervall == null ? 60L : (long)Integer.parseInt(checkIntervall)).start();
            if (comLine.hasOption("td")) {
                TwoDVisualizer.SECONDS_TO_WAIT_FOR_DOT = Integer.parseInt(comLine.getOptionValue("td"));
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    private static CommandLine processCommandLineOptions(String[] args) {
        String toolString = "java " + TGraphBrowserServer.class.getName();
        String versionString = TGraphBrowserServer.getInfo();
        OptionHandler oh = new OptionHandler(toolString, versionString);
        Option output = new Option("w", "workspace", true, "(optional): the workspace. Default is $temp$/tgraphbrowser/workspace");
        output.setRequired(false);
        output.setArgName("path");
        oh.addOption(output);
        Option stateTimeout = new Option("t", "state_timeout", true, "(optional): resources are freed, if they were not used in the last <given> seconds. Default value is 600 sec.");
        stateTimeout.setRequired(false);
        stateTimeout.setArgName("sec");
        oh.addOption(stateTimeout);
        Option checkInterval = new Option("ci", "check_interval", true, "(optional): the interval in sec after which the states are checked, if thex are to old. Default value is 60 sec.");
        checkInterval.setRequired(false);
        checkInterval.setArgName("sec");
        oh.addOption(checkInterval);
        Option timeToCreateDot = new Option("td", "time_for_dot", true, "(optional): the interval in sec after which the execution of dot is aborted. Default value is 60 sec.");
        timeToCreateDot.setRequired(false);
        timeToCreateDot.setArgName("sec");
        oh.addOption(timeToCreateDot);
        Option port = new Option("p", "port", true, "(optional): the port of the server. Default is port 8080.");
        port.setRequired(false);
        port.setArgName("portnumber");
        oh.addOption(port);
        Option incidences = new Option("i", "incidences", true, "(optional): number of incident edges which are shown in the table view. Default is 10.");
        incidences.setRequired(false);
        incidences.setArgName("int");
        oh.addOption(incidences);
        Option dot = new Option("d", "dot", true, "(optional): the command to call dot. If it is not set, the 2D-view won't be available.");
        dot.setRequired(false);
        dot.setArgName("command");
        oh.addOption(dot);
        Option maxSize = new Option("m", "maximum_filesize", true, "(optional): the maximum size of a tg-file which is loaded in MB");
        maxSize.setRequired(false);
        maxSize.setArgName("int");
        oh.addOption(maxSize);
        Option size = new Option("s", "size_of_workspace", true, "(optional): the maximum size of the workspace in MB. Newly submitted tg.-files are rejected, if maximumSizeOfWorkspace < currentSizeOfWorkspace + sizeOfSubmittedTgFile ");
        size.setRequired(false);
        size.setArgName("int");
        oh.addOption(size);
        Option roleNames = new Option("r", "print-role-names", false, "(optional): Print role names in the 2D view.  Defaults to false.");
        roleNames.setRequired(false);
        oh.addOption(roleNames);
        return oh.parse(args);
    }

    public static String getInfo() {
        String[] lines = new String[versionInfo.length + copyrightInfo.length];
        System.arraycopy(versionInfo, 0, lines, 0, versionInfo.length);
        System.arraycopy(copyrightInfo, 0, lines, versionInfo.length, copyrightInfo.length);
        return TGraphBrowserServer.getInfoString(lines);
    }

    private static String getInfoString(String[] lines) {
        StringBuilder output = new StringBuilder();
        for (String line : lines) {
            output.append(' ');
            output.append(line);
            output.append('\n');
        }
        output.append('\n');
        return output.toString();
    }

    static {
        File logs;
        versionInfo = new String[]{"TGraphBrowser", "  Version : 1.0"};
        copyrightInfo = new String[]{"(c) 2006-2011 Institute for Software Technology", "              University of Koblenz-Landau, Germany", "", "              ist@uni-koblenz.de", "", "Please report bugs to http://helena.uni-koblenz.de/redmine", "", "This program is free software; you can redistribute it and/or", "modify it under the terms of the GNU General Public License", "as published by the Free Software Foundation; either version 2", "of the License, or (at your option) any later version.", "", "This program is distributed in the hope that it will be useful,", "but WITHOUT ANY WARRANTY; without even the implied warranty of", "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the", "GNU General Public License for more details.", "", "You should have received a copy of the GNU General Public License", "along with this program; if not, write to the Free Software", "Foundation Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.", "", "This software uses:", "", "JGraLab Efraasia", "(c) 2006-2011 Institute for Software Technology", "              University of Koblenz-Landau, Germany", "", "              ist@uni-koblenz.de", "", "Apache Commons CLI 1.2", "Copyright 2001-2009 The Apache Software Foundation"};
        logger = JGraLab.getRootLogger();
        Handler handler = logger.getHandlers()[0];
        logger.removeHandler(handler);
        Formatter formatter = handler.getFormatter();
        String path = System.getProperty("java.io.tmpdir") + File.separator + "tgraphbrowser";
        File tempFolder = new File(path);
        if (!tempFolder.exists() && !tempFolder.mkdir()) {
            logger.warning(tempFolder + " could not be created.");
        }
        if (!(logs = new File(path = path + File.separator + "logs")).exists() && !logs.mkdir()) {
            logger.warning(logs.toString() + " could not be created");
        }
        try {
            path = path + File.separator + "Logging.txt";
            handler = new FileHandler(path);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        handler.setFormatter(formatter);
        logger.addHandler(handler);
        logger.setLevel(Level.INFO);
    }

    static class DeleteUnusedStates
    extends Thread {
        public static long timeout;
        private final long checkInterval;

        public DeleteUnusedStates(long timeoutSec, long checkIntervalSec) {
            timeout = timeoutSec * 1000L;
            this.checkInterval = checkIntervalSec * 1000L;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        DeleteUnusedStates.sleep(this.checkInterval);
                        StateRepository.deleteAllUnusedSessions(timeout);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

